/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.x.file.storage.core.platform;

import cn.hutool.core.util.URLUtil;
import com.github.sardine.Sardine;
import com.github.sardine.SardineFactory;
import java.io.IOException;
import lombok.Generated;
import org.dromara.x.file.storage.core.FileStorageProperties;
import org.dromara.x.file.storage.core.exception.FileStorageRuntimeException;
import org.dromara.x.file.storage.core.platform.FileStorageClientFactory;

public class WebDavFileStorageClientFactory
implements FileStorageClientFactory<Sardine> {
    private String platform;
    private String server;
    private String user;
    private String password;
    private volatile Sardine client;

    public WebDavFileStorageClientFactory(FileStorageProperties.WebDavConfig config) {
        this.platform = config.getPlatform();
        this.server = config.getServer();
        this.user = config.getUser();
        this.password = config.getPassword();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Sardine getClient() {
        if (this.client == null) {
            WebDavFileStorageClientFactory webDavFileStorageClientFactory = this;
            synchronized (webDavFileStorageClientFactory) {
                if (this.client == null) {
                    this.client = SardineFactory.begin((String)this.user, (String)this.password);
                    this.client.enablePreemptiveAuthentication(URLUtil.url((String)this.server));
                }
            }
        }
        return this.client;
    }

    @Override
    public void close() {
        if (this.client != null) {
            try {
                this.client.shutdown();
            }
            catch (IOException e) {
                throw new FileStorageRuntimeException("\u5173\u95ed WebDAV Client \u5931\u8d25\uff01", e);
            }
            this.client = null;
        }
    }

    @Override
    @Generated
    public String getPlatform() {
        return this.platform;
    }

    @Generated
    public String getServer() {
        return this.server;
    }

    @Generated
    public String getUser() {
        return this.user;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public void setPlatform(String platform) {
        this.platform = platform;
    }

    @Generated
    public void setServer(String server) {
        this.server = server;
    }

    @Generated
    public void setUser(String user) {
        this.user = user;
    }

    @Generated
    public void setPassword(String password) {
        this.password = password;
    }

    @Generated
    public void setClient(Sardine client) {
        this.client = client;
    }

    @Generated
    public WebDavFileStorageClientFactory() {
    }
}

