/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.x.file.storage.core.platform;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.format.DateParser;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.io.file.FileNameUtil;
import cn.hutool.core.map.MapProxy;
import cn.hutool.core.util.StrUtil;
import com.upyun.RestManager;
import com.upyun.UpException;
import com.upyun.UpYunUtils;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import lombok.Generated;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.dromara.x.file.storage.core.FileInfo;
import org.dromara.x.file.storage.core.FileStorageProperties;
import org.dromara.x.file.storage.core.InputStreamPlus;
import org.dromara.x.file.storage.core.ProgressListener;
import org.dromara.x.file.storage.core.UploadPretreatment;
import org.dromara.x.file.storage.core.copy.CopyPretreatment;
import org.dromara.x.file.storage.core.exception.Check;
import org.dromara.x.file.storage.core.exception.ExceptionFactory;
import org.dromara.x.file.storage.core.exception.FileStorageRuntimeException;
import org.dromara.x.file.storage.core.file.FileWrapper;
import org.dromara.x.file.storage.core.get.GetFilePretreatment;
import org.dromara.x.file.storage.core.get.ListFilesPretreatment;
import org.dromara.x.file.storage.core.get.ListFilesResult;
import org.dromara.x.file.storage.core.get.ListFilesSupportInfo;
import org.dromara.x.file.storage.core.get.RemoteDirInfo;
import org.dromara.x.file.storage.core.get.RemoteFileInfo;
import org.dromara.x.file.storage.core.move.MovePretreatment;
import org.dromara.x.file.storage.core.platform.FileStorage;
import org.dromara.x.file.storage.core.platform.FileStorageClientFactory;
import org.dromara.x.file.storage.core.upload.CompleteMultipartUploadPretreatment;
import org.dromara.x.file.storage.core.upload.FilePartInfo;
import org.dromara.x.file.storage.core.upload.InitiateMultipartUploadPretreatment;
import org.dromara.x.file.storage.core.upload.MultipartUploadSupportInfo;
import org.dromara.x.file.storage.core.upload.UploadPartPretreatment;
import org.dromara.x.file.storage.core.util.KebabCaseInsensitiveMap;
import org.dromara.x.file.storage.core.util.Tools;
import org.json.JSONArray;
import org.json.JSONObject;

public class UpyunUssFileStorage
implements FileStorage {
    private String platform;
    private String domain;
    private String basePath;
    private String bucketName;
    private Integer multipartUploadPartSize;
    private FileStorageClientFactory<RestManager> clientFactory;

    public UpyunUssFileStorage(FileStorageProperties.UpyunUssConfig config, FileStorageClientFactory<RestManager> clientFactory) {
        this.platform = config.getPlatform();
        this.domain = config.getDomain();
        this.basePath = config.getBasePath();
        this.bucketName = config.getBucketName();
        this.multipartUploadPartSize = config.getMultipartUploadPartSize();
        this.clientFactory = clientFactory;
    }

    public RestManager getClient() {
        return this.clientFactory.getClient();
    }

    @Override
    public void close() {
        this.clientFactory.close();
    }

    @Override
    public boolean save(FileInfo fileInfo, UploadPretreatment pre) {
        boolean bl;
        block21: {
            fileInfo.setBasePath(this.basePath);
            String newFileKey = this.getFileKey(fileInfo);
            fileInfo.setUrl(this.domain + newFileKey);
            Check.uploadNotSupportAcl(this.platform, fileInfo, pre);
            RestManager manager = this.getClient();
            InputStreamPlus in = pre.getInputStreamPlus();
            try {
                byte[] thumbnailBytes;
                try (Response result = manager.writeFile(newFileKey, (InputStream)in, this.getObjectMetadata(fileInfo));){
                    if (!result.isSuccessful()) {
                        throw new UpException(result.toString());
                    }
                }
                if (fileInfo.getSize() == null) {
                    fileInfo.setSize(in.getProgressSize());
                }
                if ((thumbnailBytes = pre.getThumbnailBytes()) != null) {
                    String newThFileKey = this.getThFileKey(fileInfo);
                    fileInfo.setThUrl(this.domain + newThFileKey);
                    Response thResult = manager.writeFile(newThFileKey, (InputStream)new ByteArrayInputStream(thumbnailBytes), this.getThObjectMetadata(fileInfo));
                    IoUtil.close((Closeable)thResult);
                    if (!thResult.isSuccessful()) {
                        throw new UpException(thResult.toString());
                    }
                }
                bl = true;
                if (in == null) break block21;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    try {
                        manager.deleteFile(newFileKey, null).close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw ExceptionFactory.upload(fileInfo, this.platform, e);
                }
            }
            in.close();
        }
        return bl;
    }

    @Override
    public MultipartUploadSupportInfo isSupportMultipartUpload() {
        return new MultipartUploadSupportInfo(true, false, false, null);
    }

    @Override
    public void initiateMultipartUpload(FileInfo fileInfo, InitiateMultipartUploadPretreatment pre) {
        fileInfo.setBasePath(this.basePath);
        String newFileKey = this.getFileKey(fileInfo);
        fileInfo.setUrl(this.domain + newFileKey);
        Check.uploadNotSupportAcl(this.platform, fileInfo, pre);
        RestManager manager = this.getClient();
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("X-Upyun-Multi-Disorder", "true");
            params.put("X-Upyun-Multi-Stage", "initiate");
            if (this.multipartUploadPartSize != null) {
                params.put("X-Upyun-Multi-Part-Size", String.valueOf(this.multipartUploadPartSize));
            }
            params.putAll(this.getObjectMetadata(fileInfo));
            Response result = this.checkResponse(manager.writeFile(newFileKey, new byte[0], params));
            String uploadId = result.header("X-Upyun-Multi-Uuid");
            fileInfo.setUploadId(uploadId);
        }
        catch (Exception e) {
            throw ExceptionFactory.initiateMultipartUpload(fileInfo, this.platform, e);
        }
    }

    @Override
    public FilePartInfo uploadPart(UploadPartPretreatment pre) {
        FilePartInfo filePartInfo;
        block12: {
            FileInfo fileInfo = pre.getFileInfo();
            String newFileKey = this.getFileKey(fileInfo);
            RestManager manager = this.getClient();
            FileWrapper partFileWrapper = pre.getPartFileWrapper();
            Long partSize = partFileWrapper.getSize();
            pre.setHashCalculatorMd5();
            InputStreamPlus in = pre.getInputStreamPlus();
            try {
                if (partSize == null) {
                    partSize = partFileWrapper.getInputStreamMaskResetReturn(Tools::getSize);
                }
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("X-Upyun-Multi-Stage", "upload");
                params.put("X-Upyun-Multi-Uuid", fileInfo.getUploadId());
                params.put("X-Upyun-Part-Id", String.valueOf(pre.getPartNumber() - 1));
                params.put("Content-Length", String.valueOf(partSize));
                try {
                    this.checkResponse(manager.writeFile(newFileKey, (InputStream)in, params));
                }
                catch (Exception e) {
                    String message = e.getMessage();
                    if (message != null && message.contains("wrong content-length header")) {
                        throw new FileStorageRuntimeException("\u5f53\u524d\u4e0a\u4f20\u7684\u5206\u7247\u5927\u5c0f\u4e0e\u6587\u4ef6\u521d\u59cb\u5316\u65f6\u63d0\u4f9b\u7684\u5206\u7247\u5927\u5c0f\u4e0d\u540c\uff0c\u53c8\u62cd\u4e91 USS \u6bd4\u8f83\u7279\u6b8a\uff0c\u5fc5\u987b\u63d0\u524d\u4f20\u5165\u5206\u7247\u5927\u5c0f\uff08\u6700\u540e\u4e00\u4e2a\u5206\u7247\u53ef\u4ee5\u5c0f\u4e8e\u6b64\u5927\u5c0f\uff0c\u4f46\u4e0d\u80fd\u8d85\u8fc7\uff09\uff0c\u4f60\u53ef\u4ee5\u5728\u521d\u59cb\u5316\u6587\u4ef6\u65f6\u4f7f\u7528 putMetadata(\"X-Upyun-Multi-Part-Size\", \"1048576\") \u65b9\u6cd5\u4f20\u5165\u5206\u7247\u5927\u5c0f\u6216\u4fee\u6539\u914d\u7f6e\u6587\u4ef6 multipartUploadPartSize \u53c2\u6570\uff0c\u5355\u4f4d\u5b57\u8282\uff0c\u6700\u5c0f 1MB\uff0c\u6700\u5927 50MB\uff0c\u5fc5\u987b\u662f 1MB \u7684\u6574\u6570\u500d\uff0c\u9ed8\u8ba4\u4e3a " + this.multipartUploadPartSize, e);
                    }
                    throw e;
                }
                String etag = pre.getHashCalculatorManager().getHashInfo().getMd5();
                fileInfo.setUploadId(fileInfo.getUploadId());
                FilePartInfo filePartInfo2 = new FilePartInfo(fileInfo);
                filePartInfo2.setETag(etag);
                filePartInfo2.setPartNumber(pre.getPartNumber());
                filePartInfo2.setPartSize(in.getProgressSize());
                filePartInfo2.setCreateTime(new Date());
                filePartInfo = filePartInfo2;
                if (in == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw ExceptionFactory.uploadPart(fileInfo, this.platform, e);
                }
            }
            in.close();
        }
        return filePartInfo;
    }

    @Override
    public void completeMultipartUpload(CompleteMultipartUploadPretreatment pre) {
        FileInfo fileInfo = pre.getFileInfo();
        String newFileKey = this.getFileKey(fileInfo);
        RestManager manager = this.getClient();
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("X-Upyun-Multi-Stage", "complete");
            params.put("X-Upyun-Multi-Uuid", fileInfo.getUploadId());
            Long fileSize = fileInfo.getSize();
            ProgressListener.quickStart(pre.getProgressListener(), fileSize);
            try {
                Response result = this.checkResponse(manager.writeFile(newFileKey, new byte[0], params));
                ProgressListener.quickFinish(pre.getProgressListener(), fileSize);
                String length = result.header("X-Upyun-Multi-Length");
                if (fileSize == null && length != null) {
                    fileInfo.setSize(Long.parseLong(length));
                }
            }
            catch (Exception e) {
                String message = e.getMessage();
                if (message != null && message.contains("invalid x-upyun-part-size")) {
                    throw new FileStorageRuntimeException("\u5df2\u4e0a\u4f20\u7684\u5206\u7247\u5927\u5c0f\u4e0e\u6587\u4ef6\u521d\u59cb\u5316\u65f6\u63d0\u4f9b\u7684\u5206\u7247\u5927\u5c0f\u4e0d\u540c\uff0c\u53c8\u62cd\u4e91 USS \u6bd4\u8f83\u7279\u6b8a\uff0c\u5fc5\u987b\u63d0\u524d\u4f20\u5165\u5206\u7247\u5927\u5c0f\uff08\u6700\u540e\u4e00\u4e2a\u5206\u7247\u53ef\u4ee5\u5c0f\u4e8e\u6b64\u5927\u5c0f\uff0c\u4f46\u4e0d\u80fd\u8d85\u8fc7\uff09\uff0c\u4f60\u53ef\u4ee5\u5728\u521d\u59cb\u5316\u6587\u4ef6\u65f6\u4f7f\u7528 putMetadata(\"X-Upyun-Multi-Part-Size\", \"1048576\") \u65b9\u6cd5\u4f20\u5165\u5206\u7247\u5927\u5c0f\u6216\u4fee\u6539\u914d\u7f6e\u6587\u4ef6 multipartUploadPartSize \u53c2\u6570\uff0c\u5355\u4f4d\u5b57\u8282\uff0c\u6700\u5c0f 1MB\uff0c\u6700\u5927 50MB\uff0c\u5fc5\u987b\u662f 1MB \u7684\u6574\u6570\u500d\uff0c\u9ed8\u8ba4\u4e3a " + this.multipartUploadPartSize, e);
                }
                throw e;
            }
        }
        catch (Exception e) {
            throw ExceptionFactory.completeMultipartUpload(fileInfo, this.platform, e);
        }
    }

    @Override
    public ListFilesSupportInfo isSupportListFiles() {
        return ListFilesSupportInfo.supportAll();
    }

    @Override
    public ListFilesResult listFiles(ListFilesPretreatment pre) {
        RestManager manager = this.getClient();
        try {
            JSONObject result;
            HashMap<String, String> params = new HashMap<String, String>();
            if (pre.getMarker() != null) {
                params.put("x-list-iter", pre.getMarker());
            }
            if (pre.getMaxFiles() != null) {
                params.put("x-list-limit", pre.getMaxFiles().toString());
            }
            params.put("x-list-order", "asc");
            params.put("Accept", "application/json");
            try (Response response = this.checkResponse(manager.readDirIter(this.basePath + pre.getPath() + pre.getFilenamePrefix(), params), false);){
                if (response.body() == null) {
                    throw new UpException(response.toString());
                }
                result = new JSONObject(response.body().string());
            }
            ArrayList<RemoteDirInfo> dirList = new ArrayList<RemoteDirInfo>();
            ArrayList<RemoteFileInfo> fileList = new ArrayList<RemoteFileInfo>();
            JSONArray files = result.getJSONArray("files");
            for (int i = 0; i < files.length(); ++i) {
                JSONObject item = files.getJSONObject(0);
                if ("folder".equals(item.getString("type")) && Long.valueOf(0L).equals(item.getLong("length"))) {
                    RemoteDirInfo dir = new RemoteDirInfo();
                    dir.setPlatform(pre.getPlatform());
                    dir.setBasePath(this.basePath);
                    dir.setPath(pre.getPath());
                    dir.setName(item.getString("name"));
                    dir.setOriginal(item);
                    dirList.add(dir);
                    continue;
                }
                RemoteFileInfo info = new RemoteFileInfo();
                info.setPlatform(pre.getPlatform());
                info.setBasePath(this.basePath);
                info.setPath(pre.getPath());
                info.setFilename(item.getString("name"));
                info.setUrl(this.domain + this.getFileKey(new FileInfo(this.basePath, info.getPath(), info.getFilename())));
                info.setSize(item.getLong("length"));
                info.setExt(FileNameUtil.extName((String)info.getFilename()));
                info.setETag(item.getString("etag"));
                info.setContentType(item.getString("type"));
                info.setLastModified(new Date(item.getLong("last_modified") * 1000L));
                info.setOriginal(item);
                fileList.add(info);
            }
            String iter = result.getString("iter");
            ListFilesResult list = new ListFilesResult();
            list.setDirList(dirList);
            list.setFileList(fileList);
            list.setPlatform(pre.getPlatform());
            list.setBasePath(this.basePath);
            list.setPath(pre.getPath());
            list.setFilenamePrefix(pre.getFilenamePrefix());
            list.setMaxFiles(pre.getMaxFiles());
            list.setIsTruncated(!"g2gCZAAEbmV4dGQAA2VvZg".equals(iter));
            list.setMarker(pre.getMarker());
            list.setNextMarker(list.getIsTruncated() != false ? iter : null);
            return list;
        }
        catch (Exception e) {
            throw ExceptionFactory.listFiles(pre, this.basePath, e);
        }
    }

    @Override
    public RemoteFileInfo getFile(GetFilePretreatment pre) {
        String fileKey = this.getFileKey(new FileInfo(this.basePath, pre.getPath(), pre.getFilename()));
        RestManager client = this.getClient();
        try {
            Response file;
            try {
                file = this.checkResponse(client.getFileInfo(fileKey));
                Long.parseLong(Objects.requireNonNull(file.header(RestManager.PARAMS.X_UPYUN_FILE_SIZE.getValue())));
            }
            catch (Exception e2) {
                return null;
            }
            KebabCaseInsensitiveMap<String, String> headers = new KebabCaseInsensitiveMap<String, String>(file.headers().toMultimap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (String)CollUtil.get((Collection)((Collection)e.getValue()), (int)0))));
            MapProxy headersProxy = MapProxy.create(headers);
            RemoteFileInfo info = new RemoteFileInfo();
            info.setPlatform(pre.getPlatform());
            info.setBasePath(this.basePath);
            info.setPath(pre.getPath());
            info.setFilename(FileNameUtil.getName((String)pre.getFilename()));
            info.setUrl(this.domain + fileKey);
            info.setSize(headersProxy.getLong((Object)"Content-Length"));
            info.setExt(FileNameUtil.extName((String)info.getFilename()));
            info.setETag(headersProxy.getStr((Object)"etag"));
            info.setContentDisposition(headersProxy.getStr((Object)"Content-Disposition"));
            info.setContentType(headersProxy.getStr((Object)"Content-Type"));
            info.setContentMd5(headersProxy.getStr((Object)"Content-MD5"));
            try {
                info.setLastModified((Date)DateUtil.parse((CharSequence)headersProxy.getStr((Object)"Last-Modified"), (DateParser)DatePattern.HTTP_DATETIME_FORMAT));
            }
            catch (Exception exception) {
                // empty catch block
            }
            info.setMetadata(headers.entrySet().stream().filter(e -> !((String)e.getKey()).startsWith("x-upyun-meta-")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
            info.setUserMetadata(headers.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith("x-upyun-meta-")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
            info.setOriginal(file);
            return info;
        }
        catch (Exception e3) {
            throw ExceptionFactory.getFile(pre, this.basePath, e3);
        }
    }

    public HashMap<String, String> getObjectMetadata(FileInfo fileInfo) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (fileInfo.getContentType() != null) {
            params.put(RestManager.PARAMS.CONTENT_TYPE.getValue(), fileInfo.getContentType());
        }
        if (CollUtil.isNotEmpty(fileInfo.getMetadata())) {
            params.putAll(fileInfo.getMetadata());
        }
        if (CollUtil.isNotEmpty(fileInfo.getUserMetadata())) {
            fileInfo.getUserMetadata().forEach((key, value) -> params.put(key.startsWith("x-upyun-meta-") ? key : "x-upyun-meta-" + key, (String)value));
        }
        return params;
    }

    public HashMap<String, String> getThObjectMetadata(FileInfo fileInfo) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(RestManager.PARAMS.CONTENT_TYPE.getValue(), fileInfo.getThContentType());
        if (CollUtil.isNotEmpty(fileInfo.getThMetadata())) {
            params.putAll(fileInfo.getThMetadata());
        }
        if (CollUtil.isNotEmpty(fileInfo.getThUserMetadata())) {
            fileInfo.getThUserMetadata().forEach((key, value) -> params.put(key.startsWith("x-upyun-meta-") ? key : "x-upyun-meta-" + key, (String)value));
        }
        return params;
    }

    @Override
    public boolean isSupportMetadata() {
        return true;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean delete(FileInfo fileInfo) {
        RestManager manager = this.getClient();
        String file = this.getFileKey(fileInfo);
        String thFile = this.getThFileKey(fileInfo);
        try (Response ignored = fileInfo.getThFilename() != null ? manager.deleteFile(thFile, null) : null;){
            boolean bl;
            block14: {
                Response ignored2 = manager.deleteFile(file, null);
                try {
                    bl = true;
                    if (ignored2 == null) break block14;
                }
                catch (Throwable throwable) {
                    if (ignored2 != null) {
                        try {
                            ignored2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ignored2.close();
            }
            return bl;
        }
        catch (Exception e) {
            throw ExceptionFactory.delete(fileInfo, this.platform, e);
        }
    }

    @Override
    public boolean exists(FileInfo fileInfo) {
        try {
            return this.exists(this.getFileKey(fileInfo));
        }
        catch (Exception e) {
            throw ExceptionFactory.exists(fileInfo, this.platform, e);
        }
    }

    public boolean exists(String fileKey) throws UpException, IOException {
        Response response = this.checkResponse(this.getClient().getFileInfo(fileKey));
        return StrUtil.isNotBlank((CharSequence)response.header("x-upyun-file-size"));
    }

    @Override
    public void download(FileInfo fileInfo, Consumer<InputStream> consumer) {
        try (Response response = this.getClient().readFile(this.getFileKey(fileInfo));
             ResponseBody body = response.body();
             InputStream in = body == null ? null : body.byteStream();){
            if (body == null) {
                throw new NullPointerException("body is null");
            }
            if (!response.isSuccessful()) {
                throw new UpException(IoUtil.read((InputStream)in, (Charset)StandardCharsets.UTF_8));
            }
            consumer.accept(in);
        }
        catch (Exception e) {
            throw ExceptionFactory.download(fileInfo, this.platform, e);
        }
    }

    @Override
    public void downloadTh(FileInfo fileInfo, Consumer<InputStream> consumer) {
        Check.downloadThBlankThFilename(this.platform, fileInfo);
        try (Response response = this.getClient().readFile(this.getThFileKey(fileInfo));
             ResponseBody body = response.body();
             InputStream in = body == null ? null : body.byteStream();){
            if (body == null) {
                throw new NullPointerException("body is null");
            }
            if (!response.isSuccessful()) {
                throw new UpException(IoUtil.read((InputStream)in, (Charset)StandardCharsets.UTF_8));
            }
            consumer.accept(in);
        }
        catch (Exception e) {
            throw ExceptionFactory.downloadTh(fileInfo, this.platform, e);
        }
    }

    @Override
    public boolean isSupportSameCopy() {
        return true;
    }

    public Response checkResponse(Response response) throws UpException, IOException {
        return this.checkResponse(response, true);
    }

    public Response checkResponse(Response response, boolean close) throws UpException, IOException {
        if (!response.isSuccessful()) {
            if (response.body() != null) {
                throw new UpException(response.body().string());
            }
            response.close();
            throw new UpException(response.toString());
        }
        if (close) {
            response.close();
        }
        return response;
    }

    @Override
    public void sameCopy(FileInfo srcFileInfo, FileInfo destFileInfo, CopyPretreatment pre) {
        long srcFileSize;
        Check.sameCopyNotSupportAcl(this.platform, srcFileInfo, destFileInfo, pre);
        Check.sameCopyBasePath(this.platform, this.basePath, srcFileInfo, destFileInfo);
        RestManager client = this.getClient();
        String srcFileKey = this.getFileKey(srcFileInfo);
        try {
            Response response = this.checkResponse(client.getFileInfo(srcFileKey));
            srcFileSize = Long.parseLong(Objects.requireNonNull(response.header(RestManager.PARAMS.X_UPYUN_FILE_SIZE.getValue())));
        }
        catch (Exception e) {
            throw ExceptionFactory.sameCopyNotFound(srcFileInfo, destFileInfo, this.platform, e);
        }
        String destThFileKey = null;
        if (StrUtil.isNotBlank((CharSequence)srcFileInfo.getThFilename())) {
            destThFileKey = this.getThFileKey(destFileInfo);
            destFileInfo.setThUrl(this.domain + destThFileKey);
            try {
                this.checkResponse(client.copyFile(destThFileKey, UpYunUtils.formatPath((String)this.bucketName, (String)this.getThFileKey(srcFileInfo)), null));
            }
            catch (Exception e) {
                throw ExceptionFactory.sameCopyTh(srcFileInfo, destFileInfo, this.platform, e);
            }
        }
        String destFileKey = this.getFileKey(destFileInfo);
        destFileInfo.setUrl(this.domain + destFileKey);
        try {
            ProgressListener.quickStart(pre.getProgressListener(), srcFileSize);
            this.checkResponse(client.copyFile(destFileKey, UpYunUtils.formatPath((String)this.bucketName, (String)srcFileKey), null));
            ProgressListener.quickFinish(pre.getProgressListener(), srcFileSize);
        }
        catch (Exception e) {
            if (destThFileKey != null) {
                try {
                    IoUtil.close((Closeable)client.deleteFile(destThFileKey, null));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                IoUtil.close((Closeable)client.deleteFile(destFileKey, null));
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw ExceptionFactory.sameCopy(srcFileInfo, destFileInfo, this.platform, e);
        }
    }

    @Override
    public boolean isSupportSameMove() {
        return true;
    }

    @Override
    public void sameMove(FileInfo srcFileInfo, FileInfo destFileInfo, MovePretreatment pre) {
        long srcFileSize;
        Check.sameMoveNotSupportAcl(this.platform, srcFileInfo, destFileInfo, pre);
        Check.sameMoveBasePath(this.platform, this.basePath, srcFileInfo, destFileInfo);
        RestManager client = this.getClient();
        String srcFileKey = this.getFileKey(srcFileInfo);
        try {
            Response response = this.checkResponse(client.getFileInfo(srcFileKey));
            srcFileSize = Long.parseLong(Objects.requireNonNull(response.header(RestManager.PARAMS.X_UPYUN_FILE_SIZE.getValue())));
        }
        catch (Exception e) {
            throw ExceptionFactory.sameMoveNotFound(srcFileInfo, destFileInfo, this.platform, e);
        }
        String srcThFileKey = null;
        String destThFileKey = null;
        if (StrUtil.isNotBlank((CharSequence)srcFileInfo.getThFilename())) {
            srcThFileKey = this.getThFileKey(srcFileInfo);
            destThFileKey = this.getThFileKey(destFileInfo);
            destFileInfo.setThUrl(this.domain + destThFileKey);
            try {
                this.checkResponse(client.moveFile(destThFileKey, UpYunUtils.formatPath((String)this.bucketName, (String)srcThFileKey), null));
            }
            catch (Exception e) {
                throw ExceptionFactory.sameMoveTh(srcFileInfo, destFileInfo, this.platform, e);
            }
        }
        String destFileKey = this.getFileKey(destFileInfo);
        destFileInfo.setUrl(this.domain + destFileKey);
        try {
            ProgressListener.quickStart(pre.getProgressListener(), srcFileSize);
            this.checkResponse(client.moveFile(destFileKey, UpYunUtils.formatPath((String)this.bucketName, (String)srcFileKey), null));
            ProgressListener.quickFinish(pre.getProgressListener(), srcFileSize);
        }
        catch (Exception e) {
            if (destThFileKey != null) {
                try {
                    IoUtil.close((Closeable)client.moveFile(srcThFileKey, UpYunUtils.formatPath((String)this.bucketName, (String)destThFileKey), null));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                if (this.exists(srcFileKey)) {
                    IoUtil.close((Closeable)client.deleteFile(destFileKey, null));
                } else {
                    IoUtil.close((Closeable)client.moveFile(srcFileKey, UpYunUtils.formatPath((String)this.bucketName, (String)destFileKey), null));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw ExceptionFactory.sameMove(srcFileInfo, destFileInfo, this.platform, e);
        }
    }

    @Override
    @Generated
    public String getPlatform() {
        return this.platform;
    }

    @Generated
    public String getDomain() {
        return this.domain;
    }

    @Generated
    public String getBasePath() {
        return this.basePath;
    }

    @Generated
    public String getBucketName() {
        return this.bucketName;
    }

    @Generated
    public Integer getMultipartUploadPartSize() {
        return this.multipartUploadPartSize;
    }

    @Generated
    public FileStorageClientFactory<RestManager> getClientFactory() {
        return this.clientFactory;
    }

    @Override
    @Generated
    public void setPlatform(String platform) {
        this.platform = platform;
    }

    @Generated
    public void setDomain(String domain) {
        this.domain = domain;
    }

    @Generated
    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    @Generated
    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    @Generated
    public void setMultipartUploadPartSize(Integer multipartUploadPartSize) {
        this.multipartUploadPartSize = multipartUploadPartSize;
    }

    @Generated
    public void setClientFactory(FileStorageClientFactory<RestManager> clientFactory) {
        this.clientFactory = clientFactory;
    }

    @Generated
    public UpyunUssFileStorage() {
    }
}

