/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.x.file.storage.core.platform;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.file.FileNameUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.ssh.JschRuntimeException;
import cn.hutool.extra.ssh.Sftp;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import lombok.Generated;
import org.dromara.x.file.storage.core.FileInfo;
import org.dromara.x.file.storage.core.FileStorageProperties;
import org.dromara.x.file.storage.core.InputStreamPlus;
import org.dromara.x.file.storage.core.ProgressListener;
import org.dromara.x.file.storage.core.UploadPretreatment;
import org.dromara.x.file.storage.core.exception.Check;
import org.dromara.x.file.storage.core.exception.ExceptionFactory;
import org.dromara.x.file.storage.core.get.GetFilePretreatment;
import org.dromara.x.file.storage.core.get.ListFilesPretreatment;
import org.dromara.x.file.storage.core.get.ListFilesResult;
import org.dromara.x.file.storage.core.get.ListFilesSupportInfo;
import org.dromara.x.file.storage.core.get.RemoteDirInfo;
import org.dromara.x.file.storage.core.get.RemoteFileInfo;
import org.dromara.x.file.storage.core.move.MovePretreatment;
import org.dromara.x.file.storage.core.platform.FileStorage;
import org.dromara.x.file.storage.core.platform.FileStorageClientFactory;

public class SftpFileStorage
implements FileStorage {
    private String platform;
    private String domain;
    private String basePath;
    private String storagePath;
    private FileStorageClientFactory<Sftp> clientFactory;

    public SftpFileStorage(FileStorageProperties.SftpConfig config, FileStorageClientFactory<Sftp> clientFactory) {
        this.platform = config.getPlatform();
        this.domain = config.getDomain();
        this.basePath = config.getBasePath();
        this.storagePath = config.getStoragePath();
        this.clientFactory = clientFactory;
    }

    public Sftp getClient() {
        return this.clientFactory.getClient();
    }

    public void returnClient(Sftp client) {
        this.clientFactory.returnClient(client);
    }

    @Override
    public void close() {
        this.clientFactory.close();
    }

    public String getAbsolutePath(String path) {
        return this.storagePath + path;
    }

    @Override
    public boolean save(FileInfo fileInfo, UploadPretreatment pre) {
        fileInfo.setBasePath(this.basePath);
        String newFileKey = this.getFileKey(fileInfo);
        fileInfo.setUrl(this.domain + newFileKey);
        Check.uploadNotSupportAcl(this.platform, fileInfo, pre);
        Check.uploadNotSupportMetadata(this.platform, fileInfo, pre);
        Sftp client = this.getClient();
        try {
            boolean bl;
            block16: {
                InputStreamPlus in = pre.getInputStreamPlus();
                try {
                    byte[] thumbnailBytes;
                    String path = this.getAbsolutePath(this.basePath + fileInfo.getPath());
                    if (!client.exist(path)) {
                        client.mkDirs(path);
                    }
                    client.upload(path, fileInfo.getFilename(), (InputStream)in);
                    if (fileInfo.getSize() == null) {
                        fileInfo.setSize(in.getProgressSize());
                    }
                    if ((thumbnailBytes = pre.getThumbnailBytes()) != null) {
                        String newThFileKey = this.getThFileKey(fileInfo);
                        fileInfo.setThUrl(this.domain + newThFileKey);
                        client.upload(path, fileInfo.getThFilename(), (InputStream)new ByteArrayInputStream(thumbnailBytes));
                    }
                    bl = true;
                    if (in == null) break block16;
                }
                catch (Throwable throwable) {
                    try {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        try {
                            client.delFile(this.getAbsolutePath(newFileKey));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        throw ExceptionFactory.upload(fileInfo, this.platform, e);
                    }
                }
                in.close();
            }
            return bl;
        }
        finally {
            this.returnClient(client);
        }
    }

    @Override
    public ListFilesSupportInfo isSupportListFiles() {
        return ListFilesSupportInfo.supportAll().setSupportMaxFiles(Integer.MAX_VALUE);
    }

    @Override
    public ListFilesResult listFiles(ListFilesPretreatment pre) {
        Sftp client = this.getClient();
        try {
            String path = this.getAbsolutePath(this.basePath + pre.getPath());
            List fileList = Collections.emptyList();
            if (client.isDir(path)) {
                fileList = client.lsEntries(path).stream().filter(item -> item.getAttrs().isDir() || item.getAttrs().isReg()).collect(Collectors.toList());
            }
            FileStorage.ListFilesMatchResult<ChannelSftp.LsEntry> matchResult = this.listFilesMatch(fileList, ChannelSftp.LsEntry::getFilename, pre, true);
            ListFilesResult list = new ListFilesResult();
            list.setDirList(matchResult.getList().stream().filter(item -> item.getAttrs().isDir()).map(item -> {
                RemoteDirInfo dir = new RemoteDirInfo();
                dir.setPlatform(pre.getPlatform());
                dir.setBasePath(this.basePath);
                dir.setPath(pre.getPath());
                dir.setName(item.getFilename());
                dir.setOriginal(item);
                return dir;
            }).collect(Collectors.toList()));
            list.setFileList(matchResult.getList().stream().filter(item -> item.getAttrs().isReg()).map(item -> {
                RemoteFileInfo info = new RemoteFileInfo();
                info.setPlatform(pre.getPlatform());
                info.setBasePath(this.basePath);
                info.setPath(pre.getPath());
                info.setFilename(item.getFilename());
                info.setUrl(this.domain + this.getFileKey(new FileInfo(this.basePath, info.getPath(), info.getFilename())));
                info.setSize(item.getAttrs().getSize());
                info.setExt(FileNameUtil.extName((String)info.getFilename()));
                info.setLastModified((Date)DateUtil.date((long)((long)item.getAttrs().getMTime() * 1000L)));
                info.setOriginal(item);
                return info;
            }).collect(Collectors.toList()));
            list.setPlatform(pre.getPlatform());
            list.setBasePath(this.basePath);
            list.setPath(pre.getPath());
            list.setFilenamePrefix(pre.getFilenamePrefix());
            list.setMaxFiles(pre.getMaxFiles());
            list.setIsTruncated(matchResult.getIsTruncated());
            list.setMarker(pre.getMarker());
            list.setNextMarker(matchResult.getNextMarker());
            ListFilesResult listFilesResult = list;
            return listFilesResult;
        }
        catch (Exception e) {
            throw ExceptionFactory.listFiles(pre, this.basePath, e);
        }
        finally {
            this.returnClient(client);
        }
    }

    @Override
    public RemoteFileInfo getFile(GetFilePretreatment pre) {
        String fileKey = this.getFileKey(new FileInfo(this.basePath, pre.getPath(), pre.getFilename()));
        Sftp client = this.getClient();
        try {
            SftpATTRS attrs;
            String path = this.getAbsolutePath(this.basePath + pre.getPath());
            String filename = pre.getFilename();
            try {
                attrs = client.getClient().stat(path + filename);
            }
            catch (Exception e) {
                RemoteFileInfo remoteFileInfo = null;
                this.returnClient(client);
                return remoteFileInfo;
            }
            if (attrs == null) {
                RemoteFileInfo e = null;
                return e;
            }
            ChannelSftp.LsEntry file = (ChannelSftp.LsEntry)ReflectUtil.newInstanceIfPossible(ChannelSftp.LsEntry.class);
            ReflectUtil.setFieldValue((Object)file, (String)"filename", (Object)filename);
            ReflectUtil.setFieldValue((Object)file, (String)"longname", (Object)(attrs + " " + filename));
            ReflectUtil.setFieldValue((Object)file, (String)"attrs", (Object)attrs);
            RemoteFileInfo info = new RemoteFileInfo();
            info.setPlatform(pre.getPlatform());
            info.setBasePath(this.basePath);
            info.setPath(pre.getPath());
            info.setFilename(file.getFilename());
            info.setUrl(this.domain + fileKey);
            info.setSize(file.getAttrs().getSize());
            info.setExt(FileNameUtil.extName((String)info.getFilename()));
            info.setLastModified((Date)DateUtil.date((long)((long)file.getAttrs().getMTime() * 1000L)));
            info.setOriginal(file);
            RemoteFileInfo remoteFileInfo = info;
            return remoteFileInfo;
        }
        catch (Exception e) {
            throw ExceptionFactory.getFile(pre, this.basePath, e);
        }
        finally {
            this.returnClient(client);
        }
    }

    @Override
    public boolean delete(FileInfo fileInfo) {
        Sftp client = this.getClient();
        try {
            if (fileInfo.getThFilename() != null) {
                this.delFile(client, this.getAbsolutePath(this.getThFileKey(fileInfo)));
            }
            this.delFile(client, this.getAbsolutePath(this.getFileKey(fileInfo)));
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            throw ExceptionFactory.delete(fileInfo, this.platform, e);
        }
        finally {
            this.returnClient(client);
        }
    }

    public void delFile(Sftp client, String filename) {
        block2: {
            try {
                client.delFile(filename);
            }
            catch (JschRuntimeException e) {
                if (e.getCause() instanceof SftpException && ((SftpException)e.getCause()).id == 2) break block2;
                throw e;
            }
        }
    }

    @Override
    public boolean exists(FileInfo fileInfo) {
        Sftp client = this.getClient();
        try {
            boolean bl = client.exist(this.getAbsolutePath(this.getFileKey(fileInfo)));
            return bl;
        }
        catch (Exception e) {
            throw ExceptionFactory.exists(fileInfo, this.platform, e);
        }
        finally {
            this.returnClient(client);
        }
    }

    @Override
    public void download(FileInfo fileInfo, Consumer<InputStream> consumer) {
        Sftp client = this.getClient();
        try (InputStream in = client.getClient().get(this.getAbsolutePath(this.getFileKey(fileInfo)));){
            consumer.accept(in);
        }
        catch (Exception e) {
            throw ExceptionFactory.download(fileInfo, this.platform, e);
        }
        finally {
            this.returnClient(client);
        }
    }

    @Override
    public void downloadTh(FileInfo fileInfo, Consumer<InputStream> consumer) {
        Check.downloadThBlankThFilename(this.platform, fileInfo);
        Sftp client = this.getClient();
        try (InputStream in = client.getClient().get(this.getAbsolutePath(this.getThFileKey(fileInfo)));){
            consumer.accept(in);
        }
        catch (Exception e) {
            throw ExceptionFactory.downloadTh(fileInfo, this.platform, e);
        }
        finally {
            this.returnClient(client);
        }
    }

    @Override
    public boolean isSupportSameMove() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sameMove(FileInfo srcFileInfo, FileInfo destFileInfo, MovePretreatment pre) {
        Check.sameMoveNotSupportAcl(this.platform, srcFileInfo, destFileInfo, pre);
        Check.sameMoveNotSupportMetadata(this.platform, srcFileInfo, destFileInfo, pre);
        Check.sameMoveBasePath(this.platform, this.basePath, srcFileInfo, destFileInfo);
        String srcPath = this.getAbsolutePath(srcFileInfo.getBasePath() + srcFileInfo.getPath());
        String destPath = this.getAbsolutePath(destFileInfo.getBasePath() + destFileInfo.getPath());
        String relativizePath = Paths.get(srcPath, new String[0]).relativize(Paths.get(destPath, new String[0])).toString().replace("\\", "/") + "/";
        Sftp client = this.getClient();
        try {
            SftpATTRS srcFile;
            ChannelSftp ftpClient = client.getClient();
            client.cd(srcPath);
            try {
                srcFile = ftpClient.stat(srcFileInfo.getFilename());
            }
            catch (Exception e) {
                throw ExceptionFactory.sameMoveNotFound(srcFileInfo, destFileInfo, this.platform, e);
            }
            String destThFileRelativizeKey = null;
            if (StrUtil.isNotBlank((CharSequence)srcFileInfo.getThFilename())) {
                destFileInfo.setThUrl(this.domain + this.getThFileKey(destFileInfo));
                destThFileRelativizeKey = relativizePath + destFileInfo.getThFilename();
                try {
                    client.mkDirs(destPath);
                    ftpClient.rename(srcFileInfo.getThFilename(), destThFileRelativizeKey);
                }
                catch (Exception e) {
                    throw ExceptionFactory.sameMoveTh(srcFileInfo, destFileInfo, this.platform, e);
                }
            }
            String destFileKey = this.getFileKey(destFileInfo);
            destFileInfo.setUrl(this.domain + destFileKey);
            String destFileRelativizeKey = relativizePath + destFileInfo.getFilename();
            try {
                ProgressListener.quickStart(pre.getProgressListener(), srcFile.getSize());
                ftpClient.rename(srcFileInfo.getFilename(), destFileRelativizeKey);
                ProgressListener.quickFinish(pre.getProgressListener(), srcFile.getSize());
            }
            catch (Exception e) {
                if (destThFileRelativizeKey != null) {
                    try {
                        ftpClient.rename(destThFileRelativizeKey, srcFileInfo.getThFilename());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                try {
                    if (client.exist(srcFileInfo.getFilename())) {
                        client.delFile(destFileRelativizeKey);
                    } else {
                        ftpClient.rename(destFileRelativizeKey, srcFileInfo.getFilename());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw ExceptionFactory.sameMove(srcFileInfo, destFileInfo, this.platform, e);
            }
        }
        finally {
            this.returnClient(client);
        }
    }

    @Override
    @Generated
    public String getPlatform() {
        return this.platform;
    }

    @Generated
    public String getDomain() {
        return this.domain;
    }

    @Generated
    public String getBasePath() {
        return this.basePath;
    }

    @Generated
    public String getStoragePath() {
        return this.storagePath;
    }

    @Generated
    public FileStorageClientFactory<Sftp> getClientFactory() {
        return this.clientFactory;
    }

    @Override
    @Generated
    public void setPlatform(String platform) {
        this.platform = platform;
    }

    @Generated
    public void setDomain(String domain) {
        this.domain = domain;
    }

    @Generated
    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    @Generated
    public void setStoragePath(String storagePath) {
        this.storagePath = storagePath;
    }

    @Generated
    public void setClientFactory(FileStorageClientFactory<Sftp> clientFactory) {
        this.clientFactory = clientFactory;
    }

    @Generated
    public SftpFileStorage() {
    }
}

