/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.x.file.storage.core.platform;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.file.FileNameUtil;
import cn.hutool.core.lang.Dict;
import cn.hutool.core.util.StrUtil;
import com.qiniu.common.QiniuException;
import com.qiniu.storage.ApiUploadV2AbortUpload;
import com.qiniu.storage.ApiUploadV2CompleteUpload;
import com.qiniu.storage.ApiUploadV2InitUpload;
import com.qiniu.storage.ApiUploadV2ListParts;
import com.qiniu.storage.ApiUploadV2UploadPart;
import com.qiniu.storage.BucketManager;
import com.qiniu.storage.UploadManager;
import com.qiniu.storage.model.FileListing;
import com.qiniu.util.StringMap;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import lombok.Generated;
import org.dromara.x.file.storage.core.FileInfo;
import org.dromara.x.file.storage.core.FileStorageProperties;
import org.dromara.x.file.storage.core.InputStreamPlus;
import org.dromara.x.file.storage.core.ProgressListener;
import org.dromara.x.file.storage.core.UploadPretreatment;
import org.dromara.x.file.storage.core.copy.CopyPretreatment;
import org.dromara.x.file.storage.core.exception.Check;
import org.dromara.x.file.storage.core.exception.ExceptionFactory;
import org.dromara.x.file.storage.core.exception.FileStorageRuntimeException;
import org.dromara.x.file.storage.core.get.GetFilePretreatment;
import org.dromara.x.file.storage.core.get.ListFilesPretreatment;
import org.dromara.x.file.storage.core.get.ListFilesResult;
import org.dromara.x.file.storage.core.get.ListFilesSupportInfo;
import org.dromara.x.file.storage.core.get.RemoteDirInfo;
import org.dromara.x.file.storage.core.get.RemoteFileInfo;
import org.dromara.x.file.storage.core.move.MovePretreatment;
import org.dromara.x.file.storage.core.platform.FileStorage;
import org.dromara.x.file.storage.core.platform.FileStorageClientFactory;
import org.dromara.x.file.storage.core.platform.QiniuKodoFileStorageClientFactory;
import org.dromara.x.file.storage.core.presigned.GeneratePresignedUrlPretreatment;
import org.dromara.x.file.storage.core.presigned.GeneratePresignedUrlResult;
import org.dromara.x.file.storage.core.upload.AbortMultipartUploadPretreatment;
import org.dromara.x.file.storage.core.upload.CompleteMultipartUploadPretreatment;
import org.dromara.x.file.storage.core.upload.FilePartInfo;
import org.dromara.x.file.storage.core.upload.FilePartInfoList;
import org.dromara.x.file.storage.core.upload.InitiateMultipartUploadPretreatment;
import org.dromara.x.file.storage.core.upload.ListPartsPretreatment;
import org.dromara.x.file.storage.core.upload.MultipartUploadSupportInfo;
import org.dromara.x.file.storage.core.upload.UploadPartPretreatment;

public class QiniuKodoFileStorage
implements FileStorage {
    private String platform;
    private String bucketName;
    private String domain;
    private String basePath;
    private FileStorageClientFactory<QiniuKodoFileStorageClientFactory.QiniuKodoClient> clientFactory;

    public QiniuKodoFileStorage(FileStorageProperties.QiniuKodoConfig config, FileStorageClientFactory<QiniuKodoFileStorageClientFactory.QiniuKodoClient> clientFactory) {
        this.platform = config.getPlatform();
        this.bucketName = config.getBucketName();
        this.domain = config.getDomain();
        this.basePath = config.getBasePath();
        this.clientFactory = clientFactory;
    }

    public QiniuKodoFileStorageClientFactory.QiniuKodoClient getClient() {
        return this.clientFactory.getClient();
    }

    @Override
    public void close() {
        this.clientFactory.close();
    }

    @Override
    public boolean save(FileInfo fileInfo, UploadPretreatment pre) {
        boolean bl;
        block12: {
            fileInfo.setBasePath(this.basePath);
            String newFileKey = this.getFileKey(fileInfo);
            fileInfo.setUrl(this.domain + newFileKey);
            Check.uploadNotSupportAcl(this.platform, fileInfo, pre);
            InputStreamPlus in = pre.getInputStreamPlus();
            try {
                byte[] thumbnailBytes;
                QiniuKodoFileStorageClientFactory.QiniuKodoClient client = this.getClient();
                UploadManager uploadManager = client.getUploadManager();
                String token = client.getAuth().uploadToken(this.bucketName);
                uploadManager.put((InputStream)in, newFileKey, token, this.getObjectMetadata(fileInfo), fileInfo.getContentType());
                if (fileInfo.getSize() == null) {
                    fileInfo.setSize(in.getProgressSize());
                }
                if ((thumbnailBytes = pre.getThumbnailBytes()) != null) {
                    String newThFileKey = this.getThFileKey(fileInfo);
                    fileInfo.setThUrl(this.domain + newThFileKey);
                    uploadManager.put((InputStream)new ByteArrayInputStream(thumbnailBytes), newThFileKey, token, this.getThObjectMetadata(fileInfo), fileInfo.getThContentType());
                }
                bl = true;
                if (in == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    try {
                        this.getClient().getBucketManager().delete(this.bucketName, newFileKey);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw ExceptionFactory.upload(fileInfo, this.platform, e);
                }
            }
            in.close();
        }
        return bl;
    }

    @Override
    public MultipartUploadSupportInfo isSupportMultipartUpload() {
        return MultipartUploadSupportInfo.supportAll();
    }

    @Override
    public void initiateMultipartUpload(FileInfo fileInfo, InitiateMultipartUploadPretreatment pre) {
        fileInfo.setBasePath(this.basePath);
        String newFileKey = this.getFileKey(fileInfo);
        fileInfo.setUrl(this.domain + newFileKey);
        Check.uploadNotSupportAcl(this.platform, fileInfo, pre);
        QiniuKodoFileStorageClientFactory.QiniuKodoClient client = this.getClient();
        try {
            String token = client.getAuth().uploadToken(this.bucketName);
            QiniuKodoFileStorageClientFactory.QiniuKodoClient.UploadActionResult result = client.retryUploadAction(host -> {
                ApiUploadV2InitUpload api = new ApiUploadV2InitUpload(client.getClient());
                ApiUploadV2InitUpload.Request request = new ApiUploadV2InitUpload.Request(host, token).setKey(newFileKey);
                ApiUploadV2InitUpload.Response response = api.request(request);
                return new QiniuKodoFileStorageClientFactory.QiniuKodoClient.UploadActionResult<ApiUploadV2InitUpload.Response>(response.getResponse(), response);
            }, token);
            fileInfo.setUploadId(((ApiUploadV2InitUpload.Response)result.getData()).getUploadId());
        }
        catch (Exception e) {
            throw ExceptionFactory.initiateMultipartUpload(fileInfo, this.platform, e);
        }
    }

    @Override
    public FilePartInfo uploadPart(UploadPartPretreatment pre) {
        FilePartInfo filePartInfo;
        block8: {
            FileInfo fileInfo = pre.getFileInfo();
            String newFileKey = this.getFileKey(fileInfo);
            QiniuKodoFileStorageClientFactory.QiniuKodoClient client = this.getClient();
            InputStreamPlus in = pre.getInputStreamPlus();
            try {
                String token = client.getAuth().uploadToken(this.bucketName);
                QiniuKodoFileStorageClientFactory.QiniuKodoClient.UploadActionResult result = client.retryUploadAction(host -> {
                    ApiUploadV2UploadPart api = new ApiUploadV2UploadPart(client.getClient());
                    ApiUploadV2UploadPart.Request request = new ApiUploadV2UploadPart.Request(host, token, fileInfo.getUploadId(), Integer.valueOf(pre.getPartNumber())).setKey(newFileKey).setUploadData((InputStream)in, null, -1L);
                    ApiUploadV2UploadPart.Response response = api.request(request);
                    return new QiniuKodoFileStorageClientFactory.QiniuKodoClient.UploadActionResult<ApiUploadV2UploadPart.Response>(response.getResponse(), response);
                }, token);
                FilePartInfo filePartInfo2 = new FilePartInfo(fileInfo);
                filePartInfo2.setETag(((ApiUploadV2UploadPart.Response)result.getData()).getEtag());
                filePartInfo2.setPartNumber(pre.getPartNumber());
                filePartInfo2.setPartSize(in.getProgressSize());
                filePartInfo2.setCreateTime(new Date());
                filePartInfo = filePartInfo2;
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw ExceptionFactory.uploadPart(fileInfo, this.platform, e);
                }
            }
            in.close();
        }
        return filePartInfo;
    }

    @Override
    public void completeMultipartUpload(CompleteMultipartUploadPretreatment pre) {
        FileInfo fileInfo = pre.getFileInfo();
        String newFileKey = this.getFileKey(fileInfo);
        QiniuKodoFileStorageClientFactory.QiniuKodoClient client = this.getClient();
        try {
            List partsInfo = pre.getPartInfoList().stream().map(part -> {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("partNumber", part.getPartNumber());
                map.put("etag", part.getETag());
                return map;
            }).collect(Collectors.toList());
            StringMap metadata = this.getObjectMetadata(fileInfo);
            ProgressListener.quickStart(pre.getProgressListener(), fileInfo.getSize());
            String token = client.getAuth().uploadToken(this.bucketName);
            client.retryUploadAction(host -> {
                ApiUploadV2CompleteUpload api = new ApiUploadV2CompleteUpload(client.getClient());
                ApiUploadV2CompleteUpload.Request request = new ApiUploadV2CompleteUpload.Request(host, token, fileInfo.getUploadId(), partsInfo).setKey(newFileKey).setFileMimeType(fileInfo.getContentType()).setFileName(null).setCustomParam(metadata.map()).setCustomMetaParam(metadata.map());
                ApiUploadV2CompleteUpload.Response response = api.request(request);
                return new QiniuKodoFileStorageClientFactory.QiniuKodoClient.UploadActionResult<ApiUploadV2CompleteUpload.Response>(response.getResponse(), response);
            }, token);
            ProgressListener.quickFinish(pre.getProgressListener(), fileInfo.getSize());
        }
        catch (Exception e) {
            throw ExceptionFactory.completeMultipartUpload(fileInfo, this.platform, e);
        }
    }

    @Override
    public void abortMultipartUpload(AbortMultipartUploadPretreatment pre) {
        FileInfo fileInfo = pre.getFileInfo();
        String newFileKey = this.getFileKey(fileInfo);
        QiniuKodoFileStorageClientFactory.QiniuKodoClient client = this.getClient();
        try {
            String token = client.getAuth().uploadToken(this.bucketName);
            client.retryUploadAction(host -> {
                ApiUploadV2AbortUpload api = new ApiUploadV2AbortUpload(client.getClient());
                ApiUploadV2AbortUpload.Request request = new ApiUploadV2AbortUpload.Request(host, token, fileInfo.getUploadId()).setKey(newFileKey);
                ApiUploadV2AbortUpload.Response response = api.request(request);
                return new QiniuKodoFileStorageClientFactory.QiniuKodoClient.UploadActionResult<ApiUploadV2AbortUpload.Response>(response.getResponse(), response);
            }, token);
        }
        catch (Exception e) {
            throw ExceptionFactory.abortMultipartUpload(fileInfo, this.platform, e);
        }
    }

    @Override
    public FilePartInfoList listParts(ListPartsPretreatment pre) {
        FileInfo fileInfo = pre.getFileInfo();
        String newFileKey = this.getFileKey(fileInfo);
        QiniuKodoFileStorageClientFactory.QiniuKodoClient client = this.getClient();
        try {
            String token = client.getAuth().uploadToken(this.bucketName);
            QiniuKodoFileStorageClientFactory.QiniuKodoClient.UploadActionResult result = client.retryUploadAction(host -> {
                ApiUploadV2ListParts api = new ApiUploadV2ListParts(client.getClient());
                ApiUploadV2ListParts.Request request = new ApiUploadV2ListParts.Request(host, token, fileInfo.getUploadId()).setKey(newFileKey).setMaxParts(pre.getMaxParts()).setPartNumberMarker(pre.getPartNumberMarker());
                ApiUploadV2ListParts.Response response = api.request(request);
                return new QiniuKodoFileStorageClientFactory.QiniuKodoClient.UploadActionResult<ApiUploadV2ListParts.Response>(response.getResponse(), response);
            }, token);
            ApiUploadV2ListParts.Response response = (ApiUploadV2ListParts.Response)result.getData();
            List parts = response.getParts();
            if (parts == null) {
                parts = Collections.emptyList();
            }
            FilePartInfoList list = new FilePartInfoList();
            list.setFileInfo(fileInfo);
            list.setList(parts.stream().map(p -> {
                Dict dict = new Dict(BeanUtil.beanToMap((Object)p, (String[])new String[0]));
                FilePartInfo filePartInfo = new FilePartInfo(fileInfo);
                filePartInfo.setETag(dict.getStr("etag"));
                filePartInfo.setPartNumber(dict.getInt("partNumber"));
                filePartInfo.setPartSize(dict.getLong("size"));
                filePartInfo.setLastModified(new Date(dict.getLong("putTime") * 1000L));
                return filePartInfo;
            }).collect(Collectors.toList()));
            list.setMaxParts(pre.getMaxParts());
            list.setIsTruncated(response.getPartNumberMarker() > 0);
            list.setPartNumberMarker(pre.getPartNumberMarker());
            list.setNextPartNumberMarker(response.getPartNumberMarker());
            return list;
        }
        catch (Exception e) {
            throw ExceptionFactory.listParts(fileInfo, this.platform, e);
        }
    }

    @Override
    public ListFilesSupportInfo isSupportListFiles() {
        return ListFilesSupportInfo.supportAll();
    }

    @Override
    public ListFilesResult listFiles(ListFilesPretreatment pre) {
        BucketManager manager = this.getClient().getBucketManager();
        try {
            String newFileKey = this.basePath + pre.getPath();
            FileListing result = manager.listFilesV2(this.bucketName, this.basePath + pre.getPath() + pre.getFilenamePrefix(), pre.getMarker(), pre.getMaxFiles().intValue(), "/");
            ListFilesResult list = new ListFilesResult();
            list.setDirList(Arrays.stream(result.commonPrefixes).map(item -> {
                RemoteDirInfo dir = new RemoteDirInfo();
                dir.setPlatform(pre.getPlatform());
                dir.setBasePath(this.basePath);
                dir.setPath(pre.getPath());
                dir.setName(FileNameUtil.getName((String)item));
                dir.setOriginal(item);
                return dir;
            }).collect(Collectors.toList()));
            list.setFileList(Arrays.stream(result.items).filter(item -> !newFileKey.equals(item.key)).map(item -> {
                RemoteFileInfo info = new RemoteFileInfo();
                info.setPlatform(pre.getPlatform());
                info.setBasePath(this.basePath);
                info.setPath(pre.getPath());
                info.setFilename(FileNameUtil.getName((String)item.key));
                info.setUrl(this.domain + this.getFileKey(new FileInfo(this.basePath, info.getPath(), info.getFilename())));
                info.setSize(item.fsize);
                info.setExt(FileNameUtil.extName((String)info.getFilename()));
                info.setContentType(item.mimeType);
                info.setContentMd5(item.md5);
                info.setLastModified(new Date(item.putTime / 10000L));
                HashMap<String, Object> metadata = new HashMap<String, Object>();
                metadata.put("Content-Length", item.fsize);
                if (item.mimeType != null) {
                    metadata.put("Content-Type", item.mimeType);
                }
                if (item.md5 != null) {
                    metadata.put("Content-MD5", item.md5);
                }
                metadata.put("Last-Modified", info.getLastModified());
                if (item.expiration != null) {
                    metadata.put("Expires", DateUtil.formatHttpDate((Date)new Date(item.expiration * 1000L)));
                }
                info.setMetadata(metadata);
                info.setUserMetadata(item.meta);
                info.setOriginal(item);
                return info;
            }).collect(Collectors.toList()));
            list.setPlatform(pre.getPlatform());
            list.setBasePath(this.basePath);
            list.setPath(pre.getPath());
            list.setFilenamePrefix(pre.getFilenamePrefix());
            list.setMaxFiles(pre.getMaxFiles());
            list.setIsTruncated(!result.isEOF());
            list.setMarker(pre.getMarker());
            list.setNextMarker(result.marker);
            return list;
        }
        catch (Exception e) {
            throw ExceptionFactory.listFiles(pre, this.basePath, e);
        }
    }

    @Override
    public RemoteFileInfo getFile(GetFilePretreatment pre) {
        String fileKey = this.getFileKey(new FileInfo(this.basePath, pre.getPath(), pre.getFilename()));
        QiniuKodoFileStorageClientFactory.QiniuKodoClient client = this.getClient();
        try {
            com.qiniu.storage.model.FileInfo file;
            try {
                file = client.getBucketManager().stat(this.bucketName, fileKey);
            }
            catch (Exception e) {
                return null;
            }
            if (file == null) {
                return null;
            }
            RemoteFileInfo info = new RemoteFileInfo();
            info.setPlatform(pre.getPlatform());
            info.setBasePath(this.basePath);
            info.setPath(pre.getPath());
            info.setFilename(FileNameUtil.getName((String)file.key));
            info.setUrl(this.domain + fileKey);
            info.setSize(file.fsize);
            info.setExt(FileNameUtil.extName((String)info.getFilename()));
            info.setContentType(file.mimeType);
            info.setContentMd5(file.md5);
            info.setLastModified(new Date(file.putTime / 10000L));
            HashMap<String, Object> metadata = new HashMap<String, Object>();
            metadata.put("Content-Length", file.fsize);
            if (file.mimeType != null) {
                metadata.put("Content-Type", file.mimeType);
            }
            if (file.md5 != null) {
                metadata.put("Content-MD5", file.md5);
            }
            metadata.put("Last-Modified", info.getLastModified());
            if (file.expiration != null) {
                metadata.put("Expires", DateUtil.formatHttpDate((Date)new Date(file.expiration * 1000L)));
            }
            info.setMetadata(metadata);
            info.setUserMetadata(file.meta);
            info.setOriginal(file);
            return info;
        }
        catch (Exception e) {
            throw ExceptionFactory.getFile(pre, this.basePath, e);
        }
    }

    public StringMap getObjectMetadata(FileInfo fileInfo) {
        StringMap params = new StringMap();
        if (CollUtil.isNotEmpty(fileInfo.getMetadata())) {
            fileInfo.getMetadata().forEach((arg_0, arg_1) -> ((StringMap)params).put(arg_0, arg_1));
        }
        if (CollUtil.isNotEmpty(fileInfo.getUserMetadata())) {
            fileInfo.getUserMetadata().forEach((key, value) -> params.put(key.startsWith("x-qn-meta-") ? key : "x-qn-meta-" + key, value));
        }
        return params;
    }

    public StringMap getThObjectMetadata(FileInfo fileInfo) {
        StringMap params = new StringMap();
        if (CollUtil.isNotEmpty(fileInfo.getThMetadata())) {
            fileInfo.getThMetadata().forEach((arg_0, arg_1) -> ((StringMap)params).put(arg_0, arg_1));
        }
        if (CollUtil.isNotEmpty(fileInfo.getThUserMetadata())) {
            fileInfo.getThUserMetadata().forEach((key, value) -> params.put(key.startsWith("x-qn-meta-") ? key : "x-qn-meta-" + key, value));
        }
        return params;
    }

    @Override
    public boolean isSupportPresignedUrl() {
        return true;
    }

    @Override
    public GeneratePresignedUrlResult generatePresignedUrl(GeneratePresignedUrlPretreatment pre) {
        try {
            if (!"GET".equalsIgnoreCase(String.valueOf(pre.getMethod()))) {
                throw new FileStorageRuntimeException("\u4e03\u725b\u4e91 Kode \u4ec5\u652f\u6301 GET \uff0c\u5982\u9700\u652f\u6301\u66f4\u591a\u529f\u80fd\uff0c\u53ef\u4ee5\u901a\u8fc7 AWS S3 \u7684 SDK \u6765\u4f7f\u7528");
            }
            String fileKey = this.getFileKey(new FileInfo(this.basePath, pre.getPath(), pre.getFilename()));
            int deadline = (int)(pre.getExpiration().getTime() / 1000L);
            String url = this.getClient().getAuth().privateDownloadUrlWithDeadline(this.domain + fileKey, (long)deadline);
            GeneratePresignedUrlResult result = new GeneratePresignedUrlResult(this.platform, this.basePath, pre);
            result.setUrl(url);
            result.setHeaders(new HashMap<String, String>());
            return result;
        }
        catch (Exception e) {
            throw ExceptionFactory.generatePresignedUrl(pre, e);
        }
    }

    @Override
    public boolean isSupportMetadata() {
        return true;
    }

    @Override
    public boolean delete(FileInfo fileInfo) {
        BucketManager manager = this.getClient().getBucketManager();
        try {
            if (fileInfo.getThFilename() != null) {
                this.delete(manager, this.getThFileKey(fileInfo));
            }
            this.delete(manager, this.getFileKey(fileInfo));
        }
        catch (Exception e) {
            throw ExceptionFactory.delete(fileInfo, this.platform, e);
        }
        return true;
    }

    public void delete(BucketManager manager, String filename) throws QiniuException {
        block2: {
            try {
                manager.delete(this.bucketName, filename);
            }
            catch (QiniuException e) {
                if (e.response != null && e.response.statusCode == 612) break block2;
                throw e;
            }
        }
    }

    @Override
    public boolean exists(FileInfo fileInfo) {
        try {
            return this.exists(this.getFileKey(fileInfo));
        }
        catch (Exception e) {
            throw ExceptionFactory.exists(fileInfo, this.platform, e);
        }
    }

    public boolean exists(String fileKey) throws QiniuException {
        BucketManager manager = this.getClient().getBucketManager();
        try {
            com.qiniu.storage.model.FileInfo stat = manager.stat(this.bucketName, fileKey);
            if (stat != null && (StrUtil.isNotBlank((CharSequence)stat.md5) || StrUtil.isNotBlank((CharSequence)stat.hash))) {
                return true;
            }
        }
        catch (QiniuException e) {
            if (e.code() == 612) {
                return false;
            }
            throw e;
        }
        return false;
    }

    @Override
    public void download(FileInfo fileInfo, Consumer<InputStream> consumer) {
        String newFileKey = this.getFileKey(fileInfo);
        String url = this.domain + newFileKey;
        try (InputStream in = new URL(url).openStream();){
            consumer.accept(in);
        }
        catch (Exception e) {
            throw ExceptionFactory.download(fileInfo, this.platform, e);
        }
    }

    @Override
    public void downloadTh(FileInfo fileInfo, Consumer<InputStream> consumer) {
        Check.downloadThBlankThFilename(this.platform, fileInfo);
        String newFileKey = this.getFileKey(fileInfo);
        String url = this.domain + newFileKey;
        try (InputStream in = new URL(url).openStream();){
            consumer.accept(in);
        }
        catch (Exception e) {
            throw ExceptionFactory.downloadTh(fileInfo, this.platform, e);
        }
    }

    @Override
    public boolean isSupportSameCopy() {
        return true;
    }

    @Override
    public void sameCopy(FileInfo srcFileInfo, FileInfo destFileInfo, CopyPretreatment pre) {
        com.qiniu.storage.model.FileInfo srcFile;
        Check.sameCopyNotSupportAcl(this.platform, srcFileInfo, destFileInfo, pre);
        Check.sameCopyBasePath(this.platform, this.basePath, srcFileInfo, destFileInfo);
        BucketManager manager = this.getClient().getBucketManager();
        String srcFileKey = this.getFileKey(srcFileInfo);
        try {
            srcFile = manager.stat(this.bucketName, srcFileKey);
            if (srcFile == null || StrUtil.isBlank((CharSequence)srcFile.md5) && StrUtil.isBlank((CharSequence)srcFile.hash)) {
                throw ExceptionFactory.sameCopyNotFound(srcFileInfo, destFileInfo, this.platform, null);
            }
        }
        catch (Exception e) {
            throw ExceptionFactory.sameCopyNotFound(srcFileInfo, destFileInfo, this.platform, e);
        }
        String destThFileKey = null;
        if (StrUtil.isNotBlank((CharSequence)srcFileInfo.getThFilename())) {
            destThFileKey = this.getThFileKey(destFileInfo);
            destFileInfo.setThUrl(this.domain + destThFileKey);
            try {
                manager.copy(this.bucketName, this.getThFileKey(srcFileInfo), this.bucketName, destThFileKey, true);
            }
            catch (Exception e) {
                throw ExceptionFactory.sameCopyTh(srcFileInfo, destFileInfo, this.platform, e);
            }
        }
        String destFileKey = this.getFileKey(destFileInfo);
        destFileInfo.setUrl(this.domain + destFileKey);
        try {
            ProgressListener.quickStart(pre.getProgressListener(), srcFile.fsize);
            manager.copy(this.bucketName, srcFileKey, this.bucketName, destFileKey, true);
            ProgressListener.quickFinish(pre.getProgressListener(), srcFile.fsize);
        }
        catch (Exception e) {
            if (destThFileKey != null) {
                try {
                    manager.delete(this.bucketName, destThFileKey);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                manager.delete(this.bucketName, destFileKey);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw ExceptionFactory.sameCopy(srcFileInfo, destFileInfo, this.platform, e);
        }
    }

    @Override
    public boolean isSupportSameMove() {
        return true;
    }

    @Override
    public void sameMove(FileInfo srcFileInfo, FileInfo destFileInfo, MovePretreatment pre) {
        com.qiniu.storage.model.FileInfo srcFile;
        Check.sameMoveNotSupportAcl(this.platform, srcFileInfo, destFileInfo, pre);
        Check.sameMoveBasePath(this.platform, this.basePath, srcFileInfo, destFileInfo);
        BucketManager manager = this.getClient().getBucketManager();
        String srcFileKey = this.getFileKey(srcFileInfo);
        try {
            srcFile = manager.stat(this.bucketName, srcFileKey);
            if (srcFile == null || StrUtil.isBlank((CharSequence)srcFile.md5) && StrUtil.isBlank((CharSequence)srcFile.hash)) {
                throw ExceptionFactory.sameMoveNotFound(srcFileInfo, destFileInfo, this.platform, null);
            }
        }
        catch (Exception e) {
            throw ExceptionFactory.sameMoveNotFound(srcFileInfo, destFileInfo, this.platform, e);
        }
        String srcThFileKey = null;
        String destThFileKey = null;
        if (StrUtil.isNotBlank((CharSequence)srcFileInfo.getThFilename())) {
            srcThFileKey = this.getThFileKey(srcFileInfo);
            destThFileKey = this.getThFileKey(destFileInfo);
            destFileInfo.setThUrl(this.domain + destThFileKey);
            try {
                manager.move(this.bucketName, srcThFileKey, this.bucketName, destThFileKey, true);
            }
            catch (Exception e) {
                throw ExceptionFactory.sameMoveTh(srcFileInfo, destFileInfo, this.platform, e);
            }
        }
        String destFileKey = this.getFileKey(destFileInfo);
        destFileInfo.setUrl(this.domain + destFileKey);
        try {
            ProgressListener.quickStart(pre.getProgressListener(), srcFile.fsize);
            manager.move(this.bucketName, srcFileKey, this.bucketName, destFileKey, true);
            ProgressListener.quickFinish(pre.getProgressListener(), srcFile.fsize);
        }
        catch (Exception e) {
            if (destThFileKey != null) {
                try {
                    manager.move(this.bucketName, destThFileKey, this.bucketName, srcThFileKey, true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                if (this.exists(srcFileKey)) {
                    manager.delete(this.bucketName, destFileKey);
                } else {
                    manager.move(this.bucketName, destFileKey, this.bucketName, srcFileKey, true);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw ExceptionFactory.sameMove(srcFileInfo, destFileInfo, this.platform, e);
        }
    }

    @Override
    @Generated
    public String getPlatform() {
        return this.platform;
    }

    @Generated
    public String getBucketName() {
        return this.bucketName;
    }

    @Generated
    public String getDomain() {
        return this.domain;
    }

    @Generated
    public String getBasePath() {
        return this.basePath;
    }

    @Generated
    public FileStorageClientFactory<QiniuKodoFileStorageClientFactory.QiniuKodoClient> getClientFactory() {
        return this.clientFactory;
    }

    @Override
    @Generated
    public void setPlatform(String platform) {
        this.platform = platform;
    }

    @Generated
    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    @Generated
    public void setDomain(String domain) {
        this.domain = domain;
    }

    @Generated
    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    @Generated
    public void setClientFactory(FileStorageClientFactory<QiniuKodoFileStorageClientFactory.QiniuKodoClient> clientFactory) {
        this.clientFactory = clientFactory;
    }

    @Generated
    public QiniuKodoFileStorage() {
    }
}

