/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.x.file.storage.core.platform;

import io.minio.MinioClient;
import lombok.Generated;
import org.dromara.x.file.storage.core.FileStorageProperties;
import org.dromara.x.file.storage.core.platform.FileStorageClientFactory;

public class MinioFileStorageClientFactory
implements FileStorageClientFactory<MinioClient> {
    private String platform;
    private String accessKey;
    private String secretKey;
    private String endPoint;
    private volatile MinioClient client;

    public MinioFileStorageClientFactory(FileStorageProperties.MinioConfig config) {
        this.platform = config.getPlatform();
        this.accessKey = config.getAccessKey();
        this.secretKey = config.getSecretKey();
        this.endPoint = config.getEndPoint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MinioClient getClient() {
        if (this.client == null) {
            MinioFileStorageClientFactory minioFileStorageClientFactory = this;
            synchronized (minioFileStorageClientFactory) {
                if (this.client == null) {
                    this.client = new MinioClient.Builder().credentials(this.accessKey, this.secretKey).endpoint(this.endPoint).build();
                }
            }
        }
        return this.client;
    }

    @Override
    public void close() {
        this.client = null;
    }

    @Override
    @Generated
    public String getPlatform() {
        return this.platform;
    }

    @Generated
    public String getAccessKey() {
        return this.accessKey;
    }

    @Generated
    public String getSecretKey() {
        return this.secretKey;
    }

    @Generated
    public String getEndPoint() {
        return this.endPoint;
    }

    @Generated
    public void setPlatform(String platform) {
        this.platform = platform;
    }

    @Generated
    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    @Generated
    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    @Generated
    public void setEndPoint(String endPoint) {
        this.endPoint = endPoint;
    }

    @Generated
    public void setClient(MinioClient client) {
        this.client = client;
    }

    @Generated
    public MinioFileStorageClientFactory() {
    }
}

