/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.x.file.storage.core.platform;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.io.file.FileNameUtil;
import cn.hutool.core.text.NamingCase;
import cn.hutool.core.util.StrUtil;
import com.obs.services.ObsClient;
import com.obs.services.internal.ObsConvertor;
import com.obs.services.model.AbortMultipartUploadRequest;
import com.obs.services.model.AccessControlList;
import com.obs.services.model.CompleteMultipartUploadRequest;
import com.obs.services.model.CopyObjectRequest;
import com.obs.services.model.CopyPartRequest;
import com.obs.services.model.HttpMethodEnum;
import com.obs.services.model.InitiateMultipartUploadRequest;
import com.obs.services.model.ListObjectsRequest;
import com.obs.services.model.ListPartsRequest;
import com.obs.services.model.ListPartsResult;
import com.obs.services.model.ObjectListing;
import com.obs.services.model.ObjectMetadata;
import com.obs.services.model.ObsObject;
import com.obs.services.model.PartEtag;
import com.obs.services.model.PutObjectRequest;
import com.obs.services.model.SpecialParamEnum;
import com.obs.services.model.TemporarySignatureRequest;
import com.obs.services.model.TemporarySignatureResponse;
import com.obs.services.model.UploadPartRequest;
import com.obs.services.model.UploadPartResult;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import lombok.Generated;
import org.dromara.x.file.storage.core.FileInfo;
import org.dromara.x.file.storage.core.FileStorageProperties;
import org.dromara.x.file.storage.core.InputStreamPlus;
import org.dromara.x.file.storage.core.ProgressListener;
import org.dromara.x.file.storage.core.UploadPretreatment;
import org.dromara.x.file.storage.core.copy.CopyPretreatment;
import org.dromara.x.file.storage.core.exception.Check;
import org.dromara.x.file.storage.core.exception.ExceptionFactory;
import org.dromara.x.file.storage.core.file.FileWrapper;
import org.dromara.x.file.storage.core.get.GetFilePretreatment;
import org.dromara.x.file.storage.core.get.ListFilesPretreatment;
import org.dromara.x.file.storage.core.get.ListFilesResult;
import org.dromara.x.file.storage.core.get.ListFilesSupportInfo;
import org.dromara.x.file.storage.core.get.RemoteDirInfo;
import org.dromara.x.file.storage.core.get.RemoteFileInfo;
import org.dromara.x.file.storage.core.platform.FileStorage;
import org.dromara.x.file.storage.core.platform.FileStorageClientFactory;
import org.dromara.x.file.storage.core.presigned.GeneratePresignedUrlPretreatment;
import org.dromara.x.file.storage.core.presigned.GeneratePresignedUrlResult;
import org.dromara.x.file.storage.core.upload.AbortMultipartUploadPretreatment;
import org.dromara.x.file.storage.core.upload.CompleteMultipartUploadPretreatment;
import org.dromara.x.file.storage.core.upload.FilePartInfo;
import org.dromara.x.file.storage.core.upload.FilePartInfoList;
import org.dromara.x.file.storage.core.upload.InitiateMultipartUploadPretreatment;
import org.dromara.x.file.storage.core.upload.ListPartsPretreatment;
import org.dromara.x.file.storage.core.upload.MultipartUploadSupportInfo;
import org.dromara.x.file.storage.core.upload.UploadPartPretreatment;
import org.dromara.x.file.storage.core.util.Tools;

public class HuaweiObsFileStorage
implements FileStorage {
    private String platform;
    private String bucketName;
    private String domain;
    private String basePath;
    private String defaultAcl;
    private int multipartThreshold;
    private int multipartPartSize;
    private FileStorageClientFactory<ObsClient> clientFactory;

    public HuaweiObsFileStorage(FileStorageProperties.HuaweiObsConfig config, FileStorageClientFactory<ObsClient> clientFactory) {
        this.platform = config.getPlatform();
        this.bucketName = config.getBucketName();
        this.domain = config.getDomain();
        this.basePath = config.getBasePath();
        this.defaultAcl = config.getDefaultAcl();
        this.multipartThreshold = config.getMultipartThreshold();
        this.multipartPartSize = config.getMultipartPartSize();
        this.clientFactory = clientFactory;
    }

    public ObsClient getClient() {
        return this.clientFactory.getClient();
    }

    @Override
    public void close() {
        this.clientFactory.close();
    }

    @Override
    public boolean save(FileInfo fileInfo, UploadPretreatment pre) {
        boolean bl;
        block22: {
            fileInfo.setBasePath(this.basePath);
            String newFileKey = this.getFileKey(fileInfo);
            fileInfo.setUrl(this.domain + newFileKey);
            AccessControlList fileAcl = this.getAcl(fileInfo.getFileAcl());
            ObjectMetadata metadata = this.getObjectMetadata(fileInfo);
            ProgressListener listener = pre.getProgressListener();
            ObsClient client = this.getClient();
            boolean useMultipartUpload = fileInfo.getSize() == null || fileInfo.getSize() >= (long)this.multipartThreshold;
            String uploadId = null;
            InputStreamPlus in = pre.getInputStreamPlus(false);
            try {
                byte[] thumbnailBytes;
                if (useMultipartUpload) {
                    byte[] bytes;
                    InitiateMultipartUploadRequest initiateMultipartUploadRequest = new InitiateMultipartUploadRequest(this.bucketName, newFileKey);
                    initiateMultipartUploadRequest.setMetadata(metadata);
                    initiateMultipartUploadRequest.setAcl(fileAcl);
                    uploadId = client.initiateMultipartUpload(initiateMultipartUploadRequest).getUploadId();
                    ArrayList<PartEtag> partList = new ArrayList<PartEtag>();
                    int i = 0;
                    AtomicLong progressSize = new AtomicLong();
                    if (listener != null) {
                        listener.start();
                    }
                    while ((bytes = IoUtil.readBytes((InputStream)in, (int)this.multipartPartSize)) != null && bytes.length != 0) {
                        UploadPartRequest part = new UploadPartRequest();
                        part.setBucketName(this.bucketName);
                        part.setObjectKey(newFileKey);
                        part.setUploadId(uploadId);
                        part.setInput((InputStream)new ByteArrayInputStream(bytes));
                        part.setPartSize(Long.valueOf(bytes.length));
                        part.setPartNumber(++i);
                        if (listener != null) {
                            part.setProgressListener(e -> listener.progress(progressSize.addAndGet(e.getNewlyTransferredBytes()), fileInfo.getSize()));
                        }
                        UploadPartResult uploadPartResult = client.uploadPart(part);
                        partList.add(new PartEtag(uploadPartResult.getEtag(), Integer.valueOf(uploadPartResult.getPartNumber())));
                    }
                    client.completeMultipartUpload(new CompleteMultipartUploadRequest(this.bucketName, newFileKey, uploadId, partList));
                    if (listener != null) {
                        listener.finish();
                    }
                } else {
                    PutObjectRequest request = new PutObjectRequest(this.bucketName, newFileKey, (InputStream)in);
                    request.setMetadata(metadata);
                    request.setAcl(fileAcl);
                    if (listener != null) {
                        listener.start();
                        request.setProgressListener(e -> listener.progress(e.getTransferredBytes(), fileInfo.getSize()));
                    }
                    client.putObject(request);
                    if (listener != null) {
                        listener.finish();
                    }
                }
                if (fileInfo.getSize() == null) {
                    fileInfo.setSize(in.getProgressSize());
                }
                if ((thumbnailBytes = pre.getThumbnailBytes()) != null) {
                    String newThFileKey = this.getThFileKey(fileInfo);
                    fileInfo.setThUrl(this.domain + newThFileKey);
                    PutObjectRequest request = new PutObjectRequest(this.bucketName, newThFileKey, (InputStream)new ByteArrayInputStream(thumbnailBytes));
                    request.setMetadata(this.getThObjectMetadata(fileInfo));
                    request.setAcl(this.getAcl(fileInfo.getThFileAcl()));
                    client.putObject(request);
                }
                bl = true;
                if (in == null) break block22;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e2) {
                    try {
                        if (useMultipartUpload) {
                            client.abortMultipartUpload(new AbortMultipartUploadRequest(this.bucketName, newFileKey, uploadId));
                        } else {
                            client.deleteObject(this.bucketName, newFileKey);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw ExceptionFactory.upload(fileInfo, this.platform, e2);
                }
            }
            in.close();
        }
        return bl;
    }

    @Override
    public MultipartUploadSupportInfo isSupportMultipartUpload() {
        return MultipartUploadSupportInfo.supportAll();
    }

    @Override
    public void initiateMultipartUpload(FileInfo fileInfo, InitiateMultipartUploadPretreatment pre) {
        fileInfo.setBasePath(this.basePath);
        String newFileKey = this.getFileKey(fileInfo);
        fileInfo.setUrl(this.domain + newFileKey);
        AccessControlList fileAcl = this.getAcl(fileInfo.getFileAcl());
        ObjectMetadata metadata = this.getObjectMetadata(fileInfo);
        ObsClient client = this.getClient();
        try {
            InitiateMultipartUploadRequest request = new InitiateMultipartUploadRequest(this.bucketName, newFileKey);
            request.setMetadata(metadata);
            request.setAcl(fileAcl);
            String uploadId = client.initiateMultipartUpload(request).getUploadId();
            fileInfo.setUploadId(uploadId);
        }
        catch (Exception e) {
            throw ExceptionFactory.initiateMultipartUpload(fileInfo, this.platform, e);
        }
    }

    @Override
    public FilePartInfo uploadPart(UploadPartPretreatment pre) {
        FilePartInfo filePartInfo;
        block8: {
            FileInfo fileInfo = pre.getFileInfo();
            String newFileKey = this.getFileKey(fileInfo);
            ObsClient client = this.getClient();
            FileWrapper partFileWrapper = pre.getPartFileWrapper();
            Long partSize = partFileWrapper.getSize();
            InputStreamPlus in = pre.getInputStreamPlus();
            try {
                UploadPartRequest part = new UploadPartRequest();
                part.setBucketName(this.bucketName);
                part.setObjectKey(newFileKey);
                part.setUploadId(fileInfo.getUploadId());
                part.setInput((InputStream)in);
                part.setPartSize(partSize);
                part.setPartNumber(pre.getPartNumber());
                UploadPartResult result = client.uploadPart(part);
                FilePartInfo filePartInfo2 = new FilePartInfo(fileInfo);
                filePartInfo2.setETag(result.getEtag());
                filePartInfo2.setPartNumber(result.getPartNumber());
                filePartInfo2.setPartSize(in.getProgressSize());
                filePartInfo2.setCreateTime(new Date());
                filePartInfo = filePartInfo2;
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw ExceptionFactory.uploadPart(fileInfo, this.platform, e);
                }
            }
            in.close();
        }
        return filePartInfo;
    }

    @Override
    public void completeMultipartUpload(CompleteMultipartUploadPretreatment pre) {
        FileInfo fileInfo = pre.getFileInfo();
        String newFileKey = this.getFileKey(fileInfo);
        ObsClient client = this.getClient();
        try {
            List partList = pre.getPartInfoList().stream().map(part -> new PartEtag(part.getETag(), part.getPartNumber())).collect(Collectors.toList());
            ProgressListener.quickStart(pre.getProgressListener(), fileInfo.getSize());
            client.completeMultipartUpload(new CompleteMultipartUploadRequest(this.bucketName, newFileKey, fileInfo.getUploadId(), partList));
            ProgressListener.quickFinish(pre.getProgressListener(), fileInfo.getSize());
        }
        catch (Exception e) {
            throw ExceptionFactory.completeMultipartUpload(fileInfo, this.platform, e);
        }
    }

    @Override
    public void abortMultipartUpload(AbortMultipartUploadPretreatment pre) {
        FileInfo fileInfo = pre.getFileInfo();
        String newFileKey = this.getFileKey(fileInfo);
        ObsClient client = this.getClient();
        try {
            client.abortMultipartUpload(new AbortMultipartUploadRequest(this.bucketName, newFileKey, fileInfo.getUploadId()));
        }
        catch (Exception e) {
            throw ExceptionFactory.abortMultipartUpload(fileInfo, this.platform, e);
        }
    }

    @Override
    public FilePartInfoList listParts(ListPartsPretreatment pre) {
        FileInfo fileInfo = pre.getFileInfo();
        String newFileKey = this.getFileKey(fileInfo);
        ObsClient client = this.getClient();
        try {
            ListPartsResult result = client.listParts(new ListPartsRequest(this.bucketName, newFileKey, fileInfo.getUploadId(), pre.getMaxParts(), pre.getPartNumberMarker()));
            FilePartInfoList list = new FilePartInfoList();
            list.setFileInfo(fileInfo);
            list.setList(result.getMultipartList().stream().map(p -> {
                FilePartInfo filePartInfo = new FilePartInfo(fileInfo);
                filePartInfo.setETag(p.getEtag());
                filePartInfo.setPartNumber(p.getPartNumber());
                filePartInfo.setPartSize(p.getSize());
                filePartInfo.setLastModified(p.getLastModified());
                return filePartInfo;
            }).collect(Collectors.toList()));
            list.setMaxParts(result.getMaxParts());
            list.setIsTruncated(result.isTruncated());
            list.setPartNumberMarker(Integer.parseInt(result.getPartNumberMarker()));
            list.setNextPartNumberMarker(Integer.parseInt(result.getNextPartNumberMarker()));
            return list;
        }
        catch (Exception e) {
            throw ExceptionFactory.listParts(fileInfo, this.platform, e);
        }
    }

    @Override
    public ListFilesSupportInfo isSupportListFiles() {
        return ListFilesSupportInfo.supportAll();
    }

    @Override
    public ListFilesResult listFiles(ListFilesPretreatment pre) {
        ObsClient client = this.getClient();
        try {
            ListObjectsRequest request = new ListObjectsRequest(this.bucketName);
            request.setMaxKeys(pre.getMaxFiles().intValue());
            request.setMarker(pre.getMarker());
            request.setDelimiter("/");
            request.setPrefix(this.basePath + pre.getPath() + pre.getFilenamePrefix());
            ObjectListing result = client.listObjects(request);
            ListFilesResult list = new ListFilesResult();
            list.setDirList(result.getCommonPrefixes().stream().map(item -> {
                RemoteDirInfo dir = new RemoteDirInfo();
                dir.setPlatform(pre.getPlatform());
                dir.setBasePath(this.basePath);
                dir.setPath(pre.getPath());
                dir.setName(FileNameUtil.getName((String)item));
                dir.setOriginal(item);
                return dir;
            }).collect(Collectors.toList()));
            list.setFileList(result.getObjects().stream().map(item -> {
                RemoteFileInfo info = new RemoteFileInfo();
                info.setPlatform(pre.getPlatform());
                info.setBasePath(this.basePath);
                info.setPath(pre.getPath());
                info.setFilename(FileNameUtil.getName((String)item.getObjectKey()));
                info.setUrl(this.domain + this.getFileKey(new FileInfo(this.basePath, info.getPath(), info.getFilename())));
                ObjectMetadata metadata = item.getMetadata();
                info.setSize(metadata.getContentLength());
                info.setExt(FileNameUtil.extName((String)info.getFilename()));
                info.setETag(metadata.getEtag());
                info.setContentDisposition(metadata.getContentDisposition());
                info.setContentType(metadata.getContentType());
                info.setContentMd5(metadata.getContentMd5());
                info.setLastModified(metadata.getLastModified());
                info.setMetadata(BeanUtil.beanToMap((Object)metadata, (boolean)false, (boolean)true));
                info.setUserMetadata(BeanUtil.beanToMap((Object)metadata.getAllMetadata(), (String[])new String[0]));
                info.setOriginal(item);
                return info;
            }).collect(Collectors.toList()));
            list.setPlatform(pre.getPlatform());
            list.setBasePath(this.basePath);
            list.setPath(pre.getPath());
            list.setFilenamePrefix(pre.getFilenamePrefix());
            list.setMaxFiles(result.getMaxKeys());
            list.setIsTruncated(result.isTruncated());
            list.setMarker(result.getMarker());
            list.setNextMarker(result.getNextMarker());
            return list;
        }
        catch (Exception e) {
            throw ExceptionFactory.listFiles(pre, this.basePath, e);
        }
    }

    @Override
    public RemoteFileInfo getFile(GetFilePretreatment pre) {
        String fileKey = this.getFileKey(new FileInfo(this.basePath, pre.getPath(), pre.getFilename()));
        ObsClient client = this.getClient();
        try {
            ObsObject file;
            try {
                file = client.getObject(this.bucketName, fileKey);
            }
            catch (Exception e) {
                return null;
            }
            if (file == null) {
                return null;
            }
            ObjectMetadata metadata = file.getMetadata();
            RemoteFileInfo info = new RemoteFileInfo();
            info.setPlatform(pre.getPlatform());
            info.setBasePath(this.basePath);
            info.setPath(pre.getPath());
            info.setFilename(FileNameUtil.getName((String)file.getObjectKey()));
            info.setUrl(this.domain + fileKey);
            info.setSize(metadata.getContentLength());
            info.setExt(FileNameUtil.extName((String)info.getFilename()));
            info.setETag(metadata.getEtag());
            info.setContentDisposition(metadata.getContentDisposition());
            info.setContentType(metadata.getContentType());
            info.setContentMd5(metadata.getContentMd5());
            info.setLastModified(metadata.getLastModified());
            info.setMetadata(BeanUtil.beanToMap((Object)metadata, (boolean)false, (boolean)true));
            info.getMetadata().remove("userMetadata");
            info.getMetadata().put("eTag", metadata.getEtag());
            info.setUserMetadata(new HashMap<String, Object>(metadata.getAllMetadata()));
            info.setOriginal(file);
            return info;
        }
        catch (Exception e) {
            throw ExceptionFactory.getFile(pre, this.basePath, e);
        }
    }

    public AccessControlList getAcl(Object acl) {
        if (acl instanceof AccessControlList) {
            return (AccessControlList)acl;
        }
        if (acl instanceof String || acl == null) {
            String sAcl = (String)acl;
            if (StrUtil.isEmpty((CharSequence)sAcl)) {
                sAcl = this.defaultAcl;
            }
            if (sAcl == null) {
                return null;
            }
            return ObsConvertor.getInstance().transCannedAcl(sAcl);
        }
        throw ExceptionFactory.unrecognizedAcl(acl, this.platform);
    }

    public ObjectMetadata getObjectMetadata(FileInfo fileInfo) {
        ObjectMetadata metadata = new ObjectMetadata();
        if (fileInfo.getSize() != null) {
            metadata.setContentLength(fileInfo.getSize());
        }
        metadata.setContentType(fileInfo.getContentType());
        fileInfo.getUserMetadata().forEach((arg_0, arg_1) -> ((ObjectMetadata)metadata).addUserMetadata(arg_0, arg_1));
        if (CollUtil.isNotEmpty(fileInfo.getMetadata())) {
            CopyOptions copyOptions = CopyOptions.create().ignoreCase().setFieldNameEditor(name -> NamingCase.toCamelCase((CharSequence)name, (char)'-'));
            BeanUtil.copyProperties(fileInfo.getMetadata(), (Object)metadata, (CopyOptions)copyOptions);
        }
        return metadata;
    }

    public ObjectMetadata getThObjectMetadata(FileInfo fileInfo) {
        ObjectMetadata metadata = new ObjectMetadata();
        metadata.setContentLength(fileInfo.getThSize());
        metadata.setContentType(fileInfo.getThContentType());
        fileInfo.getThUserMetadata().forEach((arg_0, arg_1) -> ((ObjectMetadata)metadata).addUserMetadata(arg_0, arg_1));
        if (CollUtil.isNotEmpty(fileInfo.getThMetadata())) {
            CopyOptions copyOptions = CopyOptions.create().ignoreCase().setFieldNameEditor(name -> NamingCase.toCamelCase((CharSequence)name, (char)'-'));
            BeanUtil.copyProperties(fileInfo.getThMetadata(), (Object)metadata, (CopyOptions)copyOptions);
        }
        return metadata;
    }

    @Override
    public boolean isSupportPresignedUrl() {
        return true;
    }

    @Override
    public GeneratePresignedUrlResult generatePresignedUrl(GeneratePresignedUrlPretreatment pre) {
        try {
            HttpMethodEnum method = Tools.getEnum(HttpMethodEnum.class, pre.getMethod());
            SpecialParamEnum specialParam = Tools.getEnum(SpecialParamEnum.class, pre.getSpecialParam());
            long expires = (pre.getExpiration().getTime() - System.currentTimeMillis()) / 1000L;
            TemporarySignatureRequest request = new TemporarySignatureRequest(method, expires);
            request.setBucketName(this.bucketName);
            request.setObjectKey(this.getFileKey(new FileInfo(this.basePath, pre.getPath(), pre.getFilename())));
            request.setSpecialParam(specialParam);
            HashMap<String, String> headers = new HashMap<String, String>(pre.getHeaders());
            headers.putAll(pre.getUserMetadata().entrySet().stream().collect(Collectors.toMap(e -> ((String)e.getKey()).startsWith("x-obs-meta-") ? (String)e.getKey() : "x-obs-meta-" + (String)e.getKey(), Map.Entry::getValue)));
            request.setHeaders(headers);
            HashMap<String, String> queryParam = new HashMap<String, String>(pre.getQueryParams());
            pre.getResponseHeaders().forEach((k, v) -> queryParam.put("response-" + k.toLowerCase(), (String)v));
            request.setQueryParams(queryParam);
            GeneratePresignedUrlResult result = new GeneratePresignedUrlResult(this.platform, this.basePath, pre);
            TemporarySignatureResponse response = this.getClient().createTemporarySignature(request);
            result.setUrl(response.getSignedUrl());
            result.setHeaders(response.getActualSignedRequestHeaders());
            return result;
        }
        catch (Exception e2) {
            throw ExceptionFactory.generatePresignedUrl(pre, e2);
        }
    }

    @Override
    public boolean isSupportAcl() {
        return true;
    }

    @Override
    public boolean setFileAcl(FileInfo fileInfo, Object acl) {
        AccessControlList oAcl = this.getAcl(acl);
        if (oAcl == null) {
            return false;
        }
        try {
            this.getClient().setObjectAcl(this.bucketName, this.getFileKey(fileInfo), oAcl);
            return true;
        }
        catch (Exception e) {
            throw ExceptionFactory.setFileAcl(fileInfo, oAcl, this.platform, e);
        }
    }

    @Override
    public boolean setThFileAcl(FileInfo fileInfo, Object acl) {
        AccessControlList oAcl = this.getAcl(acl);
        if (oAcl == null) {
            return false;
        }
        String key = this.getThFileKey(fileInfo);
        if (key == null) {
            return false;
        }
        try {
            this.getClient().setObjectAcl(this.bucketName, key, oAcl);
            return true;
        }
        catch (Exception e) {
            throw ExceptionFactory.setThFileAcl(fileInfo, oAcl, this.platform, e);
        }
    }

    @Override
    public boolean isSupportMetadata() {
        return true;
    }

    @Override
    public boolean delete(FileInfo fileInfo) {
        ObsClient client = this.getClient();
        try {
            if (fileInfo.getThFilename() != null) {
                client.deleteObject(this.bucketName, this.getThFileKey(fileInfo));
            }
            client.deleteObject(this.bucketName, this.getFileKey(fileInfo));
            return true;
        }
        catch (Exception e) {
            throw ExceptionFactory.delete(fileInfo, this.platform, e);
        }
    }

    @Override
    public boolean exists(FileInfo fileInfo) {
        try {
            return this.getClient().doesObjectExist(this.bucketName, this.getFileKey(fileInfo));
        }
        catch (Exception e) {
            throw ExceptionFactory.exists(fileInfo, this.platform, e);
        }
    }

    @Override
    public void download(FileInfo fileInfo, Consumer<InputStream> consumer) {
        ObsObject object = this.getClient().getObject(this.bucketName, this.getFileKey(fileInfo));
        try (InputStream in = object.getObjectContent();){
            consumer.accept(in);
        }
        catch (Exception e) {
            throw ExceptionFactory.download(fileInfo, this.platform, e);
        }
    }

    @Override
    public void downloadTh(FileInfo fileInfo, Consumer<InputStream> consumer) {
        Check.downloadThBlankThFilename(this.platform, fileInfo);
        ObsObject object = this.getClient().getObject(this.bucketName, this.getThFileKey(fileInfo));
        try (InputStream in = object.getObjectContent();){
            consumer.accept(in);
        }
        catch (Exception e) {
            throw ExceptionFactory.downloadTh(fileInfo, this.platform, e);
        }
    }

    @Override
    public boolean isSupportSameCopy() {
        return true;
    }

    @Override
    public void sameCopy(FileInfo srcFileInfo, FileInfo destFileInfo, CopyPretreatment pre) {
        ObjectMetadata srcFile;
        Check.sameCopyBasePath(this.platform, this.basePath, srcFileInfo, destFileInfo);
        ObsClient client = this.getClient();
        String srcFileKey = this.getFileKey(srcFileInfo);
        try {
            srcFile = client.getObjectMetadata(this.bucketName, srcFileKey);
        }
        catch (Exception e) {
            throw ExceptionFactory.sameCopyNotFound(srcFileInfo, destFileInfo, this.platform, e);
        }
        String destThFileKey = null;
        if (StrUtil.isNotBlank((CharSequence)srcFileInfo.getThFilename())) {
            destThFileKey = this.getThFileKey(destFileInfo);
            destFileInfo.setThUrl(this.domain + destThFileKey);
            try {
                CopyObjectRequest request = new CopyObjectRequest(this.bucketName, this.getThFileKey(srcFileInfo), this.bucketName, destThFileKey);
                request.setAcl(this.getAcl(destFileInfo.getThFileAcl()));
                client.copyObject(request);
            }
            catch (Exception e) {
                throw ExceptionFactory.sameCopyTh(srcFileInfo, destFileInfo, this.platform, e);
            }
        }
        String destFileKey = this.getFileKey(destFileInfo);
        destFileInfo.setUrl(this.domain + destFileKey);
        long fileSize = srcFile.getContentLength();
        boolean useMultipartCopy = fileSize >= 0x40000000L;
        String uploadId = null;
        try {
            if (useMultipartCopy) {
                InitiateMultipartUploadRequest initiateMultipartUploadRequest = new InitiateMultipartUploadRequest(this.bucketName, destFileKey);
                initiateMultipartUploadRequest.setMetadata(this.getObjectMetadata(destFileInfo));
                initiateMultipartUploadRequest.setAcl(this.getAcl(destFileInfo.getFileAcl()));
                uploadId = client.initiateMultipartUpload(initiateMultipartUploadRequest).getUploadId();
                ProgressListener.quickStart(pre.getProgressListener(), fileSize);
                ArrayList<PartEtag> partList = new ArrayList<PartEtag>();
                long progressSize = 0L;
                int i = 0;
                while (progressSize < fileSize) {
                    long partSize = Math.min(0x10000000L, fileSize - progressSize);
                    CopyPartRequest part = new CopyPartRequest(uploadId, this.bucketName, srcFileKey, this.bucketName, destFileKey, ++i);
                    part.setByteRangeStart(Long.valueOf(progressSize));
                    part.setByteRangeEnd(Long.valueOf(progressSize + partSize + 1L));
                    partList.add(new PartEtag(client.copyPart(part).getEtag(), Integer.valueOf(i)));
                    ProgressListener.quickProgress(pre.getProgressListener(), progressSize += partSize, fileSize);
                }
                client.completeMultipartUpload(new CompleteMultipartUploadRequest(this.bucketName, destFileKey, uploadId, partList));
                ProgressListener.quickFinish(pre.getProgressListener());
            } else {
                ProgressListener.quickStart(pre.getProgressListener(), fileSize);
                CopyObjectRequest request = new CopyObjectRequest(this.bucketName, srcFileKey, this.bucketName, destFileKey);
                request.setAcl(this.getAcl(destFileInfo.getFileAcl()));
                client.copyObject(request);
                ProgressListener.quickFinish(pre.getProgressListener(), fileSize);
            }
        }
        catch (Exception e) {
            if (destThFileKey != null) {
                try {
                    client.deleteObject(this.bucketName, destThFileKey);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                if (useMultipartCopy) {
                    client.abortMultipartUpload(new AbortMultipartUploadRequest(this.bucketName, destFileKey, uploadId));
                } else {
                    client.deleteObject(this.bucketName, destFileKey);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw ExceptionFactory.sameCopy(srcFileInfo, destFileInfo, this.platform, e);
        }
    }

    @Override
    @Generated
    public String getPlatform() {
        return this.platform;
    }

    @Generated
    public String getBucketName() {
        return this.bucketName;
    }

    @Generated
    public String getDomain() {
        return this.domain;
    }

    @Generated
    public String getBasePath() {
        return this.basePath;
    }

    @Generated
    public String getDefaultAcl() {
        return this.defaultAcl;
    }

    @Generated
    public int getMultipartThreshold() {
        return this.multipartThreshold;
    }

    @Generated
    public int getMultipartPartSize() {
        return this.multipartPartSize;
    }

    @Generated
    public FileStorageClientFactory<ObsClient> getClientFactory() {
        return this.clientFactory;
    }

    @Override
    @Generated
    public void setPlatform(String platform) {
        this.platform = platform;
    }

    @Generated
    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    @Generated
    public void setDomain(String domain) {
        this.domain = domain;
    }

    @Generated
    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    @Generated
    public void setDefaultAcl(String defaultAcl) {
        this.defaultAcl = defaultAcl;
    }

    @Generated
    public void setMultipartThreshold(int multipartThreshold) {
        this.multipartThreshold = multipartThreshold;
    }

    @Generated
    public void setMultipartPartSize(int multipartPartSize) {
        this.multipartPartSize = multipartPartSize;
    }

    @Generated
    public void setClientFactory(FileStorageClientFactory<ObsClient> clientFactory) {
        this.clientFactory = clientFactory;
    }

    @Generated
    public HuaweiObsFileStorage() {
    }
}

