/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.x.file.storage.core.platform;

import cn.hutool.core.util.URLUtil;
import com.google.auth.Credentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageOptions;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.dromara.x.file.storage.core.FileStorageProperties;
import org.dromara.x.file.storage.core.exception.FileStorageRuntimeException;
import org.dromara.x.file.storage.core.platform.FileStorageClientFactory;

public class GoogleCloudStorageFileStorageClientFactory
implements FileStorageClientFactory<Storage> {
    private String platform;
    private String projectId;
    private String credentialsPath;
    private volatile Storage client;

    public GoogleCloudStorageFileStorageClientFactory(FileStorageProperties.GoogleCloudStorageConfig config) {
        this.platform = config.getPlatform();
        this.projectId = config.getProjectId();
        this.credentialsPath = config.getCredentialsPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Storage getClient() {
        if (this.client == null) {
            GoogleCloudStorageFileStorageClientFactory googleCloudStorageFileStorageClientFactory = this;
            synchronized (googleCloudStorageFileStorageClientFactory) {
                if (this.client == null) {
                    ServiceAccountCredentials credentialsFromStream;
                    try (InputStream in = URLUtil.url((String)this.credentialsPath).openStream();){
                        credentialsFromStream = ServiceAccountCredentials.fromStream((InputStream)in);
                    }
                    catch (IOException e) {
                        throw new FileStorageRuntimeException("GoogleCloud Storage Platform \u6388\u6743 key \u6587\u4ef6\u83b7\u53d6\u5931\u8d25\uff01credentialsPath\uff1a" + this.credentialsPath);
                    }
                    List<String> scopes = Collections.singletonList("https://www.googleapis.com/auth/cloud-platform");
                    ServiceAccountCredentials credentials = credentialsFromStream.toBuilder().setScopes(scopes).build();
                    StorageOptions storageOptions = ((StorageOptions.Builder)((StorageOptions.Builder)StorageOptions.newBuilder().setProjectId(this.projectId)).setCredentials((Credentials)credentials)).build();
                    this.client = (Storage)storageOptions.getService();
                }
            }
        }
        return this.client;
    }

    @Override
    public void close() {
        if (this.client != null) {
            try {
                this.client.close();
            }
            catch (Exception e) {
                throw new FileStorageRuntimeException("\u5173\u95ed GoogleCloud Storage Client \u5931\u8d25\uff01", e);
            }
            this.client = null;
        }
    }

    @Override
    @Generated
    public String getPlatform() {
        return this.platform;
    }

    @Generated
    public String getProjectId() {
        return this.projectId;
    }

    @Generated
    public String getCredentialsPath() {
        return this.credentialsPath;
    }

    @Generated
    public void setPlatform(String platform) {
        this.platform = platform;
    }

    @Generated
    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    @Generated
    public void setCredentialsPath(String credentialsPath) {
        this.credentialsPath = credentialsPath;
    }

    @Generated
    public void setClient(Storage client) {
        this.client = client;
    }

    @Generated
    public GoogleCloudStorageFileStorageClientFactory() {
    }
}

