/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.x.file.storage.core.platform;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.file.FileNameUtil;
import cn.hutool.core.text.NamingCase;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import com.google.api.gax.paging.Page;
import com.google.cloud.ReadChannel;
import com.google.cloud.storage.Acl;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.HttpMethod;
import com.google.cloud.storage.Storage;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import lombok.Generated;
import org.dromara.x.file.storage.core.FileInfo;
import org.dromara.x.file.storage.core.FileStorageProperties;
import org.dromara.x.file.storage.core.InputStreamPlus;
import org.dromara.x.file.storage.core.ProgressListener;
import org.dromara.x.file.storage.core.UploadPretreatment;
import org.dromara.x.file.storage.core.copy.CopyPretreatment;
import org.dromara.x.file.storage.core.exception.Check;
import org.dromara.x.file.storage.core.exception.ExceptionFactory;
import org.dromara.x.file.storage.core.exception.FileStorageRuntimeException;
import org.dromara.x.file.storage.core.get.GetFilePretreatment;
import org.dromara.x.file.storage.core.get.ListFilesPretreatment;
import org.dromara.x.file.storage.core.get.ListFilesResult;
import org.dromara.x.file.storage.core.get.ListFilesSupportInfo;
import org.dromara.x.file.storage.core.get.RemoteDirInfo;
import org.dromara.x.file.storage.core.get.RemoteFileInfo;
import org.dromara.x.file.storage.core.platform.FileStorage;
import org.dromara.x.file.storage.core.platform.FileStorageClientFactory;
import org.dromara.x.file.storage.core.presigned.GeneratePresignedUrlPretreatment;
import org.dromara.x.file.storage.core.presigned.GeneratePresignedUrlResult;
import org.dromara.x.file.storage.core.upload.AbortMultipartUploadPretreatment;
import org.dromara.x.file.storage.core.upload.CompleteMultipartUploadPretreatment;
import org.dromara.x.file.storage.core.upload.FilePartInfo;
import org.dromara.x.file.storage.core.upload.FilePartInfoList;
import org.dromara.x.file.storage.core.upload.InitiateMultipartUploadPretreatment;
import org.dromara.x.file.storage.core.upload.ListPartsPretreatment;
import org.dromara.x.file.storage.core.upload.MultipartUploadSupportInfo;
import org.dromara.x.file.storage.core.upload.UploadPartPretreatment;
import org.dromara.x.file.storage.core.util.Tools;

public class GoogleCloudStorageFileStorage
implements FileStorage {
    private String bucketName;
    private String basePath;
    private String platform;
    private String domain;
    private String defaultAcl;
    private FileStorageClientFactory<Storage> clientFactory;

    public GoogleCloudStorageFileStorage(FileStorageProperties.GoogleCloudStorageConfig config, FileStorageClientFactory<Storage> clientFactory) {
        this.platform = config.getPlatform();
        this.bucketName = config.getBucketName();
        this.domain = config.getDomain();
        this.basePath = config.getBasePath();
        this.defaultAcl = config.getDefaultAcl();
        this.clientFactory = clientFactory;
    }

    public Storage getClient() {
        return this.clientFactory.getClient();
    }

    @Override
    public void close() {
        this.clientFactory.close();
    }

    @Override
    public boolean save(FileInfo fileInfo, UploadPretreatment pre) {
        boolean bl;
        block12: {
            fileInfo.setBasePath(this.basePath);
            String newFileKey = this.getFileKey(fileInfo);
            fileInfo.setUrl(this.domain + newFileKey);
            ArrayList<Storage.BlobWriteOption> optionList = new ArrayList<Storage.BlobWriteOption>();
            BlobInfo.Builder blobInfoBuilder = BlobInfo.newBuilder((String)this.bucketName, (String)newFileKey);
            this.setMetadata(blobInfoBuilder, fileInfo, optionList);
            Storage client = this.getClient();
            InputStreamPlus in = pre.getInputStreamPlus();
            try {
                byte[] thumbnailBytes;
                client.createFrom(blobInfoBuilder.build(), (InputStream)in, optionList.toArray(new Storage.BlobWriteOption[0]));
                if (fileInfo.getSize() == null) {
                    fileInfo.setSize(in.getProgressSize());
                }
                if ((thumbnailBytes = pre.getThumbnailBytes()) != null) {
                    String newThFileKey = this.getThFileKey(fileInfo);
                    fileInfo.setThUrl(this.domain + newThFileKey);
                    ArrayList<Storage.BlobWriteOption> thOptionList = new ArrayList<Storage.BlobWriteOption>();
                    BlobInfo.Builder thBlobInfoBuilder = BlobInfo.newBuilder((String)this.bucketName, (String)newThFileKey);
                    this.setThMetadata(thBlobInfoBuilder, fileInfo, thOptionList);
                    client.createFrom(thBlobInfoBuilder.build(), (InputStream)new ByteArrayInputStream(thumbnailBytes), thOptionList.toArray(new Storage.BlobWriteOption[0]));
                }
                bl = true;
                if (in == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    try {
                        this.checkAndDelete(newFileKey);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw ExceptionFactory.upload(fileInfo, this.platform, e);
                }
            }
            in.close();
        }
        return bl;
    }

    @Override
    public MultipartUploadSupportInfo isSupportMultipartUpload() {
        return MultipartUploadSupportInfo.supportAll().setListPartsSupportMaxParts(10000);
    }

    @Override
    public void initiateMultipartUpload(FileInfo fileInfo, InitiateMultipartUploadPretreatment pre) {
        fileInfo.setBasePath(this.basePath);
        String newFileKey = this.getFileKey(fileInfo);
        fileInfo.setUrl(this.domain + newFileKey);
        Storage client = this.getClient();
        try {
            String uploadId = "multi_" + IdUtil.objectId();
            String path = Tools.getParent(newFileKey) + "/" + uploadId + "/";
            ByteArrayInputStream in = new ByteArrayInputStream(new byte[0]);
            client.createFrom(BlobInfo.newBuilder((String)this.bucketName, (String)(path + "index")).build(), (InputStream)in, new Storage.BlobWriteOption[0]);
            fileInfo.setUploadId(uploadId);
        }
        catch (Exception e) {
            throw ExceptionFactory.initiateMultipartUpload(fileInfo, this.platform, e);
        }
    }

    @Override
    public FilePartInfo uploadPart(UploadPartPretreatment pre) {
        FilePartInfo filePartInfo;
        block8: {
            FileInfo fileInfo = pre.getFileInfo();
            String newFileKey = this.getFileKey(fileInfo);
            Storage client = this.getClient();
            InputStreamPlus in = pre.getInputStreamPlus();
            try {
                String part = Tools.getParent(newFileKey) + "/" + fileInfo.getUploadId() + "/" + StrUtil.padPre((CharSequence)String.valueOf(pre.getPartNumber()), (int)10, (CharSequence)"0");
                Blob blob = client.createFrom(BlobInfo.newBuilder((String)this.bucketName, (String)part).build(), (InputStream)in, new Storage.BlobWriteOption[0]);
                FilePartInfo filePartInfo2 = new FilePartInfo(fileInfo);
                filePartInfo2.setETag(blob.getEtag());
                filePartInfo2.setPartNumber(pre.getPartNumber());
                filePartInfo2.setPartSize(in.getProgressSize());
                filePartInfo2.setCreateTime(new Date());
                filePartInfo = filePartInfo2;
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw ExceptionFactory.uploadPart(fileInfo, this.platform, e);
                }
            }
            in.close();
        }
        return filePartInfo;
    }

    @Override
    public void completeMultipartUpload(CompleteMultipartUploadPretreatment pre) {
        FileInfo fileInfo = pre.getFileInfo();
        String newFileKey = this.getFileKey(fileInfo);
        Storage client = this.getClient();
        try {
            ProgressListener.quickStart(pre.getProgressListener(), fileInfo.getSize());
            client.delete(BlobId.of((String)this.bucketName, (String)newFileKey));
            String path = Tools.getParent(newFileKey) + "/" + fileInfo.getUploadId() + "/";
            LinkedList sources = pre.getPartInfoList().stream().map(part -> path + StrUtil.padPre((CharSequence)String.valueOf(part.getPartNumber()), (int)10, (CharSequence)"0")).collect(Collectors.toCollection(LinkedList::new));
            ArrayList<String> subSources = new ArrayList<String>();
            for (int i = 0; i < sources.size(); ++i) {
                Storage.ComposeRequest request;
                subSources.add((String)sources.get(i));
                if (subSources.size() != 32 && i + 1 != sources.size()) continue;
                ArrayList<Storage.BlobTargetOption> optionList = null;
                if (i + 1 == sources.size()) {
                    optionList = new ArrayList<Storage.BlobTargetOption>();
                    BlobInfo.Builder blobInfoBuilder = BlobInfo.newBuilder((String)this.bucketName, (String)newFileKey);
                    this.setMetadataOfBlobTargetOption(blobInfoBuilder, fileInfo, optionList);
                    request = Storage.ComposeRequest.newBuilder().setTarget(blobInfoBuilder.build()).setTargetOptions(optionList).addSource(subSources).build();
                } else {
                    request = Storage.ComposeRequest.of((String)this.bucketName, subSources, (String)newFileKey);
                }
                Blob blob = client.compose(request);
                if (CollUtil.isNotEmpty(optionList)) {
                    blob.update(optionList.toArray(optionList.toArray(new Storage.BlobTargetOption[0])));
                }
                ProgressListener.quickProgress(pre.getProgressListener(), blob.getSize(), fileInfo.getSize());
                subSources.clear();
                subSources.add(newFileKey);
            }
            List blobIdList = ListUtil.toList((Iterable)client.list(this.bucketName, new Storage.BlobListOption[]{Storage.BlobListOption.prefix((String)path)}).iterateAll()).stream().map(BlobInfo::getBlobId).collect(Collectors.toList());
            if (!blobIdList.isEmpty()) {
                client.delete(blobIdList);
            }
            ProgressListener.quickFinish(pre.getProgressListener());
        }
        catch (Exception e) {
            try {
                client.delete(BlobId.of((String)this.bucketName, (String)newFileKey));
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw ExceptionFactory.completeMultipartUpload(fileInfo, this.platform, e);
        }
    }

    @Override
    public void abortMultipartUpload(AbortMultipartUploadPretreatment pre) {
        FileInfo fileInfo = pre.getFileInfo();
        String newFileKey = this.getFileKey(fileInfo);
        Storage client = this.getClient();
        try {
            String path = Tools.getParent(newFileKey) + "/" + fileInfo.getUploadId() + "/";
            List blobIdList = ListUtil.toList((Iterable)client.list(this.bucketName, new Storage.BlobListOption[]{Storage.BlobListOption.prefix((String)path)}).iterateAll()).stream().map(BlobInfo::getBlobId).collect(Collectors.toList());
            if (!blobIdList.isEmpty()) {
                client.delete(blobIdList);
            }
        }
        catch (Exception e) {
            throw ExceptionFactory.abortMultipartUpload(fileInfo, this.platform, e);
        }
    }

    @Override
    public FilePartInfoList listParts(ListPartsPretreatment pre) {
        FileInfo fileInfo = pre.getFileInfo();
        String newFileKey = this.getFileKey(fileInfo);
        Storage client = this.getClient();
        try {
            String path = Tools.getParent(newFileKey) + "/" + fileInfo.getUploadId() + "/";
            if (client.get(BlobId.of((String)this.bucketName, (String)(path + "index"))) == null) {
                throw new FileNotFoundException(path + "index");
            }
            ArrayList<Storage.BlobListOption> options = new ArrayList<Storage.BlobListOption>();
            options.add(Storage.BlobListOption.delimiter((String)"/"));
            options.add(Storage.BlobListOption.prefix((String)path));
            Page result = client.list(this.bucketName, options.toArray(new Storage.BlobListOption[0]));
            FilePartInfoList list = new FilePartInfoList();
            list.setFileInfo(fileInfo);
            ArrayList<FilePartInfo> partList = new ArrayList<FilePartInfo>();
            int i = 1;
            for (Blob p : result.iterateAll()) {
                int partNumber;
                String filename = FileNameUtil.getName((String)p.getName());
                try {
                    partNumber = Integer.parseInt(filename);
                }
                catch (Exception e) {
                    continue;
                }
                if (pre.getPartNumberMarker() != null && pre.getPartNumberMarker() > 0 && partNumber <= pre.getPartNumberMarker()) continue;
                FilePartInfo filePartInfo = new FilePartInfo(fileInfo);
                filePartInfo.setETag(p.getEtag());
                filePartInfo.setPartNumber(partNumber);
                filePartInfo.setPartSize(p.getSize());
                filePartInfo.setLastModified((Date)DateUtil.date((TemporalAccessor)p.getUpdateTimeOffsetDateTime()));
                partList.add(filePartInfo);
                if (i == pre.getMaxParts() + 1) break;
                ++i;
            }
            list.setList(partList);
            list.setMaxParts(pre.getMaxParts());
            list.setIsTruncated(partList.size() > pre.getMaxParts());
            list.setPartNumberMarker(pre.getPartNumberMarker());
            if (list.getIsTruncated().booleanValue()) {
                partList.remove(partList.size() - 1);
                list.setNextPartNumberMarker(partList.get(partList.size() - 1).getPartNumber());
            }
            return list;
        }
        catch (Exception e) {
            throw ExceptionFactory.listParts(fileInfo, this.platform, e);
        }
    }

    @Override
    public ListFilesSupportInfo isSupportListFiles() {
        return ListFilesSupportInfo.supportAll();
    }

    @Override
    public ListFilesResult listFiles(ListFilesPretreatment pre) {
        Storage client = this.getClient();
        try {
            ArrayList<Storage.BlobListOption> options = new ArrayList<Storage.BlobListOption>();
            options.add(Storage.BlobListOption.pageSize((long)pre.getMaxFiles().intValue()));
            if (StrUtil.isNotBlank((CharSequence)pre.getMarker())) {
                options.add(Storage.BlobListOption.pageToken((String)pre.getMarker()));
            }
            options.add(Storage.BlobListOption.delimiter((String)"/"));
            options.add(Storage.BlobListOption.prefix((String)(this.basePath + pre.getPath() + pre.getFilenamePrefix())));
            Page result = client.list(this.bucketName, options.toArray(new Storage.BlobListOption[0]));
            ArrayList values = ListUtil.toList((Iterable)result.getValues());
            ListFilesResult list = new ListFilesResult();
            list.setDirList(values.stream().map(item -> {
                if (!item.isDirectory()) {
                    return null;
                }
                RemoteDirInfo dir = new RemoteDirInfo();
                dir.setPlatform(pre.getPlatform());
                dir.setBasePath(this.basePath);
                dir.setPath(pre.getPath());
                dir.setName(FileNameUtil.getName((String)item.getName()));
                dir.setOriginal(item);
                return dir;
            }).filter(Objects::nonNull).collect(Collectors.toList()));
            list.setFileList(values.stream().map(item -> {
                if (item.isDirectory()) {
                    return null;
                }
                RemoteFileInfo info = new RemoteFileInfo();
                info.setPlatform(pre.getPlatform());
                info.setBasePath(this.basePath);
                info.setPath(pre.getPath());
                info.setFilename(FileNameUtil.getName((String)item.getName()));
                info.setUrl(this.domain + this.getFileKey(new FileInfo(this.basePath, info.getPath(), info.getFilename())));
                info.setSize(item.getSize());
                info.setExt(FileNameUtil.extName((String)info.getFilename()));
                info.setETag(item.getEtag());
                info.setContentDisposition(item.getContentDisposition());
                info.setContentType(item.getContentType());
                info.setContentMd5(item.getMd5());
                info.setLastModified((Date)DateUtil.date((TemporalAccessor)item.getUpdateTimeOffsetDateTime()));
                HashMap<String, Object> metadata = new HashMap<String, Object>();
                if (item.getContentType() != null) {
                    metadata.put("Content-Type", item.getContentType());
                }
                if (item.getContentEncoding() != null) {
                    metadata.put("Content-Encoding", item.getContentEncoding());
                }
                if (item.getContentDisposition() != null) {
                    metadata.put("Content-Disposition", item.getContentDisposition());
                }
                if (item.getContentLanguage() != null) {
                    metadata.put("Content-Language", item.getContentLanguage());
                }
                if (item.getStorageClass() != null) {
                    metadata.put("Storage-Class", item.getStorageClass());
                }
                if (item.getSize() != null) {
                    metadata.put("Content-Length", item.getSize());
                }
                if (item.getMd5() != null) {
                    metadata.put("Content-MD5", item.getMd5());
                }
                if (item.getEtag() != null) {
                    metadata.put("E-Tag", item.getEtag());
                }
                if (item.getUpdateTimeOffsetDateTime() != null) {
                    metadata.put("Last-Modified", DateUtil.formatHttpDate((Date)DateUtil.date((TemporalAccessor)item.getUpdateTimeOffsetDateTime())));
                }
                info.setMetadata(metadata);
                if (item.getMetadata() != null) {
                    info.setUserMetadata(new HashMap<String, Object>(item.getMetadata()));
                }
                info.setOriginal(item);
                return info;
            }).filter(Objects::nonNull).collect(Collectors.toList()));
            list.setPlatform(pre.getPlatform());
            list.setBasePath(this.basePath);
            list.setPath(pre.getPath());
            list.setFilenamePrefix(pre.getFilenamePrefix());
            list.setMaxFiles(pre.getMaxFiles());
            list.setIsTruncated(result.hasNextPage());
            list.setMarker(pre.getMarker());
            list.setNextMarker(result.getNextPageToken());
            return list;
        }
        catch (Exception e) {
            throw ExceptionFactory.listFiles(pre, this.basePath, e);
        }
    }

    @Override
    public RemoteFileInfo getFile(GetFilePretreatment pre) {
        String fileKey = this.getFileKey(new FileInfo(this.basePath, pre.getPath(), pre.getFilename()));
        Storage client = this.getClient();
        try {
            Blob file;
            try {
                file = client.get(this.bucketName, fileKey, new Storage.BlobGetOption[0]);
            }
            catch (Exception e) {
                return null;
            }
            if (file == null) {
                return null;
            }
            RemoteFileInfo info = new RemoteFileInfo();
            info.setPlatform(pre.getPlatform());
            info.setBasePath(this.basePath);
            info.setPath(pre.getPath());
            info.setFilename(FileNameUtil.getName((String)file.getName()));
            info.setUrl(this.domain + fileKey);
            info.setSize(file.getSize());
            info.setExt(FileNameUtil.extName((String)info.getFilename()));
            info.setETag(file.getEtag());
            info.setContentDisposition(file.getContentDisposition());
            info.setContentType(file.getContentType());
            info.setContentMd5(file.getMd5());
            info.setLastModified((Date)DateUtil.date((TemporalAccessor)file.getUpdateTimeOffsetDateTime()));
            HashMap<String, Object> metadata = new HashMap<String, Object>();
            if (file.getContentType() != null) {
                metadata.put("Content-Type", file.getContentType());
            }
            if (file.getContentEncoding() != null) {
                metadata.put("Content-Encoding", file.getContentEncoding());
            }
            if (file.getContentDisposition() != null) {
                metadata.put("Content-Disposition", file.getContentDisposition());
            }
            if (file.getContentLanguage() != null) {
                metadata.put("Content-Language", file.getContentLanguage());
            }
            if (file.getStorageClass() != null) {
                metadata.put("Storage-Class", file.getStorageClass());
            }
            if (file.getSize() != null) {
                metadata.put("Content-Length", file.getSize());
            }
            if (file.getMd5() != null) {
                metadata.put("Content-MD5", file.getMd5());
            }
            if (file.getEtag() != null) {
                metadata.put("E-Tag", file.getEtag());
            }
            if (file.getUpdateTimeOffsetDateTime() != null) {
                metadata.put("Last-Modified", DateUtil.formatHttpDate((Date)DateUtil.date((TemporalAccessor)file.getUpdateTimeOffsetDateTime())));
            }
            info.setMetadata(metadata);
            if (file.getMetadata() != null) {
                info.setUserMetadata(new HashMap<String, Object>(file.getMetadata()));
            }
            info.setOriginal(file);
            return info;
        }
        catch (Exception e) {
            throw ExceptionFactory.getFile(pre, this.basePath, e);
        }
    }

    public AclWrapper getAcl(Object acl) {
        if (acl instanceof Storage.PredefinedAcl) {
            return new AclWrapper((Storage.PredefinedAcl)acl);
        }
        if (acl instanceof String || acl == null) {
            String sAcl = (String)acl;
            if (StrUtil.isEmpty((CharSequence)sAcl)) {
                sAcl = this.defaultAcl;
            }
            if (StrUtil.isEmpty((CharSequence)sAcl)) {
                return null;
            }
            sAcl = sAcl.replace("-", "_");
            for (Storage.PredefinedAcl item2 : Storage.PredefinedAcl.values()) {
                if (!item2.toString().equalsIgnoreCase(sAcl)) continue;
                return new AclWrapper(item2);
            }
            return null;
        }
        if (acl instanceof Acl) {
            return new AclWrapper(Collections.singletonList((Acl)acl));
        }
        if (acl instanceof Collection) {
            List<Acl> aclList = ((Collection)acl).stream().map(item -> {
                if (item instanceof Acl) {
                    return (Acl)item;
                }
                throw new FileStorageRuntimeException("\u4e0d\u652f\u6301\u7684ACL\uff1a" + item);
            }).collect(Collectors.toList());
            return new AclWrapper(aclList);
        }
        throw ExceptionFactory.unrecognizedAcl(acl, this.platform);
    }

    public void setMetadata(BlobInfo.Builder blobInfoBuilder, FileInfo fileInfo, ArrayList<Storage.BlobWriteOption> optionList) {
        AclWrapper fileAcl;
        blobInfoBuilder.setContentType(fileInfo.getContentType()).setMetadata(fileInfo.getUserMetadata());
        if (CollUtil.isNotEmpty(fileInfo.getMetadata())) {
            CopyOptions copyOptions = CopyOptions.create().ignoreCase().setFieldNameEditor(name -> NamingCase.toCamelCase((CharSequence)name, (char)'-'));
            BeanUtil.copyProperties(fileInfo.getMetadata(), (Object)blobInfoBuilder, (CopyOptions)copyOptions);
        }
        if ((fileAcl = this.getAcl(fileInfo.getFileAcl())) != null) {
            if (fileAcl.getAclList() != null) {
                blobInfoBuilder.setAcl(fileAcl.getAclList());
            } else if (fileAcl.getPredefinedAcl() != null) {
                optionList.add(Storage.BlobWriteOption.predefinedAcl((Storage.PredefinedAcl)fileAcl.getPredefinedAcl()));
            }
        }
    }

    public void setThMetadata(BlobInfo.Builder blobInfoBuilder, FileInfo fileInfo, ArrayList<Storage.BlobWriteOption> optionList) {
        AclWrapper fileAcl;
        blobInfoBuilder.setContentType(fileInfo.getThContentType()).setMetadata(fileInfo.getThUserMetadata());
        if (CollUtil.isNotEmpty(fileInfo.getThMetadata())) {
            CopyOptions copyOptions = CopyOptions.create().ignoreCase().setFieldNameEditor(name -> NamingCase.toCamelCase((CharSequence)name, (char)'-'));
            BeanUtil.copyProperties(fileInfo.getThMetadata(), (Object)blobInfoBuilder, (CopyOptions)copyOptions);
        }
        if ((fileAcl = this.getAcl(fileInfo.getThFileAcl())) != null) {
            if (fileAcl.getAclList() != null) {
                blobInfoBuilder.setAcl(fileAcl.getAclList());
            } else if (fileAcl.getPredefinedAcl() != null) {
                optionList.add(Storage.BlobWriteOption.predefinedAcl((Storage.PredefinedAcl)fileAcl.getPredefinedAcl()));
            }
        }
    }

    public void setMetadataOfBlobTargetOption(BlobInfo.Builder blobInfoBuilder, FileInfo fileInfo, ArrayList<Storage.BlobTargetOption> optionList) {
        AclWrapper fileAcl;
        blobInfoBuilder.setContentType(fileInfo.getContentType()).setMetadata(fileInfo.getUserMetadata());
        if (CollUtil.isNotEmpty(fileInfo.getMetadata())) {
            CopyOptions copyOptions = CopyOptions.create().ignoreCase().setFieldNameEditor(name -> NamingCase.toCamelCase((CharSequence)name, (char)'-'));
            BeanUtil.copyProperties(fileInfo.getMetadata(), (Object)blobInfoBuilder, (CopyOptions)copyOptions);
        }
        if ((fileAcl = this.getAcl(fileInfo.getFileAcl())) != null) {
            if (fileAcl.getAclList() != null) {
                blobInfoBuilder.setAcl(fileAcl.getAclList());
            } else if (fileAcl.getPredefinedAcl() != null) {
                optionList.add(Storage.BlobTargetOption.predefinedAcl((Storage.PredefinedAcl)fileAcl.getPredefinedAcl()));
            }
        }
    }

    @Override
    public boolean isSupportAcl() {
        return true;
    }

    @Override
    public boolean setFileAcl(FileInfo fileInfo, Object acl) {
        AclWrapper oAcl = this.getAcl(acl);
        if (oAcl == null) {
            return false;
        }
        try {
            BlobInfo.Builder builder = BlobInfo.newBuilder((String)this.bucketName, (String)this.getFileKey(fileInfo));
            if (oAcl.getAclList() != null) {
                builder.setAcl(oAcl.getAclList());
                this.getClient().update(builder.build());
                return true;
            }
            if (oAcl.getPredefinedAcl() != null) {
                this.getClient().update(builder.build(), new Storage.BlobTargetOption[]{Storage.BlobTargetOption.predefinedAcl((Storage.PredefinedAcl)oAcl.getPredefinedAcl())});
                return true;
            }
            return false;
        }
        catch (Exception e) {
            throw ExceptionFactory.setFileAcl(fileInfo, oAcl, this.platform, e);
        }
    }

    @Override
    public boolean setThFileAcl(FileInfo fileInfo, Object acl) {
        AclWrapper oAcl = this.getAcl(acl);
        if (oAcl == null) {
            return false;
        }
        try {
            BlobInfo.Builder builder = BlobInfo.newBuilder((String)this.bucketName, (String)this.getThFileKey(fileInfo));
            if (oAcl.getAclList() != null) {
                builder.setAcl(oAcl.getAclList());
                this.getClient().update(builder.build());
                return true;
            }
            if (oAcl.getPredefinedAcl() != null) {
                this.getClient().update(builder.build(), new Storage.BlobTargetOption[]{Storage.BlobTargetOption.predefinedAcl((Storage.PredefinedAcl)oAcl.getPredefinedAcl())});
                return true;
            }
            return false;
        }
        catch (Exception e) {
            throw ExceptionFactory.setThFileAcl(fileInfo, oAcl, this.platform, e);
        }
    }

    @Override
    public boolean isSupportPresignedUrl() {
        return true;
    }

    @Override
    public GeneratePresignedUrlResult generatePresignedUrl(GeneratePresignedUrlPretreatment pre) {
        try {
            BlobInfo blobInfo = BlobInfo.newBuilder((String)this.bucketName, (String)this.getFileKey(new FileInfo(this.basePath, pre.getPath(), pre.getFilename()))).setMetadata(pre.getUserMetadata()).build();
            long duration = pre.getExpiration().getTime() - System.currentTimeMillis();
            ArrayList<Storage.SignUrlOption> signUrlOptionList = new ArrayList<Storage.SignUrlOption>();
            signUrlOptionList.add(Storage.SignUrlOption.withV4Signature());
            if (pre.getMethod() instanceof HttpMethod) {
                signUrlOptionList.add(Storage.SignUrlOption.httpMethod((HttpMethod)((HttpMethod)pre.getMethod())));
            } else {
                signUrlOptionList.add(Storage.SignUrlOption.httpMethod((HttpMethod)HttpMethod.valueOf((String)String.valueOf(pre.getMethod()).toUpperCase())));
            }
            HashMap<String, String> queryParams = new HashMap<String, String>(pre.getQueryParams());
            pre.getResponseHeaders().forEach((k, v) -> queryParams.put("response-" + k.toLowerCase(), (String)v));
            signUrlOptionList.add(Storage.SignUrlOption.withQueryParams(queryParams));
            HashMap<String, String> headers = new HashMap<String, String>(pre.getHeaders());
            headers.putAll(pre.getUserMetadata().entrySet().stream().collect(Collectors.toMap(e -> ((String)e.getKey()).startsWith("x-goog-meta-") ? (String)e.getKey() : "x-goog-meta-" + (String)e.getKey(), Map.Entry::getValue)));
            signUrlOptionList.add(Storage.SignUrlOption.withExtHeaders(headers));
            URL url = this.getClient().signUrl(blobInfo, duration, TimeUnit.MILLISECONDS, signUrlOptionList.toArray(new Storage.SignUrlOption[0]));
            GeneratePresignedUrlResult result = new GeneratePresignedUrlResult(this.platform, this.basePath, pre);
            result.setUrl(url.toString());
            result.setHeaders(headers);
            return result;
        }
        catch (Exception e2) {
            throw ExceptionFactory.generatePresignedUrl(pre, e2);
        }
    }

    @Override
    public boolean isSupportMetadata() {
        return true;
    }

    protected void checkAndDelete(String fileKey) {
        Storage client = this.getClient();
        Blob blob = client.get(this.bucketName, fileKey, new Storage.BlobGetOption[0]);
        if (blob != null) {
            Storage.BlobSourceOption precondition = Storage.BlobSourceOption.generationMatch((long)blob.getGeneration());
            client.delete(this.bucketName, fileKey, new Storage.BlobSourceOption[]{precondition});
        }
    }

    @Override
    public boolean delete(FileInfo fileInfo) {
        try {
            if (fileInfo.getThFilename() != null) {
                this.checkAndDelete(this.getThFileKey(fileInfo));
            }
            this.checkAndDelete(this.getFileKey(fileInfo));
            return true;
        }
        catch (Exception e) {
            throw ExceptionFactory.delete(fileInfo, this.platform, e);
        }
    }

    @Override
    public boolean exists(FileInfo fileInfo) {
        try {
            Storage client = this.getClient();
            BlobId blobId = BlobId.of((String)this.bucketName, (String)this.getFileKey(fileInfo));
            return client.get(blobId) != null;
        }
        catch (Exception e) {
            throw ExceptionFactory.exists(fileInfo, this.platform, e);
        }
    }

    @Override
    public void download(FileInfo fileInfo, Consumer<InputStream> consumer) {
        Storage client = this.getClient();
        BlobId blobId = BlobId.of((String)this.bucketName, (String)this.getFileKey(fileInfo));
        try (ReadChannel readChannel = client.reader(blobId, new Storage.BlobSourceOption[0]);
             InputStream in = Channels.newInputStream((ReadableByteChannel)readChannel);){
            consumer.accept(in);
        }
        catch (Exception e) {
            throw ExceptionFactory.download(fileInfo, this.platform, e);
        }
    }

    @Override
    public void downloadTh(FileInfo fileInfo, Consumer<InputStream> consumer) {
        if (StrUtil.isBlank((CharSequence)fileInfo.getThFilename())) {
            throw new FileStorageRuntimeException("\u7f29\u7565\u56fe\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff0c\u6587\u4ef6\u4e0d\u5b58\u5728\uff01fileInfo\uff1a" + fileInfo);
        }
        Storage client = this.getClient();
        BlobId thBlobId = BlobId.of((String)this.bucketName, (String)this.getThFileKey(fileInfo));
        try (ReadChannel readChannel = client.reader(thBlobId, new Storage.BlobSourceOption[0]);
             InputStream in = Channels.newInputStream((ReadableByteChannel)readChannel);){
            consumer.accept(in);
        }
        catch (Exception e) {
            throw ExceptionFactory.downloadTh(fileInfo, this.platform, e);
        }
    }

    @Override
    public boolean isSupportSameCopy() {
        return true;
    }

    @Override
    public void sameCopy(FileInfo srcFileInfo, FileInfo destFileInfo, CopyPretreatment pre) {
        Blob srcFile;
        Check.sameCopyBasePath(this.platform, this.basePath, srcFileInfo, destFileInfo);
        Storage client = this.getClient();
        String srcFileKey = this.getFileKey(srcFileInfo);
        try {
            srcFile = client.get(this.bucketName, srcFileKey, new Storage.BlobGetOption[0]);
            if (srcFile == null) {
                throw ExceptionFactory.sameCopyNotFound(srcFileInfo, destFileInfo, this.platform, null);
            }
        }
        catch (Exception e) {
            throw ExceptionFactory.sameCopyNotFound(srcFileInfo, destFileInfo, this.platform, e);
        }
        String destThFileKey = null;
        if (StrUtil.isNotBlank((CharSequence)srcFileInfo.getThFilename())) {
            destThFileKey = this.getThFileKey(destFileInfo);
            destFileInfo.setThUrl(this.domain + destThFileKey);
            try {
                client.copy(Storage.CopyRequest.newBuilder().setSource(BlobId.of((String)this.bucketName, (String)this.getThFileKey(srcFileInfo))).setTarget(BlobId.of((String)this.bucketName, (String)destThFileKey)).build()).getResult();
            }
            catch (Exception e) {
                throw ExceptionFactory.sameCopyTh(srcFileInfo, destFileInfo, this.platform, e);
            }
        }
        String destFileKey = this.getFileKey(destFileInfo);
        destFileInfo.setUrl(this.domain + destFileKey);
        try {
            ProgressListener.quickStart(pre.getProgressListener(), srcFile.getSize());
            client.copy(Storage.CopyRequest.newBuilder().setSource(BlobId.of((String)this.bucketName, (String)srcFileKey)).setTarget(BlobId.of((String)this.bucketName, (String)destFileKey)).build()).getResult();
            ProgressListener.quickFinish(pre.getProgressListener(), srcFile.getSize());
        }
        catch (Exception e) {
            if (destThFileKey != null) {
                try {
                    this.checkAndDelete(destThFileKey);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                this.checkAndDelete(destFileKey);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw ExceptionFactory.sameCopy(srcFileInfo, destFileInfo, this.platform, e);
        }
    }

    @Generated
    public String getBucketName() {
        return this.bucketName;
    }

    @Generated
    public String getBasePath() {
        return this.basePath;
    }

    @Override
    @Generated
    public String getPlatform() {
        return this.platform;
    }

    @Generated
    public String getDomain() {
        return this.domain;
    }

    @Generated
    public String getDefaultAcl() {
        return this.defaultAcl;
    }

    @Generated
    public FileStorageClientFactory<Storage> getClientFactory() {
        return this.clientFactory;
    }

    @Generated
    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    @Generated
    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    @Override
    @Generated
    public void setPlatform(String platform) {
        this.platform = platform;
    }

    @Generated
    public void setDomain(String domain) {
        this.domain = domain;
    }

    @Generated
    public void setDefaultAcl(String defaultAcl) {
        this.defaultAcl = defaultAcl;
    }

    @Generated
    public void setClientFactory(FileStorageClientFactory<Storage> clientFactory) {
        this.clientFactory = clientFactory;
    }

    @Generated
    public GoogleCloudStorageFileStorage() {
    }

    public static class AclWrapper {
        private List<Acl> aclList;
        private Storage.PredefinedAcl predefinedAcl;

        public AclWrapper(List<Acl> aclList) {
            this.aclList = aclList;
        }

        public AclWrapper(Storage.PredefinedAcl predefinedAcl) {
            this.predefinedAcl = predefinedAcl;
        }

        @Generated
        public List<Acl> getAclList() {
            return this.aclList;
        }

        @Generated
        public Storage.PredefinedAcl getPredefinedAcl() {
            return this.predefinedAcl;
        }

        @Generated
        public void setAclList(List<Acl> aclList) {
            this.aclList = aclList;
        }

        @Generated
        public void setPredefinedAcl(Storage.PredefinedAcl predefinedAcl) {
            this.predefinedAcl = predefinedAcl;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AclWrapper)) {
                return false;
            }
            AclWrapper other = (AclWrapper)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<Acl> this$aclList = this.getAclList();
            List<Acl> other$aclList = other.getAclList();
            if (this$aclList == null ? other$aclList != null : !((Object)this$aclList).equals(other$aclList)) {
                return false;
            }
            Storage.PredefinedAcl this$predefinedAcl = this.getPredefinedAcl();
            Storage.PredefinedAcl other$predefinedAcl = other.getPredefinedAcl();
            return !(this$predefinedAcl == null ? other$predefinedAcl != null : !this$predefinedAcl.equals(other$predefinedAcl));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AclWrapper;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<Acl> $aclList = this.getAclList();
            result = result * 59 + ($aclList == null ? 43 : ((Object)$aclList).hashCode());
            Storage.PredefinedAcl $predefinedAcl = this.getPredefinedAcl();
            result = result * 59 + ($predefinedAcl == null ? 43 : $predefinedAcl.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "GoogleCloudStorageFileStorage.AclWrapper(aclList=" + this.aclList + ", predefinedAcl=" + this.predefinedAcl + ")";
        }
    }
}

