/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.x.file.storage.core.platform;

import cn.hutool.extra.ftp.Ftp;
import cn.hutool.extra.ftp.FtpConfig;
import cn.hutool.extra.ftp.FtpException;
import cn.hutool.extra.ftp.FtpMode;
import java.nio.charset.Charset;
import lombok.Generated;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.dromara.x.file.storage.core.FileStorageProperties;
import org.dromara.x.file.storage.core.exception.FileStorageRuntimeException;
import org.dromara.x.file.storage.core.platform.FileStorageClientFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FtpFileStorageClientFactory
implements FileStorageClientFactory<Ftp> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FtpFileStorageClientFactory.class);
    private String platform;
    private String host;
    private Integer port;
    private String user;
    private String password;
    private Charset charset;
    private Long connectionTimeout;
    private Long soTimeout;
    private String serverLanguageCode;
    private String systemKey;
    private Boolean isActive;
    private GenericObjectPoolConfig<Ftp> poolConfig;
    private volatile GenericObjectPool<Ftp> pool;

    public FtpFileStorageClientFactory(FileStorageProperties.FtpConfig config) {
        this.platform = config.getPlatform();
        this.host = config.getHost();
        this.port = config.getPort();
        this.user = config.getUser();
        this.password = config.getPassword();
        this.charset = config.getCharset();
        this.connectionTimeout = config.getConnectionTimeout();
        this.soTimeout = config.getSoTimeout();
        this.serverLanguageCode = config.getServerLanguageCode();
        this.systemKey = config.getSystemKey();
        this.isActive = config.getIsActive();
        this.poolConfig = config.getPool().toGenericObjectPoolConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Ftp getClient() {
        try {
            if (this.pool == null) {
                FtpFileStorageClientFactory ftpFileStorageClientFactory = this;
                synchronized (ftpFileStorageClientFactory) {
                    if (this.pool == null) {
                        this.pool = new GenericObjectPool((PooledObjectFactory)new FtpPooledObjectFactory(this), this.poolConfig);
                    }
                }
            }
            return (Ftp)this.pool.borrowObject();
        }
        catch (Exception e) {
            throw new FileStorageRuntimeException("\u83b7\u53d6 FTP Client \u5931\u8d25\uff01", e);
        }
    }

    @Override
    public void returnClient(Ftp sftp) {
        try {
            this.pool.returnObject((Object)sftp);
        }
        catch (Exception e) {
            throw new FileStorageRuntimeException("\u5f52\u8fd8 FTP Client \u5931\u8d25\uff01", e);
        }
    }

    @Override
    public void close() {
        if (this.pool != null) {
            this.pool.close();
            this.pool = null;
        }
    }

    @Override
    @Generated
    public String getPlatform() {
        return this.platform;
    }

    @Generated
    public String getHost() {
        return this.host;
    }

    @Generated
    public Integer getPort() {
        return this.port;
    }

    @Generated
    public String getUser() {
        return this.user;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public Charset getCharset() {
        return this.charset;
    }

    @Generated
    public Long getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @Generated
    public Long getSoTimeout() {
        return this.soTimeout;
    }

    @Generated
    public String getServerLanguageCode() {
        return this.serverLanguageCode;
    }

    @Generated
    public String getSystemKey() {
        return this.systemKey;
    }

    @Generated
    public Boolean getIsActive() {
        return this.isActive;
    }

    @Generated
    public GenericObjectPoolConfig<Ftp> getPoolConfig() {
        return this.poolConfig;
    }

    @Generated
    public GenericObjectPool<Ftp> getPool() {
        return this.pool;
    }

    @Generated
    public void setPlatform(String platform) {
        this.platform = platform;
    }

    @Generated
    public void setHost(String host) {
        this.host = host;
    }

    @Generated
    public void setPort(Integer port) {
        this.port = port;
    }

    @Generated
    public void setUser(String user) {
        this.user = user;
    }

    @Generated
    public void setPassword(String password) {
        this.password = password;
    }

    @Generated
    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    @Generated
    public void setConnectionTimeout(Long connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    @Generated
    public void setSoTimeout(Long soTimeout) {
        this.soTimeout = soTimeout;
    }

    @Generated
    public void setServerLanguageCode(String serverLanguageCode) {
        this.serverLanguageCode = serverLanguageCode;
    }

    @Generated
    public void setSystemKey(String systemKey) {
        this.systemKey = systemKey;
    }

    @Generated
    public void setIsActive(Boolean isActive) {
        this.isActive = isActive;
    }

    @Generated
    public void setPoolConfig(GenericObjectPoolConfig<Ftp> poolConfig) {
        this.poolConfig = poolConfig;
    }

    @Generated
    public void setPool(GenericObjectPool<Ftp> pool) {
        this.pool = pool;
    }

    @Generated
    public FtpFileStorageClientFactory() {
    }

    public static class FtpPooledObjectFactory
    extends BasePooledObjectFactory<Ftp> {
        @Generated
        private static final Logger log = LoggerFactory.getLogger(FtpPooledObjectFactory.class);
        private FtpFileStorageClientFactory factory;

        public Ftp create() {
            if (this.factory == null) {
                throw new FileStorageRuntimeException("FTP \u8fde\u63a5\u5931\u8d25\uff01config \u4e0d\u80fd\u4e3a\u7a7a");
            }
            try {
                return new Ftp(FtpConfig.create().setHost(this.factory.getHost()).setPort(this.factory.getPort().intValue()).setUser(this.factory.getUser()).setPassword(this.factory.getPassword()).setCharset(this.factory.getCharset()).setConnectionTimeout(this.factory.getConnectionTimeout().longValue()).setSoTimeout(this.factory.getSoTimeout().longValue()).setServerLanguageCode(this.factory.getServerLanguageCode()).setSystemKey(this.factory.getSystemKey()), this.factory.getIsActive() != false ? FtpMode.Active : FtpMode.Passive);
            }
            catch (Exception e) {
                throw new FileStorageRuntimeException("FTP \u8fde\u63a5\u5931\u8d25\uff01platform\uff1a" + this.factory.getPlatform(), e);
            }
        }

        public PooledObject<Ftp> wrap(Ftp sftp) {
            return new DefaultPooledObject((Object)sftp);
        }

        public boolean validateObject(PooledObject<Ftp> p) {
            try {
                ((Ftp)p.getObject()).cd(".");
                return true;
            }
            catch (FtpException e) {
                log.warn("\u9a8c\u8bc1 Ftp \u5bf9\u8c61\u5931\u8d25", (Throwable)e);
                return false;
            }
        }

        public void destroyObject(PooledObject<Ftp> p) {
            try {
                ((Ftp)p.getObject()).close();
            }
            catch (Exception e) {
                throw new FileStorageRuntimeException("\u9500\u6bc1 Ftp \u5bf9\u8c61\u5931\u8d25\uff01", e);
            }
        }

        @Generated
        public FtpPooledObjectFactory(FtpFileStorageClientFactory factory) {
            this.factory = factory;
        }
    }
}

