/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.x.file.storage.core.platform;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import java.io.InputStream;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.dromara.x.file.storage.core.FileInfo;
import org.dromara.x.file.storage.core.UploadPretreatment;
import org.dromara.x.file.storage.core.copy.CopyPretreatment;
import org.dromara.x.file.storage.core.get.GetFilePretreatment;
import org.dromara.x.file.storage.core.get.ListFilesPretreatment;
import org.dromara.x.file.storage.core.get.ListFilesResult;
import org.dromara.x.file.storage.core.get.ListFilesSupportInfo;
import org.dromara.x.file.storage.core.get.RemoteFileInfo;
import org.dromara.x.file.storage.core.move.MovePretreatment;
import org.dromara.x.file.storage.core.presigned.GeneratePresignedUrlPretreatment;
import org.dromara.x.file.storage.core.presigned.GeneratePresignedUrlResult;
import org.dromara.x.file.storage.core.upload.AbortMultipartUploadPretreatment;
import org.dromara.x.file.storage.core.upload.CompleteMultipartUploadPretreatment;
import org.dromara.x.file.storage.core.upload.FilePartInfo;
import org.dromara.x.file.storage.core.upload.FilePartInfoList;
import org.dromara.x.file.storage.core.upload.InitiateMultipartUploadPretreatment;
import org.dromara.x.file.storage.core.upload.ListPartsPretreatment;
import org.dromara.x.file.storage.core.upload.MultipartUploadSupportInfo;
import org.dromara.x.file.storage.core.upload.UploadPartPretreatment;
import org.dromara.x.file.storage.core.util.Tools;

public interface FileStorage
extends AutoCloseable {
    public String getPlatform();

    public void setPlatform(String var1);

    public boolean save(FileInfo var1, UploadPretreatment var2);

    default public MultipartUploadSupportInfo isSupportMultipartUpload() {
        return MultipartUploadSupportInfo.notSupport();
    }

    default public void initiateMultipartUpload(FileInfo fileInfo, InitiateMultipartUploadPretreatment pre) {
    }

    default public FilePartInfo uploadPart(UploadPartPretreatment pre) {
        return null;
    }

    default public void completeMultipartUpload(CompleteMultipartUploadPretreatment pre) {
    }

    default public void abortMultipartUpload(AbortMultipartUploadPretreatment pre) {
    }

    default public FilePartInfoList listParts(ListPartsPretreatment pre) {
        return null;
    }

    default public ListFilesSupportInfo isSupportListFiles() {
        return ListFilesSupportInfo.notSupport();
    }

    default public <T> ListFilesMatchResult<T> listFilesMatch(List<T> list, Function<T, String> nameGetter, ListFilesPretreatment pre, boolean sort) {
        int index;
        if (CollUtil.isNotEmpty(list) && StrUtil.isNotEmpty((CharSequence)pre.getFilenamePrefix())) {
            list = list.stream().filter(p -> ((String)nameGetter.apply(p)).startsWith(pre.getFilenamePrefix())).collect(Collectors.toList());
        }
        if (CollUtil.isNotEmpty(list) && sort) {
            list = list.stream().sorted(Comparator.comparing(nameGetter)).collect(Collectors.toList());
        }
        if (CollUtil.isNotEmpty(list) && StrUtil.isNotEmpty((CharSequence)pre.getMarker()) && (index = CollUtil.indexOf(list, p -> ((String)nameGetter.apply(p)).equals(pre.getMarker()))) >= 0) {
            list = list.subList(index + 1, list.size());
        }
        boolean isTruncated = false;
        String nextMarker = null;
        if (CollUtil.isNotEmpty(list) && pre.getMaxFiles() != null && list.size() > pre.getMaxFiles()) {
            list = list.subList(0, pre.getMaxFiles());
            isTruncated = true;
            nextMarker = nameGetter.apply(list.get(list.size() - 1));
        }
        return new ListFilesMatchResult<T>(list, isTruncated, nextMarker);
    }

    default public ListFilesResult listFiles(ListFilesPretreatment pre) {
        return null;
    }

    default public RemoteFileInfo getFile(GetFilePretreatment pre) {
        return null;
    }

    default public boolean isSupportPresignedUrl() {
        return false;
    }

    default public GeneratePresignedUrlResult generatePresignedUrl(GeneratePresignedUrlPretreatment pre) {
        return null;
    }

    default public boolean isSupportAcl() {
        return false;
    }

    default public boolean setFileAcl(FileInfo fileInfo, Object acl) {
        return false;
    }

    default public boolean setThFileAcl(FileInfo fileInfo, Object acl) {
        return false;
    }

    default public boolean isSupportMetadata() {
        return false;
    }

    public boolean delete(FileInfo var1);

    public boolean exists(FileInfo var1);

    public void download(FileInfo var1, Consumer<InputStream> var2);

    public void downloadTh(FileInfo var1, Consumer<InputStream> var2);

    default public boolean isSupportSameCopy() {
        return false;
    }

    default public void sameCopy(FileInfo srcFileInfo, FileInfo destFileInfo, CopyPretreatment pre) {
    }

    default public boolean isSupportSameMove() {
        return false;
    }

    default public void sameMove(FileInfo srcFileInfo, FileInfo destFileInfo, MovePretreatment pre) {
    }

    @Override
    default public void close() {
    }

    default public String getFileKey(FileInfo fileInfo) {
        return Tools.getNotNull(fileInfo.getBasePath(), "") + Tools.getNotNull(fileInfo.getPath(), "") + Tools.getNotNull(fileInfo.getFilename(), "");
    }

    default public String getThFileKey(FileInfo fileInfo) {
        if (StrUtil.isBlank((CharSequence)fileInfo.getThFilename())) {
            return null;
        }
        return Tools.getNotNull(fileInfo.getBasePath(), "") + Tools.getNotNull(fileInfo.getPath(), "") + Tools.getNotNull(fileInfo.getThFilename(), "");
    }

    public static class ListFilesMatchResult<T> {
        private List<T> list;
        private Boolean isTruncated;
        private String nextMarker;

        @Generated
        public List<T> getList() {
            return this.list;
        }

        @Generated
        public Boolean getIsTruncated() {
            return this.isTruncated;
        }

        @Generated
        public String getNextMarker() {
            return this.nextMarker;
        }

        @Generated
        public ListFilesMatchResult<T> setList(List<T> list) {
            this.list = list;
            return this;
        }

        @Generated
        public ListFilesMatchResult<T> setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        @Generated
        public ListFilesMatchResult<T> setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ListFilesMatchResult)) {
                return false;
            }
            ListFilesMatchResult other = (ListFilesMatchResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$isTruncated = this.getIsTruncated();
            Boolean other$isTruncated = other.getIsTruncated();
            if (this$isTruncated == null ? other$isTruncated != null : !((Object)this$isTruncated).equals(other$isTruncated)) {
                return false;
            }
            List<T> this$list = this.getList();
            List<T> other$list = other.getList();
            if (this$list == null ? other$list != null : !((Object)this$list).equals(other$list)) {
                return false;
            }
            String this$nextMarker = this.getNextMarker();
            String other$nextMarker = other.getNextMarker();
            return !(this$nextMarker == null ? other$nextMarker != null : !this$nextMarker.equals(other$nextMarker));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ListFilesMatchResult;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $isTruncated = this.getIsTruncated();
            result = result * 59 + ($isTruncated == null ? 43 : ((Object)$isTruncated).hashCode());
            List<T> $list = this.getList();
            result = result * 59 + ($list == null ? 43 : ((Object)$list).hashCode());
            String $nextMarker = this.getNextMarker();
            result = result * 59 + ($nextMarker == null ? 43 : $nextMarker.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FileStorage.ListFilesMatchResult(list=" + this.list + ", isTruncated=" + this.isTruncated + ", nextMarker=" + this.nextMarker + ")";
        }

        @Generated
        public ListFilesMatchResult(List<T> list, Boolean isTruncated, String nextMarker) {
            this.list = list;
            this.isTruncated = isTruncated;
            this.nextMarker = nextMarker;
        }
    }
}

