/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.x.file.storage.core.platform;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ReUtil;
import cn.hutool.core.util.StrUtil;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import lombok.Generated;
import lombok.NonNull;
import org.csource.common.MyException;
import org.csource.fastdfs.ClientGlobal;
import org.csource.fastdfs.StorageClient;
import org.csource.fastdfs.StorageServer;
import org.csource.fastdfs.TrackerClient;
import org.csource.fastdfs.TrackerServer;
import org.dromara.x.file.storage.core.FileStorageProperties;
import org.dromara.x.file.storage.core.exception.FileStorageRuntimeException;
import org.dromara.x.file.storage.core.platform.FileStorageClientFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FastDfsFileStorageClientFactory
implements FileStorageClientFactory<StorageClient> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FastDfsFileStorageClientFactory.class);
    private static final String IP_COLON_PORT = "^.*:(?:[1-9]\\d{0,3}|[1-5]\\d{4}|[1-5][0-9]{0,3}\\d{0,3}|6[0-4]\\d{0,3}|65[0-4]\\d{0,2}|655[0-2]\\d?)$";
    private static final String IP_COLON_PORT_COMMA = "^(.*?):\\d+(?:,(.*?):\\d+)*$";
    private final FileStorageProperties.FastDfsConfig config;
    private volatile StorageClient client;

    public FastDfsFileStorageClientFactory(FileStorageProperties.FastDfsConfig config) {
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StorageClient getClient() {
        if (this.client == null) {
            FastDfsFileStorageClientFactory fastDfsFileStorageClientFactory = this;
            synchronized (fastDfsFileStorageClientFactory) {
                if (this.client == null) {
                    try {
                        if (this.config.getTrackerServer() == null && this.config.getStorageServer() == null) {
                            throw new FileStorageRuntimeException("Tracker server \u6216 Storage server \u672a\u914d\u7f6e\u3002");
                        }
                        this.client = this.config.getTrackerServer() != null ? this.getClientByTrackerServer() : this.getClientByStorage();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        return this.client;
    }

    private StorageClient getClientByTrackerServer() throws MyException, IOException {
        Assert.notNull((Object)this.config.getTrackerServer(), (String)"Tracker server \u914d\u7f6e\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.isTrue((boolean)ReUtil.isMatch((String)IP_COLON_PORT_COMMA, (CharSequence)this.config.getTrackerServer().getServerAddr()), (String)"Tracker server \u914d\u7f6e\u9519\u8bef", (Object[])new Object[0]);
        Properties props = this.getProperties();
        ClientGlobal.initByProperties((Properties)props);
        TrackerClient trackerClient = new TrackerClient();
        TrackerServer trackerServer = trackerClient.getTrackerServer();
        StorageServer storeStorage = trackerClient.getStoreStorage(trackerServer);
        return new StorageClient(trackerServer, storeStorage);
    }

    private StorageClient getClientByStorage() throws IOException {
        FileStorageProperties.FastDfsConfig.FastDfsStorageServer storageServer = this.config.getStorageServer();
        Assert.notNull((Object)storageServer, (String)"Storage server \u914d\u7f6e\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.isTrue((boolean)ReUtil.isMatch((String)IP_COLON_PORT, (CharSequence)storageServer.getServerAddr()), (String)"Storage server \u914d\u7f6e\u9519\u8bef", (Object[])new Object[0]);
        this.initProp();
        List split = StrUtil.split((CharSequence)storageServer.getServerAddr(), (char)':');
        return new StorageClient(null, new StorageServer((String)split.get(0), Integer.parseInt((String)split.get(1)), storageServer.getStorePath().intValue()));
    }

    private void initProp() {
        Properties props = this.getProperties();
        String connectTimeoutInSecondsConf = props.getProperty("fastdfs.connect_timeout_in_seconds");
        String networkTimeoutInSecondsConf = props.getProperty("fastdfs.network_timeout_in_seconds");
        String charsetConf = props.getProperty("fastdfs.charset");
        String httpAntiStealTokenConf = props.getProperty("fastdfs.http_anti_steal_token");
        String httpSecretKeyConf = props.getProperty("fastdfs.http_secret_key");
        String httpTrackerHttpPortConf = props.getProperty("fastdfs.http_tracker_http_port");
        String poolEnabled = props.getProperty("fastdfs.connection_pool.enabled");
        String poolMaxCountPerEntry = props.getProperty("fastdfs.connection_pool.max_count_per_entry");
        String poolMaxIdleTime = props.getProperty("fastdfs.connection_pool.max_idle_time");
        String poolMaxWaitTimeInMS = props.getProperty("fastdfs.connection_pool.max_wait_time_in_ms");
        if (connectTimeoutInSecondsConf != null && !connectTimeoutInSecondsConf.trim().isEmpty()) {
            ClientGlobal.g_connect_timeout = Integer.parseInt(connectTimeoutInSecondsConf.trim()) * 1000;
        }
        if (networkTimeoutInSecondsConf != null && !networkTimeoutInSecondsConf.trim().isEmpty()) {
            ClientGlobal.g_network_timeout = Integer.parseInt(networkTimeoutInSecondsConf.trim()) * 1000;
        }
        if (charsetConf != null && !charsetConf.trim().isEmpty()) {
            ClientGlobal.g_charset = charsetConf.trim();
        }
        if (httpAntiStealTokenConf != null && !httpAntiStealTokenConf.trim().isEmpty()) {
            ClientGlobal.g_anti_steal_token = Boolean.parseBoolean(httpAntiStealTokenConf);
        }
        if (httpSecretKeyConf != null && !httpSecretKeyConf.trim().isEmpty()) {
            ClientGlobal.g_secret_key = httpSecretKeyConf.trim();
        }
        if (httpTrackerHttpPortConf != null && !httpTrackerHttpPortConf.trim().isEmpty()) {
            ClientGlobal.g_tracker_http_port = Integer.parseInt(httpTrackerHttpPortConf);
        }
        if (poolEnabled != null && !poolEnabled.trim().isEmpty()) {
            ClientGlobal.g_connection_pool_enabled = Boolean.parseBoolean(poolEnabled);
        }
        if (poolMaxCountPerEntry != null && !poolMaxCountPerEntry.trim().isEmpty()) {
            ClientGlobal.g_connection_pool_max_count_per_entry = Integer.parseInt(poolMaxCountPerEntry);
        }
        if (poolMaxIdleTime != null && !poolMaxIdleTime.trim().isEmpty()) {
            ClientGlobal.g_connection_pool_max_idle_time = Integer.parseInt(poolMaxIdleTime) * 1000;
        }
        if (poolMaxWaitTimeInMS != null && !poolMaxWaitTimeInMS.trim().isEmpty()) {
            ClientGlobal.g_connection_pool_max_wait_time_in_ms = Integer.parseInt(poolMaxWaitTimeInMS);
        }
    }

    @NonNull
    private Properties getProperties() {
        Properties props = new Properties();
        if (this.config.getTrackerServer() != null) {
            FileStorageProperties.FastDfsConfig.FastDfsTrackerServer trackerServer = this.config.getTrackerServer();
            props.put("fastdfs.tracker_servers", trackerServer.getServerAddr());
            props.put("fastdfs.http_tracker_http_port", Convert.toStr((Object)trackerServer.getHttpPort(), (String)""));
        }
        if (this.config.getExtra() != null) {
            FileStorageProperties.FastDfsConfig.FastDfsExtra extra = this.config.getExtra();
            props.put("fastdfs.connect_timeout_in_seconds", Convert.toStr((Object)extra.getConnectTimeoutInSeconds(), (String)""));
            props.put("fastdfs.network_timeout_in_seconds", Convert.toStr((Object)extra.getNetworkTimeoutInSeconds(), (String)""));
            props.put("fastdfs.charset", Convert.toStr((Object)extra.getCharset(), (String)""));
            props.put("fastdfs.http_anti_steal_token", Convert.toStr((Object)extra.getHttpAntiStealToken(), (String)""));
            props.put("fastdfs.http_secret_key", Convert.toStr((Object)extra.getHttpSecretKey(), (String)""));
            props.put("fastdfs.connection_pool.enabled", Convert.toStr((Object)extra.getConnectionPoolEnabled(), (String)""));
            props.put("fastdfs.connection_pool.max_count_per_entry", Convert.toStr((Object)extra.getConnectionPoolMaxCountPerEntry(), (String)""));
            props.put("fastdfs.connection_pool.max_idle_time", Convert.toStr((Object)extra.getConnectionPoolMaxIdleTime(), (String)""));
            props.put("fastdfs.connection_pool.max_wait_time_in_ms", Convert.toStr((Object)extra.getConnectionPoolMaxWaitTimeInMs(), (String)""));
        }
        return props;
    }

    @Override
    public void close() {
        if (this.client != null) {
            try {
                this.connClose(this.client.getTrackerServer());
                this.connClose((TrackerServer)this.client.getStorageServer());
                this.client.setStorageServer(null);
                this.client.setTrackerServer(null);
                this.client = null;
            }
            catch (Exception e) {
                throw new FileStorageRuntimeException("\u5173\u95ed FastDFS Storage Client \u5931\u8d25\uff01", e);
            }
        }
    }

    private void connClose(TrackerServer trackerServer) {
        Optional.ofNullable(trackerServer).ifPresent(e -> {
            try {
                e.getConnection().close();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        });
    }

    @Override
    public String getPlatform() {
        return this.config.getPlatform();
    }

    @Generated
    public FileStorageProperties.FastDfsConfig getConfig() {
        return this.config;
    }

    @Generated
    public void setClient(StorageClient client) {
        this.client = client;
    }
}

