/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.x.file.storage.core.platform;

import cn.hutool.core.util.StrUtil;
import com.baidubce.Protocol;
import com.baidubce.auth.BceCredentials;
import com.baidubce.auth.DefaultBceCredentials;
import com.baidubce.services.bos.BosClient;
import com.baidubce.services.bos.BosClientConfiguration;
import lombok.Generated;
import org.dromara.x.file.storage.core.FileStorageProperties;
import org.dromara.x.file.storage.core.platform.FileStorageClientFactory;

public class BaiduBosFileStorageClientFactory
implements FileStorageClientFactory<BosClient> {
    private String platform;
    private String accessKey;
    private String secretKey;
    private String endPoint;
    private volatile BosClient client;

    public BaiduBosFileStorageClientFactory(FileStorageProperties.BaiduBosConfig config) {
        this.platform = config.getPlatform();
        this.accessKey = config.getAccessKey();
        this.secretKey = config.getSecretKey();
        this.endPoint = config.getEndPoint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BosClient getClient() {
        if (this.client == null) {
            BaiduBosFileStorageClientFactory baiduBosFileStorageClientFactory = this;
            synchronized (baiduBosFileStorageClientFactory) {
                if (this.client == null) {
                    BosClientConfiguration configuration = new BosClientConfiguration();
                    configuration.setProtocol(Protocol.HTTPS);
                    configuration.setCredentials((BceCredentials)new DefaultBceCredentials(this.accessKey, this.secretKey));
                    if (StrUtil.isNotBlank((CharSequence)this.endPoint)) {
                        configuration.setEndpoint(this.endPoint);
                    }
                    this.client = new BosClient(configuration);
                }
            }
        }
        return this.client;
    }

    @Override
    public void close() {
        if (this.client != null) {
            this.client.shutdown();
            this.client = null;
        }
    }

    @Override
    @Generated
    public String getPlatform() {
        return this.platform;
    }

    @Generated
    public String getAccessKey() {
        return this.accessKey;
    }

    @Generated
    public String getSecretKey() {
        return this.secretKey;
    }

    @Generated
    public String getEndPoint() {
        return this.endPoint;
    }

    @Generated
    public void setPlatform(String platform) {
        this.platform = platform;
    }

    @Generated
    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    @Generated
    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    @Generated
    public void setEndPoint(String endPoint) {
        this.endPoint = endPoint;
    }

    @Generated
    public void setClient(BosClient client) {
        this.client = client;
    }

    @Generated
    public BaiduBosFileStorageClientFactory() {
    }
}

