/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.x.file.storage.core.platform;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.io.file.FileNameUtil;
import cn.hutool.core.text.NamingCase;
import cn.hutool.core.util.StrUtil;
import com.baidubce.BceServiceException;
import com.baidubce.http.HttpMethodName;
import com.baidubce.services.bos.BosClient;
import com.baidubce.services.bos.BosObjectInputStream;
import com.baidubce.services.bos.model.AbortMultipartUploadRequest;
import com.baidubce.services.bos.model.BosObject;
import com.baidubce.services.bos.model.BosProgressCallback;
import com.baidubce.services.bos.model.CannedAccessControlList;
import com.baidubce.services.bos.model.CompleteMultipartUploadRequest;
import com.baidubce.services.bos.model.CopyObjectRequest;
import com.baidubce.services.bos.model.GeneratePresignedUrlRequest;
import com.baidubce.services.bos.model.InitiateMultipartUploadRequest;
import com.baidubce.services.bos.model.ListObjectsRequest;
import com.baidubce.services.bos.model.ListObjectsResponse;
import com.baidubce.services.bos.model.ListPartsRequest;
import com.baidubce.services.bos.model.ListPartsResponse;
import com.baidubce.services.bos.model.ObjectMetadata;
import com.baidubce.services.bos.model.PartETag;
import com.baidubce.services.bos.model.PutObjectRequest;
import com.baidubce.services.bos.model.UploadPartCopyRequest;
import com.baidubce.services.bos.model.UploadPartCopyResponse;
import com.baidubce.services.bos.model.UploadPartRequest;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import lombok.Generated;
import org.dromara.x.file.storage.core.FileInfo;
import org.dromara.x.file.storage.core.FileStorageProperties;
import org.dromara.x.file.storage.core.InputStreamPlus;
import org.dromara.x.file.storage.core.ProgressListener;
import org.dromara.x.file.storage.core.UploadPretreatment;
import org.dromara.x.file.storage.core.copy.CopyPretreatment;
import org.dromara.x.file.storage.core.exception.Check;
import org.dromara.x.file.storage.core.exception.ExceptionFactory;
import org.dromara.x.file.storage.core.file.FileWrapper;
import org.dromara.x.file.storage.core.get.GetFilePretreatment;
import org.dromara.x.file.storage.core.get.ListFilesPretreatment;
import org.dromara.x.file.storage.core.get.ListFilesResult;
import org.dromara.x.file.storage.core.get.ListFilesSupportInfo;
import org.dromara.x.file.storage.core.get.RemoteDirInfo;
import org.dromara.x.file.storage.core.get.RemoteFileInfo;
import org.dromara.x.file.storage.core.platform.FileStorage;
import org.dromara.x.file.storage.core.platform.FileStorageClientFactory;
import org.dromara.x.file.storage.core.presigned.GeneratePresignedUrlPretreatment;
import org.dromara.x.file.storage.core.presigned.GeneratePresignedUrlResult;
import org.dromara.x.file.storage.core.upload.AbortMultipartUploadPretreatment;
import org.dromara.x.file.storage.core.upload.CompleteMultipartUploadPretreatment;
import org.dromara.x.file.storage.core.upload.FilePartInfo;
import org.dromara.x.file.storage.core.upload.FilePartInfoList;
import org.dromara.x.file.storage.core.upload.InitiateMultipartUploadPretreatment;
import org.dromara.x.file.storage.core.upload.ListPartsPretreatment;
import org.dromara.x.file.storage.core.upload.MultipartUploadSupportInfo;
import org.dromara.x.file.storage.core.upload.UploadPartPretreatment;
import org.dromara.x.file.storage.core.util.Tools;

public class BaiduBosFileStorage
implements FileStorage {
    private String platform;
    private String bucketName;
    private String domain;
    private String basePath;
    private String defaultAcl;
    private int multipartThreshold;
    private int multipartPartSize;
    private FileStorageClientFactory<BosClient> clientFactory;

    public BaiduBosFileStorage(FileStorageProperties.BaiduBosConfig config, FileStorageClientFactory<BosClient> clientFactory) {
        this.platform = config.getPlatform();
        this.bucketName = config.getBucketName();
        this.domain = config.getDomain();
        this.basePath = config.getBasePath();
        this.defaultAcl = config.getDefaultAcl();
        this.multipartThreshold = config.getMultipartThreshold();
        this.multipartPartSize = config.getMultipartPartSize();
        this.clientFactory = clientFactory;
    }

    public BosClient getClient() {
        return this.clientFactory.getClient();
    }

    @Override
    public void close() {
        this.clientFactory.close();
    }

    @Override
    public boolean save(final FileInfo fileInfo, UploadPretreatment pre) {
        boolean bl;
        block22: {
            fileInfo.setBasePath(this.basePath);
            String newFileKey = this.getFileKey(fileInfo);
            fileInfo.setUrl(this.domain + newFileKey);
            ObjectMetadata metadata = this.getObjectMetadata(fileInfo);
            final ProgressListener listener = pre.getProgressListener();
            BosClient client = this.getClient();
            boolean useMultipartUpload = fileInfo.getSize() == null || fileInfo.getSize() >= (long)this.multipartThreshold;
            String uploadId = null;
            InputStreamPlus in = pre.getInputStreamPlus(false);
            try {
                byte[] thumbnailBytes;
                if (useMultipartUpload) {
                    byte[] bytes;
                    InitiateMultipartUploadRequest initiateMultipartUploadRequest = new InitiateMultipartUploadRequest(this.bucketName, newFileKey);
                    initiateMultipartUploadRequest.setObjectMetadata(metadata);
                    uploadId = client.initiateMultipartUpload(initiateMultipartUploadRequest).getUploadId();
                    ArrayList<PartETag> partList = new ArrayList<PartETag>();
                    int i = 0;
                    final AtomicLong progressSize = new AtomicLong();
                    if (listener != null) {
                        listener.start();
                    }
                    while ((bytes = IoUtil.readBytes((InputStream)in, (int)this.multipartPartSize)) != null && bytes.length != 0) {
                        UploadPartRequest part = new UploadPartRequest();
                        part.setBucketName(this.bucketName);
                        part.setKey(newFileKey);
                        part.setUploadId(uploadId);
                        part.setInputStream((InputStream)new ByteArrayInputStream(bytes));
                        part.setPartSize((long)bytes.length);
                        part.setPartNumber(++i);
                        if (listener != null) {
                            part.setProgressCallback((BosProgressCallback)new BosProgressCallback<Object>(){

                                public void onProgress(long currentSize, long totalSize, Object data) {
                                    listener.progress(progressSize.get() + currentSize, fileInfo.getSize());
                                }
                            });
                        }
                        partList.add(client.uploadPart(part).getPartETag());
                        progressSize.addAndGet(bytes.length);
                    }
                    client.completeMultipartUpload(new CompleteMultipartUploadRequest(this.bucketName, newFileKey, uploadId, partList));
                    if (listener != null) {
                        listener.finish();
                    }
                } else {
                    PutObjectRequest request = new PutObjectRequest(this.bucketName, newFileKey, (InputStream)in, metadata);
                    if (listener != null) {
                        listener.start();
                        request.setProgressCallback((BosProgressCallback)new BosProgressCallback<Object>(){

                            public void onProgress(long currentSize, long totalSize, Object data) {
                                listener.progress(currentSize, fileInfo.getSize());
                            }
                        });
                    }
                    client.putObject(request);
                    if (listener != null) {
                        listener.finish();
                    }
                }
                if (fileInfo.getSize() == null) {
                    fileInfo.setSize(in.getProgressSize());
                }
                if ((thumbnailBytes = pre.getThumbnailBytes()) != null) {
                    String newThFileKey = this.getThFileKey(fileInfo);
                    fileInfo.setThUrl(this.domain + newThFileKey);
                    client.putObject(this.bucketName, newThFileKey, (InputStream)new ByteArrayInputStream(thumbnailBytes), this.getThObjectMetadata(fileInfo));
                }
                bl = true;
                if (in == null) break block22;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    try {
                        if (useMultipartUpload) {
                            client.abortMultipartUpload(new AbortMultipartUploadRequest(this.bucketName, newFileKey, uploadId));
                        } else {
                            client.deleteObject(this.bucketName, newFileKey);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw ExceptionFactory.upload(fileInfo, this.platform, e);
                }
            }
            in.close();
        }
        return bl;
    }

    @Override
    public MultipartUploadSupportInfo isSupportMultipartUpload() {
        return MultipartUploadSupportInfo.supportAll();
    }

    @Override
    public void initiateMultipartUpload(FileInfo fileInfo, InitiateMultipartUploadPretreatment pre) {
        fileInfo.setBasePath(this.basePath);
        String newFileKey = this.getFileKey(fileInfo);
        fileInfo.setUrl(this.domain + newFileKey);
        ObjectMetadata metadata = this.getObjectMetadata(fileInfo);
        BosClient client = this.getClient();
        try {
            InitiateMultipartUploadRequest request = new InitiateMultipartUploadRequest(this.bucketName, newFileKey);
            request.setObjectMetadata(metadata);
            String uploadId = client.initiateMultipartUpload(request).getUploadId();
            fileInfo.setUploadId(uploadId);
        }
        catch (Exception e) {
            throw ExceptionFactory.initiateMultipartUpload(fileInfo, this.platform, e);
        }
    }

    @Override
    public FilePartInfo uploadPart(UploadPartPretreatment pre) {
        FilePartInfo filePartInfo;
        block9: {
            FileInfo fileInfo = pre.getFileInfo();
            String newFileKey = this.getFileKey(fileInfo);
            BosClient client = this.getClient();
            FileWrapper partFileWrapper = pre.getPartFileWrapper();
            Long partSize = partFileWrapper.getSize();
            InputStreamPlus in = pre.getInputStreamPlus();
            try {
                if (partSize == null) {
                    partSize = partFileWrapper.getInputStreamMaskResetReturn(Tools::getSize);
                }
                UploadPartRequest part = new UploadPartRequest();
                part.setBucketName(this.bucketName);
                part.setKey(newFileKey);
                part.setUploadId(fileInfo.getUploadId());
                part.setInputStream((InputStream)in);
                part.setPartSize(partSize.longValue());
                part.setPartNumber(pre.getPartNumber());
                PartETag partETag = client.uploadPart(part).getPartETag();
                FilePartInfo filePartInfo2 = new FilePartInfo(fileInfo);
                filePartInfo2.setETag(partETag.getETag());
                filePartInfo2.setPartNumber(partETag.getPartNumber());
                filePartInfo2.setPartSize(in.getProgressSize());
                filePartInfo2.setCreateTime(new Date());
                filePartInfo = filePartInfo2;
                if (in == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw ExceptionFactory.uploadPart(fileInfo, this.platform, e);
                }
            }
            in.close();
        }
        return filePartInfo;
    }

    @Override
    public void completeMultipartUpload(CompleteMultipartUploadPretreatment pre) {
        FileInfo fileInfo = pre.getFileInfo();
        String newFileKey = this.getFileKey(fileInfo);
        BosClient client = this.getClient();
        try {
            List partList = pre.getPartInfoList().stream().map(part -> new PartETag(part.getPartNumber().intValue(), part.getETag())).collect(Collectors.toList());
            ProgressListener.quickStart(pre.getProgressListener(), fileInfo.getSize());
            client.completeMultipartUpload(new CompleteMultipartUploadRequest(this.bucketName, newFileKey, fileInfo.getUploadId(), partList));
            ProgressListener.quickFinish(pre.getProgressListener(), fileInfo.getSize());
        }
        catch (Exception e) {
            throw ExceptionFactory.completeMultipartUpload(fileInfo, this.platform, e);
        }
    }

    @Override
    public void abortMultipartUpload(AbortMultipartUploadPretreatment pre) {
        FileInfo fileInfo = pre.getFileInfo();
        String newFileKey = this.getFileKey(fileInfo);
        BosClient client = this.getClient();
        try {
            client.abortMultipartUpload(new AbortMultipartUploadRequest(this.bucketName, newFileKey, fileInfo.getUploadId()));
        }
        catch (Exception e) {
            throw ExceptionFactory.abortMultipartUpload(fileInfo, this.platform, e);
        }
    }

    @Override
    public FilePartInfoList listParts(ListPartsPretreatment pre) {
        FileInfo fileInfo = pre.getFileInfo();
        String newFileKey = this.getFileKey(fileInfo);
        BosClient client = this.getClient();
        try {
            ListPartsRequest request = new ListPartsRequest(this.bucketName, newFileKey, fileInfo.getUploadId());
            request.setMaxParts(pre.getMaxParts().intValue());
            request.setPartNumberMarker(pre.getPartNumberMarker().intValue());
            ListPartsResponse result = client.listParts(request);
            FilePartInfoList list = new FilePartInfoList();
            list.setFileInfo(fileInfo);
            list.setList(result.getParts().stream().map(p -> {
                FilePartInfo filePartInfo = new FilePartInfo(fileInfo);
                filePartInfo.setETag(p.getETag());
                filePartInfo.setPartNumber(p.getPartNumber());
                filePartInfo.setPartSize(p.getSize());
                filePartInfo.setLastModified(p.getLastModified());
                return filePartInfo;
            }).collect(Collectors.toList()));
            list.setMaxParts(result.getMaxParts());
            list.setIsTruncated(result.isTruncated());
            list.setPartNumberMarker(result.getPartNumberMarker());
            list.setNextPartNumberMarker(result.getNextPartNumberMarker());
            return list;
        }
        catch (Exception e) {
            throw ExceptionFactory.listParts(fileInfo, this.platform, e);
        }
    }

    @Override
    public ListFilesSupportInfo isSupportListFiles() {
        return ListFilesSupportInfo.supportAll();
    }

    @Override
    public ListFilesResult listFiles(ListFilesPretreatment pre) {
        BosClient client = this.getClient();
        try {
            ListObjectsRequest request = new ListObjectsRequest(this.bucketName);
            request.setMaxKeys(pre.getMaxFiles().intValue());
            request.setMarker(pre.getMarker());
            request.setDelimiter("/");
            request.setPrefix(this.basePath + pre.getPath() + pre.getFilenamePrefix());
            ListObjectsResponse result = client.listObjects(request);
            ListFilesResult list = new ListFilesResult();
            list.setDirList(result.getCommonPrefixes().stream().map(item -> {
                RemoteDirInfo dir = new RemoteDirInfo();
                dir.setPlatform(pre.getPlatform());
                dir.setBasePath(this.basePath);
                dir.setPath(pre.getPath());
                dir.setName(FileNameUtil.getName((String)item));
                dir.setOriginal(item);
                return dir;
            }).collect(Collectors.toList()));
            list.setFileList(result.getContents().stream().map(item -> {
                RemoteFileInfo info = new RemoteFileInfo();
                info.setPlatform(pre.getPlatform());
                info.setBasePath(this.basePath);
                info.setPath(pre.getPath());
                info.setFilename(FileNameUtil.getName((String)item.getKey()));
                info.setUrl(this.domain + this.getFileKey(new FileInfo(this.basePath, info.getPath(), info.getFilename())));
                info.setSize(item.getSize());
                info.setExt(FileNameUtil.extName((String)info.getFilename()));
                info.setETag(item.getETag());
                info.setLastModified(item.getLastModified());
                info.setOriginal(item);
                return info;
            }).collect(Collectors.toList()));
            list.setPlatform(pre.getPlatform());
            list.setBasePath(this.basePath);
            list.setPath(pre.getPath());
            list.setFilenamePrefix(pre.getFilenamePrefix());
            list.setMaxFiles(result.getMaxKeys());
            list.setIsTruncated(result.isTruncated());
            list.setMarker(result.getMarker());
            list.setNextMarker(result.getNextMarker());
            return list;
        }
        catch (Exception e) {
            throw ExceptionFactory.listFiles(pre, this.basePath, e);
        }
    }

    @Override
    public RemoteFileInfo getFile(GetFilePretreatment pre) {
        String fileKey = this.getFileKey(new FileInfo(this.basePath, pre.getPath(), pre.getFilename()));
        BosClient client = this.getClient();
        try {
            BosObject file;
            try {
                file = client.getObject(this.bucketName, fileKey);
            }
            catch (Exception e) {
                return null;
            }
            if (file == null) {
                return null;
            }
            ObjectMetadata metadata = file.getObjectMetadata();
            RemoteFileInfo info = new RemoteFileInfo();
            info.setPlatform(pre.getPlatform());
            info.setBasePath(this.basePath);
            info.setPath(pre.getPath());
            info.setFilename(FileNameUtil.getName((String)file.getKey()));
            info.setUrl(this.domain + fileKey);
            info.setSize(metadata.getContentLength());
            info.setExt(FileNameUtil.extName((String)info.getFilename()));
            info.setETag(metadata.getETag());
            info.setContentDisposition(metadata.getContentDisposition());
            info.setContentType(metadata.getContentType());
            info.setContentMd5(metadata.getContentMd5());
            info.setLastModified(metadata.getLastModified());
            info.setMetadata(BeanUtil.beanToMap((Object)metadata, (boolean)false, (boolean)true));
            info.getMetadata().remove("userMetadata");
            if (metadata.getUserMetadata() != null) {
                info.setUserMetadata(new HashMap<String, Object>(metadata.getUserMetadata()));
            }
            info.setOriginal(file);
            return info;
        }
        catch (Exception e) {
            throw ExceptionFactory.getFile(pre, this.basePath, e);
        }
    }

    public CannedAccessControlList getAcl(Object acl) {
        if (acl instanceof CannedAccessControlList) {
            return (CannedAccessControlList)acl;
        }
        if (acl instanceof String || acl == null) {
            String sAcl = (String)acl;
            if (StrUtil.isEmpty((CharSequence)sAcl)) {
                sAcl = this.defaultAcl;
            }
            for (CannedAccessControlList item : CannedAccessControlList.values()) {
                if (!item.toString().equals(sAcl)) continue;
                return item;
            }
        } else {
            throw ExceptionFactory.unrecognizedAcl(acl, this.platform);
        }
        return null;
    }

    public ObjectMetadata getObjectMetadata(FileInfo fileInfo) {
        CannedAccessControlList fileAcl = this.getAcl(fileInfo.getFileAcl());
        ObjectMetadata metadata = new ObjectMetadata();
        if (fileInfo.getSize() != null) {
            metadata.setContentLength(fileInfo.getSize().longValue());
        }
        metadata.setContentType(fileInfo.getContentType());
        if (fileAcl != null) {
            metadata.setxBceAcl(fileAcl.toString());
        }
        metadata.setUserMetadata(fileInfo.getUserMetadata());
        if (CollUtil.isNotEmpty(fileInfo.getMetadata())) {
            CopyOptions copyOptions = CopyOptions.create().ignoreCase().setFieldNameEditor(name -> NamingCase.toCamelCase((CharSequence)name, (char)'-'));
            BeanUtil.copyProperties(fileInfo.getMetadata(), (Object)metadata, (CopyOptions)copyOptions);
        }
        return metadata;
    }

    public ObjectMetadata getThObjectMetadata(FileInfo fileInfo) {
        ObjectMetadata metadata = new ObjectMetadata();
        metadata.setContentLength(fileInfo.getThSize().longValue());
        metadata.setContentType(fileInfo.getThContentType());
        CannedAccessControlList thFileAcl = this.getAcl(fileInfo.getThFileAcl());
        if (thFileAcl != null) {
            metadata.setxBceAcl(thFileAcl.toString());
        }
        metadata.setUserMetadata(fileInfo.getThUserMetadata());
        if (CollUtil.isNotEmpty(fileInfo.getThMetadata())) {
            CopyOptions copyOptions = CopyOptions.create().ignoreCase().setFieldNameEditor(name -> NamingCase.toCamelCase((CharSequence)name, (char)'-'));
            BeanUtil.copyProperties(fileInfo.getThMetadata(), (Object)metadata, (CopyOptions)copyOptions);
        }
        return metadata;
    }

    @Override
    public boolean isSupportPresignedUrl() {
        return true;
    }

    @Override
    public GeneratePresignedUrlResult generatePresignedUrl(GeneratePresignedUrlPretreatment pre) {
        try {
            String fileKey = this.getFileKey(new FileInfo(this.basePath, pre.getPath(), pre.getFilename()));
            GeneratePresignedUrlRequest request = new GeneratePresignedUrlRequest(this.bucketName, fileKey);
            request.setExpiration((int)((pre.getExpiration().getTime() - System.currentTimeMillis()) / 1000L));
            request.setMethod(Tools.getEnum(HttpMethodName.class, pre.getMethod()));
            HashMap<String, String> headers = new HashMap<String, String>(pre.getHeaders());
            headers.putAll(pre.getUserMetadata().entrySet().stream().collect(Collectors.toMap(e -> ((String)e.getKey()).startsWith("x-bce-meta-") ? (String)e.getKey() : "x-bce-meta-" + (String)e.getKey(), Map.Entry::getValue)));
            headers.forEach((arg_0, arg_1) -> ((GeneratePresignedUrlRequest)request).addRequestHeaders(arg_0, arg_1));
            pre.getQueryParams().forEach((arg_0, arg_1) -> ((GeneratePresignedUrlRequest)request).addRequestParameter(arg_0, arg_1));
            pre.getResponseHeaders().forEach((k, v) -> request.addRequestParameter(NamingCase.toCamelCase((CharSequence)("response-" + k.toLowerCase()), (char)'-'), v));
            URL url = this.getClient().generatePresignedUrl(request);
            GeneratePresignedUrlResult result = new GeneratePresignedUrlResult(this.platform, this.basePath, pre);
            result.setUrl(url.toString());
            result.setHeaders(headers);
            return result;
        }
        catch (Exception e2) {
            throw ExceptionFactory.generatePresignedUrl(pre, e2);
        }
    }

    @Override
    public boolean isSupportAcl() {
        return true;
    }

    @Override
    public boolean setFileAcl(FileInfo fileInfo, Object acl) {
        CannedAccessControlList oAcl = this.getAcl(acl);
        if (oAcl == null) {
            return false;
        }
        try {
            this.getClient().setObjectAcl(this.bucketName, this.getFileKey(fileInfo), oAcl);
            return true;
        }
        catch (Exception e) {
            throw ExceptionFactory.setFileAcl(fileInfo, oAcl, this.platform, e);
        }
    }

    @Override
    public boolean setThFileAcl(FileInfo fileInfo, Object acl) {
        CannedAccessControlList oAcl = this.getAcl(acl);
        if (oAcl == null) {
            return false;
        }
        String key = this.getThFileKey(fileInfo);
        if (key == null) {
            return false;
        }
        try {
            this.getClient().setObjectAcl(this.bucketName, key, oAcl);
            return true;
        }
        catch (Exception e) {
            throw ExceptionFactory.setThFileAcl(fileInfo, oAcl, this.platform, e);
        }
    }

    @Override
    public boolean isSupportMetadata() {
        return true;
    }

    @Override
    public boolean delete(FileInfo fileInfo) {
        BosClient client = this.getClient();
        try {
            block8: {
                if (fileInfo.getThFilename() != null) {
                    try {
                        client.deleteObject(this.bucketName, this.getThFileKey(fileInfo));
                    }
                    catch (BceServiceException e) {
                        if ("NoSuchKey".equals(e.getErrorCode())) break block8;
                        throw e;
                    }
                }
            }
            try {
                client.deleteObject(this.bucketName, this.getFileKey(fileInfo));
            }
            catch (BceServiceException e) {
                if (!"NoSuchKey".equals(e.getErrorCode())) {
                    throw e;
                }
            }
        }
        catch (Exception e) {
            throw ExceptionFactory.delete(fileInfo, this.platform, e);
        }
        return true;
    }

    @Override
    public boolean exists(FileInfo fileInfo) {
        try {
            return this.getClient().doesObjectExist(this.bucketName, this.getFileKey(fileInfo));
        }
        catch (Exception e) {
            throw ExceptionFactory.exists(fileInfo, this.platform, e);
        }
    }

    @Override
    public void download(FileInfo fileInfo, Consumer<InputStream> consumer) {
        BosObject object = this.getClient().getObject(this.bucketName, this.getFileKey(fileInfo));
        try (BosObjectInputStream in = object.getObjectContent();){
            consumer.accept((InputStream)in);
        }
        catch (Exception e) {
            throw ExceptionFactory.download(fileInfo, this.platform, e);
        }
    }

    @Override
    public void downloadTh(FileInfo fileInfo, Consumer<InputStream> consumer) {
        Check.downloadThBlankThFilename(this.platform, fileInfo);
        BosObject object = this.getClient().getObject(this.bucketName, this.getThFileKey(fileInfo));
        try (BosObjectInputStream in = object.getObjectContent();){
            consumer.accept((InputStream)in);
        }
        catch (Exception e) {
            throw ExceptionFactory.downloadTh(fileInfo, this.platform, e);
        }
    }

    @Override
    public boolean isSupportSameCopy() {
        return true;
    }

    @Override
    public void sameCopy(FileInfo srcFileInfo, FileInfo destFileInfo, CopyPretreatment pre) {
        ObjectMetadata srcFile;
        Check.sameCopyBasePath(this.platform, this.basePath, srcFileInfo, destFileInfo);
        BosClient client = this.getClient();
        String srcFileKey = this.getFileKey(srcFileInfo);
        try {
            srcFile = client.getObjectMetadata(this.bucketName, srcFileKey);
        }
        catch (Exception e) {
            throw ExceptionFactory.sameCopyNotFound(srcFileInfo, destFileInfo, this.platform, e);
        }
        String destThFileKey = null;
        if (StrUtil.isNotBlank((CharSequence)srcFileInfo.getThFilename())) {
            destThFileKey = this.getThFileKey(destFileInfo);
            destFileInfo.setThUrl(this.domain + destThFileKey);
            try {
                CopyObjectRequest request = new CopyObjectRequest(this.bucketName, this.getThFileKey(srcFileInfo), this.bucketName, destThFileKey);
                request.setNewObjectMetadata(this.getThObjectMetadata(destFileInfo));
                client.copyObject(request);
            }
            catch (Exception e) {
                throw ExceptionFactory.sameCopyTh(srcFileInfo, destFileInfo, this.platform, e);
            }
        }
        String destFileKey = this.getFileKey(destFileInfo);
        destFileInfo.setUrl(this.domain + destFileKey);
        long fileSize = srcFile.getContentLength();
        boolean useMultipartCopy = fileSize >= 0x40000000L;
        String uploadId = null;
        try {
            if (useMultipartCopy) {
                ObjectMetadata metadata = this.getObjectMetadata(destFileInfo);
                uploadId = client.initiateMultipartUpload(new InitiateMultipartUploadRequest(this.bucketName, destFileKey).withMetadata(metadata)).getUploadId();
                ProgressListener.quickStart(pre.getProgressListener(), fileSize);
                ArrayList<PartETag> partList = new ArrayList<PartETag>();
                long progressSize = 0L;
                int i = 1;
                while (progressSize < fileSize) {
                    long partSize = Math.min(0x10000000L, fileSize - progressSize);
                    UploadPartCopyRequest part = new UploadPartCopyRequest();
                    part.setBucketName(this.bucketName);
                    part.setKey(destFileKey);
                    part.setSourceBucketName(this.bucketName);
                    part.setSourceKey(srcFileKey);
                    part.setUploadId(uploadId);
                    part.setPartSize(partSize);
                    part.setOffSet(progressSize);
                    part.setPartNumber(i);
                    UploadPartCopyResponse partCopyResponse = client.uploadPartCopy(part);
                    partList.add(new PartETag(part.getPartNumber(), partCopyResponse.getETag()));
                    ProgressListener.quickProgress(pre.getProgressListener(), progressSize += partSize, fileSize);
                    ++i;
                }
                client.completeMultipartUpload(new CompleteMultipartUploadRequest(this.bucketName, destFileKey, uploadId, partList, metadata));
                ProgressListener.quickFinish(pre.getProgressListener());
            } else {
                ProgressListener.quickStart(pre.getProgressListener(), fileSize);
                CopyObjectRequest request = new CopyObjectRequest(this.bucketName, srcFileKey, this.bucketName, destFileKey);
                request.withNewObjectMetadata(this.getObjectMetadata(destFileInfo));
                client.copyObject(request);
                ProgressListener.quickFinish(pre.getProgressListener(), fileSize);
            }
        }
        catch (Exception e) {
            if (destThFileKey != null) {
                try {
                    client.deleteObject(this.bucketName, destThFileKey);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                if (useMultipartCopy) {
                    client.abortMultipartUpload(new AbortMultipartUploadRequest(this.bucketName, destFileKey, uploadId));
                } else {
                    client.deleteObject(this.bucketName, destFileKey);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw ExceptionFactory.sameCopy(srcFileInfo, destFileInfo, this.platform, e);
        }
    }

    @Override
    @Generated
    public String getPlatform() {
        return this.platform;
    }

    @Generated
    public String getBucketName() {
        return this.bucketName;
    }

    @Generated
    public String getDomain() {
        return this.domain;
    }

    @Generated
    public String getBasePath() {
        return this.basePath;
    }

    @Generated
    public String getDefaultAcl() {
        return this.defaultAcl;
    }

    @Generated
    public int getMultipartThreshold() {
        return this.multipartThreshold;
    }

    @Generated
    public int getMultipartPartSize() {
        return this.multipartPartSize;
    }

    @Generated
    public FileStorageClientFactory<BosClient> getClientFactory() {
        return this.clientFactory;
    }

    @Override
    @Generated
    public void setPlatform(String platform) {
        this.platform = platform;
    }

    @Generated
    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    @Generated
    public void setDomain(String domain) {
        this.domain = domain;
    }

    @Generated
    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    @Generated
    public void setDefaultAcl(String defaultAcl) {
        this.defaultAcl = defaultAcl;
    }

    @Generated
    public void setMultipartThreshold(int multipartThreshold) {
        this.multipartThreshold = multipartThreshold;
    }

    @Generated
    public void setMultipartPartSize(int multipartPartSize) {
        this.multipartPartSize = multipartPartSize;
    }

    @Generated
    public void setClientFactory(FileStorageClientFactory<BosClient> clientFactory) {
        this.clientFactory = clientFactory;
    }

    @Generated
    public BaiduBosFileStorage() {
    }
}

