/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.x.file.storage.core.platform;

import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.BlobServiceClientBuilder;
import com.azure.storage.file.datalake.DataLakeServiceClient;
import com.azure.storage.file.datalake.DataLakeServiceClientBuilder;
import lombok.Generated;
import org.dromara.x.file.storage.core.FileStorageProperties;
import org.dromara.x.file.storage.core.platform.FileStorageClientFactory;

public class AzureBlobStorageFileStorageClientFactory
implements FileStorageClientFactory<AzureBlobStorageClient> {
    private FileStorageProperties.AzureBlobStorageConfig config;
    private volatile AzureBlobStorageClient client;

    public AzureBlobStorageFileStorageClientFactory(FileStorageProperties.AzureBlobStorageConfig config) {
        this.config = config;
    }

    @Override
    public String getPlatform() {
        return this.config.getPlatform();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AzureBlobStorageClient getClient() {
        if (this.client == null) {
            AzureBlobStorageFileStorageClientFactory azureBlobStorageFileStorageClientFactory = this;
            synchronized (azureBlobStorageFileStorageClientFactory) {
                if (this.client == null) {
                    this.client = new AzureBlobStorageClient(this.config);
                }
            }
        }
        return this.client;
    }

    @Override
    public void close() {
        this.client = null;
    }

    @Generated
    public FileStorageProperties.AzureBlobStorageConfig getConfig() {
        return this.config;
    }

    @Generated
    public void setConfig(FileStorageProperties.AzureBlobStorageConfig config) {
        this.config = config;
    }

    @Generated
    public void setClient(AzureBlobStorageClient client) {
        this.client = client;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AzureBlobStorageFileStorageClientFactory)) {
            return false;
        }
        AzureBlobStorageFileStorageClientFactory other = (AzureBlobStorageFileStorageClientFactory)o;
        if (!other.canEqual(this)) {
            return false;
        }
        FileStorageProperties.AzureBlobStorageConfig this$config = this.getConfig();
        FileStorageProperties.AzureBlobStorageConfig other$config = other.getConfig();
        if (this$config == null ? other$config != null : !((Object)this$config).equals(other$config)) {
            return false;
        }
        AzureBlobStorageClient this$client = this.getClient();
        AzureBlobStorageClient other$client = other.getClient();
        return !(this$client == null ? other$client != null : !this$client.equals(other$client));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AzureBlobStorageFileStorageClientFactory;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        FileStorageProperties.AzureBlobStorageConfig $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : ((Object)$config).hashCode());
        AzureBlobStorageClient $client = this.getClient();
        result = result * 59 + ($client == null ? 43 : $client.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AzureBlobStorageFileStorageClientFactory(config=" + this.config + ", client=" + this.client + ")";
    }

    public static final class AzureBlobStorageClient {
        private FileStorageProperties.AzureBlobStorageConfig config;
        private volatile BlobServiceClient blobServiceClient;
        private volatile DataLakeServiceClient dataLakeServiceClient;

        public AzureBlobStorageClient(FileStorageProperties.AzureBlobStorageConfig config) {
            this.config = config;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public BlobServiceClient getBlobServiceClient() {
            if (this.blobServiceClient == null) {
                AzureBlobStorageClient azureBlobStorageClient = this;
                synchronized (azureBlobStorageClient) {
                    if (this.blobServiceClient == null) {
                        this.blobServiceClient = new BlobServiceClientBuilder().endpoint(this.config.getEndPoint()).connectionString(this.config.getConnectionString()).buildClient();
                    }
                }
            }
            return this.blobServiceClient;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DataLakeServiceClient getDataLakeServiceClient() {
            if (this.dataLakeServiceClient == null) {
                AzureBlobStorageClient azureBlobStorageClient = this;
                synchronized (azureBlobStorageClient) {
                    if (this.dataLakeServiceClient == null) {
                        this.dataLakeServiceClient = new DataLakeServiceClientBuilder().endpoint(this.config.getEndPoint()).connectionString(this.config.getConnectionString()).buildClient();
                    }
                }
            }
            return this.dataLakeServiceClient;
        }

        @Generated
        public FileStorageProperties.AzureBlobStorageConfig getConfig() {
            return this.config;
        }

        @Generated
        public void setConfig(FileStorageProperties.AzureBlobStorageConfig config) {
            this.config = config;
        }

        @Generated
        public void setBlobServiceClient(BlobServiceClient blobServiceClient) {
            this.blobServiceClient = blobServiceClient;
        }

        @Generated
        public void setDataLakeServiceClient(DataLakeServiceClient dataLakeServiceClient) {
            this.dataLakeServiceClient = dataLakeServiceClient;
        }
    }
}

