/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.x.file.storage.core.platform;

import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import lombok.Generated;
import org.dromara.x.file.storage.core.FileStorageProperties;
import org.dromara.x.file.storage.core.platform.FileStorageClientFactory;

public class AliyunOssFileStorageClientFactory
implements FileStorageClientFactory<OSS> {
    private String platform;
    private String accessKey;
    private String secretKey;
    private String endPoint;
    private volatile OSS client;

    public AliyunOssFileStorageClientFactory(FileStorageProperties.AliyunOssConfig config) {
        this.platform = config.getPlatform();
        this.accessKey = config.getAccessKey();
        this.secretKey = config.getSecretKey();
        this.endPoint = config.getEndPoint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OSS getClient() {
        if (this.client == null) {
            AliyunOssFileStorageClientFactory aliyunOssFileStorageClientFactory = this;
            synchronized (aliyunOssFileStorageClientFactory) {
                if (this.client == null) {
                    this.client = new OSSClientBuilder().build(this.endPoint, this.accessKey, this.secretKey);
                }
            }
        }
        return this.client;
    }

    @Override
    public void close() {
        if (this.client != null) {
            this.client.shutdown();
            this.client = null;
        }
    }

    @Override
    @Generated
    public String getPlatform() {
        return this.platform;
    }

    @Generated
    public String getAccessKey() {
        return this.accessKey;
    }

    @Generated
    public String getSecretKey() {
        return this.secretKey;
    }

    @Generated
    public String getEndPoint() {
        return this.endPoint;
    }

    @Generated
    public void setPlatform(String platform) {
        this.platform = platform;
    }

    @Generated
    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    @Generated
    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    @Generated
    public void setEndPoint(String endPoint) {
        this.endPoint = endPoint;
    }

    @Generated
    public void setClient(OSS client) {
        this.client = client;
    }

    @Generated
    public AliyunOssFileStorageClientFactory() {
    }
}

