/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.x.file.storage.core.move;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import lombok.Generated;
import org.dromara.x.file.storage.core.FileInfo;
import org.dromara.x.file.storage.core.FileStorageService;
import org.dromara.x.file.storage.core.ProgressListener;
import org.dromara.x.file.storage.core.constant.Constant;
import org.dromara.x.file.storage.core.move.MoveActuator;

public class MovePretreatment {
    private final FileStorageService fileStorageService;
    private final FileInfo fileInfo;
    private Constant.MoveMode moveMode = Constant.MoveMode.AUTO;
    private Constant.CopyMode copyMode = Constant.CopyMode.AUTO;
    private String platform;
    private String path;
    private String filename;
    private String thFilename;
    private ProgressListener progressListener;
    private Boolean notSupportMetadataThrowException = true;
    private Boolean notSupportAclThrowException = true;

    public MovePretreatment(FileInfo fileInfo, FileStorageService fileStorageService) {
        this.fileStorageService = fileStorageService;
        this.fileInfo = fileInfo;
        this.platform = fileInfo.getPlatform();
        this.path = fileInfo.getPath();
        this.filename = fileInfo.getFilename();
        this.thFilename = fileInfo.getThFilename();
    }

    public MovePretreatment setMoveMode(boolean flag, Constant.MoveMode moveMode) {
        if (flag) {
            this.moveMode = moveMode;
        }
        return this;
    }

    public MovePretreatment setCopyMode(boolean flag, Constant.CopyMode copyMode) {
        if (flag) {
            this.copyMode = copyMode;
        }
        return this;
    }

    public MovePretreatment setPlatform(boolean flag, String platform) {
        if (flag) {
            this.platform = platform;
        }
        return this;
    }

    public MovePretreatment setPath(boolean flag, String path) {
        if (flag) {
            this.path = path;
        }
        return this;
    }

    public MovePretreatment setFilename(boolean flag, String filename) {
        if (flag) {
            this.filename = filename;
        }
        return this;
    }

    public MovePretreatment setThFilename(boolean flag, String thFilename) {
        if (flag) {
            this.thFilename = thFilename;
        }
        return this;
    }

    public MovePretreatment setProgressListener(Consumer<Long> progressListener) {
        return this.setProgressListener((Long progressSize, Long allSize) -> progressListener.accept((Long)progressSize));
    }

    public MovePretreatment setProgressListener(boolean flag, Consumer<Long> progressListener) {
        if (flag) {
            this.setProgressListener((Long progressSize, Long allSize) -> progressListener.accept((Long)progressSize));
        }
        return this;
    }

    public MovePretreatment setProgressListener(final BiConsumer<Long, Long> progressListener) {
        return this.setProgressListener(new ProgressListener(){

            @Override
            public void start() {
            }

            @Override
            public void progress(long progressSize, Long allSize) {
                progressListener.accept(progressSize, allSize);
            }

            @Override
            public void finish() {
            }
        });
    }

    public MovePretreatment setProgressListener(boolean flag, BiConsumer<Long, Long> progressListener) {
        if (flag) {
            this.setProgressListener(progressListener);
        }
        return this;
    }

    public MovePretreatment setProgressListener(ProgressListener progressListener) {
        this.progressListener = progressListener;
        return this;
    }

    public MovePretreatment setProgressListener(boolean flag, ProgressListener progressListener) {
        if (flag) {
            this.progressListener = progressListener;
        }
        return this;
    }

    public MovePretreatment setNotSupportMetadataThrowException(boolean flag, Boolean notSupportMetadataThrowException) {
        if (flag) {
            this.notSupportMetadataThrowException = notSupportMetadataThrowException;
        }
        return this;
    }

    public MovePretreatment setNotSupportAclThrowException(boolean flag, Boolean notSupportAclThrowException) {
        if (flag) {
            this.notSupportAclThrowException = notSupportAclThrowException;
        }
        return this;
    }

    public FileInfo move() {
        return new MoveActuator(this).execute();
    }

    @Generated
    public FileStorageService getFileStorageService() {
        return this.fileStorageService;
    }

    @Generated
    public FileInfo getFileInfo() {
        return this.fileInfo;
    }

    @Generated
    public Constant.MoveMode getMoveMode() {
        return this.moveMode;
    }

    @Generated
    public Constant.CopyMode getCopyMode() {
        return this.copyMode;
    }

    @Generated
    public String getPlatform() {
        return this.platform;
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @Generated
    public String getFilename() {
        return this.filename;
    }

    @Generated
    public String getThFilename() {
        return this.thFilename;
    }

    @Generated
    public ProgressListener getProgressListener() {
        return this.progressListener;
    }

    @Generated
    public Boolean getNotSupportMetadataThrowException() {
        return this.notSupportMetadataThrowException;
    }

    @Generated
    public Boolean getNotSupportAclThrowException() {
        return this.notSupportAclThrowException;
    }

    @Generated
    public MovePretreatment setMoveMode(Constant.MoveMode moveMode) {
        this.moveMode = moveMode;
        return this;
    }

    @Generated
    public MovePretreatment setCopyMode(Constant.CopyMode copyMode) {
        this.copyMode = copyMode;
        return this;
    }

    @Generated
    public MovePretreatment setPlatform(String platform) {
        this.platform = platform;
        return this;
    }

    @Generated
    public MovePretreatment setPath(String path) {
        this.path = path;
        return this;
    }

    @Generated
    public MovePretreatment setFilename(String filename) {
        this.filename = filename;
        return this;
    }

    @Generated
    public MovePretreatment setThFilename(String thFilename) {
        this.thFilename = thFilename;
        return this;
    }

    @Generated
    public MovePretreatment setNotSupportMetadataThrowException(Boolean notSupportMetadataThrowException) {
        this.notSupportMetadataThrowException = notSupportMetadataThrowException;
        return this;
    }

    @Generated
    public MovePretreatment setNotSupportAclThrowException(Boolean notSupportAclThrowException) {
        this.notSupportAclThrowException = notSupportAclThrowException;
        return this;
    }
}

