/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.x.file.storage.core.move;

import cn.hutool.core.io.file.FileNameUtil;
import cn.hutool.core.lang.Dict;
import cn.hutool.core.util.StrUtil;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.dromara.x.file.storage.core.FileInfo;
import org.dromara.x.file.storage.core.FileStorageService;
import org.dromara.x.file.storage.core.aspect.FileStorageAspect;
import org.dromara.x.file.storage.core.aspect.MoveAspectChain;
import org.dromara.x.file.storage.core.aspect.SameMoveAspectChain;
import org.dromara.x.file.storage.core.constant.Constant;
import org.dromara.x.file.storage.core.exception.FileStorageRuntimeException;
import org.dromara.x.file.storage.core.hash.HashInfo;
import org.dromara.x.file.storage.core.move.MovePretreatment;
import org.dromara.x.file.storage.core.platform.FileStorage;
import org.dromara.x.file.storage.core.recorder.FileRecorder;

public class MoveActuator {
    private final FileStorageService fileStorageService;
    private final FileStorage fileStorage;
    private final FileInfo fileInfo;
    private final MovePretreatment pre;

    public MoveActuator(MovePretreatment pre) {
        this.pre = pre;
        this.fileStorageService = pre.getFileStorageService();
        this.fileInfo = pre.getFileInfo();
        this.fileStorage = this.fileStorageService.getFileStorageVerify(this.fileInfo.getPlatform());
    }

    public FileInfo execute() {
        if (this.fileInfo == null) {
            throw new FileStorageRuntimeException("fileInfo \u4e0d\u80fd\u4e3a null");
        }
        if (this.fileInfo.getPlatform() == null) {
            throw new FileStorageRuntimeException("fileInfo \u7684 platform \u4e0d\u80fd\u4e3a null");
        }
        if (this.fileInfo.getPath() == null) {
            throw new FileStorageRuntimeException("fileInfo \u7684 path \u4e0d\u80fd\u4e3a null");
        }
        if (StrUtil.isBlank((CharSequence)this.fileInfo.getFilename())) {
            throw new FileStorageRuntimeException("fileInfo \u7684 filename \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StrUtil.isNotBlank((CharSequence)this.fileInfo.getThFilename()) && StrUtil.isBlank((CharSequence)this.pre.getThFilename())) {
            throw new FileStorageRuntimeException("\u76ee\u6807\u7f29\u7565\u56fe\u6587\u4ef6\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CopyOnWriteArrayList<FileStorageAspect> aspectList = this.fileStorageService.getAspectList();
        FileRecorder fileRecorder = this.fileStorageService.getFileRecorder();
        return new MoveAspectChain(aspectList, (_srcFileInfo, _pre, _fileStorage, _fileRecorder) -> {
            FileInfo destFileInfo = this.isSameMove(_srcFileInfo, _pre, _fileStorage) ? this.sameMove(_srcFileInfo, _pre, _fileStorage, _fileRecorder, aspectList) : this.crossMove(_srcFileInfo, _pre, _fileStorage, _fileRecorder, aspectList);
            return destFileInfo;
        }).next(this.fileInfo, this.pre, this.fileStorage, fileRecorder);
    }

    protected boolean isSameMove(FileInfo srcFileInfo, MovePretreatment pre, FileStorage fileStorage) {
        Constant.MoveMode moveMode = pre.getMoveMode();
        if (moveMode == Constant.MoveMode.SAME) {
            if (!this.fileStorageService.isSupportSameMove(fileStorage)) {
                throw new FileStorageRuntimeException("\u5b58\u50a8\u5e73\u53f0\u3010" + fileStorage.getPlatform() + "\u3011\u4e0d\u652f\u6301\u540c\u5b58\u50a8\u5e73\u53f0\u79fb\u52a8");
            }
            return true;
        }
        if (moveMode == Constant.MoveMode.CROSS) {
            return false;
        }
        return srcFileInfo.getPlatform().equals(pre.getPlatform()) && this.fileStorageService.isSupportSameMove(fileStorage);
    }

    protected FileInfo sameMove(FileInfo srcFileInfo, MovePretreatment pre, FileStorage fileStorage, FileRecorder fileRecorder, List<FileStorageAspect> aspectList) {
        if ((srcFileInfo.getPath() + srcFileInfo.getFilename()).equals(pre.getPath() + pre.getFilename())) {
            throw new FileStorageRuntimeException("\u6e90\u6587\u4ef6\u4e0e\u76ee\u6807\u6587\u4ef6\u8def\u5f84\u76f8\u540c");
        }
        if (StrUtil.isNotBlank((CharSequence)srcFileInfo.getThFilename()) && (srcFileInfo.getPath() + srcFileInfo.getThFilename()).equals(pre.getPath() + pre.getThFilename())) {
            throw new FileStorageRuntimeException("\u6e90\u7f29\u7565\u56fe\u6587\u4ef6\u4e0e\u76ee\u6807\u7f29\u7565\u56fe\u6587\u4ef6\u8def\u5f84\u76f8\u540c");
        }
        FileInfo destFileInfo = new FileInfo();
        destFileInfo.setSize(srcFileInfo.getSize());
        destFileInfo.setFilename(pre.getFilename());
        destFileInfo.setOriginalFilename(srcFileInfo.getOriginalFilename());
        destFileInfo.setBasePath(srcFileInfo.getBasePath());
        destFileInfo.setPath(pre.getPath());
        destFileInfo.setExt(FileNameUtil.extName((String)pre.getFilename()));
        destFileInfo.setContentType(srcFileInfo.getContentType());
        destFileInfo.setPlatform(pre.getPlatform());
        destFileInfo.setThFilename(pre.getThFilename());
        destFileInfo.setThSize(srcFileInfo.getThSize());
        destFileInfo.setThContentType(srcFileInfo.getThContentType());
        destFileInfo.setObjectId(srcFileInfo.getObjectId());
        destFileInfo.setObjectType(srcFileInfo.getObjectType());
        if (srcFileInfo.getMetadata() != null) {
            destFileInfo.setMetadata(new LinkedHashMap<String, String>(srcFileInfo.getMetadata()));
        }
        if (srcFileInfo.getUserMetadata() != null) {
            destFileInfo.setUserMetadata(new LinkedHashMap<String, String>(srcFileInfo.getUserMetadata()));
        }
        if (srcFileInfo.getThMetadata() != null) {
            destFileInfo.setThMetadata(new LinkedHashMap<String, String>(srcFileInfo.getThMetadata()));
        }
        if (srcFileInfo.getThUserMetadata() != null) {
            destFileInfo.setThUserMetadata(new LinkedHashMap<String, String>(srcFileInfo.getThUserMetadata()));
        }
        if (srcFileInfo.getAttr() != null) {
            destFileInfo.setAttr(new Dict((Map)srcFileInfo.getAttr()));
        }
        if (srcFileInfo.getHashInfo() != null) {
            destFileInfo.setHashInfo(new HashInfo((Map<String, String>)((Object)srcFileInfo.getHashInfo())));
        }
        destFileInfo.setFileAcl(srcFileInfo.getFileAcl());
        destFileInfo.setThFileAcl(srcFileInfo.getThFileAcl());
        destFileInfo.setCreateTime(new Date());
        return new SameMoveAspectChain(aspectList, (_srcFileInfo, _destFileInfo, _pre, _fileStorage, _fileRecorder) -> {
            _fileStorage.sameMove(_srcFileInfo, _destFileInfo, _pre);
            _fileRecorder.save(_destFileInfo);
            if (!this.fileStorageService.delete(_srcFileInfo, _fileStorage, _fileRecorder, aspectList)) {
                throw new FileStorageRuntimeException("\u79fb\u52a8\u6587\u4ef6\u5931\u8d25\uff0c\u6e90\u6587\u4ef6\u5220\u9664\u5931\u8d25");
            }
            return _destFileInfo;
        }).next(srcFileInfo, destFileInfo, pre, fileStorage, fileRecorder);
    }

    protected FileInfo crossMove(FileInfo srcFileInfo, MovePretreatment pre, FileStorage fileStorage, FileRecorder fileRecorder, List<FileStorageAspect> aspectList) {
        FileInfo destFileInfo = this.fileStorageService.copy(srcFileInfo).setCopyMode(pre.getCopyMode()).setPlatform(pre.getPlatform()).setPath(pre.getPath()).setFilename(pre.getFilename()).setThFilename(pre.getThFilename()).setProgressListener(pre.getProgressListener()).setNotSupportMetadataThrowException(pre.getNotSupportMetadataThrowException() == false, pre.getNotSupportMetadataThrowException()).setNotSupportAclThrowException(pre.getNotSupportAclThrowException() == false, pre.getNotSupportAclThrowException()).copy(fileStorage, fileRecorder, aspectList);
        if (destFileInfo == null) {
            throw new FileStorageRuntimeException("\u79fb\u52a8\u6587\u4ef6\u5931\u8d25\uff0c\u6e90\u6587\u4ef6\u590d\u5236\u5931\u8d25");
        }
        if (!this.fileStorageService.delete(srcFileInfo, fileStorage, fileRecorder, aspectList)) {
            throw new FileStorageRuntimeException("\u79fb\u52a8\u6587\u4ef6\u5931\u8d25\uff0c\u6e90\u6587\u4ef6\u5220\u9664\u5931\u8d25");
        }
        return destFileInfo;
    }
}

