/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.x.file.storage.core.hash;

import cn.hutool.core.util.StrUtil;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import lombok.Generated;
import org.dromara.x.file.storage.core.exception.FileStorageRuntimeException;
import org.dromara.x.file.storage.core.hash.HashCalculator;
import org.dromara.x.file.storage.core.hash.HashCalculatorSetter;
import org.dromara.x.file.storage.core.hash.HashInfo;

public class HashCalculatorManager
implements HashCalculatorSetter<HashCalculatorManager> {
    private final List<HashCalculator> hashCalculatorList = new CopyOnWriteArrayList<HashCalculator>();
    private volatile HashInfo hashInfo;

    @Override
    public HashCalculatorManager setHashCalculator(HashCalculator hashCalculator) {
        this.hashCalculatorList.add(hashCalculator);
        return this;
    }

    public HashCalculatorManager update(byte[] bytes) {
        if (this.hashInfo != null) {
            throw new FileStorageRuntimeException(StrUtil.format((CharSequence)"\u5f53\u524d HashCalculatorManager \u5df2\u8c03\u7528 getHashInfo() \u65b9\u6cd5\u83b7\u53d6\u4e86\u54c8\u5e0c\u4fe1\u606f\uff0c\u65e0\u6cd5\u518d\u6b21\u8fdb\u884c\u589e\u91cf\u8ba1\u7b97", (Object[])new Object[0]));
        }
        for (HashCalculator hashCalculator : this.hashCalculatorList) {
            hashCalculator.update(bytes);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashInfo getHashInfo() {
        if (this.hashInfo == null) {
            HashCalculatorManager hashCalculatorManager = this;
            synchronized (hashCalculatorManager) {
                if (this.hashInfo == null) {
                    this.hashInfo = new HashInfo();
                    for (HashCalculator hashCalculator : this.hashCalculatorList) {
                        this.hashInfo.put(hashCalculator.getName(), hashCalculator.getValue());
                    }
                }
            }
        }
        return this.hashInfo;
    }

    @Generated
    public List<HashCalculator> getHashCalculatorList() {
        return this.hashCalculatorList;
    }
}

