/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.x.file.storage.core.get;

import cn.hutool.core.map.MapProxy;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.OSSObjectSummary;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.azure.storage.blob.implementation.models.BlobItemInternal;
import com.azure.storage.blob.models.BlobProperties;
import com.baidubce.services.bos.model.BosObject;
import com.baidubce.services.bos.model.BosObjectSummary;
import com.github.sardine.DavResource;
import com.google.cloud.storage.Blob;
import com.jcraft.jsch.ChannelSftp;
import com.obs.services.model.ObsObject;
import com.qcloud.cos.model.COSObject;
import com.qcloud.cos.model.COSObjectSummary;
import io.minio.StatObjectResponse;
import io.minio.messages.Contents;
import java.io.File;
import java.util.Date;
import java.util.Map;
import lombok.Generated;
import okhttp3.Response;
import org.apache.commons.net.ftp.FTPFile;
import org.dromara.x.file.storage.core.FileInfo;
import org.dromara.x.file.storage.core.platform.FastDfsFileStorage;
import org.dromara.x.file.storage.core.util.KebabCaseInsensitiveMap;
import org.dromara.x.file.storage.core.util.Tools;
import org.json.JSONObject;

public class RemoteFileInfo {
    private String platform;
    private String basePath;
    private String path;
    private String filename;
    private String url;
    private Long size;
    private String ext;
    private String eTag;
    private String contentDisposition;
    private String contentType;
    private String contentMd5;
    private Date lastModified;
    private Map<String, Object> metadata;
    private Map<String, Object> userMetadata;
    private Object original;

    public MapProxy getKebabCaseInsensitiveMetadata() {
        if (this.metadata == null) {
            return null;
        }
        return new MapProxy(new KebabCaseInsensitiveMap<String, Object>(this.metadata));
    }

    public MapProxy getKebabCaseInsensitiveUserMetadata() {
        if (this.userMetadata == null) {
            return null;
        }
        return new MapProxy(new KebabCaseInsensitiveMap<String, Object>(this.userMetadata));
    }

    public <T> T getOriginal(Class<T> clazz) {
        if (this.original == null) {
            return null;
        }
        if (clazz.isInstance(this.original)) {
            return Tools.cast(this.original);
        }
        return null;
    }

    public OSSObject getOriginalAliyunOssObject() {
        return this.getOriginal(OSSObject.class);
    }

    public OSSObjectSummary getOriginalAliyunOssObjectSummary() {
        return this.getOriginal(OSSObjectSummary.class);
    }

    public S3Object getOriginalAmazonS3Object() {
        return this.getOriginal(S3Object.class);
    }

    public S3ObjectSummary getOriginalAmazonS3ObjectSummary() {
        return this.getOriginal(S3ObjectSummary.class);
    }

    public BlobProperties getOriginalAzureBlobStorageBlobProperties() {
        return this.getOriginal(BlobProperties.class);
    }

    public BlobItemInternal getOriginalAzureBlobStorageBlobItemInternal() {
        return this.getOriginal(BlobItemInternal.class);
    }

    public BosObject getOriginalBaiduBosObject() {
        return this.getOriginal(BosObject.class);
    }

    public BosObjectSummary getOriginalBaiduBosObjectSummary() {
        return this.getOriginal(BosObjectSummary.class);
    }

    public FastDfsFileStorage.FastDfsFileInfo getOriginalFastDfs() {
        return this.getOriginal(FastDfsFileStorage.FastDfsFileInfo.class);
    }

    public FTPFile getOriginalFtp() {
        return this.getOriginal(FTPFile.class);
    }

    public Blob getOriginalGoogleCloudStorage() {
        return this.getOriginal(Blob.class);
    }

    public ObsObject getOriginalHuaweiObs() {
        return this.getOriginal(ObsObject.class);
    }

    public File getOriginalLocal() {
        return this.getOriginal(File.class);
    }

    public StatObjectResponse getOriginalMinioStatObjectResponse() {
        return this.getOriginal(StatObjectResponse.class);
    }

    public Contents getOriginalMinioContents() {
        return this.getOriginal(Contents.class);
    }

    public com.qiniu.storage.model.FileInfo getOriginalQiniuKodo() {
        return this.getOriginal(com.qiniu.storage.model.FileInfo.class);
    }

    public ChannelSftp.LsEntry getOriginalSftp() {
        return this.getOriginal(ChannelSftp.LsEntry.class);
    }

    public COSObject getOriginalTencentCosObject() {
        return this.getOriginal(COSObject.class);
    }

    public COSObjectSummary getOriginalTencentCosObjectSummary() {
        return this.getOriginal(COSObjectSummary.class);
    }

    public Response getOriginalUpyunUssResponse() {
        return this.getOriginal(Response.class);
    }

    public JSONObject getOriginalUpyunUssJSONObject() {
        return this.getOriginal(JSONObject.class);
    }

    public DavResource getOriginalWebDav() {
        return this.getOriginal(DavResource.class);
    }

    public FileInfo toFileInfo() {
        return this.toFileInfo(new FileInfo());
    }

    public FileInfo toFileInfo(FileInfo fileInfo) {
        fileInfo.setPlatform(this.platform).setBasePath(this.basePath).setPath(this.path).setFilename(this.filename);
        fileInfo.setUrl(this.url).setSize(this.size).setExt(this.ext).setContentType(this.contentType);
        fileInfo.setCreateTime(this.lastModified);
        fileInfo.setMetadata(Tools.toStringMap(this.metadata));
        fileInfo.setUserMetadata(Tools.toStringMap(this.userMetadata));
        return fileInfo;
    }

    public FileInfo toFileInfoTh() {
        return this.toFileInfo(new FileInfo());
    }

    public FileInfo toFileInfoTh(FileInfo fileInfo) {
        fileInfo.setThFilename(this.filename).setThUrl(this.url).setThSize(this.size).setThContentType(this.contentType);
        fileInfo.setThMetadata(Tools.toStringMap(this.metadata));
        fileInfo.setThUserMetadata(Tools.toStringMap(this.userMetadata));
        return fileInfo;
    }

    public FileInfo toFileInfoThAll() {
        return this.toFileInfoThAll(new FileInfo());
    }

    public FileInfo toFileInfoThAll(FileInfo fileInfo) {
        return this.toFileInfoTh(fileInfo).setPlatform(this.platform).setBasePath(this.basePath).setPath(this.path);
    }

    @Generated
    public String getPlatform() {
        return this.platform;
    }

    @Generated
    public String getBasePath() {
        return this.basePath;
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @Generated
    public String getFilename() {
        return this.filename;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public Long getSize() {
        return this.size;
    }

    @Generated
    public String getExt() {
        return this.ext;
    }

    @Generated
    public String getETag() {
        return this.eTag;
    }

    @Generated
    public String getContentDisposition() {
        return this.contentDisposition;
    }

    @Generated
    public String getContentType() {
        return this.contentType;
    }

    @Generated
    public String getContentMd5() {
        return this.contentMd5;
    }

    @Generated
    public Date getLastModified() {
        return this.lastModified;
    }

    @Generated
    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    @Generated
    public Map<String, Object> getUserMetadata() {
        return this.userMetadata;
    }

    @Generated
    public Object getOriginal() {
        return this.original;
    }

    @Generated
    public RemoteFileInfo setPlatform(String platform) {
        this.platform = platform;
        return this;
    }

    @Generated
    public RemoteFileInfo setBasePath(String basePath) {
        this.basePath = basePath;
        return this;
    }

    @Generated
    public RemoteFileInfo setPath(String path) {
        this.path = path;
        return this;
    }

    @Generated
    public RemoteFileInfo setFilename(String filename) {
        this.filename = filename;
        return this;
    }

    @Generated
    public RemoteFileInfo setUrl(String url) {
        this.url = url;
        return this;
    }

    @Generated
    public RemoteFileInfo setSize(Long size) {
        this.size = size;
        return this;
    }

    @Generated
    public RemoteFileInfo setExt(String ext) {
        this.ext = ext;
        return this;
    }

    @Generated
    public RemoteFileInfo setETag(String eTag) {
        this.eTag = eTag;
        return this;
    }

    @Generated
    public RemoteFileInfo setContentDisposition(String contentDisposition) {
        this.contentDisposition = contentDisposition;
        return this;
    }

    @Generated
    public RemoteFileInfo setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    @Generated
    public RemoteFileInfo setContentMd5(String contentMd5) {
        this.contentMd5 = contentMd5;
        return this;
    }

    @Generated
    public RemoteFileInfo setLastModified(Date lastModified) {
        this.lastModified = lastModified;
        return this;
    }

    @Generated
    public RemoteFileInfo setMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
        return this;
    }

    @Generated
    public RemoteFileInfo setUserMetadata(Map<String, Object> userMetadata) {
        this.userMetadata = userMetadata;
        return this;
    }

    @Generated
    public RemoteFileInfo setOriginal(Object original) {
        this.original = original;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoteFileInfo)) {
            return false;
        }
        RemoteFileInfo other = (RemoteFileInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$size = this.getSize();
        Long other$size = other.getSize();
        if (this$size == null ? other$size != null : !((Object)this$size).equals(other$size)) {
            return false;
        }
        String this$platform = this.getPlatform();
        String other$platform = other.getPlatform();
        if (this$platform == null ? other$platform != null : !this$platform.equals(other$platform)) {
            return false;
        }
        String this$basePath = this.getBasePath();
        String other$basePath = other.getBasePath();
        if (this$basePath == null ? other$basePath != null : !this$basePath.equals(other$basePath)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        String this$filename = this.getFilename();
        String other$filename = other.getFilename();
        if (this$filename == null ? other$filename != null : !this$filename.equals(other$filename)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$ext = this.getExt();
        String other$ext = other.getExt();
        if (this$ext == null ? other$ext != null : !this$ext.equals(other$ext)) {
            return false;
        }
        String this$eTag = this.getETag();
        String other$eTag = other.getETag();
        if (this$eTag == null ? other$eTag != null : !this$eTag.equals(other$eTag)) {
            return false;
        }
        String this$contentDisposition = this.getContentDisposition();
        String other$contentDisposition = other.getContentDisposition();
        if (this$contentDisposition == null ? other$contentDisposition != null : !this$contentDisposition.equals(other$contentDisposition)) {
            return false;
        }
        String this$contentType = this.getContentType();
        String other$contentType = other.getContentType();
        if (this$contentType == null ? other$contentType != null : !this$contentType.equals(other$contentType)) {
            return false;
        }
        String this$contentMd5 = this.getContentMd5();
        String other$contentMd5 = other.getContentMd5();
        if (this$contentMd5 == null ? other$contentMd5 != null : !this$contentMd5.equals(other$contentMd5)) {
            return false;
        }
        Date this$lastModified = this.getLastModified();
        Date other$lastModified = other.getLastModified();
        if (this$lastModified == null ? other$lastModified != null : !((Object)this$lastModified).equals(other$lastModified)) {
            return false;
        }
        Map<String, Object> this$metadata = this.getMetadata();
        Map<String, Object> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        Map<String, Object> this$userMetadata = this.getUserMetadata();
        Map<String, Object> other$userMetadata = other.getUserMetadata();
        if (this$userMetadata == null ? other$userMetadata != null : !((Object)this$userMetadata).equals(other$userMetadata)) {
            return false;
        }
        Object this$original = this.getOriginal();
        Object other$original = other.getOriginal();
        return !(this$original == null ? other$original != null : !this$original.equals(other$original));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RemoteFileInfo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $size = this.getSize();
        result = result * 59 + ($size == null ? 43 : ((Object)$size).hashCode());
        String $platform = this.getPlatform();
        result = result * 59 + ($platform == null ? 43 : $platform.hashCode());
        String $basePath = this.getBasePath();
        result = result * 59 + ($basePath == null ? 43 : $basePath.hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        String $filename = this.getFilename();
        result = result * 59 + ($filename == null ? 43 : $filename.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $ext = this.getExt();
        result = result * 59 + ($ext == null ? 43 : $ext.hashCode());
        String $eTag = this.getETag();
        result = result * 59 + ($eTag == null ? 43 : $eTag.hashCode());
        String $contentDisposition = this.getContentDisposition();
        result = result * 59 + ($contentDisposition == null ? 43 : $contentDisposition.hashCode());
        String $contentType = this.getContentType();
        result = result * 59 + ($contentType == null ? 43 : $contentType.hashCode());
        String $contentMd5 = this.getContentMd5();
        result = result * 59 + ($contentMd5 == null ? 43 : $contentMd5.hashCode());
        Date $lastModified = this.getLastModified();
        result = result * 59 + ($lastModified == null ? 43 : ((Object)$lastModified).hashCode());
        Map<String, Object> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        Map<String, Object> $userMetadata = this.getUserMetadata();
        result = result * 59 + ($userMetadata == null ? 43 : ((Object)$userMetadata).hashCode());
        Object $original = this.getOriginal();
        result = result * 59 + ($original == null ? 43 : $original.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RemoteFileInfo(platform=" + this.platform + ", basePath=" + this.basePath + ", path=" + this.path + ", filename=" + this.filename + ", url=" + this.url + ", size=" + this.size + ", ext=" + this.ext + ", eTag=" + this.eTag + ", contentDisposition=" + this.contentDisposition + ", contentType=" + this.contentType + ", contentMd5=" + this.contentMd5 + ", lastModified=" + this.lastModified + ", metadata=" + this.metadata + ", userMetadata=" + this.userMetadata + ", original=" + this.original + ")";
    }

    @Generated
    public RemoteFileInfo() {
    }
}

