/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.x.file.storage.core.file;

import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.ReUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import lombok.Generated;
import org.dromara.x.file.storage.core.file.FileWrapper;
import org.dromara.x.file.storage.core.file.FileWrapperAdapter;
import org.dromara.x.file.storage.core.file.UriFileWrapper;
import org.dromara.x.file.storage.core.tika.ContentTypeDetect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UriFileWrapperAdapter
implements FileWrapperAdapter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UriFileWrapperAdapter.class);
    private ContentTypeDetect contentTypeDetect;

    @Override
    public boolean isSupport(Object source) {
        if (source instanceof UriFileWrapper) {
            return true;
        }
        if (source instanceof URL) {
            return true;
        }
        if (source instanceof URI) {
            return true;
        }
        if (source instanceof String) {
            try {
                URLUtil.url((String)((String)source));
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public FileWrapper getFileWrapper(Object source, String name, String contentType, Long size) throws IOException {
        if (source instanceof UriFileWrapper) {
            return this.updateFileWrapper((UriFileWrapper)source, name, contentType, size);
        }
        URL url = source instanceof URI ? ((URI)source).toURL() : (source instanceof String ? URLUtil.url((String)((String)source)) : (URL)source);
        URLConnection conn = url.openConnection();
        InputStream inputStream = IoUtil.toMarkSupportStream((InputStream)conn.getInputStream());
        if (name == null) {
            name = this.getName(conn, url);
        }
        if (size == null && (size = Long.valueOf(conn.getContentLengthLong())) < 0L) {
            size = null;
        }
        UriFileWrapper wrapper = new UriFileWrapper(inputStream, name, contentType, size);
        if (contentType == null) {
            wrapper.getInputStreamMaskReset(in -> wrapper.setContentType(this.contentTypeDetect.detect((InputStream)in, wrapper.getName())));
        }
        return wrapper;
    }

    public String getName(URLConnection conn, URL url) {
        String path;
        String name = "";
        String disposition = conn.getHeaderField("Content-Disposition");
        if (StrUtil.isNotBlank((CharSequence)disposition) && StrUtil.isBlank((CharSequence)(name = ReUtil.get((String)"filename=\"(.*?)\"", (CharSequence)disposition, (int)1)))) {
            name = StrUtil.subAfter((CharSequence)disposition, (CharSequence)"filename=", (boolean)true);
        }
        if (StrUtil.isBlank((CharSequence)name) && StrUtil.isNotBlank((CharSequence)(name = StrUtil.subSuf((CharSequence)(path = url.getPath()), (int)(path.lastIndexOf(47) + 1))))) {
            name = URLUtil.decode((String)name, (Charset)StandardCharsets.UTF_8);
        }
        return name;
    }

    @Generated
    public ContentTypeDetect getContentTypeDetect() {
        return this.contentTypeDetect;
    }

    @Generated
    public void setContentTypeDetect(ContentTypeDetect contentTypeDetect) {
        this.contentTypeDetect = contentTypeDetect;
    }

    @Generated
    public UriFileWrapperAdapter() {
    }

    @Generated
    public UriFileWrapperAdapter(ContentTypeDetect contentTypeDetect) {
        this.contentTypeDetect = contentTypeDetect;
    }
}

