/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.x.file.storage.core.file;

import cn.hutool.core.io.IoUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.dromara.x.file.storage.core.exception.FileStorageRuntimeException;

public class MultipartFormDataReader {
    public static int BUFFER_LENGTH = 131072;

    public static MultipartFormData read(String contentType, InputStream inputStream, Charset charset, Long contentLength) throws IOException {
        String boundary = Boundary.getBoundary(contentType);
        if (boundary == null) {
            throw new FileStorageRuntimeException("HttpServletRequest \u7684 ContentType \u4e2d\u672a\u8bfb\u53d6\u5230 boundary \u53c2\u6570\uff01");
        }
        MultipartFormData data = new MultipartFormData();
        data.inputStream = IoUtil.toMarkSupportStream((InputStream)inputStream);
        data.charset = charset;
        data.contentLength = contentLength;
        MultipartFormData.access$302(data, new byte[BUFFER_LENGTH]);
        data.parameterMap = new LinkedHashMap();
        do {
            data.boundary = Boundary.create(MultipartFormDataReader.readLineBytes(data), boundary, charset);
        } while (data.boundary == null);
        while (MultipartFormDataReader.readPart(data) != 3) {
        }
        return data;
    }

    public static int readPart(MultipartFormData data) throws IOException {
        String[] stringArray;
        String line;
        HashMap<String, String> headerMap = new HashMap<String, String>();
        while (!StrUtil.isBlank((CharSequence)(line = new String(MultipartFormDataReader.readLineBytes(data), data.charset)))) {
            int splitIndex = line.indexOf(": ");
            if (splitIndex < 0) {
                headerMap.put(line.trim().toLowerCase(), "");
                continue;
            }
            String name = line.substring(0, splitIndex).trim().toLowerCase();
            String value = line.substring(splitIndex + 1).trim();
            headerMap.put(name, value);
        }
        String disposition = (String)headerMap.get("content-disposition");
        if (StrUtil.isEmpty((CharSequence)disposition)) {
            throw new FileStorageRuntimeException("HttpServletRequest \u7684 Part \u65e0\u6cd5\u8bc6\u522b content-disposition");
        }
        LinkedHashMap<String, String> dispositionMap = MultipartFormDataReader.convertPartHeaderValue(disposition);
        MultipartFormDataPartInputStream pin = new MultipartFormDataPartInputStream(data);
        if (dispositionMap.containsKey("filename")) {
            if ("true".equals(data.getParameter("_hasTh")) && data.thFileBytes == null) {
                data.thFileContentType = (String)headerMap.get("content-type");
                MultipartFormData.access$602(data, IoUtil.readBytes((InputStream)pin));
                data.thFileOriginalFilename = dispositionMap.get("filename");
                return 2;
            }
            data.fileContentType = (String)headerMap.get("content-type");
            data.fileInputStream = pin;
            data.fileOriginalFilename = dispositionMap.get("filename");
            String fileSize = data.getParameter("_fileSize");
            if (StrUtil.isNotBlank((CharSequence)fileSize)) {
                data.fileSize = Long.parseLong(fileSize);
            } else {
                data.fileSize = data.contentLength - data.totalReadLength - (long)data.boundary.footerByteLength;
            }
            return 3;
        }
        String name = dispositionMap.get("name");
        String value = IoUtil.read((InputStream)pin, (Charset)data.charset);
        Object[] values = (String[])data.parameterMap.get(name);
        if (values == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = value;
        } else {
            stringArray = (String[])ArrayUtil.append((Object[])values, (Object[])new String[]{value});
        }
        values = stringArray;
        data.parameterMap.put(name, values);
        return 1;
    }

    public static LinkedHashMap<String, String> convertPartHeaderValue(String text) {
        return Arrays.stream(text.split(";")).map(String::trim).filter(CharSequenceUtil::isNotBlank).map(v -> {
            String value;
            String name;
            int splitIndex = v.indexOf("=");
            if (splitIndex < 0) {
                name = v.trim().toLowerCase();
                value = "";
            } else {
                name = v.substring(0, splitIndex).trim().toLowerCase();
                value = v.substring(splitIndex + 1).trim();
                if (value.length() > 1 && value.startsWith("\"") && value.endsWith("\"")) {
                    value = value.substring(1, value.length() - 1);
                }
            }
            return new String[]{name, value};
        }).collect(Collectors.toMap(v -> v[0], v -> v[1], (o, n) -> n, LinkedHashMap::new));
    }

    public static byte[] readLineBytes(MultipartFormData data) throws IOException {
        int readLength = MultipartFormDataReader.readLine(data.inputStream, data.buffer, 0, data.buffer.length);
        if (readLength == -1) {
            throw new FileStorageRuntimeException("HttpServletRequest \u89e3\u6790\u5931\u8d25\uff0c\u5c1a\u672a\u53d1\u73b0\u6587\u4ef6");
        }
        data.totalReadLength += readLength;
        if (readLength == data.buffer.length) {
            throw new FileStorageRuntimeException("HttpServletRequest \u89e3\u6790\u5931\u8d25\uff0c\u53c2\u6570\u8d85\u8fc7\u7f13\u51b2\u533a\u5927\u5c0f");
        }
        return Arrays.copyOfRange(data.buffer, 0, readLength);
    }

    public static int readLine(InputStream in, byte[] b, int off, int len) throws IOException {
        int c;
        if (len <= 0) {
            return 0;
        }
        int count = 0;
        while ((c = in.read()) != -1) {
            b[off++] = (byte)c;
            if (c != 10 && ++count != len) continue;
        }
        return count > 0 ? count : -1;
    }

    public static class Boundary {
        private String boundary;
        private String line;
        private byte[] lineBytes;
        private byte[] endLineBytes;
        private String endLine;
        private int footerByteLength;
        private String lineEndFlag;
        private byte[] lineEndFlagBytes;

        public static Boundary create(byte[] bytes, String boundary, Charset charset) {
            String line = new String(bytes, charset);
            if (!line.contains(boundary)) {
                return null;
            }
            Boundary instance = new Boundary();
            instance.boundary = boundary;
            instance.line = line;
            instance.lineBytes = bytes;
            instance.lineEndFlag = line.endsWith("\r\n") ? "\r\n" : "\n";
            instance.lineEndFlagBytes = instance.lineEndFlag.getBytes(charset);
            instance.endLine = line.substring(0, line.length() - instance.lineEndFlag.length()) + "--" + instance.lineEndFlag;
            instance.endLineBytes = instance.endLine.getBytes(charset);
            instance.footerByteLength = (instance.endLine + instance.lineEndFlag).getBytes(charset).length;
            return instance;
        }

        public static String getBoundary(String contentType) {
            if (contentType == null) {
                return null;
            }
            int begin = contentType.indexOf("boundary=");
            if (begin < 0) {
                return null;
            }
            int end = contentType.indexOf(";", begin);
            if (end < 0) {
                end = contentType.length();
            }
            return contentType.substring(begin += "boundary=".length(), end).trim();
        }

        @Generated
        public String getBoundary() {
            return this.boundary;
        }

        @Generated
        public String getLine() {
            return this.line;
        }

        @Generated
        public byte[] getLineBytes() {
            return this.lineBytes;
        }

        @Generated
        public byte[] getEndLineBytes() {
            return this.endLineBytes;
        }

        @Generated
        public String getEndLine() {
            return this.endLine;
        }

        @Generated
        public int getFooterByteLength() {
            return this.footerByteLength;
        }

        @Generated
        public String getLineEndFlag() {
            return this.lineEndFlag;
        }

        @Generated
        public byte[] getLineEndFlagBytes() {
            return this.lineEndFlagBytes;
        }
    }

    public static class MultipartFormData {
        private InputStream inputStream;
        private Boundary boundary;
        private Charset charset;
        private Long contentLength;
        private byte[] buffer;
        private long totalReadLength = 0L;
        private Map<String, String[]> parameterMap;
        private byte[] thFileBytes;
        private String thFileContentType;
        private String thFileOriginalFilename;
        private InputStream fileInputStream;
        private String fileContentType;
        private String fileOriginalFilename;
        private Long fileSize;

        public String getParameter(String name) {
            if (this.parameterMap == null) {
                return null;
            }
            String[] values = this.parameterMap.get(name);
            if (values == null || values.length == 0) {
                return null;
            }
            return values[0];
        }

        public String[] getParameterValues(String name) {
            if (this.parameterMap == null) {
                return null;
            }
            return this.parameterMap.get(name);
        }

        @Generated
        public InputStream getInputStream() {
            return this.inputStream;
        }

        @Generated
        public Boundary getBoundary() {
            return this.boundary;
        }

        @Generated
        public Charset getCharset() {
            return this.charset;
        }

        @Generated
        public Long getContentLength() {
            return this.contentLength;
        }

        @Generated
        public byte[] getBuffer() {
            return this.buffer;
        }

        @Generated
        public long getTotalReadLength() {
            return this.totalReadLength;
        }

        @Generated
        public Map<String, String[]> getParameterMap() {
            return this.parameterMap;
        }

        @Generated
        public byte[] getThFileBytes() {
            return this.thFileBytes;
        }

        @Generated
        public String getThFileContentType() {
            return this.thFileContentType;
        }

        @Generated
        public String getThFileOriginalFilename() {
            return this.thFileOriginalFilename;
        }

        @Generated
        public InputStream getFileInputStream() {
            return this.fileInputStream;
        }

        @Generated
        public String getFileContentType() {
            return this.fileContentType;
        }

        @Generated
        public String getFileOriginalFilename() {
            return this.fileOriginalFilename;
        }

        @Generated
        public Long getFileSize() {
            return this.fileSize;
        }

        static /* synthetic */ byte[] access$302(MultipartFormData x0, byte[] x1) {
            x0.buffer = x1;
            return x1;
        }

        static /* synthetic */ byte[] access$602(MultipartFormData x0, byte[] x1) {
            x0.thFileBytes = x1;
            return x1;
        }
    }

    public static class MultipartFormDataPartInputStream
    extends InputStream {
        private final MultipartFormData data;
        private int bufferLength = 0;
        private int index = -1;
        private int status = 0;

        public MultipartFormDataPartInputStream(MultipartFormData data) {
            this.data = data;
        }

        @Override
        public int read() throws IOException {
            if (this.index + 1 == this.bufferLength) {
                if (this.status == 2) {
                    return -1;
                }
                this.readLineBuffer();
                if (this.index + 1 == this.bufferLength && this.status == 2) {
                    return -1;
                }
            }
            return this.data.buffer[++this.index] & 0xFF;
        }

        protected void readLineBuffer() throws IOException {
            if (this.status == 2) {
                return;
            }
            int readLength = MultipartFormDataReader.readLine(this.data.inputStream, this.data.buffer, 0, this.data.buffer.length);
            if (readLength == -1) {
                throw new FileStorageRuntimeException("HttpServletRequest \u89e3\u6790\u5931\u8d25\uff0c\u6587\u4ef6\u5c1a\u672a\u5b8c\u6574\u8bfb\u53d6");
            }
            this.data.totalReadLength += readLength;
            if (this.isEndLine(this.data.buffer, readLength)) {
                this.status = 2;
                return;
            }
            this.bufferLength = readLength;
            this.index = -1;
            if (this.endsWithLineEndFlag(this.data.buffer, readLength) && this.nextLineIsEndLine()) {
                this.status = 2;
                this.bufferLength -= this.data.boundary.lineEndFlagBytes.length;
            }
        }

        protected boolean nextLineIsEndLine() throws IOException {
            this.data.inputStream.mark(this.data.boundary.endLineBytes.length);
            byte[] bytes = new byte[this.data.boundary.endLineBytes.length];
            int readLength = MultipartFormDataReader.readLine(this.data.inputStream, bytes, 0, bytes.length);
            this.data.inputStream.reset();
            return this.isEndLine(bytes, readLength);
        }

        protected boolean endsWithLineEndFlag(byte[] buffer, int readLength) {
            if (readLength < this.data.boundary.lineEndFlagBytes.length) {
                return false;
            }
            byte[] bytes = Arrays.copyOfRange(buffer, readLength - this.data.boundary.lineEndFlagBytes.length, readLength);
            return Arrays.equals(bytes, this.data.boundary.lineEndFlagBytes);
        }

        protected boolean isEndLine(byte[] buffer, int readLength) {
            if (readLength == this.data.boundary.lineBytes.length && Arrays.equals(Arrays.copyOfRange(buffer, 0, readLength), this.data.boundary.lineBytes)) {
                return true;
            }
            return readLength == this.data.boundary.endLineBytes.length && Arrays.equals(Arrays.copyOfRange(buffer, 0, readLength), this.data.boundary.endLineBytes);
        }
    }
}

