/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.x.file.storage.core.file;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.dromara.x.file.storage.core.IOExceptionConsumer;
import org.dromara.x.file.storage.core.IOExceptionFunction;
import org.dromara.x.file.storage.core.exception.FileStorageRuntimeException;

public interface FileWrapper {
    public String getName();

    public void setName(String var1);

    public String getContentType();

    public void setContentType(String var1);

    public InputStream getInputStream() throws IOException;

    default public void getInputStreamMaskReset(IOExceptionConsumer<InputStream> consumer) throws IOException {
        this.getInputStreamMaskResetReturn(in -> {
            consumer.accept((InputStream)in);
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public <R> R getInputStreamMaskResetReturn(IOExceptionFunction<InputStream, R> function) throws IOException {
        InputStream in = this.getInputStream();
        in.mark(Integer.MAX_VALUE);
        try {
            R r = function.apply(in);
            return r;
        }
        finally {
            in.reset();
        }
    }

    public Long getSize();

    public void setSize(Long var1);

    default public void transferTo(File dest) {
        throw new FileStorageRuntimeException("\u5f53\u524d FileWrapper \u4e0d\u652f\u6301 transferTo \u65b9\u6cd5");
    }

    default public boolean supportTransfer() {
        return false;
    }
}

