/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.x.file.storage.core.aspect;

import java.io.InputStream;
import java.util.Iterator;
import java.util.function.Consumer;
import lombok.Generated;
import org.dromara.x.file.storage.core.FileInfo;
import org.dromara.x.file.storage.core.aspect.DownloadAspectChainCallback;
import org.dromara.x.file.storage.core.aspect.FileStorageAspect;
import org.dromara.x.file.storage.core.platform.FileStorage;

public class DownloadAspectChain {
    private DownloadAspectChainCallback callback;
    private Iterator<FileStorageAspect> aspectIterator;

    public DownloadAspectChain(Iterable<FileStorageAspect> aspects, DownloadAspectChainCallback callback) {
        this.aspectIterator = aspects.iterator();
        this.callback = callback;
    }

    public void next(FileInfo fileInfo, FileStorage fileStorage, Consumer<InputStream> consumer) {
        if (this.aspectIterator.hasNext()) {
            this.aspectIterator.next().downloadAround(this, fileInfo, fileStorage, consumer);
        } else {
            this.callback.run(fileInfo, fileStorage, consumer);
        }
    }

    @Generated
    public DownloadAspectChainCallback getCallback() {
        return this.callback;
    }

    @Generated
    public Iterator<FileStorageAspect> getAspectIterator() {
        return this.aspectIterator;
    }

    @Generated
    public void setCallback(DownloadAspectChainCallback callback) {
        this.callback = callback;
    }

    @Generated
    public void setAspectIterator(Iterator<FileStorageAspect> aspectIterator) {
        this.aspectIterator = aspectIterator;
    }
}

