/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.x.file.storage.core;

import java.util.function.LongSupplier;

public interface ProgressListener {
    public void start();

    public void progress(long var1, Long var3);

    public void finish();

    public static void quickStart(ProgressListener progressListener, Long size) {
        if (progressListener == null) {
            return;
        }
        progressListener.start();
        progressListener.progress(0L, size);
    }

    public static void quickProgress(ProgressListener progressListener, long progressSize, Long size) {
        if (progressListener == null) {
            return;
        }
        progressListener.progress(progressSize, size);
    }

    public static void quickFinish(ProgressListener progressListener, Long size, LongSupplier progressSizeSupplier) {
        if (progressListener == null) {
            return;
        }
        progressListener.progress(progressSizeSupplier.getAsLong(), size);
        progressListener.finish();
    }

    public static void quickFinish(ProgressListener progressListener, Long size) {
        if (progressListener == null) {
            return;
        }
        progressListener.progress(size, size);
        progressListener.finish();
    }

    public static void quickFinish(ProgressListener progressListener) {
        if (progressListener == null) {
            return;
        }
        progressListener.finish();
    }
}

