/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.x.file.storage.core;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.extra.ftp.Ftp;
import cn.hutool.extra.ssh.Sftp;
import com.aliyun.oss.OSS;
import com.amazonaws.services.s3.AmazonS3;
import com.baidubce.services.bos.BosClient;
import com.github.sardine.Sardine;
import com.google.cloud.storage.Storage;
import com.obs.services.ObsClient;
import com.qcloud.cos.COSClient;
import com.upyun.RestManager;
import io.minio.MinioClient;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import org.csource.fastdfs.StorageClient;
import org.dromara.x.file.storage.core.FileStorageProperties;
import org.dromara.x.file.storage.core.FileStorageService;
import org.dromara.x.file.storage.core.aspect.FileStorageAspect;
import org.dromara.x.file.storage.core.exception.FileStorageRuntimeException;
import org.dromara.x.file.storage.core.file.ByteFileWrapperAdapter;
import org.dromara.x.file.storage.core.file.FileWrapperAdapter;
import org.dromara.x.file.storage.core.file.InputStreamFileWrapperAdapter;
import org.dromara.x.file.storage.core.file.JakartaHttpServletRequestFileWrapperAdapter;
import org.dromara.x.file.storage.core.file.JavaxHttpServletRequestFileWrapperAdapter;
import org.dromara.x.file.storage.core.file.LocalFileWrapperAdapter;
import org.dromara.x.file.storage.core.file.UriFileWrapperAdapter;
import org.dromara.x.file.storage.core.platform.AliyunOssFileStorage;
import org.dromara.x.file.storage.core.platform.AliyunOssFileStorageClientFactory;
import org.dromara.x.file.storage.core.platform.AmazonS3FileStorage;
import org.dromara.x.file.storage.core.platform.AmazonS3FileStorageClientFactory;
import org.dromara.x.file.storage.core.platform.AzureBlobStorageFileStorage;
import org.dromara.x.file.storage.core.platform.AzureBlobStorageFileStorageClientFactory;
import org.dromara.x.file.storage.core.platform.BaiduBosFileStorage;
import org.dromara.x.file.storage.core.platform.BaiduBosFileStorageClientFactory;
import org.dromara.x.file.storage.core.platform.FastDfsFileStorage;
import org.dromara.x.file.storage.core.platform.FastDfsFileStorageClientFactory;
import org.dromara.x.file.storage.core.platform.FileStorage;
import org.dromara.x.file.storage.core.platform.FileStorageClientFactory;
import org.dromara.x.file.storage.core.platform.FtpFileStorage;
import org.dromara.x.file.storage.core.platform.FtpFileStorageClientFactory;
import org.dromara.x.file.storage.core.platform.GoogleCloudStorageFileStorage;
import org.dromara.x.file.storage.core.platform.GoogleCloudStorageFileStorageClientFactory;
import org.dromara.x.file.storage.core.platform.HuaweiObsFileStorage;
import org.dromara.x.file.storage.core.platform.HuaweiObsFileStorageClientFactory;
import org.dromara.x.file.storage.core.platform.LocalFileStorage;
import org.dromara.x.file.storage.core.platform.LocalPlusFileStorage;
import org.dromara.x.file.storage.core.platform.MinioFileStorage;
import org.dromara.x.file.storage.core.platform.MinioFileStorageClientFactory;
import org.dromara.x.file.storage.core.platform.QiniuKodoFileStorage;
import org.dromara.x.file.storage.core.platform.QiniuKodoFileStorageClientFactory;
import org.dromara.x.file.storage.core.platform.SftpFileStorage;
import org.dromara.x.file.storage.core.platform.SftpFileStorageClientFactory;
import org.dromara.x.file.storage.core.platform.TencentCosFileStorage;
import org.dromara.x.file.storage.core.platform.TencentCosFileStorageClientFactory;
import org.dromara.x.file.storage.core.platform.UpyunUssFileStorage;
import org.dromara.x.file.storage.core.platform.UpyunUssFileStorageClientFactory;
import org.dromara.x.file.storage.core.platform.WebDavFileStorage;
import org.dromara.x.file.storage.core.platform.WebDavFileStorageClientFactory;
import org.dromara.x.file.storage.core.recorder.DefaultFileRecorder;
import org.dromara.x.file.storage.core.recorder.FileRecorder;
import org.dromara.x.file.storage.core.tika.ContentTypeDetect;
import org.dromara.x.file.storage.core.tika.DefaultTikaFactory;
import org.dromara.x.file.storage.core.tika.TikaContentTypeDetect;
import org.dromara.x.file.storage.core.tika.TikaFactory;
import org.dromara.x.file.storage.core.util.Tools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileStorageServiceBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FileStorageServiceBuilder.class);
    private FileStorageProperties properties;
    private FileRecorder fileRecorder;
    private TikaFactory tikaFactory;
    private ContentTypeDetect contentTypeDetect;
    private List<FileStorageAspect> aspectList = new ArrayList<FileStorageAspect>();
    private List<FileWrapperAdapter> fileWrapperAdapterList = new ArrayList<FileWrapperAdapter>();
    private List<List<FileStorageClientFactory<?>>> clientFactoryList = new ArrayList();
    private List<FileStorage> fileStorageList = new ArrayList<FileStorage>();

    public FileStorageServiceBuilder(FileStorageProperties properties) {
        this.properties = properties;
    }

    public FileStorageServiceBuilder setDefaultFileRecorder() {
        this.fileRecorder = new DefaultFileRecorder();
        return this;
    }

    public FileStorageServiceBuilder setDefaultTikaFactory() {
        this.tikaFactory = new DefaultTikaFactory();
        return this;
    }

    public FileStorageServiceBuilder setTikaContentTypeDetect() {
        if (this.tikaFactory == null) {
            throw new FileStorageRuntimeException("\u8bf7\u5148\u8bbe\u7f6e TikaFactory");
        }
        this.contentTypeDetect = new TikaContentTypeDetect(this.tikaFactory);
        return this;
    }

    public FileStorageServiceBuilder addAspect(FileStorageAspect aspect) {
        this.aspectList.add(aspect);
        return this;
    }

    public FileStorageServiceBuilder addFileWrapperAdapter(FileWrapperAdapter adapter) {
        this.fileWrapperAdapterList.add(adapter);
        return this;
    }

    public FileStorageServiceBuilder addByteFileWrapperAdapter() {
        if (this.contentTypeDetect == null) {
            throw new FileStorageRuntimeException("\u8bf7\u5148\u8bbe\u7f6e TikaFactory \u548c ContentTypeDetect");
        }
        this.fileWrapperAdapterList.add(new ByteFileWrapperAdapter(this.contentTypeDetect));
        return this;
    }

    public FileStorageServiceBuilder addInputStreamFileWrapperAdapter() {
        if (this.contentTypeDetect == null) {
            throw new FileStorageRuntimeException("\u8bf7\u5148\u8bbe\u7f6e TikaFactory \u548c ContentTypeDetect");
        }
        this.fileWrapperAdapterList.add(new InputStreamFileWrapperAdapter(this.contentTypeDetect));
        return this;
    }

    public FileStorageServiceBuilder addLocalFileWrapperAdapter() {
        if (this.contentTypeDetect == null) {
            throw new FileStorageRuntimeException("\u8bf7\u5148\u8bbe\u7f6e TikaFactory \u548c ContentTypeDetect");
        }
        this.fileWrapperAdapterList.add(new LocalFileWrapperAdapter(this.contentTypeDetect));
        return this;
    }

    public FileStorageServiceBuilder addUriFileWrapperAdapter() {
        if (this.contentTypeDetect == null) {
            throw new FileStorageRuntimeException("\u8bf7\u5148\u8bbe\u7f6e TikaFactory \u548c ContentTypeDetect");
        }
        this.fileWrapperAdapterList.add(new UriFileWrapperAdapter(this.contentTypeDetect));
        return this;
    }

    public FileStorageServiceBuilder addHttpServletRequestFileWrapperAdapter() {
        if (!FileStorageServiceBuilder.doesNotExistClass("javax.servlet.http.HttpServletRequest")) {
            this.fileWrapperAdapterList.add(new JavaxHttpServletRequestFileWrapperAdapter());
        }
        if (!FileStorageServiceBuilder.doesNotExistClass("jakarta.servlet.http.HttpServletRequest")) {
            this.fileWrapperAdapterList.add(new JakartaHttpServletRequestFileWrapperAdapter());
        }
        return this;
    }

    public FileStorageServiceBuilder addAllFileWrapperAdapter() {
        this.addByteFileWrapperAdapter();
        this.addInputStreamFileWrapperAdapter();
        this.addLocalFileWrapperAdapter();
        this.addUriFileWrapperAdapter();
        this.addHttpServletRequestFileWrapperAdapter();
        return this;
    }

    public FileStorageServiceBuilder addFileStorageClientFactory(List<FileStorageClientFactory<?>> list) {
        this.clientFactoryList.add(list);
        return this;
    }

    public FileStorageServiceBuilder addFileStorageClientFactory(FileStorageClientFactory<?> factory) {
        this.clientFactoryList.add(Collections.singletonList(factory));
        return this;
    }

    public FileStorageServiceBuilder addFileStorage(List<? extends FileStorage> storageList) {
        this.fileStorageList.addAll(storageList);
        return this;
    }

    public FileStorageServiceBuilder addFileStorage(FileStorage storage) {
        this.fileStorageList.add(storage);
        return this;
    }

    public FileStorageServiceBuilder useDefault() {
        this.setDefaultFileRecorder();
        this.setDefaultTikaFactory();
        this.setTikaContentTypeDetect();
        this.addAllFileWrapperAdapter();
        return this;
    }

    public FileStorageService build() {
        if (this.properties == null) {
            throw new FileStorageRuntimeException("properties \u4e0d\u80fd\u4e3a null");
        }
        this.fileStorageList.addAll(FileStorageServiceBuilder.buildLocalFileStorage(this.properties.getLocal()));
        this.fileStorageList.addAll(FileStorageServiceBuilder.buildLocalPlusFileStorage(this.properties.getLocalPlus()));
        this.fileStorageList.addAll(FileStorageServiceBuilder.buildHuaweiObsFileStorage(this.properties.getHuaweiObs(), this.clientFactoryList));
        this.fileStorageList.addAll(FileStorageServiceBuilder.buildAliyunOssFileStorage(this.properties.getAliyunOss(), this.clientFactoryList));
        this.fileStorageList.addAll(FileStorageServiceBuilder.buildQiniuKodoFileStorage(this.properties.getQiniuKodo(), this.clientFactoryList));
        this.fileStorageList.addAll(FileStorageServiceBuilder.buildTencentCosFileStorage(this.properties.getTencentCos(), this.clientFactoryList));
        this.fileStorageList.addAll(FileStorageServiceBuilder.buildBaiduBosFileStorage(this.properties.getBaiduBos(), this.clientFactoryList));
        this.fileStorageList.addAll(FileStorageServiceBuilder.buildUpyunUssFileStorage(this.properties.getUpyunUss(), this.clientFactoryList));
        this.fileStorageList.addAll(FileStorageServiceBuilder.buildMinioFileStorage(this.properties.getMinio(), this.clientFactoryList));
        this.fileStorageList.addAll(FileStorageServiceBuilder.buildAmazonS3FileStorage(this.properties.getAmazonS3(), this.clientFactoryList));
        this.fileStorageList.addAll(FileStorageServiceBuilder.buildFtpFileStorage(this.properties.getFtp(), this.clientFactoryList));
        this.fileStorageList.addAll(FileStorageServiceBuilder.buildSftpFileStorage(this.properties.getSftp(), this.clientFactoryList));
        this.fileStorageList.addAll(FileStorageServiceBuilder.buildWebDavFileStorage(this.properties.getWebdav(), this.clientFactoryList));
        this.fileStorageList.addAll(FileStorageServiceBuilder.buildGoogleCloudStorageFileStorage(this.properties.getGoogleCloudStorage(), this.clientFactoryList));
        this.fileStorageList.addAll(this.buildFastDfsFileStorage(this.properties.getFastdfs(), this.clientFactoryList));
        this.fileStorageList.addAll(FileStorageServiceBuilder.buildAzureBlobFileStorage(this.properties.getAzureBlob(), this.clientFactoryList));
        FileStorageService service = new FileStorageService();
        service.setSelf(service);
        service.setProperties(this.properties);
        service.setFileStorageList(new CopyOnWriteArrayList<FileStorage>(this.fileStorageList));
        service.setFileRecorder(this.fileRecorder);
        service.setAspectList(new CopyOnWriteArrayList<FileStorageAspect>(this.aspectList));
        service.setFileWrapperAdapterList(new CopyOnWriteArrayList<FileWrapperAdapter>(this.fileWrapperAdapterList));
        service.setContentTypeDetect(this.contentTypeDetect);
        return service;
    }

    public static FileStorageServiceBuilder create(FileStorageProperties properties) {
        return new FileStorageServiceBuilder(properties);
    }

    public static List<LocalFileStorage> buildLocalFileStorage(List<? extends FileStorageProperties.LocalConfig> list) {
        if (CollUtil.isEmpty(list)) {
            return Collections.emptyList();
        }
        return list.stream().map(config -> {
            log.info("\u52a0\u8f7d\u672c\u5730\u5b58\u50a8\u5e73\u53f0\uff1a{}\uff0c\u6b64\u5b58\u50a8\u5e73\u53f0\u5df2\u4e0d\u63a8\u8350\u4f7f\u7528\uff0c\u65b0\u9879\u76ee\u8bf7\u4f7f\u7528 \u672c\u5730\u5347\u7ea7\u7248\u5b58\u50a8\u5e73\u53f0\uff08LocalPlusFileStorage\uff09", (Object)config.getPlatform());
            return new LocalFileStorage((FileStorageProperties.LocalConfig)config);
        }).collect(Collectors.toList());
    }

    public static List<LocalPlusFileStorage> buildLocalPlusFileStorage(List<? extends FileStorageProperties.LocalPlusConfig> list) {
        if (CollUtil.isEmpty(list)) {
            return Collections.emptyList();
        }
        return list.stream().map(config -> {
            log.info("\u52a0\u8f7d\u672c\u5730\u5347\u7ea7\u7248\u5b58\u50a8\u5e73\u53f0\uff1a{}", (Object)config.getPlatform());
            return new LocalPlusFileStorage((FileStorageProperties.LocalPlusConfig)config);
        }).collect(Collectors.toList());
    }

    public static List<HuaweiObsFileStorage> buildHuaweiObsFileStorage(List<? extends FileStorageProperties.HuaweiObsConfig> list, List<List<FileStorageClientFactory<?>>> clientFactoryList) {
        if (CollUtil.isEmpty(list)) {
            return Collections.emptyList();
        }
        FileStorageServiceBuilder.buildFileStorageDetect(list, "\u534e\u4e3a\u4e91 OBS", "com.obs.services.ObsClient");
        return list.stream().map(config -> {
            log.info("\u52a0\u8f7d\u534e\u4e3a\u4e91 OBS \u5b58\u50a8\u5e73\u53f0\uff1a{}", (Object)config.getPlatform());
            FileStorageClientFactory<ObsClient> clientFactory = FileStorageServiceBuilder.getFactory(config.getPlatform(), clientFactoryList, () -> new HuaweiObsFileStorageClientFactory((FileStorageProperties.HuaweiObsConfig)config));
            return new HuaweiObsFileStorage((FileStorageProperties.HuaweiObsConfig)config, clientFactory);
        }).collect(Collectors.toList());
    }

    public static List<AliyunOssFileStorage> buildAliyunOssFileStorage(List<? extends FileStorageProperties.AliyunOssConfig> list, List<List<FileStorageClientFactory<?>>> clientFactoryList) {
        if (CollUtil.isEmpty(list)) {
            return Collections.emptyList();
        }
        FileStorageServiceBuilder.buildFileStorageDetect(list, "\u963f\u91cc\u4e91 OSS", "com.aliyun.oss.OSS");
        return list.stream().map(config -> {
            log.info("\u52a0\u8f7d\u963f\u91cc\u4e91 OSS \u5b58\u50a8\u5e73\u53f0\uff1a{}", (Object)config.getPlatform());
            FileStorageClientFactory<OSS> clientFactory = FileStorageServiceBuilder.getFactory(config.getPlatform(), clientFactoryList, () -> new AliyunOssFileStorageClientFactory((FileStorageProperties.AliyunOssConfig)config));
            return new AliyunOssFileStorage((FileStorageProperties.AliyunOssConfig)config, clientFactory);
        }).collect(Collectors.toList());
    }

    public static List<QiniuKodoFileStorage> buildQiniuKodoFileStorage(List<? extends FileStorageProperties.QiniuKodoConfig> list, List<List<FileStorageClientFactory<?>>> clientFactoryList) {
        if (CollUtil.isEmpty(list)) {
            return Collections.emptyList();
        }
        FileStorageServiceBuilder.buildFileStorageDetect(list, "\u4e03\u725b\u4e91 Kodo", "com.qiniu.storage.UploadManager");
        return list.stream().map(config -> {
            log.info("\u52a0\u8f7d\u4e03\u725b\u4e91 Kodo \u5b58\u50a8\u5e73\u53f0\uff1a{}", (Object)config.getPlatform());
            FileStorageClientFactory<QiniuKodoFileStorageClientFactory.QiniuKodoClient> clientFactory = FileStorageServiceBuilder.getFactory(config.getPlatform(), clientFactoryList, () -> new QiniuKodoFileStorageClientFactory((FileStorageProperties.QiniuKodoConfig)config));
            return new QiniuKodoFileStorage((FileStorageProperties.QiniuKodoConfig)config, clientFactory);
        }).collect(Collectors.toList());
    }

    public static List<TencentCosFileStorage> buildTencentCosFileStorage(List<? extends FileStorageProperties.TencentCosConfig> list, List<List<FileStorageClientFactory<?>>> clientFactoryList) {
        if (CollUtil.isEmpty(list)) {
            return Collections.emptyList();
        }
        FileStorageServiceBuilder.buildFileStorageDetect(list, "\u817e\u8baf\u4e91 COS", "com.qcloud.cos.COSClient");
        return list.stream().map(config -> {
            log.info("\u52a0\u8f7d\u817e\u8baf\u4e91 COS \u5b58\u50a8\u5e73\u53f0\uff1a{}", (Object)config.getPlatform());
            FileStorageClientFactory<COSClient> clientFactory = FileStorageServiceBuilder.getFactory(config.getPlatform(), clientFactoryList, () -> new TencentCosFileStorageClientFactory((FileStorageProperties.TencentCosConfig)config));
            return new TencentCosFileStorage((FileStorageProperties.TencentCosConfig)config, clientFactory);
        }).collect(Collectors.toList());
    }

    public static List<BaiduBosFileStorage> buildBaiduBosFileStorage(List<? extends FileStorageProperties.BaiduBosConfig> list, List<List<FileStorageClientFactory<?>>> clientFactoryList) {
        if (CollUtil.isEmpty(list)) {
            return Collections.emptyList();
        }
        FileStorageServiceBuilder.buildFileStorageDetect(list, "\u767e\u5ea6\u4e91 BOS", "com.baidubce.services.bos.BosClient");
        return list.stream().map(config -> {
            log.info("\u52a0\u8f7d\u767e\u5ea6\u4e91 BOS \u5b58\u50a8\u5e73\u53f0\uff1a{}", (Object)config.getPlatform());
            FileStorageClientFactory<BosClient> clientFactory = FileStorageServiceBuilder.getFactory(config.getPlatform(), clientFactoryList, () -> new BaiduBosFileStorageClientFactory((FileStorageProperties.BaiduBosConfig)config));
            return new BaiduBosFileStorage((FileStorageProperties.BaiduBosConfig)config, clientFactory);
        }).collect(Collectors.toList());
    }

    public static List<UpyunUssFileStorage> buildUpyunUssFileStorage(List<? extends FileStorageProperties.UpyunUssConfig> list, List<List<FileStorageClientFactory<?>>> clientFactoryList) {
        if (CollUtil.isEmpty(list)) {
            return Collections.emptyList();
        }
        FileStorageServiceBuilder.buildFileStorageDetect(list, "\u53c8\u62cd\u4e91 USS", "com.upyun.RestManager");
        return list.stream().map(config -> {
            log.info("\u52a0\u8f7d\u53c8\u62cd\u4e91 USS \u5b58\u50a8\u5e73\u53f0\uff1a{}", (Object)config.getPlatform());
            FileStorageClientFactory<RestManager> clientFactory = FileStorageServiceBuilder.getFactory(config.getPlatform(), clientFactoryList, () -> new UpyunUssFileStorageClientFactory((FileStorageProperties.UpyunUssConfig)config));
            return new UpyunUssFileStorage((FileStorageProperties.UpyunUssConfig)config, clientFactory);
        }).collect(Collectors.toList());
    }

    public static List<MinioFileStorage> buildMinioFileStorage(List<? extends FileStorageProperties.MinioConfig> list, List<List<FileStorageClientFactory<?>>> clientFactoryList) {
        if (CollUtil.isEmpty(list)) {
            return Collections.emptyList();
        }
        FileStorageServiceBuilder.buildFileStorageDetect(list, "MinIO", "io.minio.MinioClient");
        return list.stream().map(config -> {
            log.info("\u52a0\u8f7d MinIO \u5b58\u50a8\u5e73\u53f0\uff1a{}", (Object)config.getPlatform());
            FileStorageClientFactory<MinioClient> clientFactory = FileStorageServiceBuilder.getFactory(config.getPlatform(), clientFactoryList, () -> new MinioFileStorageClientFactory((FileStorageProperties.MinioConfig)config));
            return new MinioFileStorage((FileStorageProperties.MinioConfig)config, clientFactory);
        }).collect(Collectors.toList());
    }

    public static List<AmazonS3FileStorage> buildAmazonS3FileStorage(List<? extends FileStorageProperties.AmazonS3Config> list, List<List<FileStorageClientFactory<?>>> clientFactoryList) {
        if (CollUtil.isEmpty(list)) {
            return Collections.emptyList();
        }
        FileStorageServiceBuilder.buildFileStorageDetect(list, "Amazon S3", "com.amazonaws.services.s3.AmazonS3");
        return list.stream().map(config -> {
            log.info("\u52a0\u8f7d Amazon S3 \u5b58\u50a8\u5e73\u53f0\uff1a{}", (Object)config.getPlatform());
            FileStorageClientFactory<AmazonS3> clientFactory = FileStorageServiceBuilder.getFactory(config.getPlatform(), clientFactoryList, () -> new AmazonS3FileStorageClientFactory((FileStorageProperties.AmazonS3Config)config));
            return new AmazonS3FileStorage((FileStorageProperties.AmazonS3Config)config, clientFactory);
        }).collect(Collectors.toList());
    }

    public static List<FtpFileStorage> buildFtpFileStorage(List<? extends FileStorageProperties.FtpConfig> list, List<List<FileStorageClientFactory<?>>> clientFactoryList) {
        if (CollUtil.isEmpty(list)) {
            return Collections.emptyList();
        }
        FileStorageServiceBuilder.buildFileStorageDetect(list, "FTP", "org.apache.commons.net.ftp.FTPClient", "cn.hutool.extra.ftp.Ftp", "org.apache.commons.pool2.impl.GenericObjectPool");
        return list.stream().map(config -> {
            log.info("\u52a0\u8f7d FTP \u5b58\u50a8\u5e73\u53f0\uff1a{}", (Object)config.getPlatform());
            FileStorageClientFactory<Ftp> clientFactory = FileStorageServiceBuilder.getFactory(config.getPlatform(), clientFactoryList, () -> new FtpFileStorageClientFactory((FileStorageProperties.FtpConfig)config));
            return new FtpFileStorage((FileStorageProperties.FtpConfig)config, clientFactory);
        }).collect(Collectors.toList());
    }

    public static List<SftpFileStorage> buildSftpFileStorage(List<? extends FileStorageProperties.SftpConfig> list, List<List<FileStorageClientFactory<?>>> clientFactoryList) {
        if (CollUtil.isEmpty(list)) {
            return Collections.emptyList();
        }
        FileStorageServiceBuilder.buildFileStorageDetect(list, "SFTP", "com.jcraft.jsch.ChannelSftp", "cn.hutool.extra.ftp.Ftp", "org.apache.commons.pool2.impl.GenericObjectPool");
        return list.stream().map(config -> {
            log.info("\u52a0\u8f7d SFTP \u5b58\u50a8\u5e73\u53f0\uff1a{}", (Object)config.getPlatform());
            FileStorageClientFactory<Sftp> clientFactory = FileStorageServiceBuilder.getFactory(config.getPlatform(), clientFactoryList, () -> new SftpFileStorageClientFactory((FileStorageProperties.SftpConfig)config));
            return new SftpFileStorage((FileStorageProperties.SftpConfig)config, clientFactory);
        }).collect(Collectors.toList());
    }

    public static List<WebDavFileStorage> buildWebDavFileStorage(List<? extends FileStorageProperties.WebDavConfig> list, List<List<FileStorageClientFactory<?>>> clientFactoryList) {
        if (CollUtil.isEmpty(list)) {
            return Collections.emptyList();
        }
        FileStorageServiceBuilder.buildFileStorageDetect(list, "WebDAV", "com.github.sardine.Sardine");
        return list.stream().map(config -> {
            log.info("\u52a0\u8f7d WebDAV \u5b58\u50a8\u5e73\u53f0\uff1a{}", (Object)config.getPlatform());
            FileStorageClientFactory<Sardine> clientFactory = FileStorageServiceBuilder.getFactory(config.getPlatform(), clientFactoryList, () -> new WebDavFileStorageClientFactory((FileStorageProperties.WebDavConfig)config));
            return new WebDavFileStorage((FileStorageProperties.WebDavConfig)config, clientFactory);
        }).collect(Collectors.toList());
    }

    public static List<GoogleCloudStorageFileStorage> buildGoogleCloudStorageFileStorage(List<? extends FileStorageProperties.GoogleCloudStorageConfig> list, List<List<FileStorageClientFactory<?>>> clientFactoryList) {
        if (CollUtil.isEmpty(list)) {
            return Collections.emptyList();
        }
        FileStorageServiceBuilder.buildFileStorageDetect(list, "GoogleCloud Storage ", "com.google.cloud.storage.Storage");
        return list.stream().map(config -> {
            log.info("\u52a0\u8f7d GoogleCloud Storage \u5b58\u50a8\u5e73\u53f0\uff1a{}", (Object)config.getPlatform());
            FileStorageClientFactory<Storage> clientFactory = FileStorageServiceBuilder.getFactory(config.getPlatform(), clientFactoryList, () -> new GoogleCloudStorageFileStorageClientFactory((FileStorageProperties.GoogleCloudStorageConfig)config));
            return new GoogleCloudStorageFileStorage((FileStorageProperties.GoogleCloudStorageConfig)config, clientFactory);
        }).collect(Collectors.toList());
    }

    private Collection<? extends FileStorage> buildFastDfsFileStorage(List<? extends FileStorageProperties.FastDfsConfig> fastdfs, List<List<FileStorageClientFactory<?>>> clientFactoryList) {
        if (CollUtil.isEmpty(fastdfs)) {
            return Collections.emptyList();
        }
        FileStorageServiceBuilder.buildFileStorageDetect(fastdfs, "FastDFS", "org.csource.fastdfs.StorageClient");
        return fastdfs.stream().map(config -> {
            log.info("\u52a0\u8f7d FastDFS \u5b58\u50a8\u5e73\u53f0\uff1a{}", (Object)config.getPlatform());
            FileStorageClientFactory<StorageClient> clientFactory = FileStorageServiceBuilder.getFactory(config.getPlatform(), clientFactoryList, () -> new FastDfsFileStorageClientFactory((FileStorageProperties.FastDfsConfig)config));
            return new FastDfsFileStorage((FileStorageProperties.FastDfsConfig)config, clientFactory);
        }).collect(Collectors.toList());
    }

    public static List<AzureBlobStorageFileStorage> buildAzureBlobFileStorage(List<? extends FileStorageProperties.AzureBlobStorageConfig> list, List<List<FileStorageClientFactory<?>>> clientFactoryList) {
        if (CollUtil.isEmpty(list)) {
            return Collections.emptyList();
        }
        FileStorageServiceBuilder.buildFileStorageDetect(list, "microsoft azure blob ", "com.azure.storage.blob.BlobServiceClient");
        return list.stream().map(config -> {
            log.info("\u52a0\u8f7d microsoft azure blob \u5b58\u50a8\u5e73\u53f0\uff1a{}", (Object)config.getPlatform());
            FileStorageClientFactory<AzureBlobStorageFileStorageClientFactory.AzureBlobStorageClient> clientFactory = FileStorageServiceBuilder.getFactory(config.getPlatform(), clientFactoryList, () -> new AzureBlobStorageFileStorageClientFactory((FileStorageProperties.AzureBlobStorageConfig)config));
            return new AzureBlobStorageFileStorage((FileStorageProperties.AzureBlobStorageConfig)config, clientFactory);
        }).collect(Collectors.toList());
    }

    public static <Client> FileStorageClientFactory<Client> getFactory(String platform, List<List<FileStorageClientFactory<?>>> list, Supplier<FileStorageClientFactory<Client>> defaultSupplier) {
        if (list != null) {
            for (List<FileStorageClientFactory<?>> factoryList : list) {
                for (FileStorageClientFactory<?> factory : factoryList) {
                    if (!Objects.equals(platform, factory.getPlatform())) continue;
                    try {
                        return (FileStorageClientFactory)Tools.cast(factory);
                    }
                    catch (Exception e) {
                        throw new FileStorageRuntimeException("\u83b7\u53d6 FileStorageClientFactory \u5931\u8d25\uff0c\u7c7b\u578b\u4e0d\u5339\u914d\uff0cplatform\uff1a" + platform, e);
                    }
                }
            }
        }
        return defaultSupplier.get();
    }

    public static boolean doesNotExistClass(String name) {
        try {
            Class.forName(name);
            return false;
        }
        catch (ClassNotFoundException e) {
            return true;
        }
    }

    public static void buildFileStorageDetect(List<?> list, String platformName, String ... classNames) {
        if (CollUtil.isEmpty(list)) {
            return;
        }
        for (String className : classNames) {
            if (!FileStorageServiceBuilder.doesNotExistClass(className)) continue;
            throw new FileStorageRuntimeException("\u68c0\u6d4b\u5230\u3010" + platformName + "\u3011\u914d\u7f6e\uff0c\u4f46\u662f\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u4f9d\u8d56\u7c7b\uff1a\u3010" + className + "\u3011\uff0c\u6240\u4ee5\u65e0\u6cd5\u52a0\u8f7d\u6b64\u5b58\u50a8\u5e73\u53f0\uff01\u914d\u7f6e\u53c2\u8003\u5730\u5740\uff1ahttps://x-file-storage.xuyanwu.cn/2.2.0/#/%E5%BF%AB%E9%80%9F%E5%85%A5%E9%97%A8");
        }
    }

    @Generated
    public FileStorageProperties getProperties() {
        return this.properties;
    }

    @Generated
    public FileRecorder getFileRecorder() {
        return this.fileRecorder;
    }

    @Generated
    public TikaFactory getTikaFactory() {
        return this.tikaFactory;
    }

    @Generated
    public ContentTypeDetect getContentTypeDetect() {
        return this.contentTypeDetect;
    }

    @Generated
    public List<FileStorageAspect> getAspectList() {
        return this.aspectList;
    }

    @Generated
    public List<FileWrapperAdapter> getFileWrapperAdapterList() {
        return this.fileWrapperAdapterList;
    }

    @Generated
    public List<List<FileStorageClientFactory<?>>> getClientFactoryList() {
        return this.clientFactoryList;
    }

    @Generated
    public List<FileStorage> getFileStorageList() {
        return this.fileStorageList;
    }

    @Generated
    public FileStorageServiceBuilder setProperties(FileStorageProperties properties) {
        this.properties = properties;
        return this;
    }

    @Generated
    public FileStorageServiceBuilder setFileRecorder(FileRecorder fileRecorder) {
        this.fileRecorder = fileRecorder;
        return this;
    }

    @Generated
    public FileStorageServiceBuilder setTikaFactory(TikaFactory tikaFactory) {
        this.tikaFactory = tikaFactory;
        return this;
    }

    @Generated
    public FileStorageServiceBuilder setContentTypeDetect(ContentTypeDetect contentTypeDetect) {
        this.contentTypeDetect = contentTypeDetect;
        return this;
    }

    @Generated
    public FileStorageServiceBuilder setAspectList(List<FileStorageAspect> aspectList) {
        this.aspectList = aspectList;
        return this;
    }

    @Generated
    public FileStorageServiceBuilder setFileWrapperAdapterList(List<FileWrapperAdapter> fileWrapperAdapterList) {
        this.fileWrapperAdapterList = fileWrapperAdapterList;
        return this;
    }

    @Generated
    public FileStorageServiceBuilder setClientFactoryList(List<List<FileStorageClientFactory<?>>> clientFactoryList) {
        this.clientFactoryList = clientFactoryList;
        return this;
    }

    @Generated
    public FileStorageServiceBuilder setFileStorageList(List<FileStorage> fileStorageList) {
        this.fileStorageList = fileStorageList;
        return this;
    }
}

