/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.x.file.storage.core;

import cn.hutool.core.map.MapBuilder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;

public class FileStorageProperties {
    private String defaultPlatform = "local";
    private String thumbnailSuffix = ".min.jpg";
    private Boolean uploadNotSupportMetadataThrowException = true;
    private Boolean uploadNotSupportAclThrowException = true;
    private Boolean copyNotSupportMetadataThrowException = true;
    private Boolean copyNotSupportAclThrowException = true;
    private Boolean moveNotSupportMetadataThrowException = true;
    private Boolean moveNotSupportAclThrowException = true;
    private List<? extends LocalConfig> local = new ArrayList<LocalConfig>();
    private List<? extends LocalPlusConfig> localPlus = new ArrayList<LocalPlusConfig>();
    private List<? extends HuaweiObsConfig> huaweiObs = new ArrayList<HuaweiObsConfig>();
    private List<? extends AliyunOssConfig> aliyunOss = new ArrayList<AliyunOssConfig>();
    private List<? extends QiniuKodoConfig> qiniuKodo = new ArrayList<QiniuKodoConfig>();
    private List<? extends TencentCosConfig> tencentCos = new ArrayList<TencentCosConfig>();
    private List<? extends BaiduBosConfig> baiduBos = new ArrayList<BaiduBosConfig>();
    private List<? extends UpyunUssConfig> upyunUss = new ArrayList<UpyunUssConfig>();
    private List<? extends MinioConfig> minio = new ArrayList<MinioConfig>();
    private List<? extends AmazonS3Config> amazonS3 = new ArrayList<AmazonS3Config>();
    private List<? extends FtpConfig> ftp = new ArrayList<FtpConfig>();
    private List<? extends SftpConfig> sftp = new ArrayList<SftpConfig>();
    private List<? extends WebDavConfig> webdav = new ArrayList<WebDavConfig>();
    private List<? extends GoogleCloudStorageConfig> googleCloudStorage = new ArrayList<GoogleCloudStorageConfig>();
    private List<? extends FastDfsConfig> fastdfs = new ArrayList<FastDfsConfig>();
    private List<? extends AzureBlobStorageConfig> azureBlob = new ArrayList<AzureBlobStorageConfig>();

    @Generated
    public FileStorageProperties() {
    }

    @Generated
    public String getDefaultPlatform() {
        return this.defaultPlatform;
    }

    @Generated
    public String getThumbnailSuffix() {
        return this.thumbnailSuffix;
    }

    @Generated
    public Boolean getUploadNotSupportMetadataThrowException() {
        return this.uploadNotSupportMetadataThrowException;
    }

    @Generated
    public Boolean getUploadNotSupportAclThrowException() {
        return this.uploadNotSupportAclThrowException;
    }

    @Generated
    public Boolean getCopyNotSupportMetadataThrowException() {
        return this.copyNotSupportMetadataThrowException;
    }

    @Generated
    public Boolean getCopyNotSupportAclThrowException() {
        return this.copyNotSupportAclThrowException;
    }

    @Generated
    public Boolean getMoveNotSupportMetadataThrowException() {
        return this.moveNotSupportMetadataThrowException;
    }

    @Generated
    public Boolean getMoveNotSupportAclThrowException() {
        return this.moveNotSupportAclThrowException;
    }

    @Generated
    public List<? extends LocalConfig> getLocal() {
        return this.local;
    }

    @Generated
    public List<? extends LocalPlusConfig> getLocalPlus() {
        return this.localPlus;
    }

    @Generated
    public List<? extends HuaweiObsConfig> getHuaweiObs() {
        return this.huaweiObs;
    }

    @Generated
    public List<? extends AliyunOssConfig> getAliyunOss() {
        return this.aliyunOss;
    }

    @Generated
    public List<? extends QiniuKodoConfig> getQiniuKodo() {
        return this.qiniuKodo;
    }

    @Generated
    public List<? extends TencentCosConfig> getTencentCos() {
        return this.tencentCos;
    }

    @Generated
    public List<? extends BaiduBosConfig> getBaiduBos() {
        return this.baiduBos;
    }

    @Generated
    public List<? extends UpyunUssConfig> getUpyunUss() {
        return this.upyunUss;
    }

    @Generated
    public List<? extends MinioConfig> getMinio() {
        return this.minio;
    }

    @Generated
    public List<? extends AmazonS3Config> getAmazonS3() {
        return this.amazonS3;
    }

    @Generated
    public List<? extends FtpConfig> getFtp() {
        return this.ftp;
    }

    @Generated
    public List<? extends SftpConfig> getSftp() {
        return this.sftp;
    }

    @Generated
    public List<? extends WebDavConfig> getWebdav() {
        return this.webdav;
    }

    @Generated
    public List<? extends GoogleCloudStorageConfig> getGoogleCloudStorage() {
        return this.googleCloudStorage;
    }

    @Generated
    public List<? extends FastDfsConfig> getFastdfs() {
        return this.fastdfs;
    }

    @Generated
    public List<? extends AzureBlobStorageConfig> getAzureBlob() {
        return this.azureBlob;
    }

    @Generated
    public FileStorageProperties setDefaultPlatform(String defaultPlatform) {
        this.defaultPlatform = defaultPlatform;
        return this;
    }

    @Generated
    public FileStorageProperties setThumbnailSuffix(String thumbnailSuffix) {
        this.thumbnailSuffix = thumbnailSuffix;
        return this;
    }

    @Generated
    public FileStorageProperties setUploadNotSupportMetadataThrowException(Boolean uploadNotSupportMetadataThrowException) {
        this.uploadNotSupportMetadataThrowException = uploadNotSupportMetadataThrowException;
        return this;
    }

    @Generated
    public FileStorageProperties setUploadNotSupportAclThrowException(Boolean uploadNotSupportAclThrowException) {
        this.uploadNotSupportAclThrowException = uploadNotSupportAclThrowException;
        return this;
    }

    @Generated
    public FileStorageProperties setCopyNotSupportMetadataThrowException(Boolean copyNotSupportMetadataThrowException) {
        this.copyNotSupportMetadataThrowException = copyNotSupportMetadataThrowException;
        return this;
    }

    @Generated
    public FileStorageProperties setCopyNotSupportAclThrowException(Boolean copyNotSupportAclThrowException) {
        this.copyNotSupportAclThrowException = copyNotSupportAclThrowException;
        return this;
    }

    @Generated
    public FileStorageProperties setMoveNotSupportMetadataThrowException(Boolean moveNotSupportMetadataThrowException) {
        this.moveNotSupportMetadataThrowException = moveNotSupportMetadataThrowException;
        return this;
    }

    @Generated
    public FileStorageProperties setMoveNotSupportAclThrowException(Boolean moveNotSupportAclThrowException) {
        this.moveNotSupportAclThrowException = moveNotSupportAclThrowException;
        return this;
    }

    @Generated
    public FileStorageProperties setLocal(List<? extends LocalConfig> local) {
        this.local = local;
        return this;
    }

    @Generated
    public FileStorageProperties setLocalPlus(List<? extends LocalPlusConfig> localPlus) {
        this.localPlus = localPlus;
        return this;
    }

    @Generated
    public FileStorageProperties setHuaweiObs(List<? extends HuaweiObsConfig> huaweiObs) {
        this.huaweiObs = huaweiObs;
        return this;
    }

    @Generated
    public FileStorageProperties setAliyunOss(List<? extends AliyunOssConfig> aliyunOss) {
        this.aliyunOss = aliyunOss;
        return this;
    }

    @Generated
    public FileStorageProperties setQiniuKodo(List<? extends QiniuKodoConfig> qiniuKodo) {
        this.qiniuKodo = qiniuKodo;
        return this;
    }

    @Generated
    public FileStorageProperties setTencentCos(List<? extends TencentCosConfig> tencentCos) {
        this.tencentCos = tencentCos;
        return this;
    }

    @Generated
    public FileStorageProperties setBaiduBos(List<? extends BaiduBosConfig> baiduBos) {
        this.baiduBos = baiduBos;
        return this;
    }

    @Generated
    public FileStorageProperties setUpyunUss(List<? extends UpyunUssConfig> upyunUss) {
        this.upyunUss = upyunUss;
        return this;
    }

    @Generated
    public FileStorageProperties setMinio(List<? extends MinioConfig> minio) {
        this.minio = minio;
        return this;
    }

    @Generated
    public FileStorageProperties setAmazonS3(List<? extends AmazonS3Config> amazonS3) {
        this.amazonS3 = amazonS3;
        return this;
    }

    @Generated
    public FileStorageProperties setFtp(List<? extends FtpConfig> ftp) {
        this.ftp = ftp;
        return this;
    }

    @Generated
    public FileStorageProperties setSftp(List<? extends SftpConfig> sftp) {
        this.sftp = sftp;
        return this;
    }

    @Generated
    public FileStorageProperties setWebdav(List<? extends WebDavConfig> webdav) {
        this.webdav = webdav;
        return this;
    }

    @Generated
    public FileStorageProperties setGoogleCloudStorage(List<? extends GoogleCloudStorageConfig> googleCloudStorage) {
        this.googleCloudStorage = googleCloudStorage;
        return this;
    }

    @Generated
    public FileStorageProperties setFastdfs(List<? extends FastDfsConfig> fastdfs) {
        this.fastdfs = fastdfs;
        return this;
    }

    @Generated
    public FileStorageProperties setAzureBlob(List<? extends AzureBlobStorageConfig> azureBlob) {
        this.azureBlob = azureBlob;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FileStorageProperties)) {
            return false;
        }
        FileStorageProperties other = (FileStorageProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$uploadNotSupportMetadataThrowException = this.getUploadNotSupportMetadataThrowException();
        Boolean other$uploadNotSupportMetadataThrowException = other.getUploadNotSupportMetadataThrowException();
        if (this$uploadNotSupportMetadataThrowException == null ? other$uploadNotSupportMetadataThrowException != null : !((Object)this$uploadNotSupportMetadataThrowException).equals(other$uploadNotSupportMetadataThrowException)) {
            return false;
        }
        Boolean this$uploadNotSupportAclThrowException = this.getUploadNotSupportAclThrowException();
        Boolean other$uploadNotSupportAclThrowException = other.getUploadNotSupportAclThrowException();
        if (this$uploadNotSupportAclThrowException == null ? other$uploadNotSupportAclThrowException != null : !((Object)this$uploadNotSupportAclThrowException).equals(other$uploadNotSupportAclThrowException)) {
            return false;
        }
        Boolean this$copyNotSupportMetadataThrowException = this.getCopyNotSupportMetadataThrowException();
        Boolean other$copyNotSupportMetadataThrowException = other.getCopyNotSupportMetadataThrowException();
        if (this$copyNotSupportMetadataThrowException == null ? other$copyNotSupportMetadataThrowException != null : !((Object)this$copyNotSupportMetadataThrowException).equals(other$copyNotSupportMetadataThrowException)) {
            return false;
        }
        Boolean this$copyNotSupportAclThrowException = this.getCopyNotSupportAclThrowException();
        Boolean other$copyNotSupportAclThrowException = other.getCopyNotSupportAclThrowException();
        if (this$copyNotSupportAclThrowException == null ? other$copyNotSupportAclThrowException != null : !((Object)this$copyNotSupportAclThrowException).equals(other$copyNotSupportAclThrowException)) {
            return false;
        }
        Boolean this$moveNotSupportMetadataThrowException = this.getMoveNotSupportMetadataThrowException();
        Boolean other$moveNotSupportMetadataThrowException = other.getMoveNotSupportMetadataThrowException();
        if (this$moveNotSupportMetadataThrowException == null ? other$moveNotSupportMetadataThrowException != null : !((Object)this$moveNotSupportMetadataThrowException).equals(other$moveNotSupportMetadataThrowException)) {
            return false;
        }
        Boolean this$moveNotSupportAclThrowException = this.getMoveNotSupportAclThrowException();
        Boolean other$moveNotSupportAclThrowException = other.getMoveNotSupportAclThrowException();
        if (this$moveNotSupportAclThrowException == null ? other$moveNotSupportAclThrowException != null : !((Object)this$moveNotSupportAclThrowException).equals(other$moveNotSupportAclThrowException)) {
            return false;
        }
        String this$defaultPlatform = this.getDefaultPlatform();
        String other$defaultPlatform = other.getDefaultPlatform();
        if (this$defaultPlatform == null ? other$defaultPlatform != null : !this$defaultPlatform.equals(other$defaultPlatform)) {
            return false;
        }
        String this$thumbnailSuffix = this.getThumbnailSuffix();
        String other$thumbnailSuffix = other.getThumbnailSuffix();
        if (this$thumbnailSuffix == null ? other$thumbnailSuffix != null : !this$thumbnailSuffix.equals(other$thumbnailSuffix)) {
            return false;
        }
        List<? extends LocalConfig> this$local = this.getLocal();
        List<? extends LocalConfig> other$local = other.getLocal();
        if (this$local == null ? other$local != null : !((Object)this$local).equals(other$local)) {
            return false;
        }
        List<? extends LocalPlusConfig> this$localPlus = this.getLocalPlus();
        List<? extends LocalPlusConfig> other$localPlus = other.getLocalPlus();
        if (this$localPlus == null ? other$localPlus != null : !((Object)this$localPlus).equals(other$localPlus)) {
            return false;
        }
        List<? extends HuaweiObsConfig> this$huaweiObs = this.getHuaweiObs();
        List<? extends HuaweiObsConfig> other$huaweiObs = other.getHuaweiObs();
        if (this$huaweiObs == null ? other$huaweiObs != null : !((Object)this$huaweiObs).equals(other$huaweiObs)) {
            return false;
        }
        List<? extends AliyunOssConfig> this$aliyunOss = this.getAliyunOss();
        List<? extends AliyunOssConfig> other$aliyunOss = other.getAliyunOss();
        if (this$aliyunOss == null ? other$aliyunOss != null : !((Object)this$aliyunOss).equals(other$aliyunOss)) {
            return false;
        }
        List<? extends QiniuKodoConfig> this$qiniuKodo = this.getQiniuKodo();
        List<? extends QiniuKodoConfig> other$qiniuKodo = other.getQiniuKodo();
        if (this$qiniuKodo == null ? other$qiniuKodo != null : !((Object)this$qiniuKodo).equals(other$qiniuKodo)) {
            return false;
        }
        List<? extends TencentCosConfig> this$tencentCos = this.getTencentCos();
        List<? extends TencentCosConfig> other$tencentCos = other.getTencentCos();
        if (this$tencentCos == null ? other$tencentCos != null : !((Object)this$tencentCos).equals(other$tencentCos)) {
            return false;
        }
        List<? extends BaiduBosConfig> this$baiduBos = this.getBaiduBos();
        List<? extends BaiduBosConfig> other$baiduBos = other.getBaiduBos();
        if (this$baiduBos == null ? other$baiduBos != null : !((Object)this$baiduBos).equals(other$baiduBos)) {
            return false;
        }
        List<? extends UpyunUssConfig> this$upyunUss = this.getUpyunUss();
        List<? extends UpyunUssConfig> other$upyunUss = other.getUpyunUss();
        if (this$upyunUss == null ? other$upyunUss != null : !((Object)this$upyunUss).equals(other$upyunUss)) {
            return false;
        }
        List<? extends MinioConfig> this$minio = this.getMinio();
        List<? extends MinioConfig> other$minio = other.getMinio();
        if (this$minio == null ? other$minio != null : !((Object)this$minio).equals(other$minio)) {
            return false;
        }
        List<? extends AmazonS3Config> this$amazonS3 = this.getAmazonS3();
        List<? extends AmazonS3Config> other$amazonS3 = other.getAmazonS3();
        if (this$amazonS3 == null ? other$amazonS3 != null : !((Object)this$amazonS3).equals(other$amazonS3)) {
            return false;
        }
        List<? extends FtpConfig> this$ftp = this.getFtp();
        List<? extends FtpConfig> other$ftp = other.getFtp();
        if (this$ftp == null ? other$ftp != null : !((Object)this$ftp).equals(other$ftp)) {
            return false;
        }
        List<? extends SftpConfig> this$sftp = this.getSftp();
        List<? extends SftpConfig> other$sftp = other.getSftp();
        if (this$sftp == null ? other$sftp != null : !((Object)this$sftp).equals(other$sftp)) {
            return false;
        }
        List<? extends WebDavConfig> this$webdav = this.getWebdav();
        List<? extends WebDavConfig> other$webdav = other.getWebdav();
        if (this$webdav == null ? other$webdav != null : !((Object)this$webdav).equals(other$webdav)) {
            return false;
        }
        List<? extends GoogleCloudStorageConfig> this$googleCloudStorage = this.getGoogleCloudStorage();
        List<? extends GoogleCloudStorageConfig> other$googleCloudStorage = other.getGoogleCloudStorage();
        if (this$googleCloudStorage == null ? other$googleCloudStorage != null : !((Object)this$googleCloudStorage).equals(other$googleCloudStorage)) {
            return false;
        }
        List<? extends FastDfsConfig> this$fastdfs = this.getFastdfs();
        List<? extends FastDfsConfig> other$fastdfs = other.getFastdfs();
        if (this$fastdfs == null ? other$fastdfs != null : !((Object)this$fastdfs).equals(other$fastdfs)) {
            return false;
        }
        List<? extends AzureBlobStorageConfig> this$azureBlob = this.getAzureBlob();
        List<? extends AzureBlobStorageConfig> other$azureBlob = other.getAzureBlob();
        return !(this$azureBlob == null ? other$azureBlob != null : !((Object)this$azureBlob).equals(other$azureBlob));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FileStorageProperties;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $uploadNotSupportMetadataThrowException = this.getUploadNotSupportMetadataThrowException();
        result = result * 59 + ($uploadNotSupportMetadataThrowException == null ? 43 : ((Object)$uploadNotSupportMetadataThrowException).hashCode());
        Boolean $uploadNotSupportAclThrowException = this.getUploadNotSupportAclThrowException();
        result = result * 59 + ($uploadNotSupportAclThrowException == null ? 43 : ((Object)$uploadNotSupportAclThrowException).hashCode());
        Boolean $copyNotSupportMetadataThrowException = this.getCopyNotSupportMetadataThrowException();
        result = result * 59 + ($copyNotSupportMetadataThrowException == null ? 43 : ((Object)$copyNotSupportMetadataThrowException).hashCode());
        Boolean $copyNotSupportAclThrowException = this.getCopyNotSupportAclThrowException();
        result = result * 59 + ($copyNotSupportAclThrowException == null ? 43 : ((Object)$copyNotSupportAclThrowException).hashCode());
        Boolean $moveNotSupportMetadataThrowException = this.getMoveNotSupportMetadataThrowException();
        result = result * 59 + ($moveNotSupportMetadataThrowException == null ? 43 : ((Object)$moveNotSupportMetadataThrowException).hashCode());
        Boolean $moveNotSupportAclThrowException = this.getMoveNotSupportAclThrowException();
        result = result * 59 + ($moveNotSupportAclThrowException == null ? 43 : ((Object)$moveNotSupportAclThrowException).hashCode());
        String $defaultPlatform = this.getDefaultPlatform();
        result = result * 59 + ($defaultPlatform == null ? 43 : $defaultPlatform.hashCode());
        String $thumbnailSuffix = this.getThumbnailSuffix();
        result = result * 59 + ($thumbnailSuffix == null ? 43 : $thumbnailSuffix.hashCode());
        List<? extends LocalConfig> $local = this.getLocal();
        result = result * 59 + ($local == null ? 43 : ((Object)$local).hashCode());
        List<? extends LocalPlusConfig> $localPlus = this.getLocalPlus();
        result = result * 59 + ($localPlus == null ? 43 : ((Object)$localPlus).hashCode());
        List<? extends HuaweiObsConfig> $huaweiObs = this.getHuaweiObs();
        result = result * 59 + ($huaweiObs == null ? 43 : ((Object)$huaweiObs).hashCode());
        List<? extends AliyunOssConfig> $aliyunOss = this.getAliyunOss();
        result = result * 59 + ($aliyunOss == null ? 43 : ((Object)$aliyunOss).hashCode());
        List<? extends QiniuKodoConfig> $qiniuKodo = this.getQiniuKodo();
        result = result * 59 + ($qiniuKodo == null ? 43 : ((Object)$qiniuKodo).hashCode());
        List<? extends TencentCosConfig> $tencentCos = this.getTencentCos();
        result = result * 59 + ($tencentCos == null ? 43 : ((Object)$tencentCos).hashCode());
        List<? extends BaiduBosConfig> $baiduBos = this.getBaiduBos();
        result = result * 59 + ($baiduBos == null ? 43 : ((Object)$baiduBos).hashCode());
        List<? extends UpyunUssConfig> $upyunUss = this.getUpyunUss();
        result = result * 59 + ($upyunUss == null ? 43 : ((Object)$upyunUss).hashCode());
        List<? extends MinioConfig> $minio = this.getMinio();
        result = result * 59 + ($minio == null ? 43 : ((Object)$minio).hashCode());
        List<? extends AmazonS3Config> $amazonS3 = this.getAmazonS3();
        result = result * 59 + ($amazonS3 == null ? 43 : ((Object)$amazonS3).hashCode());
        List<? extends FtpConfig> $ftp = this.getFtp();
        result = result * 59 + ($ftp == null ? 43 : ((Object)$ftp).hashCode());
        List<? extends SftpConfig> $sftp = this.getSftp();
        result = result * 59 + ($sftp == null ? 43 : ((Object)$sftp).hashCode());
        List<? extends WebDavConfig> $webdav = this.getWebdav();
        result = result * 59 + ($webdav == null ? 43 : ((Object)$webdav).hashCode());
        List<? extends GoogleCloudStorageConfig> $googleCloudStorage = this.getGoogleCloudStorage();
        result = result * 59 + ($googleCloudStorage == null ? 43 : ((Object)$googleCloudStorage).hashCode());
        List<? extends FastDfsConfig> $fastdfs = this.getFastdfs();
        result = result * 59 + ($fastdfs == null ? 43 : ((Object)$fastdfs).hashCode());
        List<? extends AzureBlobStorageConfig> $azureBlob = this.getAzureBlob();
        result = result * 59 + ($azureBlob == null ? 43 : ((Object)$azureBlob).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "FileStorageProperties(defaultPlatform=" + this.defaultPlatform + ", thumbnailSuffix=" + this.thumbnailSuffix + ", uploadNotSupportMetadataThrowException=" + this.uploadNotSupportMetadataThrowException + ", uploadNotSupportAclThrowException=" + this.uploadNotSupportAclThrowException + ", copyNotSupportMetadataThrowException=" + this.copyNotSupportMetadataThrowException + ", copyNotSupportAclThrowException=" + this.copyNotSupportAclThrowException + ", moveNotSupportMetadataThrowException=" + this.moveNotSupportMetadataThrowException + ", moveNotSupportAclThrowException=" + this.moveNotSupportAclThrowException + ", local=" + this.local + ", localPlus=" + this.localPlus + ", huaweiObs=" + this.huaweiObs + ", aliyunOss=" + this.aliyunOss + ", qiniuKodo=" + this.qiniuKodo + ", tencentCos=" + this.tencentCos + ", baiduBos=" + this.baiduBos + ", upyunUss=" + this.upyunUss + ", minio=" + this.minio + ", amazonS3=" + this.amazonS3 + ", ftp=" + this.ftp + ", sftp=" + this.sftp + ", webdav=" + this.webdav + ", googleCloudStorage=" + this.googleCloudStorage + ", fastdfs=" + this.fastdfs + ", azureBlob=" + this.azureBlob + ")";
    }

    public static class CommonClientPoolConfig {
        private Boolean testOnBorrow = true;
        private Boolean testWhileIdle = true;
        private Integer maxTotal = 16;
        private Integer maxIdle = 4;
        private Integer minIdle = 1;
        private Duration timeBetweenEvictionRuns = Duration.ofSeconds(30L);
        private Duration minEvictableIdleDuration = Duration.ofMillis(-1L);
        private Duration softMinEvictableIdleDuration = Duration.ofMillis(30L);

        public <T> GenericObjectPoolConfig<T> toGenericObjectPoolConfig() {
            GenericObjectPoolConfig config = new GenericObjectPoolConfig();
            config.setTestOnBorrow(this.testOnBorrow.booleanValue());
            config.setTestWhileIdle(this.testWhileIdle.booleanValue());
            config.setMaxTotal(this.maxTotal.intValue());
            config.setMinIdle(this.minIdle.intValue());
            config.setMaxIdle(this.maxIdle.intValue());
            config.setTimeBetweenEvictionRuns(this.timeBetweenEvictionRuns);
            config.setMinEvictableIdleTime(this.minEvictableIdleDuration);
            config.setSoftMinEvictableIdleTime(this.softMinEvictableIdleDuration);
            return config;
        }

        @Generated
        public CommonClientPoolConfig() {
        }

        @Generated
        public Boolean getTestOnBorrow() {
            return this.testOnBorrow;
        }

        @Generated
        public Boolean getTestWhileIdle() {
            return this.testWhileIdle;
        }

        @Generated
        public Integer getMaxTotal() {
            return this.maxTotal;
        }

        @Generated
        public Integer getMaxIdle() {
            return this.maxIdle;
        }

        @Generated
        public Integer getMinIdle() {
            return this.minIdle;
        }

        @Generated
        public Duration getTimeBetweenEvictionRuns() {
            return this.timeBetweenEvictionRuns;
        }

        @Generated
        public Duration getMinEvictableIdleDuration() {
            return this.minEvictableIdleDuration;
        }

        @Generated
        public Duration getSoftMinEvictableIdleDuration() {
            return this.softMinEvictableIdleDuration;
        }

        @Generated
        public CommonClientPoolConfig setTestOnBorrow(Boolean testOnBorrow) {
            this.testOnBorrow = testOnBorrow;
            return this;
        }

        @Generated
        public CommonClientPoolConfig setTestWhileIdle(Boolean testWhileIdle) {
            this.testWhileIdle = testWhileIdle;
            return this;
        }

        @Generated
        public CommonClientPoolConfig setMaxTotal(Integer maxTotal) {
            this.maxTotal = maxTotal;
            return this;
        }

        @Generated
        public CommonClientPoolConfig setMaxIdle(Integer maxIdle) {
            this.maxIdle = maxIdle;
            return this;
        }

        @Generated
        public CommonClientPoolConfig setMinIdle(Integer minIdle) {
            this.minIdle = minIdle;
            return this;
        }

        @Generated
        public CommonClientPoolConfig setTimeBetweenEvictionRuns(Duration timeBetweenEvictionRuns) {
            this.timeBetweenEvictionRuns = timeBetweenEvictionRuns;
            return this;
        }

        @Generated
        public CommonClientPoolConfig setMinEvictableIdleDuration(Duration minEvictableIdleDuration) {
            this.minEvictableIdleDuration = minEvictableIdleDuration;
            return this;
        }

        @Generated
        public CommonClientPoolConfig setSoftMinEvictableIdleDuration(Duration softMinEvictableIdleDuration) {
            this.softMinEvictableIdleDuration = softMinEvictableIdleDuration;
            return this;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CommonClientPoolConfig)) {
                return false;
            }
            CommonClientPoolConfig other = (CommonClientPoolConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$testOnBorrow = this.getTestOnBorrow();
            Boolean other$testOnBorrow = other.getTestOnBorrow();
            if (this$testOnBorrow == null ? other$testOnBorrow != null : !((Object)this$testOnBorrow).equals(other$testOnBorrow)) {
                return false;
            }
            Boolean this$testWhileIdle = this.getTestWhileIdle();
            Boolean other$testWhileIdle = other.getTestWhileIdle();
            if (this$testWhileIdle == null ? other$testWhileIdle != null : !((Object)this$testWhileIdle).equals(other$testWhileIdle)) {
                return false;
            }
            Integer this$maxTotal = this.getMaxTotal();
            Integer other$maxTotal = other.getMaxTotal();
            if (this$maxTotal == null ? other$maxTotal != null : !((Object)this$maxTotal).equals(other$maxTotal)) {
                return false;
            }
            Integer this$maxIdle = this.getMaxIdle();
            Integer other$maxIdle = other.getMaxIdle();
            if (this$maxIdle == null ? other$maxIdle != null : !((Object)this$maxIdle).equals(other$maxIdle)) {
                return false;
            }
            Integer this$minIdle = this.getMinIdle();
            Integer other$minIdle = other.getMinIdle();
            if (this$minIdle == null ? other$minIdle != null : !((Object)this$minIdle).equals(other$minIdle)) {
                return false;
            }
            Duration this$timeBetweenEvictionRuns = this.getTimeBetweenEvictionRuns();
            Duration other$timeBetweenEvictionRuns = other.getTimeBetweenEvictionRuns();
            if (this$timeBetweenEvictionRuns == null ? other$timeBetweenEvictionRuns != null : !((Object)this$timeBetweenEvictionRuns).equals(other$timeBetweenEvictionRuns)) {
                return false;
            }
            Duration this$minEvictableIdleDuration = this.getMinEvictableIdleDuration();
            Duration other$minEvictableIdleDuration = other.getMinEvictableIdleDuration();
            if (this$minEvictableIdleDuration == null ? other$minEvictableIdleDuration != null : !((Object)this$minEvictableIdleDuration).equals(other$minEvictableIdleDuration)) {
                return false;
            }
            Duration this$softMinEvictableIdleDuration = this.getSoftMinEvictableIdleDuration();
            Duration other$softMinEvictableIdleDuration = other.getSoftMinEvictableIdleDuration();
            return !(this$softMinEvictableIdleDuration == null ? other$softMinEvictableIdleDuration != null : !((Object)this$softMinEvictableIdleDuration).equals(other$softMinEvictableIdleDuration));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CommonClientPoolConfig;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $testOnBorrow = this.getTestOnBorrow();
            result = result * 59 + ($testOnBorrow == null ? 43 : ((Object)$testOnBorrow).hashCode());
            Boolean $testWhileIdle = this.getTestWhileIdle();
            result = result * 59 + ($testWhileIdle == null ? 43 : ((Object)$testWhileIdle).hashCode());
            Integer $maxTotal = this.getMaxTotal();
            result = result * 59 + ($maxTotal == null ? 43 : ((Object)$maxTotal).hashCode());
            Integer $maxIdle = this.getMaxIdle();
            result = result * 59 + ($maxIdle == null ? 43 : ((Object)$maxIdle).hashCode());
            Integer $minIdle = this.getMinIdle();
            result = result * 59 + ($minIdle == null ? 43 : ((Object)$minIdle).hashCode());
            Duration $timeBetweenEvictionRuns = this.getTimeBetweenEvictionRuns();
            result = result * 59 + ($timeBetweenEvictionRuns == null ? 43 : ((Object)$timeBetweenEvictionRuns).hashCode());
            Duration $minEvictableIdleDuration = this.getMinEvictableIdleDuration();
            result = result * 59 + ($minEvictableIdleDuration == null ? 43 : ((Object)$minEvictableIdleDuration).hashCode());
            Duration $softMinEvictableIdleDuration = this.getSoftMinEvictableIdleDuration();
            result = result * 59 + ($softMinEvictableIdleDuration == null ? 43 : ((Object)$softMinEvictableIdleDuration).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FileStorageProperties.CommonClientPoolConfig(testOnBorrow=" + this.testOnBorrow + ", testWhileIdle=" + this.testWhileIdle + ", maxTotal=" + this.maxTotal + ", maxIdle=" + this.maxIdle + ", minIdle=" + this.minIdle + ", timeBetweenEvictionRuns=" + this.timeBetweenEvictionRuns + ", minEvictableIdleDuration=" + this.minEvictableIdleDuration + ", softMinEvictableIdleDuration=" + this.softMinEvictableIdleDuration + ")";
        }
    }

    public static class AzureBlobStorageConfig
    extends BaseConfig {
        private String endPoint;
        private String domain = "";
        private String containerName;
        private String basePath = "";
        private String defaultAcl;
        private String connectionString;
        private long multipartThreshold = 0x10000000L;
        private long multipartPartSize = 0x400000L;
        private int maxConcurrency = 8;
        private Map<String, String> methodToPermissionMap = MapBuilder.create(new HashMap()).put((Object)"GET", (Object)"r").put((Object)"PUT", (Object)"w").put((Object)"DELETE", (Object)"d").build();
        private Map<String, Object> attr = new LinkedHashMap<String, Object>();

        @Generated
        public AzureBlobStorageConfig() {
        }

        @Generated
        public String getEndPoint() {
            return this.endPoint;
        }

        @Generated
        public String getDomain() {
            return this.domain;
        }

        @Generated
        public String getContainerName() {
            return this.containerName;
        }

        @Generated
        public String getBasePath() {
            return this.basePath;
        }

        @Generated
        public String getDefaultAcl() {
            return this.defaultAcl;
        }

        @Generated
        public String getConnectionString() {
            return this.connectionString;
        }

        @Generated
        public long getMultipartThreshold() {
            return this.multipartThreshold;
        }

        @Generated
        public long getMultipartPartSize() {
            return this.multipartPartSize;
        }

        @Generated
        public int getMaxConcurrency() {
            return this.maxConcurrency;
        }

        @Generated
        public Map<String, String> getMethodToPermissionMap() {
            return this.methodToPermissionMap;
        }

        @Generated
        public Map<String, Object> getAttr() {
            return this.attr;
        }

        @Generated
        public AzureBlobStorageConfig setEndPoint(String endPoint) {
            this.endPoint = endPoint;
            return this;
        }

        @Generated
        public AzureBlobStorageConfig setDomain(String domain) {
            this.domain = domain;
            return this;
        }

        @Generated
        public AzureBlobStorageConfig setContainerName(String containerName) {
            this.containerName = containerName;
            return this;
        }

        @Generated
        public AzureBlobStorageConfig setBasePath(String basePath) {
            this.basePath = basePath;
            return this;
        }

        @Generated
        public AzureBlobStorageConfig setDefaultAcl(String defaultAcl) {
            this.defaultAcl = defaultAcl;
            return this;
        }

        @Generated
        public AzureBlobStorageConfig setConnectionString(String connectionString) {
            this.connectionString = connectionString;
            return this;
        }

        @Generated
        public AzureBlobStorageConfig setMultipartThreshold(long multipartThreshold) {
            this.multipartThreshold = multipartThreshold;
            return this;
        }

        @Generated
        public AzureBlobStorageConfig setMultipartPartSize(long multipartPartSize) {
            this.multipartPartSize = multipartPartSize;
            return this;
        }

        @Generated
        public AzureBlobStorageConfig setMaxConcurrency(int maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
            return this;
        }

        @Generated
        public AzureBlobStorageConfig setMethodToPermissionMap(Map<String, String> methodToPermissionMap) {
            this.methodToPermissionMap = methodToPermissionMap;
            return this;
        }

        @Generated
        public AzureBlobStorageConfig setAttr(Map<String, Object> attr) {
            this.attr = attr;
            return this;
        }

        @Override
        @Generated
        public String toString() {
            return "FileStorageProperties.AzureBlobStorageConfig(super=" + super.toString() + ", endPoint=" + this.endPoint + ", domain=" + this.domain + ", containerName=" + this.containerName + ", basePath=" + this.basePath + ", defaultAcl=" + this.defaultAcl + ", connectionString=" + this.connectionString + ", multipartThreshold=" + this.multipartThreshold + ", multipartPartSize=" + this.multipartPartSize + ", maxConcurrency=" + this.maxConcurrency + ", methodToPermissionMap=" + this.methodToPermissionMap + ", attr=" + this.attr + ")";
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AzureBlobStorageConfig)) {
                return false;
            }
            AzureBlobStorageConfig other = (AzureBlobStorageConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            if (this.getMultipartThreshold() != other.getMultipartThreshold()) {
                return false;
            }
            if (this.getMultipartPartSize() != other.getMultipartPartSize()) {
                return false;
            }
            if (this.getMaxConcurrency() != other.getMaxConcurrency()) {
                return false;
            }
            String this$endPoint = this.getEndPoint();
            String other$endPoint = other.getEndPoint();
            if (this$endPoint == null ? other$endPoint != null : !this$endPoint.equals(other$endPoint)) {
                return false;
            }
            String this$domain = this.getDomain();
            String other$domain = other.getDomain();
            if (this$domain == null ? other$domain != null : !this$domain.equals(other$domain)) {
                return false;
            }
            String this$containerName = this.getContainerName();
            String other$containerName = other.getContainerName();
            if (this$containerName == null ? other$containerName != null : !this$containerName.equals(other$containerName)) {
                return false;
            }
            String this$basePath = this.getBasePath();
            String other$basePath = other.getBasePath();
            if (this$basePath == null ? other$basePath != null : !this$basePath.equals(other$basePath)) {
                return false;
            }
            String this$defaultAcl = this.getDefaultAcl();
            String other$defaultAcl = other.getDefaultAcl();
            if (this$defaultAcl == null ? other$defaultAcl != null : !this$defaultAcl.equals(other$defaultAcl)) {
                return false;
            }
            String this$connectionString = this.getConnectionString();
            String other$connectionString = other.getConnectionString();
            if (this$connectionString == null ? other$connectionString != null : !this$connectionString.equals(other$connectionString)) {
                return false;
            }
            Map<String, String> this$methodToPermissionMap = this.getMethodToPermissionMap();
            Map<String, String> other$methodToPermissionMap = other.getMethodToPermissionMap();
            if (this$methodToPermissionMap == null ? other$methodToPermissionMap != null : !((Object)this$methodToPermissionMap).equals(other$methodToPermissionMap)) {
                return false;
            }
            Map<String, Object> this$attr = this.getAttr();
            Map<String, Object> other$attr = other.getAttr();
            return !(this$attr == null ? other$attr != null : !((Object)this$attr).equals(other$attr));
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AzureBlobStorageConfig;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            long $multipartThreshold = this.getMultipartThreshold();
            result = result * 59 + (int)($multipartThreshold >>> 32 ^ $multipartThreshold);
            long $multipartPartSize = this.getMultipartPartSize();
            result = result * 59 + (int)($multipartPartSize >>> 32 ^ $multipartPartSize);
            result = result * 59 + this.getMaxConcurrency();
            String $endPoint = this.getEndPoint();
            result = result * 59 + ($endPoint == null ? 43 : $endPoint.hashCode());
            String $domain = this.getDomain();
            result = result * 59 + ($domain == null ? 43 : $domain.hashCode());
            String $containerName = this.getContainerName();
            result = result * 59 + ($containerName == null ? 43 : $containerName.hashCode());
            String $basePath = this.getBasePath();
            result = result * 59 + ($basePath == null ? 43 : $basePath.hashCode());
            String $defaultAcl = this.getDefaultAcl();
            result = result * 59 + ($defaultAcl == null ? 43 : $defaultAcl.hashCode());
            String $connectionString = this.getConnectionString();
            result = result * 59 + ($connectionString == null ? 43 : $connectionString.hashCode());
            Map<String, String> $methodToPermissionMap = this.getMethodToPermissionMap();
            result = result * 59 + ($methodToPermissionMap == null ? 43 : ((Object)$methodToPermissionMap).hashCode());
            Map<String, Object> $attr = this.getAttr();
            result = result * 59 + ($attr == null ? 43 : ((Object)$attr).hashCode());
            return result;
        }
    }

    public static class FastDfsConfig
    extends BaseConfig {
        private RunMod runMod = RunMod.COVER;
        private FastDfsTrackerServer trackerServer;
        private FastDfsStorageServer storageServer;
        private FastDfsExtra extra;
        private String domain = "";
        private String basePath = "";
        private int multipartThreshold = 0x8000000;
        private int multipartPartSize = 0x2000000;
        private Map<String, Object> attr = new LinkedHashMap<String, Object>();

        public String getGroupName() {
            return Optional.ofNullable(this.extra).map(FastDfsExtra::getGroupName).orElse("");
        }

        @Generated
        public FastDfsConfig() {
        }

        @Generated
        public RunMod getRunMod() {
            return this.runMod;
        }

        @Generated
        public FastDfsTrackerServer getTrackerServer() {
            return this.trackerServer;
        }

        @Generated
        public FastDfsStorageServer getStorageServer() {
            return this.storageServer;
        }

        @Generated
        public FastDfsExtra getExtra() {
            return this.extra;
        }

        @Generated
        public String getDomain() {
            return this.domain;
        }

        @Generated
        public String getBasePath() {
            return this.basePath;
        }

        @Generated
        public int getMultipartThreshold() {
            return this.multipartThreshold;
        }

        @Generated
        public int getMultipartPartSize() {
            return this.multipartPartSize;
        }

        @Generated
        public Map<String, Object> getAttr() {
            return this.attr;
        }

        @Generated
        public FastDfsConfig setRunMod(RunMod runMod) {
            this.runMod = runMod;
            return this;
        }

        @Generated
        public FastDfsConfig setTrackerServer(FastDfsTrackerServer trackerServer) {
            this.trackerServer = trackerServer;
            return this;
        }

        @Generated
        public FastDfsConfig setStorageServer(FastDfsStorageServer storageServer) {
            this.storageServer = storageServer;
            return this;
        }

        @Generated
        public FastDfsConfig setExtra(FastDfsExtra extra) {
            this.extra = extra;
            return this;
        }

        @Generated
        public FastDfsConfig setDomain(String domain) {
            this.domain = domain;
            return this;
        }

        @Generated
        public FastDfsConfig setBasePath(String basePath) {
            this.basePath = basePath;
            return this;
        }

        @Generated
        public FastDfsConfig setMultipartThreshold(int multipartThreshold) {
            this.multipartThreshold = multipartThreshold;
            return this;
        }

        @Generated
        public FastDfsConfig setMultipartPartSize(int multipartPartSize) {
            this.multipartPartSize = multipartPartSize;
            return this;
        }

        @Generated
        public FastDfsConfig setAttr(Map<String, Object> attr) {
            this.attr = attr;
            return this;
        }

        @Override
        @Generated
        public String toString() {
            return "FileStorageProperties.FastDfsConfig(super=" + super.toString() + ", runMod=" + (Object)((Object)this.runMod) + ", trackerServer=" + this.trackerServer + ", storageServer=" + this.storageServer + ", extra=" + this.extra + ", domain=" + this.domain + ", basePath=" + this.basePath + ", multipartThreshold=" + this.multipartThreshold + ", multipartPartSize=" + this.multipartPartSize + ", attr=" + this.attr + ")";
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FastDfsConfig)) {
                return false;
            }
            FastDfsConfig other = (FastDfsConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            if (this.getMultipartThreshold() != other.getMultipartThreshold()) {
                return false;
            }
            if (this.getMultipartPartSize() != other.getMultipartPartSize()) {
                return false;
            }
            RunMod this$runMod = this.getRunMod();
            RunMod other$runMod = other.getRunMod();
            if (this$runMod == null ? other$runMod != null : !((Object)((Object)this$runMod)).equals((Object)other$runMod)) {
                return false;
            }
            FastDfsTrackerServer this$trackerServer = this.getTrackerServer();
            FastDfsTrackerServer other$trackerServer = other.getTrackerServer();
            if (this$trackerServer == null ? other$trackerServer != null : !((Object)this$trackerServer).equals(other$trackerServer)) {
                return false;
            }
            FastDfsStorageServer this$storageServer = this.getStorageServer();
            FastDfsStorageServer other$storageServer = other.getStorageServer();
            if (this$storageServer == null ? other$storageServer != null : !((Object)this$storageServer).equals(other$storageServer)) {
                return false;
            }
            FastDfsExtra this$extra = this.getExtra();
            FastDfsExtra other$extra = other.getExtra();
            if (this$extra == null ? other$extra != null : !((Object)this$extra).equals(other$extra)) {
                return false;
            }
            String this$domain = this.getDomain();
            String other$domain = other.getDomain();
            if (this$domain == null ? other$domain != null : !this$domain.equals(other$domain)) {
                return false;
            }
            String this$basePath = this.getBasePath();
            String other$basePath = other.getBasePath();
            if (this$basePath == null ? other$basePath != null : !this$basePath.equals(other$basePath)) {
                return false;
            }
            Map<String, Object> this$attr = this.getAttr();
            Map<String, Object> other$attr = other.getAttr();
            return !(this$attr == null ? other$attr != null : !((Object)this$attr).equals(other$attr));
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof FastDfsConfig;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            result = result * 59 + this.getMultipartThreshold();
            result = result * 59 + this.getMultipartPartSize();
            RunMod $runMod = this.getRunMod();
            result = result * 59 + ($runMod == null ? 43 : ((Object)((Object)$runMod)).hashCode());
            FastDfsTrackerServer $trackerServer = this.getTrackerServer();
            result = result * 59 + ($trackerServer == null ? 43 : ((Object)$trackerServer).hashCode());
            FastDfsStorageServer $storageServer = this.getStorageServer();
            result = result * 59 + ($storageServer == null ? 43 : ((Object)$storageServer).hashCode());
            FastDfsExtra $extra = this.getExtra();
            result = result * 59 + ($extra == null ? 43 : ((Object)$extra).hashCode());
            String $domain = this.getDomain();
            result = result * 59 + ($domain == null ? 43 : $domain.hashCode());
            String $basePath = this.getBasePath();
            result = result * 59 + ($basePath == null ? 43 : $basePath.hashCode());
            Map<String, Object> $attr = this.getAttr();
            result = result * 59 + ($attr == null ? 43 : ((Object)$attr).hashCode());
            return result;
        }

        public static class FastDfsExtra {
            private String groupName = "";
            private Integer connectTimeoutInSeconds = 5;
            private Integer networkTimeoutInSeconds = 30;
            private Charset charset = StandardCharsets.UTF_8;
            private Boolean httpAntiStealToken = false;
            private String httpSecretKey = "FastDFS1234567890";
            private Boolean connectionPoolEnabled = true;
            private Integer connectionPoolMaxCountPerEntry = 100;
            private Integer connectionPoolMaxIdleTime = 3600;
            private Integer connectionPoolMaxWaitTimeInMs = 1000;

            @Generated
            public FastDfsExtra() {
            }

            @Generated
            public String getGroupName() {
                return this.groupName;
            }

            @Generated
            public Integer getConnectTimeoutInSeconds() {
                return this.connectTimeoutInSeconds;
            }

            @Generated
            public Integer getNetworkTimeoutInSeconds() {
                return this.networkTimeoutInSeconds;
            }

            @Generated
            public Charset getCharset() {
                return this.charset;
            }

            @Generated
            public Boolean getHttpAntiStealToken() {
                return this.httpAntiStealToken;
            }

            @Generated
            public String getHttpSecretKey() {
                return this.httpSecretKey;
            }

            @Generated
            public Boolean getConnectionPoolEnabled() {
                return this.connectionPoolEnabled;
            }

            @Generated
            public Integer getConnectionPoolMaxCountPerEntry() {
                return this.connectionPoolMaxCountPerEntry;
            }

            @Generated
            public Integer getConnectionPoolMaxIdleTime() {
                return this.connectionPoolMaxIdleTime;
            }

            @Generated
            public Integer getConnectionPoolMaxWaitTimeInMs() {
                return this.connectionPoolMaxWaitTimeInMs;
            }

            @Generated
            public FastDfsExtra setGroupName(String groupName) {
                this.groupName = groupName;
                return this;
            }

            @Generated
            public FastDfsExtra setConnectTimeoutInSeconds(Integer connectTimeoutInSeconds) {
                this.connectTimeoutInSeconds = connectTimeoutInSeconds;
                return this;
            }

            @Generated
            public FastDfsExtra setNetworkTimeoutInSeconds(Integer networkTimeoutInSeconds) {
                this.networkTimeoutInSeconds = networkTimeoutInSeconds;
                return this;
            }

            @Generated
            public FastDfsExtra setCharset(Charset charset) {
                this.charset = charset;
                return this;
            }

            @Generated
            public FastDfsExtra setHttpAntiStealToken(Boolean httpAntiStealToken) {
                this.httpAntiStealToken = httpAntiStealToken;
                return this;
            }

            @Generated
            public FastDfsExtra setHttpSecretKey(String httpSecretKey) {
                this.httpSecretKey = httpSecretKey;
                return this;
            }

            @Generated
            public FastDfsExtra setConnectionPoolEnabled(Boolean connectionPoolEnabled) {
                this.connectionPoolEnabled = connectionPoolEnabled;
                return this;
            }

            @Generated
            public FastDfsExtra setConnectionPoolMaxCountPerEntry(Integer connectionPoolMaxCountPerEntry) {
                this.connectionPoolMaxCountPerEntry = connectionPoolMaxCountPerEntry;
                return this;
            }

            @Generated
            public FastDfsExtra setConnectionPoolMaxIdleTime(Integer connectionPoolMaxIdleTime) {
                this.connectionPoolMaxIdleTime = connectionPoolMaxIdleTime;
                return this;
            }

            @Generated
            public FastDfsExtra setConnectionPoolMaxWaitTimeInMs(Integer connectionPoolMaxWaitTimeInMs) {
                this.connectionPoolMaxWaitTimeInMs = connectionPoolMaxWaitTimeInMs;
                return this;
            }

            @Generated
            public String toString() {
                return "FileStorageProperties.FastDfsConfig.FastDfsExtra(groupName=" + this.groupName + ", connectTimeoutInSeconds=" + this.connectTimeoutInSeconds + ", networkTimeoutInSeconds=" + this.networkTimeoutInSeconds + ", charset=" + this.charset + ", httpAntiStealToken=" + this.httpAntiStealToken + ", httpSecretKey=" + this.httpSecretKey + ", connectionPoolEnabled=" + this.connectionPoolEnabled + ", connectionPoolMaxCountPerEntry=" + this.connectionPoolMaxCountPerEntry + ", connectionPoolMaxIdleTime=" + this.connectionPoolMaxIdleTime + ", connectionPoolMaxWaitTimeInMs=" + this.connectionPoolMaxWaitTimeInMs + ")";
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof FastDfsExtra)) {
                    return false;
                }
                FastDfsExtra other = (FastDfsExtra)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Integer this$connectTimeoutInSeconds = this.getConnectTimeoutInSeconds();
                Integer other$connectTimeoutInSeconds = other.getConnectTimeoutInSeconds();
                if (this$connectTimeoutInSeconds == null ? other$connectTimeoutInSeconds != null : !((Object)this$connectTimeoutInSeconds).equals(other$connectTimeoutInSeconds)) {
                    return false;
                }
                Integer this$networkTimeoutInSeconds = this.getNetworkTimeoutInSeconds();
                Integer other$networkTimeoutInSeconds = other.getNetworkTimeoutInSeconds();
                if (this$networkTimeoutInSeconds == null ? other$networkTimeoutInSeconds != null : !((Object)this$networkTimeoutInSeconds).equals(other$networkTimeoutInSeconds)) {
                    return false;
                }
                Boolean this$httpAntiStealToken = this.getHttpAntiStealToken();
                Boolean other$httpAntiStealToken = other.getHttpAntiStealToken();
                if (this$httpAntiStealToken == null ? other$httpAntiStealToken != null : !((Object)this$httpAntiStealToken).equals(other$httpAntiStealToken)) {
                    return false;
                }
                Boolean this$connectionPoolEnabled = this.getConnectionPoolEnabled();
                Boolean other$connectionPoolEnabled = other.getConnectionPoolEnabled();
                if (this$connectionPoolEnabled == null ? other$connectionPoolEnabled != null : !((Object)this$connectionPoolEnabled).equals(other$connectionPoolEnabled)) {
                    return false;
                }
                Integer this$connectionPoolMaxCountPerEntry = this.getConnectionPoolMaxCountPerEntry();
                Integer other$connectionPoolMaxCountPerEntry = other.getConnectionPoolMaxCountPerEntry();
                if (this$connectionPoolMaxCountPerEntry == null ? other$connectionPoolMaxCountPerEntry != null : !((Object)this$connectionPoolMaxCountPerEntry).equals(other$connectionPoolMaxCountPerEntry)) {
                    return false;
                }
                Integer this$connectionPoolMaxIdleTime = this.getConnectionPoolMaxIdleTime();
                Integer other$connectionPoolMaxIdleTime = other.getConnectionPoolMaxIdleTime();
                if (this$connectionPoolMaxIdleTime == null ? other$connectionPoolMaxIdleTime != null : !((Object)this$connectionPoolMaxIdleTime).equals(other$connectionPoolMaxIdleTime)) {
                    return false;
                }
                Integer this$connectionPoolMaxWaitTimeInMs = this.getConnectionPoolMaxWaitTimeInMs();
                Integer other$connectionPoolMaxWaitTimeInMs = other.getConnectionPoolMaxWaitTimeInMs();
                if (this$connectionPoolMaxWaitTimeInMs == null ? other$connectionPoolMaxWaitTimeInMs != null : !((Object)this$connectionPoolMaxWaitTimeInMs).equals(other$connectionPoolMaxWaitTimeInMs)) {
                    return false;
                }
                String this$groupName = this.getGroupName();
                String other$groupName = other.getGroupName();
                if (this$groupName == null ? other$groupName != null : !this$groupName.equals(other$groupName)) {
                    return false;
                }
                Charset this$charset = this.getCharset();
                Charset other$charset = other.getCharset();
                if (this$charset == null ? other$charset != null : !((Object)this$charset).equals(other$charset)) {
                    return false;
                }
                String this$httpSecretKey = this.getHttpSecretKey();
                String other$httpSecretKey = other.getHttpSecretKey();
                return !(this$httpSecretKey == null ? other$httpSecretKey != null : !this$httpSecretKey.equals(other$httpSecretKey));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof FastDfsExtra;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Integer $connectTimeoutInSeconds = this.getConnectTimeoutInSeconds();
                result = result * 59 + ($connectTimeoutInSeconds == null ? 43 : ((Object)$connectTimeoutInSeconds).hashCode());
                Integer $networkTimeoutInSeconds = this.getNetworkTimeoutInSeconds();
                result = result * 59 + ($networkTimeoutInSeconds == null ? 43 : ((Object)$networkTimeoutInSeconds).hashCode());
                Boolean $httpAntiStealToken = this.getHttpAntiStealToken();
                result = result * 59 + ($httpAntiStealToken == null ? 43 : ((Object)$httpAntiStealToken).hashCode());
                Boolean $connectionPoolEnabled = this.getConnectionPoolEnabled();
                result = result * 59 + ($connectionPoolEnabled == null ? 43 : ((Object)$connectionPoolEnabled).hashCode());
                Integer $connectionPoolMaxCountPerEntry = this.getConnectionPoolMaxCountPerEntry();
                result = result * 59 + ($connectionPoolMaxCountPerEntry == null ? 43 : ((Object)$connectionPoolMaxCountPerEntry).hashCode());
                Integer $connectionPoolMaxIdleTime = this.getConnectionPoolMaxIdleTime();
                result = result * 59 + ($connectionPoolMaxIdleTime == null ? 43 : ((Object)$connectionPoolMaxIdleTime).hashCode());
                Integer $connectionPoolMaxWaitTimeInMs = this.getConnectionPoolMaxWaitTimeInMs();
                result = result * 59 + ($connectionPoolMaxWaitTimeInMs == null ? 43 : ((Object)$connectionPoolMaxWaitTimeInMs).hashCode());
                String $groupName = this.getGroupName();
                result = result * 59 + ($groupName == null ? 43 : $groupName.hashCode());
                Charset $charset = this.getCharset();
                result = result * 59 + ($charset == null ? 43 : ((Object)$charset).hashCode());
                String $httpSecretKey = this.getHttpSecretKey();
                result = result * 59 + ($httpSecretKey == null ? 43 : $httpSecretKey.hashCode());
                return result;
            }
        }

        public static enum RunMod {
            COVER,
            URL;

        }

        public static class FastDfsTrackerServer {
            private String serverAddr;
            private Integer httpPort = 80;

            @Generated
            public FastDfsTrackerServer() {
            }

            @Generated
            public String getServerAddr() {
                return this.serverAddr;
            }

            @Generated
            public Integer getHttpPort() {
                return this.httpPort;
            }

            @Generated
            public FastDfsTrackerServer setServerAddr(String serverAddr) {
                this.serverAddr = serverAddr;
                return this;
            }

            @Generated
            public FastDfsTrackerServer setHttpPort(Integer httpPort) {
                this.httpPort = httpPort;
                return this;
            }

            @Generated
            public String toString() {
                return "FileStorageProperties.FastDfsConfig.FastDfsTrackerServer(serverAddr=" + this.serverAddr + ", httpPort=" + this.httpPort + ")";
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof FastDfsTrackerServer)) {
                    return false;
                }
                FastDfsTrackerServer other = (FastDfsTrackerServer)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Integer this$httpPort = this.getHttpPort();
                Integer other$httpPort = other.getHttpPort();
                if (this$httpPort == null ? other$httpPort != null : !((Object)this$httpPort).equals(other$httpPort)) {
                    return false;
                }
                String this$serverAddr = this.getServerAddr();
                String other$serverAddr = other.getServerAddr();
                return !(this$serverAddr == null ? other$serverAddr != null : !this$serverAddr.equals(other$serverAddr));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof FastDfsTrackerServer;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Integer $httpPort = this.getHttpPort();
                result = result * 59 + ($httpPort == null ? 43 : ((Object)$httpPort).hashCode());
                String $serverAddr = this.getServerAddr();
                result = result * 59 + ($serverAddr == null ? 43 : $serverAddr.hashCode());
                return result;
            }
        }

        public static class FastDfsStorageServer {
            private String serverAddr;
            private Integer storePath = 0;

            @Generated
            public FastDfsStorageServer() {
            }

            @Generated
            public String getServerAddr() {
                return this.serverAddr;
            }

            @Generated
            public Integer getStorePath() {
                return this.storePath;
            }

            @Generated
            public FastDfsStorageServer setServerAddr(String serverAddr) {
                this.serverAddr = serverAddr;
                return this;
            }

            @Generated
            public FastDfsStorageServer setStorePath(Integer storePath) {
                this.storePath = storePath;
                return this;
            }

            @Generated
            public String toString() {
                return "FileStorageProperties.FastDfsConfig.FastDfsStorageServer(serverAddr=" + this.serverAddr + ", storePath=" + this.storePath + ")";
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof FastDfsStorageServer)) {
                    return false;
                }
                FastDfsStorageServer other = (FastDfsStorageServer)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Integer this$storePath = this.getStorePath();
                Integer other$storePath = other.getStorePath();
                if (this$storePath == null ? other$storePath != null : !((Object)this$storePath).equals(other$storePath)) {
                    return false;
                }
                String this$serverAddr = this.getServerAddr();
                String other$serverAddr = other.getServerAddr();
                return !(this$serverAddr == null ? other$serverAddr != null : !this$serverAddr.equals(other$serverAddr));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof FastDfsStorageServer;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Integer $storePath = this.getStorePath();
                result = result * 59 + ($storePath == null ? 43 : ((Object)$storePath).hashCode());
                String $serverAddr = this.getServerAddr();
                result = result * 59 + ($serverAddr == null ? 43 : $serverAddr.hashCode());
                return result;
            }
        }
    }

    public static class GoogleCloudStorageConfig
    extends BaseConfig {
        private String projectId;
        private String credentialsPath;
        private String bucketName;
        private String domain = "";
        private String basePath = "";
        private String defaultAcl;
        private Map<String, Object> attr = new LinkedHashMap<String, Object>();

        @Generated
        public GoogleCloudStorageConfig() {
        }

        @Generated
        public String getProjectId() {
            return this.projectId;
        }

        @Generated
        public String getCredentialsPath() {
            return this.credentialsPath;
        }

        @Generated
        public String getBucketName() {
            return this.bucketName;
        }

        @Generated
        public String getDomain() {
            return this.domain;
        }

        @Generated
        public String getBasePath() {
            return this.basePath;
        }

        @Generated
        public String getDefaultAcl() {
            return this.defaultAcl;
        }

        @Generated
        public Map<String, Object> getAttr() {
            return this.attr;
        }

        @Generated
        public GoogleCloudStorageConfig setProjectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        @Generated
        public GoogleCloudStorageConfig setCredentialsPath(String credentialsPath) {
            this.credentialsPath = credentialsPath;
            return this;
        }

        @Generated
        public GoogleCloudStorageConfig setBucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        @Generated
        public GoogleCloudStorageConfig setDomain(String domain) {
            this.domain = domain;
            return this;
        }

        @Generated
        public GoogleCloudStorageConfig setBasePath(String basePath) {
            this.basePath = basePath;
            return this;
        }

        @Generated
        public GoogleCloudStorageConfig setDefaultAcl(String defaultAcl) {
            this.defaultAcl = defaultAcl;
            return this;
        }

        @Generated
        public GoogleCloudStorageConfig setAttr(Map<String, Object> attr) {
            this.attr = attr;
            return this;
        }

        @Override
        @Generated
        public String toString() {
            return "FileStorageProperties.GoogleCloudStorageConfig(super=" + super.toString() + ", projectId=" + this.projectId + ", credentialsPath=" + this.credentialsPath + ", bucketName=" + this.bucketName + ", domain=" + this.domain + ", basePath=" + this.basePath + ", defaultAcl=" + this.defaultAcl + ", attr=" + this.attr + ")";
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GoogleCloudStorageConfig)) {
                return false;
            }
            GoogleCloudStorageConfig other = (GoogleCloudStorageConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$projectId = this.getProjectId();
            String other$projectId = other.getProjectId();
            if (this$projectId == null ? other$projectId != null : !this$projectId.equals(other$projectId)) {
                return false;
            }
            String this$credentialsPath = this.getCredentialsPath();
            String other$credentialsPath = other.getCredentialsPath();
            if (this$credentialsPath == null ? other$credentialsPath != null : !this$credentialsPath.equals(other$credentialsPath)) {
                return false;
            }
            String this$bucketName = this.getBucketName();
            String other$bucketName = other.getBucketName();
            if (this$bucketName == null ? other$bucketName != null : !this$bucketName.equals(other$bucketName)) {
                return false;
            }
            String this$domain = this.getDomain();
            String other$domain = other.getDomain();
            if (this$domain == null ? other$domain != null : !this$domain.equals(other$domain)) {
                return false;
            }
            String this$basePath = this.getBasePath();
            String other$basePath = other.getBasePath();
            if (this$basePath == null ? other$basePath != null : !this$basePath.equals(other$basePath)) {
                return false;
            }
            String this$defaultAcl = this.getDefaultAcl();
            String other$defaultAcl = other.getDefaultAcl();
            if (this$defaultAcl == null ? other$defaultAcl != null : !this$defaultAcl.equals(other$defaultAcl)) {
                return false;
            }
            Map<String, Object> this$attr = this.getAttr();
            Map<String, Object> other$attr = other.getAttr();
            return !(this$attr == null ? other$attr != null : !((Object)this$attr).equals(other$attr));
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof GoogleCloudStorageConfig;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $projectId = this.getProjectId();
            result = result * 59 + ($projectId == null ? 43 : $projectId.hashCode());
            String $credentialsPath = this.getCredentialsPath();
            result = result * 59 + ($credentialsPath == null ? 43 : $credentialsPath.hashCode());
            String $bucketName = this.getBucketName();
            result = result * 59 + ($bucketName == null ? 43 : $bucketName.hashCode());
            String $domain = this.getDomain();
            result = result * 59 + ($domain == null ? 43 : $domain.hashCode());
            String $basePath = this.getBasePath();
            result = result * 59 + ($basePath == null ? 43 : $basePath.hashCode());
            String $defaultAcl = this.getDefaultAcl();
            result = result * 59 + ($defaultAcl == null ? 43 : $defaultAcl.hashCode());
            Map<String, Object> $attr = this.getAttr();
            result = result * 59 + ($attr == null ? 43 : ((Object)$attr).hashCode());
            return result;
        }
    }

    public static class WebDavConfig
    extends BaseConfig {
        private String server;
        private String user;
        private String password;
        private String domain = "";
        private String basePath = "";
        private String storagePath = "/";
        private Map<String, Object> attr = new LinkedHashMap<String, Object>();

        @Generated
        public WebDavConfig() {
        }

        @Generated
        public String getServer() {
            return this.server;
        }

        @Generated
        public String getUser() {
            return this.user;
        }

        @Generated
        public String getPassword() {
            return this.password;
        }

        @Generated
        public String getDomain() {
            return this.domain;
        }

        @Generated
        public String getBasePath() {
            return this.basePath;
        }

        @Generated
        public String getStoragePath() {
            return this.storagePath;
        }

        @Generated
        public Map<String, Object> getAttr() {
            return this.attr;
        }

        @Generated
        public WebDavConfig setServer(String server) {
            this.server = server;
            return this;
        }

        @Generated
        public WebDavConfig setUser(String user) {
            this.user = user;
            return this;
        }

        @Generated
        public WebDavConfig setPassword(String password) {
            this.password = password;
            return this;
        }

        @Generated
        public WebDavConfig setDomain(String domain) {
            this.domain = domain;
            return this;
        }

        @Generated
        public WebDavConfig setBasePath(String basePath) {
            this.basePath = basePath;
            return this;
        }

        @Generated
        public WebDavConfig setStoragePath(String storagePath) {
            this.storagePath = storagePath;
            return this;
        }

        @Generated
        public WebDavConfig setAttr(Map<String, Object> attr) {
            this.attr = attr;
            return this;
        }

        @Override
        @Generated
        public String toString() {
            return "FileStorageProperties.WebDavConfig(super=" + super.toString() + ", server=" + this.server + ", user=" + this.user + ", password=" + this.password + ", domain=" + this.domain + ", basePath=" + this.basePath + ", storagePath=" + this.storagePath + ", attr=" + this.attr + ")";
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WebDavConfig)) {
                return false;
            }
            WebDavConfig other = (WebDavConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$server = this.getServer();
            String other$server = other.getServer();
            if (this$server == null ? other$server != null : !this$server.equals(other$server)) {
                return false;
            }
            String this$user = this.getUser();
            String other$user = other.getUser();
            if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
                return false;
            }
            String this$password = this.getPassword();
            String other$password = other.getPassword();
            if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
                return false;
            }
            String this$domain = this.getDomain();
            String other$domain = other.getDomain();
            if (this$domain == null ? other$domain != null : !this$domain.equals(other$domain)) {
                return false;
            }
            String this$basePath = this.getBasePath();
            String other$basePath = other.getBasePath();
            if (this$basePath == null ? other$basePath != null : !this$basePath.equals(other$basePath)) {
                return false;
            }
            String this$storagePath = this.getStoragePath();
            String other$storagePath = other.getStoragePath();
            if (this$storagePath == null ? other$storagePath != null : !this$storagePath.equals(other$storagePath)) {
                return false;
            }
            Map<String, Object> this$attr = this.getAttr();
            Map<String, Object> other$attr = other.getAttr();
            return !(this$attr == null ? other$attr != null : !((Object)this$attr).equals(other$attr));
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof WebDavConfig;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $server = this.getServer();
            result = result * 59 + ($server == null ? 43 : $server.hashCode());
            String $user = this.getUser();
            result = result * 59 + ($user == null ? 43 : $user.hashCode());
            String $password = this.getPassword();
            result = result * 59 + ($password == null ? 43 : $password.hashCode());
            String $domain = this.getDomain();
            result = result * 59 + ($domain == null ? 43 : $domain.hashCode());
            String $basePath = this.getBasePath();
            result = result * 59 + ($basePath == null ? 43 : $basePath.hashCode());
            String $storagePath = this.getStoragePath();
            result = result * 59 + ($storagePath == null ? 43 : $storagePath.hashCode());
            Map<String, Object> $attr = this.getAttr();
            result = result * 59 + ($attr == null ? 43 : ((Object)$attr).hashCode());
            return result;
        }
    }

    public static class SftpConfig
    extends BaseConfig {
        private String host;
        private int port = 22;
        private String user;
        private String password;
        private String privateKeyPath;
        private Charset charset = StandardCharsets.UTF_8;
        private int connectionTimeout = 10000;
        private String domain = "";
        private String basePath = "";
        private String storagePath = "/";
        private CommonClientPoolConfig pool = new CommonClientPoolConfig();
        private Map<String, Object> attr = new LinkedHashMap<String, Object>();

        @Generated
        public SftpConfig() {
        }

        @Generated
        public String getHost() {
            return this.host;
        }

        @Generated
        public int getPort() {
            return this.port;
        }

        @Generated
        public String getUser() {
            return this.user;
        }

        @Generated
        public String getPassword() {
            return this.password;
        }

        @Generated
        public String getPrivateKeyPath() {
            return this.privateKeyPath;
        }

        @Generated
        public Charset getCharset() {
            return this.charset;
        }

        @Generated
        public int getConnectionTimeout() {
            return this.connectionTimeout;
        }

        @Generated
        public String getDomain() {
            return this.domain;
        }

        @Generated
        public String getBasePath() {
            return this.basePath;
        }

        @Generated
        public String getStoragePath() {
            return this.storagePath;
        }

        @Generated
        public CommonClientPoolConfig getPool() {
            return this.pool;
        }

        @Generated
        public Map<String, Object> getAttr() {
            return this.attr;
        }

        @Generated
        public SftpConfig setHost(String host) {
            this.host = host;
            return this;
        }

        @Generated
        public SftpConfig setPort(int port) {
            this.port = port;
            return this;
        }

        @Generated
        public SftpConfig setUser(String user) {
            this.user = user;
            return this;
        }

        @Generated
        public SftpConfig setPassword(String password) {
            this.password = password;
            return this;
        }

        @Generated
        public SftpConfig setPrivateKeyPath(String privateKeyPath) {
            this.privateKeyPath = privateKeyPath;
            return this;
        }

        @Generated
        public SftpConfig setCharset(Charset charset) {
            this.charset = charset;
            return this;
        }

        @Generated
        public SftpConfig setConnectionTimeout(int connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
            return this;
        }

        @Generated
        public SftpConfig setDomain(String domain) {
            this.domain = domain;
            return this;
        }

        @Generated
        public SftpConfig setBasePath(String basePath) {
            this.basePath = basePath;
            return this;
        }

        @Generated
        public SftpConfig setStoragePath(String storagePath) {
            this.storagePath = storagePath;
            return this;
        }

        @Generated
        public SftpConfig setPool(CommonClientPoolConfig pool) {
            this.pool = pool;
            return this;
        }

        @Generated
        public SftpConfig setAttr(Map<String, Object> attr) {
            this.attr = attr;
            return this;
        }

        @Override
        @Generated
        public String toString() {
            return "FileStorageProperties.SftpConfig(super=" + super.toString() + ", host=" + this.host + ", port=" + this.port + ", user=" + this.user + ", password=" + this.password + ", privateKeyPath=" + this.privateKeyPath + ", charset=" + this.charset + ", connectionTimeout=" + this.connectionTimeout + ", domain=" + this.domain + ", basePath=" + this.basePath + ", storagePath=" + this.storagePath + ", pool=" + this.pool + ", attr=" + this.attr + ")";
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SftpConfig)) {
                return false;
            }
            SftpConfig other = (SftpConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            if (this.getPort() != other.getPort()) {
                return false;
            }
            if (this.getConnectionTimeout() != other.getConnectionTimeout()) {
                return false;
            }
            String this$host = this.getHost();
            String other$host = other.getHost();
            if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
                return false;
            }
            String this$user = this.getUser();
            String other$user = other.getUser();
            if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
                return false;
            }
            String this$password = this.getPassword();
            String other$password = other.getPassword();
            if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
                return false;
            }
            String this$privateKeyPath = this.getPrivateKeyPath();
            String other$privateKeyPath = other.getPrivateKeyPath();
            if (this$privateKeyPath == null ? other$privateKeyPath != null : !this$privateKeyPath.equals(other$privateKeyPath)) {
                return false;
            }
            Charset this$charset = this.getCharset();
            Charset other$charset = other.getCharset();
            if (this$charset == null ? other$charset != null : !((Object)this$charset).equals(other$charset)) {
                return false;
            }
            String this$domain = this.getDomain();
            String other$domain = other.getDomain();
            if (this$domain == null ? other$domain != null : !this$domain.equals(other$domain)) {
                return false;
            }
            String this$basePath = this.getBasePath();
            String other$basePath = other.getBasePath();
            if (this$basePath == null ? other$basePath != null : !this$basePath.equals(other$basePath)) {
                return false;
            }
            String this$storagePath = this.getStoragePath();
            String other$storagePath = other.getStoragePath();
            if (this$storagePath == null ? other$storagePath != null : !this$storagePath.equals(other$storagePath)) {
                return false;
            }
            CommonClientPoolConfig this$pool = this.getPool();
            CommonClientPoolConfig other$pool = other.getPool();
            if (this$pool == null ? other$pool != null : !((Object)this$pool).equals(other$pool)) {
                return false;
            }
            Map<String, Object> this$attr = this.getAttr();
            Map<String, Object> other$attr = other.getAttr();
            return !(this$attr == null ? other$attr != null : !((Object)this$attr).equals(other$attr));
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SftpConfig;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            result = result * 59 + this.getPort();
            result = result * 59 + this.getConnectionTimeout();
            String $host = this.getHost();
            result = result * 59 + ($host == null ? 43 : $host.hashCode());
            String $user = this.getUser();
            result = result * 59 + ($user == null ? 43 : $user.hashCode());
            String $password = this.getPassword();
            result = result * 59 + ($password == null ? 43 : $password.hashCode());
            String $privateKeyPath = this.getPrivateKeyPath();
            result = result * 59 + ($privateKeyPath == null ? 43 : $privateKeyPath.hashCode());
            Charset $charset = this.getCharset();
            result = result * 59 + ($charset == null ? 43 : ((Object)$charset).hashCode());
            String $domain = this.getDomain();
            result = result * 59 + ($domain == null ? 43 : $domain.hashCode());
            String $basePath = this.getBasePath();
            result = result * 59 + ($basePath == null ? 43 : $basePath.hashCode());
            String $storagePath = this.getStoragePath();
            result = result * 59 + ($storagePath == null ? 43 : $storagePath.hashCode());
            CommonClientPoolConfig $pool = this.getPool();
            result = result * 59 + ($pool == null ? 43 : ((Object)$pool).hashCode());
            Map<String, Object> $attr = this.getAttr();
            result = result * 59 + ($attr == null ? 43 : ((Object)$attr).hashCode());
            return result;
        }
    }

    public static class FtpConfig
    extends BaseConfig {
        private String host;
        private int port = 21;
        private String user = "anonymous";
        private String password = "";
        private Charset charset = StandardCharsets.UTF_8;
        private long connectionTimeout = 10000L;
        private long soTimeout = 10000L;
        private String serverLanguageCode;
        private String systemKey;
        private Boolean isActive = false;
        private String domain = "";
        private String basePath = "";
        private String storagePath = "/";
        private CommonClientPoolConfig pool = new CommonClientPoolConfig();
        private Map<String, Object> attr = new LinkedHashMap<String, Object>();

        @Generated
        public FtpConfig() {
        }

        @Generated
        public String getHost() {
            return this.host;
        }

        @Generated
        public int getPort() {
            return this.port;
        }

        @Generated
        public String getUser() {
            return this.user;
        }

        @Generated
        public String getPassword() {
            return this.password;
        }

        @Generated
        public Charset getCharset() {
            return this.charset;
        }

        @Generated
        public long getConnectionTimeout() {
            return this.connectionTimeout;
        }

        @Generated
        public long getSoTimeout() {
            return this.soTimeout;
        }

        @Generated
        public String getServerLanguageCode() {
            return this.serverLanguageCode;
        }

        @Generated
        public String getSystemKey() {
            return this.systemKey;
        }

        @Generated
        public Boolean getIsActive() {
            return this.isActive;
        }

        @Generated
        public String getDomain() {
            return this.domain;
        }

        @Generated
        public String getBasePath() {
            return this.basePath;
        }

        @Generated
        public String getStoragePath() {
            return this.storagePath;
        }

        @Generated
        public CommonClientPoolConfig getPool() {
            return this.pool;
        }

        @Generated
        public Map<String, Object> getAttr() {
            return this.attr;
        }

        @Generated
        public FtpConfig setHost(String host) {
            this.host = host;
            return this;
        }

        @Generated
        public FtpConfig setPort(int port) {
            this.port = port;
            return this;
        }

        @Generated
        public FtpConfig setUser(String user) {
            this.user = user;
            return this;
        }

        @Generated
        public FtpConfig setPassword(String password) {
            this.password = password;
            return this;
        }

        @Generated
        public FtpConfig setCharset(Charset charset) {
            this.charset = charset;
            return this;
        }

        @Generated
        public FtpConfig setConnectionTimeout(long connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
            return this;
        }

        @Generated
        public FtpConfig setSoTimeout(long soTimeout) {
            this.soTimeout = soTimeout;
            return this;
        }

        @Generated
        public FtpConfig setServerLanguageCode(String serverLanguageCode) {
            this.serverLanguageCode = serverLanguageCode;
            return this;
        }

        @Generated
        public FtpConfig setSystemKey(String systemKey) {
            this.systemKey = systemKey;
            return this;
        }

        @Generated
        public FtpConfig setIsActive(Boolean isActive) {
            this.isActive = isActive;
            return this;
        }

        @Generated
        public FtpConfig setDomain(String domain) {
            this.domain = domain;
            return this;
        }

        @Generated
        public FtpConfig setBasePath(String basePath) {
            this.basePath = basePath;
            return this;
        }

        @Generated
        public FtpConfig setStoragePath(String storagePath) {
            this.storagePath = storagePath;
            return this;
        }

        @Generated
        public FtpConfig setPool(CommonClientPoolConfig pool) {
            this.pool = pool;
            return this;
        }

        @Generated
        public FtpConfig setAttr(Map<String, Object> attr) {
            this.attr = attr;
            return this;
        }

        @Override
        @Generated
        public String toString() {
            return "FileStorageProperties.FtpConfig(super=" + super.toString() + ", host=" + this.host + ", port=" + this.port + ", user=" + this.user + ", password=" + this.password + ", charset=" + this.charset + ", connectionTimeout=" + this.connectionTimeout + ", soTimeout=" + this.soTimeout + ", serverLanguageCode=" + this.serverLanguageCode + ", systemKey=" + this.systemKey + ", isActive=" + this.isActive + ", domain=" + this.domain + ", basePath=" + this.basePath + ", storagePath=" + this.storagePath + ", pool=" + this.pool + ", attr=" + this.attr + ")";
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FtpConfig)) {
                return false;
            }
            FtpConfig other = (FtpConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            if (this.getPort() != other.getPort()) {
                return false;
            }
            if (this.getConnectionTimeout() != other.getConnectionTimeout()) {
                return false;
            }
            if (this.getSoTimeout() != other.getSoTimeout()) {
                return false;
            }
            Boolean this$isActive = this.getIsActive();
            Boolean other$isActive = other.getIsActive();
            if (this$isActive == null ? other$isActive != null : !((Object)this$isActive).equals(other$isActive)) {
                return false;
            }
            String this$host = this.getHost();
            String other$host = other.getHost();
            if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
                return false;
            }
            String this$user = this.getUser();
            String other$user = other.getUser();
            if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
                return false;
            }
            String this$password = this.getPassword();
            String other$password = other.getPassword();
            if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
                return false;
            }
            Charset this$charset = this.getCharset();
            Charset other$charset = other.getCharset();
            if (this$charset == null ? other$charset != null : !((Object)this$charset).equals(other$charset)) {
                return false;
            }
            String this$serverLanguageCode = this.getServerLanguageCode();
            String other$serverLanguageCode = other.getServerLanguageCode();
            if (this$serverLanguageCode == null ? other$serverLanguageCode != null : !this$serverLanguageCode.equals(other$serverLanguageCode)) {
                return false;
            }
            String this$systemKey = this.getSystemKey();
            String other$systemKey = other.getSystemKey();
            if (this$systemKey == null ? other$systemKey != null : !this$systemKey.equals(other$systemKey)) {
                return false;
            }
            String this$domain = this.getDomain();
            String other$domain = other.getDomain();
            if (this$domain == null ? other$domain != null : !this$domain.equals(other$domain)) {
                return false;
            }
            String this$basePath = this.getBasePath();
            String other$basePath = other.getBasePath();
            if (this$basePath == null ? other$basePath != null : !this$basePath.equals(other$basePath)) {
                return false;
            }
            String this$storagePath = this.getStoragePath();
            String other$storagePath = other.getStoragePath();
            if (this$storagePath == null ? other$storagePath != null : !this$storagePath.equals(other$storagePath)) {
                return false;
            }
            CommonClientPoolConfig this$pool = this.getPool();
            CommonClientPoolConfig other$pool = other.getPool();
            if (this$pool == null ? other$pool != null : !((Object)this$pool).equals(other$pool)) {
                return false;
            }
            Map<String, Object> this$attr = this.getAttr();
            Map<String, Object> other$attr = other.getAttr();
            return !(this$attr == null ? other$attr != null : !((Object)this$attr).equals(other$attr));
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof FtpConfig;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            result = result * 59 + this.getPort();
            long $connectionTimeout = this.getConnectionTimeout();
            result = result * 59 + (int)($connectionTimeout >>> 32 ^ $connectionTimeout);
            long $soTimeout = this.getSoTimeout();
            result = result * 59 + (int)($soTimeout >>> 32 ^ $soTimeout);
            Boolean $isActive = this.getIsActive();
            result = result * 59 + ($isActive == null ? 43 : ((Object)$isActive).hashCode());
            String $host = this.getHost();
            result = result * 59 + ($host == null ? 43 : $host.hashCode());
            String $user = this.getUser();
            result = result * 59 + ($user == null ? 43 : $user.hashCode());
            String $password = this.getPassword();
            result = result * 59 + ($password == null ? 43 : $password.hashCode());
            Charset $charset = this.getCharset();
            result = result * 59 + ($charset == null ? 43 : ((Object)$charset).hashCode());
            String $serverLanguageCode = this.getServerLanguageCode();
            result = result * 59 + ($serverLanguageCode == null ? 43 : $serverLanguageCode.hashCode());
            String $systemKey = this.getSystemKey();
            result = result * 59 + ($systemKey == null ? 43 : $systemKey.hashCode());
            String $domain = this.getDomain();
            result = result * 59 + ($domain == null ? 43 : $domain.hashCode());
            String $basePath = this.getBasePath();
            result = result * 59 + ($basePath == null ? 43 : $basePath.hashCode());
            String $storagePath = this.getStoragePath();
            result = result * 59 + ($storagePath == null ? 43 : $storagePath.hashCode());
            CommonClientPoolConfig $pool = this.getPool();
            result = result * 59 + ($pool == null ? 43 : ((Object)$pool).hashCode());
            Map<String, Object> $attr = this.getAttr();
            result = result * 59 + ($attr == null ? 43 : ((Object)$attr).hashCode());
            return result;
        }
    }

    public static class AmazonS3Config
    extends BaseConfig {
        private String accessKey;
        private String secretKey;
        private String region;
        private String endPoint;
        private String bucketName;
        private String domain = "";
        private String basePath = "";
        private String defaultAcl;
        private int multipartThreshold = 0x8000000;
        private int multipartPartSize = 0x2000000;
        private Map<String, Object> attr = new LinkedHashMap<String, Object>();

        @Generated
        public AmazonS3Config() {
        }

        @Generated
        public String getAccessKey() {
            return this.accessKey;
        }

        @Generated
        public String getSecretKey() {
            return this.secretKey;
        }

        @Generated
        public String getRegion() {
            return this.region;
        }

        @Generated
        public String getEndPoint() {
            return this.endPoint;
        }

        @Generated
        public String getBucketName() {
            return this.bucketName;
        }

        @Generated
        public String getDomain() {
            return this.domain;
        }

        @Generated
        public String getBasePath() {
            return this.basePath;
        }

        @Generated
        public String getDefaultAcl() {
            return this.defaultAcl;
        }

        @Generated
        public int getMultipartThreshold() {
            return this.multipartThreshold;
        }

        @Generated
        public int getMultipartPartSize() {
            return this.multipartPartSize;
        }

        @Generated
        public Map<String, Object> getAttr() {
            return this.attr;
        }

        @Generated
        public AmazonS3Config setAccessKey(String accessKey) {
            this.accessKey = accessKey;
            return this;
        }

        @Generated
        public AmazonS3Config setSecretKey(String secretKey) {
            this.secretKey = secretKey;
            return this;
        }

        @Generated
        public AmazonS3Config setRegion(String region) {
            this.region = region;
            return this;
        }

        @Generated
        public AmazonS3Config setEndPoint(String endPoint) {
            this.endPoint = endPoint;
            return this;
        }

        @Generated
        public AmazonS3Config setBucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        @Generated
        public AmazonS3Config setDomain(String domain) {
            this.domain = domain;
            return this;
        }

        @Generated
        public AmazonS3Config setBasePath(String basePath) {
            this.basePath = basePath;
            return this;
        }

        @Generated
        public AmazonS3Config setDefaultAcl(String defaultAcl) {
            this.defaultAcl = defaultAcl;
            return this;
        }

        @Generated
        public AmazonS3Config setMultipartThreshold(int multipartThreshold) {
            this.multipartThreshold = multipartThreshold;
            return this;
        }

        @Generated
        public AmazonS3Config setMultipartPartSize(int multipartPartSize) {
            this.multipartPartSize = multipartPartSize;
            return this;
        }

        @Generated
        public AmazonS3Config setAttr(Map<String, Object> attr) {
            this.attr = attr;
            return this;
        }

        @Override
        @Generated
        public String toString() {
            return "FileStorageProperties.AmazonS3Config(super=" + super.toString() + ", accessKey=" + this.accessKey + ", secretKey=" + this.secretKey + ", region=" + this.region + ", endPoint=" + this.endPoint + ", bucketName=" + this.bucketName + ", domain=" + this.domain + ", basePath=" + this.basePath + ", defaultAcl=" + this.defaultAcl + ", multipartThreshold=" + this.multipartThreshold + ", multipartPartSize=" + this.multipartPartSize + ", attr=" + this.attr + ")";
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AmazonS3Config)) {
                return false;
            }
            AmazonS3Config other = (AmazonS3Config)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            if (this.getMultipartThreshold() != other.getMultipartThreshold()) {
                return false;
            }
            if (this.getMultipartPartSize() != other.getMultipartPartSize()) {
                return false;
            }
            String this$accessKey = this.getAccessKey();
            String other$accessKey = other.getAccessKey();
            if (this$accessKey == null ? other$accessKey != null : !this$accessKey.equals(other$accessKey)) {
                return false;
            }
            String this$secretKey = this.getSecretKey();
            String other$secretKey = other.getSecretKey();
            if (this$secretKey == null ? other$secretKey != null : !this$secretKey.equals(other$secretKey)) {
                return false;
            }
            String this$region = this.getRegion();
            String other$region = other.getRegion();
            if (this$region == null ? other$region != null : !this$region.equals(other$region)) {
                return false;
            }
            String this$endPoint = this.getEndPoint();
            String other$endPoint = other.getEndPoint();
            if (this$endPoint == null ? other$endPoint != null : !this$endPoint.equals(other$endPoint)) {
                return false;
            }
            String this$bucketName = this.getBucketName();
            String other$bucketName = other.getBucketName();
            if (this$bucketName == null ? other$bucketName != null : !this$bucketName.equals(other$bucketName)) {
                return false;
            }
            String this$domain = this.getDomain();
            String other$domain = other.getDomain();
            if (this$domain == null ? other$domain != null : !this$domain.equals(other$domain)) {
                return false;
            }
            String this$basePath = this.getBasePath();
            String other$basePath = other.getBasePath();
            if (this$basePath == null ? other$basePath != null : !this$basePath.equals(other$basePath)) {
                return false;
            }
            String this$defaultAcl = this.getDefaultAcl();
            String other$defaultAcl = other.getDefaultAcl();
            if (this$defaultAcl == null ? other$defaultAcl != null : !this$defaultAcl.equals(other$defaultAcl)) {
                return false;
            }
            Map<String, Object> this$attr = this.getAttr();
            Map<String, Object> other$attr = other.getAttr();
            return !(this$attr == null ? other$attr != null : !((Object)this$attr).equals(other$attr));
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AmazonS3Config;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            result = result * 59 + this.getMultipartThreshold();
            result = result * 59 + this.getMultipartPartSize();
            String $accessKey = this.getAccessKey();
            result = result * 59 + ($accessKey == null ? 43 : $accessKey.hashCode());
            String $secretKey = this.getSecretKey();
            result = result * 59 + ($secretKey == null ? 43 : $secretKey.hashCode());
            String $region = this.getRegion();
            result = result * 59 + ($region == null ? 43 : $region.hashCode());
            String $endPoint = this.getEndPoint();
            result = result * 59 + ($endPoint == null ? 43 : $endPoint.hashCode());
            String $bucketName = this.getBucketName();
            result = result * 59 + ($bucketName == null ? 43 : $bucketName.hashCode());
            String $domain = this.getDomain();
            result = result * 59 + ($domain == null ? 43 : $domain.hashCode());
            String $basePath = this.getBasePath();
            result = result * 59 + ($basePath == null ? 43 : $basePath.hashCode());
            String $defaultAcl = this.getDefaultAcl();
            result = result * 59 + ($defaultAcl == null ? 43 : $defaultAcl.hashCode());
            Map<String, Object> $attr = this.getAttr();
            result = result * 59 + ($attr == null ? 43 : ((Object)$attr).hashCode());
            return result;
        }
    }

    public static class MinioConfig
    extends BaseConfig {
        private String accessKey;
        private String secretKey;
        private String endPoint;
        private String bucketName;
        private String domain = "";
        private String basePath = "";
        private int multipartThreshold = 0x8000000;
        private int multipartPartSize = 0x2000000;
        private Map<String, Object> attr = new LinkedHashMap<String, Object>();

        @Generated
        public MinioConfig() {
        }

        @Generated
        public String getAccessKey() {
            return this.accessKey;
        }

        @Generated
        public String getSecretKey() {
            return this.secretKey;
        }

        @Generated
        public String getEndPoint() {
            return this.endPoint;
        }

        @Generated
        public String getBucketName() {
            return this.bucketName;
        }

        @Generated
        public String getDomain() {
            return this.domain;
        }

        @Generated
        public String getBasePath() {
            return this.basePath;
        }

        @Generated
        public int getMultipartThreshold() {
            return this.multipartThreshold;
        }

        @Generated
        public int getMultipartPartSize() {
            return this.multipartPartSize;
        }

        @Generated
        public Map<String, Object> getAttr() {
            return this.attr;
        }

        @Generated
        public MinioConfig setAccessKey(String accessKey) {
            this.accessKey = accessKey;
            return this;
        }

        @Generated
        public MinioConfig setSecretKey(String secretKey) {
            this.secretKey = secretKey;
            return this;
        }

        @Generated
        public MinioConfig setEndPoint(String endPoint) {
            this.endPoint = endPoint;
            return this;
        }

        @Generated
        public MinioConfig setBucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        @Generated
        public MinioConfig setDomain(String domain) {
            this.domain = domain;
            return this;
        }

        @Generated
        public MinioConfig setBasePath(String basePath) {
            this.basePath = basePath;
            return this;
        }

        @Generated
        public MinioConfig setMultipartThreshold(int multipartThreshold) {
            this.multipartThreshold = multipartThreshold;
            return this;
        }

        @Generated
        public MinioConfig setMultipartPartSize(int multipartPartSize) {
            this.multipartPartSize = multipartPartSize;
            return this;
        }

        @Generated
        public MinioConfig setAttr(Map<String, Object> attr) {
            this.attr = attr;
            return this;
        }

        @Override
        @Generated
        public String toString() {
            return "FileStorageProperties.MinioConfig(super=" + super.toString() + ", accessKey=" + this.accessKey + ", secretKey=" + this.secretKey + ", endPoint=" + this.endPoint + ", bucketName=" + this.bucketName + ", domain=" + this.domain + ", basePath=" + this.basePath + ", multipartThreshold=" + this.multipartThreshold + ", multipartPartSize=" + this.multipartPartSize + ", attr=" + this.attr + ")";
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MinioConfig)) {
                return false;
            }
            MinioConfig other = (MinioConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            if (this.getMultipartThreshold() != other.getMultipartThreshold()) {
                return false;
            }
            if (this.getMultipartPartSize() != other.getMultipartPartSize()) {
                return false;
            }
            String this$accessKey = this.getAccessKey();
            String other$accessKey = other.getAccessKey();
            if (this$accessKey == null ? other$accessKey != null : !this$accessKey.equals(other$accessKey)) {
                return false;
            }
            String this$secretKey = this.getSecretKey();
            String other$secretKey = other.getSecretKey();
            if (this$secretKey == null ? other$secretKey != null : !this$secretKey.equals(other$secretKey)) {
                return false;
            }
            String this$endPoint = this.getEndPoint();
            String other$endPoint = other.getEndPoint();
            if (this$endPoint == null ? other$endPoint != null : !this$endPoint.equals(other$endPoint)) {
                return false;
            }
            String this$bucketName = this.getBucketName();
            String other$bucketName = other.getBucketName();
            if (this$bucketName == null ? other$bucketName != null : !this$bucketName.equals(other$bucketName)) {
                return false;
            }
            String this$domain = this.getDomain();
            String other$domain = other.getDomain();
            if (this$domain == null ? other$domain != null : !this$domain.equals(other$domain)) {
                return false;
            }
            String this$basePath = this.getBasePath();
            String other$basePath = other.getBasePath();
            if (this$basePath == null ? other$basePath != null : !this$basePath.equals(other$basePath)) {
                return false;
            }
            Map<String, Object> this$attr = this.getAttr();
            Map<String, Object> other$attr = other.getAttr();
            return !(this$attr == null ? other$attr != null : !((Object)this$attr).equals(other$attr));
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof MinioConfig;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            result = result * 59 + this.getMultipartThreshold();
            result = result * 59 + this.getMultipartPartSize();
            String $accessKey = this.getAccessKey();
            result = result * 59 + ($accessKey == null ? 43 : $accessKey.hashCode());
            String $secretKey = this.getSecretKey();
            result = result * 59 + ($secretKey == null ? 43 : $secretKey.hashCode());
            String $endPoint = this.getEndPoint();
            result = result * 59 + ($endPoint == null ? 43 : $endPoint.hashCode());
            String $bucketName = this.getBucketName();
            result = result * 59 + ($bucketName == null ? 43 : $bucketName.hashCode());
            String $domain = this.getDomain();
            result = result * 59 + ($domain == null ? 43 : $domain.hashCode());
            String $basePath = this.getBasePath();
            result = result * 59 + ($basePath == null ? 43 : $basePath.hashCode());
            Map<String, Object> $attr = this.getAttr();
            result = result * 59 + ($attr == null ? 43 : ((Object)$attr).hashCode());
            return result;
        }
    }

    public static class UpyunUssConfig
    extends BaseConfig {
        private String username;
        private String password;
        private String bucketName;
        private String domain = "";
        private String basePath = "";
        private Integer multipartUploadPartSize = 0x100000;
        private Map<String, Object> attr = new LinkedHashMap<String, Object>();

        @Generated
        public UpyunUssConfig() {
        }

        @Generated
        public String getUsername() {
            return this.username;
        }

        @Generated
        public String getPassword() {
            return this.password;
        }

        @Generated
        public String getBucketName() {
            return this.bucketName;
        }

        @Generated
        public String getDomain() {
            return this.domain;
        }

        @Generated
        public String getBasePath() {
            return this.basePath;
        }

        @Generated
        public Integer getMultipartUploadPartSize() {
            return this.multipartUploadPartSize;
        }

        @Generated
        public Map<String, Object> getAttr() {
            return this.attr;
        }

        @Generated
        public UpyunUssConfig setUsername(String username) {
            this.username = username;
            return this;
        }

        @Generated
        public UpyunUssConfig setPassword(String password) {
            this.password = password;
            return this;
        }

        @Generated
        public UpyunUssConfig setBucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        @Generated
        public UpyunUssConfig setDomain(String domain) {
            this.domain = domain;
            return this;
        }

        @Generated
        public UpyunUssConfig setBasePath(String basePath) {
            this.basePath = basePath;
            return this;
        }

        @Generated
        public UpyunUssConfig setMultipartUploadPartSize(Integer multipartUploadPartSize) {
            this.multipartUploadPartSize = multipartUploadPartSize;
            return this;
        }

        @Generated
        public UpyunUssConfig setAttr(Map<String, Object> attr) {
            this.attr = attr;
            return this;
        }

        @Override
        @Generated
        public String toString() {
            return "FileStorageProperties.UpyunUssConfig(super=" + super.toString() + ", username=" + this.username + ", password=" + this.password + ", bucketName=" + this.bucketName + ", domain=" + this.domain + ", basePath=" + this.basePath + ", multipartUploadPartSize=" + this.multipartUploadPartSize + ", attr=" + this.attr + ")";
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UpyunUssConfig)) {
                return false;
            }
            UpyunUssConfig other = (UpyunUssConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Integer this$multipartUploadPartSize = this.getMultipartUploadPartSize();
            Integer other$multipartUploadPartSize = other.getMultipartUploadPartSize();
            if (this$multipartUploadPartSize == null ? other$multipartUploadPartSize != null : !((Object)this$multipartUploadPartSize).equals(other$multipartUploadPartSize)) {
                return false;
            }
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            String this$password = this.getPassword();
            String other$password = other.getPassword();
            if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
                return false;
            }
            String this$bucketName = this.getBucketName();
            String other$bucketName = other.getBucketName();
            if (this$bucketName == null ? other$bucketName != null : !this$bucketName.equals(other$bucketName)) {
                return false;
            }
            String this$domain = this.getDomain();
            String other$domain = other.getDomain();
            if (this$domain == null ? other$domain != null : !this$domain.equals(other$domain)) {
                return false;
            }
            String this$basePath = this.getBasePath();
            String other$basePath = other.getBasePath();
            if (this$basePath == null ? other$basePath != null : !this$basePath.equals(other$basePath)) {
                return false;
            }
            Map<String, Object> this$attr = this.getAttr();
            Map<String, Object> other$attr = other.getAttr();
            return !(this$attr == null ? other$attr != null : !((Object)this$attr).equals(other$attr));
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof UpyunUssConfig;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Integer $multipartUploadPartSize = this.getMultipartUploadPartSize();
            result = result * 59 + ($multipartUploadPartSize == null ? 43 : ((Object)$multipartUploadPartSize).hashCode());
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            String $password = this.getPassword();
            result = result * 59 + ($password == null ? 43 : $password.hashCode());
            String $bucketName = this.getBucketName();
            result = result * 59 + ($bucketName == null ? 43 : $bucketName.hashCode());
            String $domain = this.getDomain();
            result = result * 59 + ($domain == null ? 43 : $domain.hashCode());
            String $basePath = this.getBasePath();
            result = result * 59 + ($basePath == null ? 43 : $basePath.hashCode());
            Map<String, Object> $attr = this.getAttr();
            result = result * 59 + ($attr == null ? 43 : ((Object)$attr).hashCode());
            return result;
        }
    }

    public static class BaiduBosConfig
    extends BaseConfig {
        private String accessKey;
        private String secretKey;
        private String endPoint;
        private String bucketName;
        private String domain = "";
        private String basePath = "";
        private String defaultAcl;
        private int multipartThreshold = 0x8000000;
        private int multipartPartSize = 0x2000000;
        private Map<String, Object> attr = new LinkedHashMap<String, Object>();

        @Generated
        public BaiduBosConfig() {
        }

        @Generated
        public String getAccessKey() {
            return this.accessKey;
        }

        @Generated
        public String getSecretKey() {
            return this.secretKey;
        }

        @Generated
        public String getEndPoint() {
            return this.endPoint;
        }

        @Generated
        public String getBucketName() {
            return this.bucketName;
        }

        @Generated
        public String getDomain() {
            return this.domain;
        }

        @Generated
        public String getBasePath() {
            return this.basePath;
        }

        @Generated
        public String getDefaultAcl() {
            return this.defaultAcl;
        }

        @Generated
        public int getMultipartThreshold() {
            return this.multipartThreshold;
        }

        @Generated
        public int getMultipartPartSize() {
            return this.multipartPartSize;
        }

        @Generated
        public Map<String, Object> getAttr() {
            return this.attr;
        }

        @Generated
        public BaiduBosConfig setAccessKey(String accessKey) {
            this.accessKey = accessKey;
            return this;
        }

        @Generated
        public BaiduBosConfig setSecretKey(String secretKey) {
            this.secretKey = secretKey;
            return this;
        }

        @Generated
        public BaiduBosConfig setEndPoint(String endPoint) {
            this.endPoint = endPoint;
            return this;
        }

        @Generated
        public BaiduBosConfig setBucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        @Generated
        public BaiduBosConfig setDomain(String domain) {
            this.domain = domain;
            return this;
        }

        @Generated
        public BaiduBosConfig setBasePath(String basePath) {
            this.basePath = basePath;
            return this;
        }

        @Generated
        public BaiduBosConfig setDefaultAcl(String defaultAcl) {
            this.defaultAcl = defaultAcl;
            return this;
        }

        @Generated
        public BaiduBosConfig setMultipartThreshold(int multipartThreshold) {
            this.multipartThreshold = multipartThreshold;
            return this;
        }

        @Generated
        public BaiduBosConfig setMultipartPartSize(int multipartPartSize) {
            this.multipartPartSize = multipartPartSize;
            return this;
        }

        @Generated
        public BaiduBosConfig setAttr(Map<String, Object> attr) {
            this.attr = attr;
            return this;
        }

        @Override
        @Generated
        public String toString() {
            return "FileStorageProperties.BaiduBosConfig(super=" + super.toString() + ", accessKey=" + this.accessKey + ", secretKey=" + this.secretKey + ", endPoint=" + this.endPoint + ", bucketName=" + this.bucketName + ", domain=" + this.domain + ", basePath=" + this.basePath + ", defaultAcl=" + this.defaultAcl + ", multipartThreshold=" + this.multipartThreshold + ", multipartPartSize=" + this.multipartPartSize + ", attr=" + this.attr + ")";
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BaiduBosConfig)) {
                return false;
            }
            BaiduBosConfig other = (BaiduBosConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            if (this.getMultipartThreshold() != other.getMultipartThreshold()) {
                return false;
            }
            if (this.getMultipartPartSize() != other.getMultipartPartSize()) {
                return false;
            }
            String this$accessKey = this.getAccessKey();
            String other$accessKey = other.getAccessKey();
            if (this$accessKey == null ? other$accessKey != null : !this$accessKey.equals(other$accessKey)) {
                return false;
            }
            String this$secretKey = this.getSecretKey();
            String other$secretKey = other.getSecretKey();
            if (this$secretKey == null ? other$secretKey != null : !this$secretKey.equals(other$secretKey)) {
                return false;
            }
            String this$endPoint = this.getEndPoint();
            String other$endPoint = other.getEndPoint();
            if (this$endPoint == null ? other$endPoint != null : !this$endPoint.equals(other$endPoint)) {
                return false;
            }
            String this$bucketName = this.getBucketName();
            String other$bucketName = other.getBucketName();
            if (this$bucketName == null ? other$bucketName != null : !this$bucketName.equals(other$bucketName)) {
                return false;
            }
            String this$domain = this.getDomain();
            String other$domain = other.getDomain();
            if (this$domain == null ? other$domain != null : !this$domain.equals(other$domain)) {
                return false;
            }
            String this$basePath = this.getBasePath();
            String other$basePath = other.getBasePath();
            if (this$basePath == null ? other$basePath != null : !this$basePath.equals(other$basePath)) {
                return false;
            }
            String this$defaultAcl = this.getDefaultAcl();
            String other$defaultAcl = other.getDefaultAcl();
            if (this$defaultAcl == null ? other$defaultAcl != null : !this$defaultAcl.equals(other$defaultAcl)) {
                return false;
            }
            Map<String, Object> this$attr = this.getAttr();
            Map<String, Object> other$attr = other.getAttr();
            return !(this$attr == null ? other$attr != null : !((Object)this$attr).equals(other$attr));
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof BaiduBosConfig;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            result = result * 59 + this.getMultipartThreshold();
            result = result * 59 + this.getMultipartPartSize();
            String $accessKey = this.getAccessKey();
            result = result * 59 + ($accessKey == null ? 43 : $accessKey.hashCode());
            String $secretKey = this.getSecretKey();
            result = result * 59 + ($secretKey == null ? 43 : $secretKey.hashCode());
            String $endPoint = this.getEndPoint();
            result = result * 59 + ($endPoint == null ? 43 : $endPoint.hashCode());
            String $bucketName = this.getBucketName();
            result = result * 59 + ($bucketName == null ? 43 : $bucketName.hashCode());
            String $domain = this.getDomain();
            result = result * 59 + ($domain == null ? 43 : $domain.hashCode());
            String $basePath = this.getBasePath();
            result = result * 59 + ($basePath == null ? 43 : $basePath.hashCode());
            String $defaultAcl = this.getDefaultAcl();
            result = result * 59 + ($defaultAcl == null ? 43 : $defaultAcl.hashCode());
            Map<String, Object> $attr = this.getAttr();
            result = result * 59 + ($attr == null ? 43 : ((Object)$attr).hashCode());
            return result;
        }
    }

    public static class TencentCosConfig
    extends BaseConfig {
        private String secretId;
        private String secretKey;
        private String region;
        private String bucketName;
        private String domain = "";
        private String basePath = "";
        private String defaultAcl;
        private int multipartThreshold = 0x8000000;
        private int multipartPartSize = 0x2000000;
        private Map<String, Object> attr = new LinkedHashMap<String, Object>();

        @Generated
        public TencentCosConfig() {
        }

        @Generated
        public String getSecretId() {
            return this.secretId;
        }

        @Generated
        public String getSecretKey() {
            return this.secretKey;
        }

        @Generated
        public String getRegion() {
            return this.region;
        }

        @Generated
        public String getBucketName() {
            return this.bucketName;
        }

        @Generated
        public String getDomain() {
            return this.domain;
        }

        @Generated
        public String getBasePath() {
            return this.basePath;
        }

        @Generated
        public String getDefaultAcl() {
            return this.defaultAcl;
        }

        @Generated
        public int getMultipartThreshold() {
            return this.multipartThreshold;
        }

        @Generated
        public int getMultipartPartSize() {
            return this.multipartPartSize;
        }

        @Generated
        public Map<String, Object> getAttr() {
            return this.attr;
        }

        @Generated
        public TencentCosConfig setSecretId(String secretId) {
            this.secretId = secretId;
            return this;
        }

        @Generated
        public TencentCosConfig setSecretKey(String secretKey) {
            this.secretKey = secretKey;
            return this;
        }

        @Generated
        public TencentCosConfig setRegion(String region) {
            this.region = region;
            return this;
        }

        @Generated
        public TencentCosConfig setBucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        @Generated
        public TencentCosConfig setDomain(String domain) {
            this.domain = domain;
            return this;
        }

        @Generated
        public TencentCosConfig setBasePath(String basePath) {
            this.basePath = basePath;
            return this;
        }

        @Generated
        public TencentCosConfig setDefaultAcl(String defaultAcl) {
            this.defaultAcl = defaultAcl;
            return this;
        }

        @Generated
        public TencentCosConfig setMultipartThreshold(int multipartThreshold) {
            this.multipartThreshold = multipartThreshold;
            return this;
        }

        @Generated
        public TencentCosConfig setMultipartPartSize(int multipartPartSize) {
            this.multipartPartSize = multipartPartSize;
            return this;
        }

        @Generated
        public TencentCosConfig setAttr(Map<String, Object> attr) {
            this.attr = attr;
            return this;
        }

        @Override
        @Generated
        public String toString() {
            return "FileStorageProperties.TencentCosConfig(super=" + super.toString() + ", secretId=" + this.secretId + ", secretKey=" + this.secretKey + ", region=" + this.region + ", bucketName=" + this.bucketName + ", domain=" + this.domain + ", basePath=" + this.basePath + ", defaultAcl=" + this.defaultAcl + ", multipartThreshold=" + this.multipartThreshold + ", multipartPartSize=" + this.multipartPartSize + ", attr=" + this.attr + ")";
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TencentCosConfig)) {
                return false;
            }
            TencentCosConfig other = (TencentCosConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            if (this.getMultipartThreshold() != other.getMultipartThreshold()) {
                return false;
            }
            if (this.getMultipartPartSize() != other.getMultipartPartSize()) {
                return false;
            }
            String this$secretId = this.getSecretId();
            String other$secretId = other.getSecretId();
            if (this$secretId == null ? other$secretId != null : !this$secretId.equals(other$secretId)) {
                return false;
            }
            String this$secretKey = this.getSecretKey();
            String other$secretKey = other.getSecretKey();
            if (this$secretKey == null ? other$secretKey != null : !this$secretKey.equals(other$secretKey)) {
                return false;
            }
            String this$region = this.getRegion();
            String other$region = other.getRegion();
            if (this$region == null ? other$region != null : !this$region.equals(other$region)) {
                return false;
            }
            String this$bucketName = this.getBucketName();
            String other$bucketName = other.getBucketName();
            if (this$bucketName == null ? other$bucketName != null : !this$bucketName.equals(other$bucketName)) {
                return false;
            }
            String this$domain = this.getDomain();
            String other$domain = other.getDomain();
            if (this$domain == null ? other$domain != null : !this$domain.equals(other$domain)) {
                return false;
            }
            String this$basePath = this.getBasePath();
            String other$basePath = other.getBasePath();
            if (this$basePath == null ? other$basePath != null : !this$basePath.equals(other$basePath)) {
                return false;
            }
            String this$defaultAcl = this.getDefaultAcl();
            String other$defaultAcl = other.getDefaultAcl();
            if (this$defaultAcl == null ? other$defaultAcl != null : !this$defaultAcl.equals(other$defaultAcl)) {
                return false;
            }
            Map<String, Object> this$attr = this.getAttr();
            Map<String, Object> other$attr = other.getAttr();
            return !(this$attr == null ? other$attr != null : !((Object)this$attr).equals(other$attr));
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof TencentCosConfig;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            result = result * 59 + this.getMultipartThreshold();
            result = result * 59 + this.getMultipartPartSize();
            String $secretId = this.getSecretId();
            result = result * 59 + ($secretId == null ? 43 : $secretId.hashCode());
            String $secretKey = this.getSecretKey();
            result = result * 59 + ($secretKey == null ? 43 : $secretKey.hashCode());
            String $region = this.getRegion();
            result = result * 59 + ($region == null ? 43 : $region.hashCode());
            String $bucketName = this.getBucketName();
            result = result * 59 + ($bucketName == null ? 43 : $bucketName.hashCode());
            String $domain = this.getDomain();
            result = result * 59 + ($domain == null ? 43 : $domain.hashCode());
            String $basePath = this.getBasePath();
            result = result * 59 + ($basePath == null ? 43 : $basePath.hashCode());
            String $defaultAcl = this.getDefaultAcl();
            result = result * 59 + ($defaultAcl == null ? 43 : $defaultAcl.hashCode());
            Map<String, Object> $attr = this.getAttr();
            result = result * 59 + ($attr == null ? 43 : ((Object)$attr).hashCode());
            return result;
        }
    }

    public static class QiniuKodoConfig
    extends BaseConfig {
        private String accessKey;
        private String secretKey;
        private String bucketName;
        private String domain = "";
        private String basePath = "";
        private Map<String, Object> attr = new LinkedHashMap<String, Object>();

        @Generated
        public QiniuKodoConfig() {
        }

        @Generated
        public String getAccessKey() {
            return this.accessKey;
        }

        @Generated
        public String getSecretKey() {
            return this.secretKey;
        }

        @Generated
        public String getBucketName() {
            return this.bucketName;
        }

        @Generated
        public String getDomain() {
            return this.domain;
        }

        @Generated
        public String getBasePath() {
            return this.basePath;
        }

        @Generated
        public Map<String, Object> getAttr() {
            return this.attr;
        }

        @Generated
        public QiniuKodoConfig setAccessKey(String accessKey) {
            this.accessKey = accessKey;
            return this;
        }

        @Generated
        public QiniuKodoConfig setSecretKey(String secretKey) {
            this.secretKey = secretKey;
            return this;
        }

        @Generated
        public QiniuKodoConfig setBucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        @Generated
        public QiniuKodoConfig setDomain(String domain) {
            this.domain = domain;
            return this;
        }

        @Generated
        public QiniuKodoConfig setBasePath(String basePath) {
            this.basePath = basePath;
            return this;
        }

        @Generated
        public QiniuKodoConfig setAttr(Map<String, Object> attr) {
            this.attr = attr;
            return this;
        }

        @Override
        @Generated
        public String toString() {
            return "FileStorageProperties.QiniuKodoConfig(super=" + super.toString() + ", accessKey=" + this.accessKey + ", secretKey=" + this.secretKey + ", bucketName=" + this.bucketName + ", domain=" + this.domain + ", basePath=" + this.basePath + ", attr=" + this.attr + ")";
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof QiniuKodoConfig)) {
                return false;
            }
            QiniuKodoConfig other = (QiniuKodoConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$accessKey = this.getAccessKey();
            String other$accessKey = other.getAccessKey();
            if (this$accessKey == null ? other$accessKey != null : !this$accessKey.equals(other$accessKey)) {
                return false;
            }
            String this$secretKey = this.getSecretKey();
            String other$secretKey = other.getSecretKey();
            if (this$secretKey == null ? other$secretKey != null : !this$secretKey.equals(other$secretKey)) {
                return false;
            }
            String this$bucketName = this.getBucketName();
            String other$bucketName = other.getBucketName();
            if (this$bucketName == null ? other$bucketName != null : !this$bucketName.equals(other$bucketName)) {
                return false;
            }
            String this$domain = this.getDomain();
            String other$domain = other.getDomain();
            if (this$domain == null ? other$domain != null : !this$domain.equals(other$domain)) {
                return false;
            }
            String this$basePath = this.getBasePath();
            String other$basePath = other.getBasePath();
            if (this$basePath == null ? other$basePath != null : !this$basePath.equals(other$basePath)) {
                return false;
            }
            Map<String, Object> this$attr = this.getAttr();
            Map<String, Object> other$attr = other.getAttr();
            return !(this$attr == null ? other$attr != null : !((Object)this$attr).equals(other$attr));
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof QiniuKodoConfig;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $accessKey = this.getAccessKey();
            result = result * 59 + ($accessKey == null ? 43 : $accessKey.hashCode());
            String $secretKey = this.getSecretKey();
            result = result * 59 + ($secretKey == null ? 43 : $secretKey.hashCode());
            String $bucketName = this.getBucketName();
            result = result * 59 + ($bucketName == null ? 43 : $bucketName.hashCode());
            String $domain = this.getDomain();
            result = result * 59 + ($domain == null ? 43 : $domain.hashCode());
            String $basePath = this.getBasePath();
            result = result * 59 + ($basePath == null ? 43 : $basePath.hashCode());
            Map<String, Object> $attr = this.getAttr();
            result = result * 59 + ($attr == null ? 43 : ((Object)$attr).hashCode());
            return result;
        }
    }

    public static class AliyunOssConfig
    extends BaseConfig {
        private String accessKey;
        private String secretKey;
        private String endPoint;
        private String bucketName;
        private String domain = "";
        private String basePath = "";
        private String defaultAcl;
        private int multipartThreshold = 0x8000000;
        private int multipartPartSize = 0x2000000;
        private Map<String, Object> attr = new LinkedHashMap<String, Object>();

        @Generated
        public AliyunOssConfig() {
        }

        @Generated
        public String getAccessKey() {
            return this.accessKey;
        }

        @Generated
        public String getSecretKey() {
            return this.secretKey;
        }

        @Generated
        public String getEndPoint() {
            return this.endPoint;
        }

        @Generated
        public String getBucketName() {
            return this.bucketName;
        }

        @Generated
        public String getDomain() {
            return this.domain;
        }

        @Generated
        public String getBasePath() {
            return this.basePath;
        }

        @Generated
        public String getDefaultAcl() {
            return this.defaultAcl;
        }

        @Generated
        public int getMultipartThreshold() {
            return this.multipartThreshold;
        }

        @Generated
        public int getMultipartPartSize() {
            return this.multipartPartSize;
        }

        @Generated
        public Map<String, Object> getAttr() {
            return this.attr;
        }

        @Generated
        public AliyunOssConfig setAccessKey(String accessKey) {
            this.accessKey = accessKey;
            return this;
        }

        @Generated
        public AliyunOssConfig setSecretKey(String secretKey) {
            this.secretKey = secretKey;
            return this;
        }

        @Generated
        public AliyunOssConfig setEndPoint(String endPoint) {
            this.endPoint = endPoint;
            return this;
        }

        @Generated
        public AliyunOssConfig setBucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        @Generated
        public AliyunOssConfig setDomain(String domain) {
            this.domain = domain;
            return this;
        }

        @Generated
        public AliyunOssConfig setBasePath(String basePath) {
            this.basePath = basePath;
            return this;
        }

        @Generated
        public AliyunOssConfig setDefaultAcl(String defaultAcl) {
            this.defaultAcl = defaultAcl;
            return this;
        }

        @Generated
        public AliyunOssConfig setMultipartThreshold(int multipartThreshold) {
            this.multipartThreshold = multipartThreshold;
            return this;
        }

        @Generated
        public AliyunOssConfig setMultipartPartSize(int multipartPartSize) {
            this.multipartPartSize = multipartPartSize;
            return this;
        }

        @Generated
        public AliyunOssConfig setAttr(Map<String, Object> attr) {
            this.attr = attr;
            return this;
        }

        @Override
        @Generated
        public String toString() {
            return "FileStorageProperties.AliyunOssConfig(super=" + super.toString() + ", accessKey=" + this.accessKey + ", secretKey=" + this.secretKey + ", endPoint=" + this.endPoint + ", bucketName=" + this.bucketName + ", domain=" + this.domain + ", basePath=" + this.basePath + ", defaultAcl=" + this.defaultAcl + ", multipartThreshold=" + this.multipartThreshold + ", multipartPartSize=" + this.multipartPartSize + ", attr=" + this.attr + ")";
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AliyunOssConfig)) {
                return false;
            }
            AliyunOssConfig other = (AliyunOssConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            if (this.getMultipartThreshold() != other.getMultipartThreshold()) {
                return false;
            }
            if (this.getMultipartPartSize() != other.getMultipartPartSize()) {
                return false;
            }
            String this$accessKey = this.getAccessKey();
            String other$accessKey = other.getAccessKey();
            if (this$accessKey == null ? other$accessKey != null : !this$accessKey.equals(other$accessKey)) {
                return false;
            }
            String this$secretKey = this.getSecretKey();
            String other$secretKey = other.getSecretKey();
            if (this$secretKey == null ? other$secretKey != null : !this$secretKey.equals(other$secretKey)) {
                return false;
            }
            String this$endPoint = this.getEndPoint();
            String other$endPoint = other.getEndPoint();
            if (this$endPoint == null ? other$endPoint != null : !this$endPoint.equals(other$endPoint)) {
                return false;
            }
            String this$bucketName = this.getBucketName();
            String other$bucketName = other.getBucketName();
            if (this$bucketName == null ? other$bucketName != null : !this$bucketName.equals(other$bucketName)) {
                return false;
            }
            String this$domain = this.getDomain();
            String other$domain = other.getDomain();
            if (this$domain == null ? other$domain != null : !this$domain.equals(other$domain)) {
                return false;
            }
            String this$basePath = this.getBasePath();
            String other$basePath = other.getBasePath();
            if (this$basePath == null ? other$basePath != null : !this$basePath.equals(other$basePath)) {
                return false;
            }
            String this$defaultAcl = this.getDefaultAcl();
            String other$defaultAcl = other.getDefaultAcl();
            if (this$defaultAcl == null ? other$defaultAcl != null : !this$defaultAcl.equals(other$defaultAcl)) {
                return false;
            }
            Map<String, Object> this$attr = this.getAttr();
            Map<String, Object> other$attr = other.getAttr();
            return !(this$attr == null ? other$attr != null : !((Object)this$attr).equals(other$attr));
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AliyunOssConfig;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            result = result * 59 + this.getMultipartThreshold();
            result = result * 59 + this.getMultipartPartSize();
            String $accessKey = this.getAccessKey();
            result = result * 59 + ($accessKey == null ? 43 : $accessKey.hashCode());
            String $secretKey = this.getSecretKey();
            result = result * 59 + ($secretKey == null ? 43 : $secretKey.hashCode());
            String $endPoint = this.getEndPoint();
            result = result * 59 + ($endPoint == null ? 43 : $endPoint.hashCode());
            String $bucketName = this.getBucketName();
            result = result * 59 + ($bucketName == null ? 43 : $bucketName.hashCode());
            String $domain = this.getDomain();
            result = result * 59 + ($domain == null ? 43 : $domain.hashCode());
            String $basePath = this.getBasePath();
            result = result * 59 + ($basePath == null ? 43 : $basePath.hashCode());
            String $defaultAcl = this.getDefaultAcl();
            result = result * 59 + ($defaultAcl == null ? 43 : $defaultAcl.hashCode());
            Map<String, Object> $attr = this.getAttr();
            result = result * 59 + ($attr == null ? 43 : ((Object)$attr).hashCode());
            return result;
        }
    }

    public static class HuaweiObsConfig
    extends BaseConfig {
        private String accessKey;
        private String secretKey;
        private String endPoint;
        private String bucketName;
        private String domain = "";
        private String basePath = "";
        private String defaultAcl;
        private int multipartThreshold = 0x8000000;
        private int multipartPartSize = 0x2000000;
        private Map<String, Object> attr = new LinkedHashMap<String, Object>();

        @Generated
        public HuaweiObsConfig() {
        }

        @Generated
        public String getAccessKey() {
            return this.accessKey;
        }

        @Generated
        public String getSecretKey() {
            return this.secretKey;
        }

        @Generated
        public String getEndPoint() {
            return this.endPoint;
        }

        @Generated
        public String getBucketName() {
            return this.bucketName;
        }

        @Generated
        public String getDomain() {
            return this.domain;
        }

        @Generated
        public String getBasePath() {
            return this.basePath;
        }

        @Generated
        public String getDefaultAcl() {
            return this.defaultAcl;
        }

        @Generated
        public int getMultipartThreshold() {
            return this.multipartThreshold;
        }

        @Generated
        public int getMultipartPartSize() {
            return this.multipartPartSize;
        }

        @Generated
        public Map<String, Object> getAttr() {
            return this.attr;
        }

        @Generated
        public HuaweiObsConfig setAccessKey(String accessKey) {
            this.accessKey = accessKey;
            return this;
        }

        @Generated
        public HuaweiObsConfig setSecretKey(String secretKey) {
            this.secretKey = secretKey;
            return this;
        }

        @Generated
        public HuaweiObsConfig setEndPoint(String endPoint) {
            this.endPoint = endPoint;
            return this;
        }

        @Generated
        public HuaweiObsConfig setBucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        @Generated
        public HuaweiObsConfig setDomain(String domain) {
            this.domain = domain;
            return this;
        }

        @Generated
        public HuaweiObsConfig setBasePath(String basePath) {
            this.basePath = basePath;
            return this;
        }

        @Generated
        public HuaweiObsConfig setDefaultAcl(String defaultAcl) {
            this.defaultAcl = defaultAcl;
            return this;
        }

        @Generated
        public HuaweiObsConfig setMultipartThreshold(int multipartThreshold) {
            this.multipartThreshold = multipartThreshold;
            return this;
        }

        @Generated
        public HuaweiObsConfig setMultipartPartSize(int multipartPartSize) {
            this.multipartPartSize = multipartPartSize;
            return this;
        }

        @Generated
        public HuaweiObsConfig setAttr(Map<String, Object> attr) {
            this.attr = attr;
            return this;
        }

        @Override
        @Generated
        public String toString() {
            return "FileStorageProperties.HuaweiObsConfig(super=" + super.toString() + ", accessKey=" + this.accessKey + ", secretKey=" + this.secretKey + ", endPoint=" + this.endPoint + ", bucketName=" + this.bucketName + ", domain=" + this.domain + ", basePath=" + this.basePath + ", defaultAcl=" + this.defaultAcl + ", multipartThreshold=" + this.multipartThreshold + ", multipartPartSize=" + this.multipartPartSize + ", attr=" + this.attr + ")";
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof HuaweiObsConfig)) {
                return false;
            }
            HuaweiObsConfig other = (HuaweiObsConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            if (this.getMultipartThreshold() != other.getMultipartThreshold()) {
                return false;
            }
            if (this.getMultipartPartSize() != other.getMultipartPartSize()) {
                return false;
            }
            String this$accessKey = this.getAccessKey();
            String other$accessKey = other.getAccessKey();
            if (this$accessKey == null ? other$accessKey != null : !this$accessKey.equals(other$accessKey)) {
                return false;
            }
            String this$secretKey = this.getSecretKey();
            String other$secretKey = other.getSecretKey();
            if (this$secretKey == null ? other$secretKey != null : !this$secretKey.equals(other$secretKey)) {
                return false;
            }
            String this$endPoint = this.getEndPoint();
            String other$endPoint = other.getEndPoint();
            if (this$endPoint == null ? other$endPoint != null : !this$endPoint.equals(other$endPoint)) {
                return false;
            }
            String this$bucketName = this.getBucketName();
            String other$bucketName = other.getBucketName();
            if (this$bucketName == null ? other$bucketName != null : !this$bucketName.equals(other$bucketName)) {
                return false;
            }
            String this$domain = this.getDomain();
            String other$domain = other.getDomain();
            if (this$domain == null ? other$domain != null : !this$domain.equals(other$domain)) {
                return false;
            }
            String this$basePath = this.getBasePath();
            String other$basePath = other.getBasePath();
            if (this$basePath == null ? other$basePath != null : !this$basePath.equals(other$basePath)) {
                return false;
            }
            String this$defaultAcl = this.getDefaultAcl();
            String other$defaultAcl = other.getDefaultAcl();
            if (this$defaultAcl == null ? other$defaultAcl != null : !this$defaultAcl.equals(other$defaultAcl)) {
                return false;
            }
            Map<String, Object> this$attr = this.getAttr();
            Map<String, Object> other$attr = other.getAttr();
            return !(this$attr == null ? other$attr != null : !((Object)this$attr).equals(other$attr));
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof HuaweiObsConfig;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            result = result * 59 + this.getMultipartThreshold();
            result = result * 59 + this.getMultipartPartSize();
            String $accessKey = this.getAccessKey();
            result = result * 59 + ($accessKey == null ? 43 : $accessKey.hashCode());
            String $secretKey = this.getSecretKey();
            result = result * 59 + ($secretKey == null ? 43 : $secretKey.hashCode());
            String $endPoint = this.getEndPoint();
            result = result * 59 + ($endPoint == null ? 43 : $endPoint.hashCode());
            String $bucketName = this.getBucketName();
            result = result * 59 + ($bucketName == null ? 43 : $bucketName.hashCode());
            String $domain = this.getDomain();
            result = result * 59 + ($domain == null ? 43 : $domain.hashCode());
            String $basePath = this.getBasePath();
            result = result * 59 + ($basePath == null ? 43 : $basePath.hashCode());
            String $defaultAcl = this.getDefaultAcl();
            result = result * 59 + ($defaultAcl == null ? 43 : $defaultAcl.hashCode());
            Map<String, Object> $attr = this.getAttr();
            result = result * 59 + ($attr == null ? 43 : ((Object)$attr).hashCode());
            return result;
        }
    }

    public static class LocalPlusConfig
    extends BaseConfig {
        private String basePath = "";
        private String storagePath = "/";
        private String domain = "";
        private Map<String, Object> attr = new LinkedHashMap<String, Object>();

        @Generated
        public LocalPlusConfig() {
        }

        @Generated
        public String getBasePath() {
            return this.basePath;
        }

        @Generated
        public String getStoragePath() {
            return this.storagePath;
        }

        @Generated
        public String getDomain() {
            return this.domain;
        }

        @Generated
        public Map<String, Object> getAttr() {
            return this.attr;
        }

        @Generated
        public LocalPlusConfig setBasePath(String basePath) {
            this.basePath = basePath;
            return this;
        }

        @Generated
        public LocalPlusConfig setStoragePath(String storagePath) {
            this.storagePath = storagePath;
            return this;
        }

        @Generated
        public LocalPlusConfig setDomain(String domain) {
            this.domain = domain;
            return this;
        }

        @Generated
        public LocalPlusConfig setAttr(Map<String, Object> attr) {
            this.attr = attr;
            return this;
        }

        @Override
        @Generated
        public String toString() {
            return "FileStorageProperties.LocalPlusConfig(super=" + super.toString() + ", basePath=" + this.basePath + ", storagePath=" + this.storagePath + ", domain=" + this.domain + ", attr=" + this.attr + ")";
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LocalPlusConfig)) {
                return false;
            }
            LocalPlusConfig other = (LocalPlusConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$basePath = this.getBasePath();
            String other$basePath = other.getBasePath();
            if (this$basePath == null ? other$basePath != null : !this$basePath.equals(other$basePath)) {
                return false;
            }
            String this$storagePath = this.getStoragePath();
            String other$storagePath = other.getStoragePath();
            if (this$storagePath == null ? other$storagePath != null : !this$storagePath.equals(other$storagePath)) {
                return false;
            }
            String this$domain = this.getDomain();
            String other$domain = other.getDomain();
            if (this$domain == null ? other$domain != null : !this$domain.equals(other$domain)) {
                return false;
            }
            Map<String, Object> this$attr = this.getAttr();
            Map<String, Object> other$attr = other.getAttr();
            return !(this$attr == null ? other$attr != null : !((Object)this$attr).equals(other$attr));
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof LocalPlusConfig;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $basePath = this.getBasePath();
            result = result * 59 + ($basePath == null ? 43 : $basePath.hashCode());
            String $storagePath = this.getStoragePath();
            result = result * 59 + ($storagePath == null ? 43 : $storagePath.hashCode());
            String $domain = this.getDomain();
            result = result * 59 + ($domain == null ? 43 : $domain.hashCode());
            Map<String, Object> $attr = this.getAttr();
            result = result * 59 + ($attr == null ? 43 : ((Object)$attr).hashCode());
            return result;
        }
    }

    @Deprecated
    public static class LocalConfig
    extends BaseConfig {
        private String basePath = "";
        private String domain = "";
        private Map<String, Object> attr = new LinkedHashMap<String, Object>();

        @Generated
        public LocalConfig() {
        }

        @Generated
        public String getBasePath() {
            return this.basePath;
        }

        @Generated
        public String getDomain() {
            return this.domain;
        }

        @Generated
        public Map<String, Object> getAttr() {
            return this.attr;
        }

        @Generated
        public LocalConfig setBasePath(String basePath) {
            this.basePath = basePath;
            return this;
        }

        @Generated
        public LocalConfig setDomain(String domain) {
            this.domain = domain;
            return this;
        }

        @Generated
        public LocalConfig setAttr(Map<String, Object> attr) {
            this.attr = attr;
            return this;
        }

        @Override
        @Generated
        public String toString() {
            return "FileStorageProperties.LocalConfig(super=" + super.toString() + ", basePath=" + this.basePath + ", domain=" + this.domain + ", attr=" + this.attr + ")";
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LocalConfig)) {
                return false;
            }
            LocalConfig other = (LocalConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$basePath = this.getBasePath();
            String other$basePath = other.getBasePath();
            if (this$basePath == null ? other$basePath != null : !this$basePath.equals(other$basePath)) {
                return false;
            }
            String this$domain = this.getDomain();
            String other$domain = other.getDomain();
            if (this$domain == null ? other$domain != null : !this$domain.equals(other$domain)) {
                return false;
            }
            Map<String, Object> this$attr = this.getAttr();
            Map<String, Object> other$attr = other.getAttr();
            return !(this$attr == null ? other$attr != null : !((Object)this$attr).equals(other$attr));
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof LocalConfig;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $basePath = this.getBasePath();
            result = result * 59 + ($basePath == null ? 43 : $basePath.hashCode());
            String $domain = this.getDomain();
            result = result * 59 + ($domain == null ? 43 : $domain.hashCode());
            Map<String, Object> $attr = this.getAttr();
            result = result * 59 + ($attr == null ? 43 : ((Object)$attr).hashCode());
            return result;
        }
    }

    public static class BaseConfig {
        private String platform = "";

        @Generated
        public BaseConfig() {
        }

        @Generated
        public String getPlatform() {
            return this.platform;
        }

        @Generated
        public BaseConfig setPlatform(String platform) {
            this.platform = platform;
            return this;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BaseConfig)) {
                return false;
            }
            BaseConfig other = (BaseConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$platform = this.getPlatform();
            String other$platform = other.getPlatform();
            return !(this$platform == null ? other$platform != null : !this$platform.equals(other$platform));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof BaseConfig;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $platform = this.getPlatform();
            result = result * 59 + ($platform == null ? 43 : $platform.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FileStorageProperties.BaseConfig(platform=" + this.platform + ")";
        }
    }
}

