/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.x.file.storage.core;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IoUtil;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.function.Consumer;
import lombok.Generated;
import org.dromara.x.file.storage.core.FileInfo;
import org.dromara.x.file.storage.core.InputStreamPlus;
import org.dromara.x.file.storage.core.ProgressListener;
import org.dromara.x.file.storage.core.ProgressListenerSetter;
import org.dromara.x.file.storage.core.aspect.DownloadAspectChain;
import org.dromara.x.file.storage.core.aspect.DownloadThAspectChain;
import org.dromara.x.file.storage.core.aspect.FileStorageAspect;
import org.dromara.x.file.storage.core.exception.FileStorageRuntimeException;
import org.dromara.x.file.storage.core.hash.HashCalculator;
import org.dromara.x.file.storage.core.hash.HashCalculatorManager;
import org.dromara.x.file.storage.core.hash.HashCalculatorSetter;
import org.dromara.x.file.storage.core.platform.FileStorage;

public class Downloader
implements ProgressListenerSetter<Downloader>,
HashCalculatorSetter<Downloader> {
    public static final int TARGET_FILE = 1;
    public static final int TARGET_TH_FILE = 2;
    private final FileStorage fileStorage;
    private final List<FileStorageAspect> aspectList;
    private final FileInfo fileInfo;
    private final Integer target;
    private ProgressListener progressListener;
    private HashCalculatorManager hashCalculatorManager = new HashCalculatorManager();

    public Downloader(FileInfo fileInfo, List<FileStorageAspect> aspectList, FileStorage fileStorage, Integer target) {
        this.fileStorage = fileStorage;
        this.aspectList = aspectList;
        this.fileInfo = fileInfo;
        this.target = target;
    }

    @Override
    public Downloader setHashCalculator(HashCalculator hashCalculator) {
        this.hashCalculatorManager.setHashCalculator(hashCalculator);
        return this;
    }

    public Downloader setHashCalculatorManager(boolean flag, HashCalculatorManager hashCalculatorManager) {
        if (flag) {
            this.setHashCalculatorManager(hashCalculatorManager);
        }
        return this;
    }

    public void inputStream(Consumer<InputStream> consumer) {
        if (this.target == 1) {
            new DownloadAspectChain(this.aspectList, (_fileInfo, _fileStorage, _consumer) -> _fileStorage.download(_fileInfo, _consumer)).next(this.fileInfo, this.fileStorage, in -> consumer.accept(new InputStreamPlus((InputStream)in, this.progressListener, this.fileInfo.getSize(), this.hashCalculatorManager)));
        } else if (this.target == 2) {
            new DownloadThAspectChain(this.aspectList, (_fileInfo, _fileStorage, _consumer) -> _fileStorage.downloadTh(_fileInfo, _consumer)).next(this.fileInfo, this.fileStorage, in -> consumer.accept(new InputStreamPlus((InputStream)in, this.progressListener, this.fileInfo.getThSize(), this.hashCalculatorManager)));
        } else {
            throw new FileStorageRuntimeException("\u6ca1\u627e\u5230\u5bf9\u5e94\u7684\u4e0b\u8f7d\u76ee\u6807\uff0c\u8bf7\u8bbe\u7f6e target \u53c2\u6570\uff01");
        }
    }

    public byte[] bytes() {
        byte[][] bytes = new byte[1][];
        this.inputStream(in -> {
            bytes[0] = IoUtil.readBytes((InputStream)in);
        });
        return bytes[0];
    }

    public void file(File file) {
        this.inputStream(in -> FileUtil.writeFromStream((InputStream)in, (File)file));
    }

    public void file(String filename) {
        this.inputStream(in -> FileUtil.writeFromStream((InputStream)in, (String)filename));
    }

    public void outputStream(OutputStream out) {
        this.inputStream(in -> IoUtil.copy((InputStream)in, (OutputStream)out));
    }

    @Override
    @Generated
    public Downloader setProgressListener(ProgressListener progressListener) {
        this.progressListener = progressListener;
        return this;
    }

    @Generated
    public HashCalculatorManager getHashCalculatorManager() {
        return this.hashCalculatorManager;
    }

    @Generated
    public Downloader setHashCalculatorManager(HashCalculatorManager hashCalculatorManager) {
        this.hashCalculatorManager = hashCalculatorManager;
        return this;
    }
}

