/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.utils;

import com.bstek.ureport.definition.dataset.Field;
import com.bstek.ureport.exception.ReportException;
import com.bstek.ureport.utils.StatementWrapper;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jnpf.util.XSSEscape;
import org.springframework.jdbc.support.JdbcUtils;

public class ProcedureUtils {
    public static boolean isProcedure(String sql) {
        sql = sql.trim().toLowerCase();
        return sql.startsWith("call ");
    }

    public static List<Field> procedureColumnsQuery(String sql, Map<String, Object> pmap, Connection conn) {
        ArrayList<Field> arrayList;
        StatementWrapper wrapper = ProcedureUtils.buildProcedureCallableStatement(sql, pmap, conn);
        CallableStatement cs = wrapper.getCallableStatement();
        int oracleCursorIndex = wrapper.getOracleCursorIndex();
        ResultSet rs = null;
        try {
            if (oracleCursorIndex == -1) {
                rs = cs.executeQuery();
            } else {
                cs.executeUpdate();
                rs = (ResultSet)cs.getObject(oracleCursorIndex);
            }
            ResultSetMetaData metadata = rs.getMetaData();
            int columnCount = metadata.getColumnCount();
            ArrayList<Field> fields = new ArrayList<Field>();
            for (int i = 1; i <= columnCount; ++i) {
                String columnName = metadata.getColumnLabel(i);
                fields.add(new Field(columnName));
            }
            arrayList = fields;
        }
        catch (SQLException e) {
            try {
                throw new ReportException(e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeResultSet(rs);
                JdbcUtils.closeStatement((Statement)cs);
                JdbcUtils.closeConnection((Connection)conn);
                throw throwable;
            }
        }
        JdbcUtils.closeResultSet((ResultSet)rs);
        JdbcUtils.closeStatement((Statement)cs);
        JdbcUtils.closeConnection((Connection)conn);
        return arrayList;
    }

    public static List<Map<String, Object>> procedureQuery(String sql, Map<String, Object> pmap, Connection conn) {
        ArrayList<Map<String, Object>> arrayList;
        StatementWrapper wrapper = ProcedureUtils.buildProcedureCallableStatement(sql, pmap, conn);
        CallableStatement cs = wrapper.getCallableStatement();
        int oracleCursorIndex = wrapper.getOracleCursorIndex();
        ResultSet rs = null;
        try {
            if (oracleCursorIndex == -1) {
                rs = cs.executeQuery();
            } else {
                cs.executeUpdate();
                rs = (ResultSet)cs.getObject(oracleCursorIndex);
            }
            ResultSetMetaData metadata = rs.getMetaData();
            int columnCount = metadata.getColumnCount();
            ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
            while (rs.next()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                for (int i = 1; i <= columnCount; ++i) {
                    String columnName = metadata.getColumnLabel(i);
                    map.put(columnName, rs.getObject(columnName));
                }
                result.add(map);
            }
            arrayList = result;
        }
        catch (SQLException e) {
            try {
                throw new ReportException(e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeResultSet(rs);
                JdbcUtils.closeStatement((Statement)cs);
                JdbcUtils.closeConnection((Connection)conn);
                throw throwable;
            }
        }
        JdbcUtils.closeResultSet((ResultSet)rs);
        JdbcUtils.closeStatement((Statement)cs);
        JdbcUtils.closeConnection((Connection)conn);
        return arrayList;
    }

    private static StatementWrapper buildProcedureCallableStatement(String sql, Map<String, Object> pmap, Connection conn) {
        try {
            String[] str;
            LinkedHashMap<String, Object> paramMap = new LinkedHashMap<String, Object>();
            int leftParnPos = sql.indexOf("(");
            int rightParnPos = sql.indexOf(")");
            String paramStr = "";
            if (leftParnPos > -1 && rightParnPos > -1) {
                paramStr = sql.substring(leftParnPos + 1, rightParnPos);
            }
            int oracleCursorIndex = -1;
            int paramIndex = 0;
            for (String param : str = paramStr.split(",")) {
                String paramName;
                ++paramIndex;
                if ("Oracle".equalsIgnoreCase((param = param.trim()).toLowerCase())) {
                    sql = sql.replaceFirst(param, "?");
                    oracleCursorIndex = paramIndex;
                    continue;
                }
                if (!param.startsWith(":")) continue;
                sql = sql.replaceFirst(param, "?");
                Object paramValue = pmap.get(paramName = param.substring(1, param.length()));
                paramMap.put(paramName, paramValue == null ? "" : paramValue);
            }
            String procedure = "{" + sql + "}";
            CallableStatement cs = conn.prepareCall(XSSEscape.escapeEmpty((String)procedure));
            int index = 1;
            for (String name : paramMap.keySet()) {
                Object value = paramMap.get(name);
                if (value instanceof String) {
                    cs.setString(index, (String)value);
                } else if (value instanceof java.util.Date) {
                    java.util.Date date = (java.util.Date)value;
                    cs.setDate(index, new Date(date.getTime()));
                } else if (value instanceof Integer) {
                    cs.setInt(index, (int)((Integer)value));
                } else if (value instanceof Float) {
                    cs.setFloat(index, ((Float)value).floatValue());
                } else if (value instanceof Double) {
                    cs.setDouble(index, (double)((Double)value));
                } else {
                    cs.setObject(index, value);
                }
                ++index;
            }
            if (oracleCursorIndex > -1) {
                cs.registerOutParameter(oracleCursorIndex, -10);
            }
            return new StatementWrapper(cs, oracleCursorIndex);
        }
        catch (SQLException e) {
            throw new ReportException(e);
        }
    }
}

