/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.utils;

import com.bstek.ureport.exception.ReportComputeException;
import com.bstek.ureport.image.ChartImageProcessor;
import com.bstek.ureport.image.ImageProcessor;
import com.bstek.ureport.image.ImageType;
import com.bstek.ureport.image.StaticImageProcessor;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;

public class ImageUtils {
    public static final int EMU_PER_PIXEL = 9525;
    public static final int EMU_PER_POINT = 12700;
    public static final int POINT_DPI = 72;
    public static final int PIXEL_DPI = 96;
    private static Map<ImageType, ImageProcessor<?>> imageProcessorMap = new HashMap();

    public static InputStream base64DataToInputStream(String base64Data) {
        byte[] bytes = Base64.getDecoder().decode(base64Data);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        return inputStream;
    }

    public static String getImageBase64Data(ImageType type, Object data, int width, int height) {
        ImageProcessor<?> targetProcessor = imageProcessorMap.get((Object)type);
        if (targetProcessor == null) {
            throw new ReportComputeException("Unknow image type :" + String.valueOf((Object)type));
        }
        InputStream inputStream = targetProcessor.getImage(data);
        try {
            if (width > 0 && height > 0) {
                BufferedImage inputImage = ImageIO.read(inputStream);
                BufferedImage outputImage = new BufferedImage(width, height, 8);
                Graphics2D g = outputImage.createGraphics();
                g.drawImage(inputImage, 0, 0, width, height, null);
                g.dispose();
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)outputImage, "png", outputStream);
                inputStream = new ByteArrayInputStream(outputStream.toByteArray());
            }
            byte[] bytes = IOUtils.toByteArray((InputStream)inputStream);
            String string = Base64.getEncoder().encodeToString(bytes);
            return string;
        }
        catch (Exception ex) {
            throw new ReportComputeException(ex);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    static {
        StaticImageProcessor staticImageProcessor = new StaticImageProcessor();
        imageProcessorMap.put(ImageType.image, staticImageProcessor);
        ChartImageProcessor chartImageProcessor = new ChartImageProcessor();
        imageProcessorMap.put(ImageType.chart, chartImageProcessor);
    }
}

