/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.utils;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import jnpf.util.JsonUtil;
import jnpf.util.ServletUtil;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpUtil.class);

    public static JSONObject httpsRequest(String requestUrl, String requestMethod, String outputStr) {
        JSONObject jsonObject = null;
        try {
            URL url = new URL(requestUrl);
            HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setUseCaches(false);
            conn.setRequestMethod(requestMethod);
            conn.setConnectTimeout(5000);
            conn.setReadTimeout(3000);
            if (null != outputStr) {
                OutputStream outputStream = conn.getOutputStream();
                outputStream.write(outputStr.getBytes("UTF-8"));
                outputStream.close();
            }
            InputStream inputStream = conn.getInputStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String str = null;
            StringBuffer buffer = new StringBuffer();
            while ((str = bufferedReader.readLine()) != null) {
                buffer.append(str);
            }
            bufferedReader.close();
            inputStreamReader.close();
            inputStream.close();
            conn.disconnect();
            jsonObject = JSONObject.parseObject((String)buffer.toString());
        }
        catch (Exception e) {
            if (e.getMessage().contains("400")) {
                jsonObject = JSONObject.parseObject((String)"{\"code\":400,\"message\":\"\u79df\u6237\u4e0d\u5b58\u5728,\u8bf7\u5148\u6ce8\u518c\",\"data\":null}");
            }
            log.error(e.getMessage());
        }
        return jsonObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONObject httpRequest(String requestUrl, String requestMethod, String outputStr, String ... token) {
        JSONObject jsonObject = null;
        try {
            String agent;
            URL url = new URL(requestUrl);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setUseCaches(false);
            conn.setRequestMethod(requestMethod);
            conn.setConnectTimeout(5000);
            conn.setReadTimeout(6000);
            conn.setRequestProperty("Content-Type", "application/json");
            if (ObjectUtil.isNotEmpty((Object)token)) {
                conn.setRequestProperty("Authorization", token[0]);
                if (token.length > 1 && ObjectUtil.isNotEmpty((Object)token[1])) {
                    Map requestHeader = JsonUtil.stringToMap((String)token[1]);
                    for (String field : requestHeader.keySet()) {
                        conn.setRequestProperty(field, String.valueOf(requestHeader.get(field)));
                    }
                }
            }
            if (ObjectUtil.isNotEmpty((Object)(agent = ServletUtil.getUserAgent()))) {
                conn.setRequestProperty("User-Agent", agent);
            }
            if (ObjectUtil.isNotEmpty((Object)outputStr)) {
                OutputStream outputStream = conn.getOutputStream();
                try {
                    outputStream.write(outputStr.getBytes("UTF-8"));
                    outputStream.close();
                }
                finally {
                    if (Collections.singletonList(outputStream).get(0) != null) {
                        outputStream.close();
                    }
                }
            }
            InputStream inputStream = conn.getInputStream();
            try {
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
                try {
                    BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                    try {
                        String str = null;
                        StringBuffer buffer = new StringBuffer();
                        while ((str = bufferedReader.readLine()) != null) {
                            buffer.append(str);
                        }
                        bufferedReader.close();
                        inputStreamReader.close();
                        inputStream.close();
                        conn.disconnect();
                        jsonObject = JSONObject.parseObject((String)buffer.toString());
                    }
                    finally {
                        if (Collections.singletonList(bufferedReader).get(0) != null) {
                            bufferedReader.close();
                        }
                    }
                }
                finally {
                    if (Collections.singletonList(inputStreamReader).get(0) != null) {
                        inputStreamReader.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(inputStream).get(0) != null) {
                    inputStream.close();
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        return jsonObject;
    }
}

