/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.provider.report.classpath;

import com.bstek.ureport.exception.ReportException;
import com.bstek.ureport.provider.report.ReportFile;
import com.bstek.ureport.provider.report.ReportProvider;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.Resource;

public class ClasspathReportProvider
implements ReportProvider,
ApplicationContextAware {
    private ApplicationContext applicationContext;

    @Override
    public InputStream loadReport(String file) {
        Resource resource = this.applicationContext.getResource(file);
        try {
            return resource.getInputStream();
        }
        catch (IOException e) {
            String newFileName = null;
            if (file.startsWith("classpath:")) {
                newFileName = "classpath*:" + file.substring(10, file.length());
            } else if (file.startsWith("classpath*:")) {
                newFileName = "classpath:" + file.substring(11, file.length());
            }
            if (newFileName != null) {
                try {
                    return this.applicationContext.getResource(file).getInputStream();
                }
                catch (IOException ex) {
                    throw new ReportException(e);
                }
            }
            throw new ReportException(e);
        }
    }

    @Override
    public String getPrefix() {
        return "classpath";
    }

    @Override
    public void deleteReport(String file) {
    }

    @Override
    public void saveReport(String file, String content) {
    }

    @Override
    public List<ReportFile> getReportFiles() {
        return null;
    }

    @Override
    public boolean disabled() {
        return false;
    }

    @Override
    public String getName() {
        return null;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

