/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.provider.image;

import com.bstek.ureport.exception.ReportComputeException;
import com.bstek.ureport.provider.image.ImageProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import jnpf.util.XSSEscape;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.StringUtils;
import org.springframework.web.context.WebApplicationContext;

public class DefaultImageProvider
implements ImageProvider,
ApplicationContextAware {
    private ApplicationContext applicationContext;
    private String baseWebPath;
    private String imgPath;

    @Override
    public InputStream getImage(String path) {
        try {
            if (((String)path).startsWith("classpath:") || ((String)path).startsWith("/WEB-INF")) {
                return this.applicationContext.getResource((String)path).getInputStream();
            }
            if (this.imgPath != null) {
                path = this.imgPath + (String)path;
                path = ((String)path).replaceAll("\\\\", "/").replaceAll("/{2,}", "/").replaceAll("\\.{2,}", "\\.");
            } else {
                path = this.baseWebPath + (String)path;
            }
            return new FileInputStream(XSSEscape.escapePath((String)path));
        }
        catch (IOException e) {
            throw new ReportComputeException(e);
        }
    }

    @Override
    public boolean support(String path) {
        if (path.startsWith("classpath:")) {
            return true;
        }
        if (this.baseWebPath != null && (path.startsWith("/") || path.startsWith("/WEB-INF"))) {
            return true;
        }
        return this.imgPath != null && !path.matches("\\w+://.*");
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (applicationContext instanceof WebApplicationContext) {
            WebApplicationContext context = (WebApplicationContext)applicationContext;
            this.baseWebPath = context.getServletContext().getRealPath("/");
        }
        if (StringUtils.hasText((String)applicationContext.getEnvironment().getProperty("config.imgPath"))) {
            File f;
            this.imgPath = applicationContext.getEnvironment().getProperty("config.imgPath");
            this.imgPath = this.imgPath.replaceAll("\\\\", "/");
            if (!this.imgPath.endsWith("/")) {
                this.imgPath = this.imgPath + "/";
            }
            if (!(f = new File(this.imgPath)).exists()) {
                f.mkdirs();
            }
        }
        this.applicationContext = applicationContext;
    }
}

