/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.parser.impl;

import com.bstek.ureport.definition.dataset.BeanDatasetDefinition;
import com.bstek.ureport.definition.dataset.DatasetDefinition;
import com.bstek.ureport.definition.dataset.Field;
import com.bstek.ureport.definition.dataset.Parameter;
import com.bstek.ureport.definition.dataset.SqlDatasetDefinition;
import com.bstek.ureport.definition.datasource.BuildinDatasourceDefinition;
import com.bstek.ureport.definition.datasource.DataType;
import com.bstek.ureport.definition.datasource.DatasourceDefinition;
import com.bstek.ureport.definition.datasource.JdbcDatasourceDefinition;
import com.bstek.ureport.definition.datasource.SpringBeanDatasourceDefinition;
import com.bstek.ureport.expression.ExpressionUtils;
import com.bstek.ureport.expression.model.Expression;
import com.bstek.ureport.parser.Parser;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Element;

public class DatasourceParser
implements Parser<DatasourceDefinition> {
    @Override
    public DatasourceDefinition parse(Element element) {
        String type = element.attributeValue("type");
        if (type.equals("jdbc")) {
            JdbcDatasourceDefinition ds = new JdbcDatasourceDefinition();
            ds.setName(element.attributeValue("name"));
            ds.setDriver(element.attributeValue("driver"));
            ds.setUrl(element.attributeValue("url"));
            ds.setUsername(element.attributeValue("username"));
            ds.setPassword(element.attributeValue("password"));
            ds.setDatasets(this.parseDatasets(element));
            return ds;
        }
        if (type.equals("spring")) {
            SpringBeanDatasourceDefinition ds = new SpringBeanDatasourceDefinition();
            ds.setName(element.attributeValue("name"));
            ds.setBeanId(element.attributeValue("bean"));
            ds.setDatasets(this.parseDatasets(element));
            return ds;
        }
        if (type.equals("buildin")) {
            BuildinDatasourceDefinition ds = new BuildinDatasourceDefinition();
            ds.setName(element.attributeValue("name"));
            ds.setDatasets(this.parseDatasets(element));
            return ds;
        }
        return null;
    }

    private List<DatasetDefinition> parseDatasets(Element element) {
        ArrayList<DatasetDefinition> list = new ArrayList<DatasetDefinition>();
        for (Object obj : element.elements()) {
            DatasetDefinition dataset;
            if (obj == null || !(obj instanceof Element)) continue;
            Element ele = (Element)obj;
            String type = ele.attributeValue("type");
            if (type.equals("sql")) {
                dataset = new SqlDatasetDefinition();
                ((SqlDatasetDefinition)dataset).setName(ele.attributeValue("name"));
                ((SqlDatasetDefinition)dataset).setSql(this.parseSql(ele, (SqlDatasetDefinition)dataset));
                ((SqlDatasetDefinition)dataset).setFields(this.parseFields(ele));
                ((SqlDatasetDefinition)dataset).setParameters(this.parseParameters(ele));
                list.add(dataset);
                continue;
            }
            if (!type.equals("bean")) continue;
            dataset = new BeanDatasetDefinition();
            ((BeanDatasetDefinition)dataset).setName(ele.attributeValue("name"));
            ((BeanDatasetDefinition)dataset).setMethod(ele.attributeValue("method"));
            ((BeanDatasetDefinition)dataset).setFields(this.parseFields(ele));
            ((BeanDatasetDefinition)dataset).setClazz(ele.attributeValue("clazz"));
            list.add(dataset);
        }
        return list;
    }

    private List<Parameter> parseParameters(Element element) {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        for (Object obj : element.elements()) {
            Element ele;
            if (obj == null || !(obj instanceof Element) || !(ele = (Element)obj).getName().equals("parameter")) continue;
            Parameter param = new Parameter();
            param.setName(ele.attributeValue("name"));
            param.setDefaultValue(ele.attributeValue("default-value"));
            param.setType(DataType.valueOf(ele.attributeValue("type")));
            parameters.add(param);
        }
        return parameters;
    }

    private List<Field> parseFields(Element element) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Object obj : element.elements()) {
            Element ele;
            if (obj == null || !(obj instanceof Element) || !(ele = (Element)obj).getName().equals("field")) continue;
            Field field = new Field(ele.attributeValue("name"));
            fields.add(field);
        }
        return fields;
    }

    private String parseSql(Element element, SqlDatasetDefinition dataset) {
        for (Object obj : element.elements()) {
            Element ele;
            if (obj == null || !(obj instanceof Element) || !(ele = (Element)obj).getName().equals("sql")) continue;
            String sql = ele.getText().trim();
            if (sql.startsWith("${") && sql.endsWith("}")) {
                String s = sql.substring(2, sql.length() - 1);
                Expression expr = ExpressionUtils.parseExpression(s);
                dataset.setSqlExpression(expr);
            }
            return ele.getText();
        }
        return null;
    }
}

