/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.parser.impl;

import com.bstek.ureport.Utils;
import com.bstek.ureport.definition.Alignment;
import com.bstek.ureport.definition.Border;
import com.bstek.ureport.definition.BorderStyle;
import com.bstek.ureport.definition.CellStyle;
import com.bstek.ureport.definition.ConditionCellStyle;
import com.bstek.ureport.definition.Scope;
import com.bstek.ureport.parser.Parser;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;

public class CellStyleParser
implements Parser<CellStyle> {
    @Override
    public CellStyle parse(Element element) {
        String lineHeight;
        String wrapCompute;
        String align;
        String valign;
        String underline;
        String fontSize;
        String bold;
        String fontFamily;
        boolean forCondition = false;
        String forConditionText = element.attributeValue("for-condition");
        if (StringUtils.isNotBlank((String)forConditionText)) {
            forCondition = Boolean.valueOf(forConditionText);
        }
        CellStyle style = null;
        if (forCondition) {
            String valignScope;
            String alignScope;
            String underlineScope;
            String italicScope;
            String boldScope;
            String fontFamilyScope;
            String fontSizeScope;
            String forecolorScope;
            ConditionCellStyle s = new ConditionCellStyle();
            String bgcolorScope = element.attributeValue("bgcolor-scope");
            if (StringUtils.isNotBlank((String)bgcolorScope)) {
                s.setBgcolorScope(Scope.valueOf(bgcolorScope));
            }
            if (StringUtils.isNotBlank((String)(forecolorScope = element.attributeValue("forecolor-scope")))) {
                s.setForecolorScope(Scope.valueOf(forecolorScope));
            }
            if (StringUtils.isNotBlank((String)(fontSizeScope = element.attributeValue("font-size-scope")))) {
                s.setFontSizeScope(Scope.valueOf(fontSizeScope));
            }
            if (StringUtils.isNotBlank((String)(fontFamilyScope = element.attributeValue("font-family-scope")))) {
                s.setFontFamilyScope(Scope.valueOf(fontFamilyScope));
            }
            if (StringUtils.isNotBlank((String)(boldScope = element.attributeValue("bold-scope")))) {
                s.setBoldScope(Scope.valueOf(boldScope));
            }
            if (StringUtils.isNotBlank((String)(italicScope = element.attributeValue("italic-scope")))) {
                s.setItalicScope(Scope.valueOf(italicScope));
            }
            if (StringUtils.isNotBlank((String)(underlineScope = element.attributeValue("underline-scope")))) {
                s.setUnderlineScope(Scope.valueOf(underlineScope));
            }
            if (StringUtils.isNotBlank((String)(alignScope = element.attributeValue("align-scope")))) {
                s.setAlignScope(Scope.valueOf(alignScope));
            }
            if (StringUtils.isNotBlank((String)(valignScope = element.attributeValue("valign-scope")))) {
                s.setValignScope(Scope.valueOf(valignScope));
            }
            style = s;
        } else {
            style = new CellStyle();
        }
        style.setBgcolor(element.attributeValue("bgcolor"));
        String forecolor = element.attributeValue("forecolor");
        if (StringUtils.isNotBlank((String)forecolor)) {
            style.setForecolor(forecolor);
        }
        if (StringUtils.isNotBlank((String)(fontFamily = element.attributeValue("font-family")))) {
            style.setFontFamily(fontFamily);
        }
        if (StringUtils.isNotBlank((String)(bold = element.attributeValue("bold")))) {
            style.setBold(Boolean.valueOf(bold));
        }
        if (StringUtils.isNotBlank((String)(fontSize = element.attributeValue("font-size")))) {
            style.setFontSize(Integer.valueOf(fontSize));
        }
        style.setFormat(element.attributeValue("format"));
        String italic = element.attributeValue("italic");
        if (StringUtils.isNotBlank((String)italic)) {
            style.setItalic(Boolean.valueOf(italic));
        }
        if (StringUtils.isNotBlank((String)(underline = element.attributeValue("underline")))) {
            style.setUnderline(Boolean.valueOf(underline));
        }
        if (StringUtils.isNotBlank((String)(valign = element.attributeValue("valign")))) {
            style.setValign(Alignment.valueOf(valign));
        }
        if (StringUtils.isNotBlank((String)(align = element.attributeValue("align")))) {
            style.setAlign(Alignment.valueOf(align));
        }
        if (StringUtils.isNotBlank((String)(wrapCompute = element.attributeValue("wrap-compute")))) {
            style.setWrapCompute(Boolean.valueOf(wrapCompute));
        }
        if (StringUtils.isNotBlank((String)(lineHeight = element.attributeValue("line-height")))) {
            style.setLineHeight(Utils.toBigDecimal(lineHeight).floatValue());
        }
        for (Object obj : element.elements()) {
            if (obj == null || !(obj instanceof Element)) continue;
            Element ele = (Element)obj;
            String name = ele.getName();
            if (name.equals("left-border")) {
                style.setLeftBorder(this.parseBorder(ele));
                continue;
            }
            if (name.equals("right-border")) {
                style.setRightBorder(this.parseBorder(ele));
                continue;
            }
            if (name.equals("top-border")) {
                style.setTopBorder(this.parseBorder(ele));
                continue;
            }
            if (!name.equals("bottom-border")) continue;
            style.setBottomBorder(this.parseBorder(ele));
        }
        return style;
    }

    private Border parseBorder(Element element) {
        Border border = new Border();
        border.setWidth(Integer.valueOf(element.attributeValue("width")));
        border.setStyle(BorderStyle.valueOf(element.attributeValue("style")));
        border.setColor(element.attributeValue("color"));
        return border;
    }
}

