/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.model;

import com.bstek.ureport.build.Context;
import com.bstek.ureport.build.paging.Page;
import com.bstek.ureport.build.paging.PagingBuilder;
import com.bstek.ureport.definition.Band;
import com.bstek.ureport.definition.ConditionPropertyItem;
import com.bstek.ureport.definition.HeaderFooterDefinition;
import com.bstek.ureport.definition.Paper;
import com.bstek.ureport.model.Cell;
import com.bstek.ureport.model.Column;
import com.bstek.ureport.model.Row;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Report {
    private Paper paper;
    private HeaderFooterDefinition header;
    private HeaderFooterDefinition footer;
    private Cell rootCell;
    private Context context;
    private List<Row> rows;
    private List<Row> headerRepeatRows = new ArrayList<Row>();
    private List<Row> footerRepeatRows = new ArrayList<Row>();
    private List<Row> titleRows = new ArrayList<Row>();
    private List<Row> summaryRows = new ArrayList<Row>();
    private int repeatHeaderRowHeight = 0;
    private int repeatFooterRowHeight = 0;
    private int titleRowsHeight = 0;
    private int summaryRowsHeight = 0;
    private List<Column> columns;
    private List<Page> pages;
    private String reportFullName;
    private List<Cell> lazyComputeCells = new ArrayList<Cell>();
    private Map<Row, Map<Column, Cell>> rowColCellMap = new HashMap<Row, Map<Column, Cell>>();
    private Map<String, List<Cell>> cellsMap = new HashMap<String, List<Cell>>();

    public void insertRow(Row row, int rowNumber) {
        int pos = rowNumber - 1;
        this.rows.add(pos, row);
        Band band = row.getBand();
        if (band == null) {
            return;
        }
    }

    public void insertRows(int firstRowIndex, List<Row> insertRows) {
        int pos = firstRowIndex - 1;
        this.rows.addAll(pos, insertRows);
    }

    public void insertColumn(Column column, int columnNumber) {
        int pos = columnNumber - 1;
        this.columns.add(pos, column);
    }

    public void insertColumns(int firstColumnIndex, List<Column> insertColumns) {
        int pos = firstColumnIndex - 1;
        this.columns.addAll(pos, insertColumns);
    }

    public Row getRow(int rowNumber) {
        if (rowNumber > this.rows.size()) {
            return null;
        }
        return this.rows.get(rowNumber - 1);
    }

    public Column getColumn(int columnNumber) {
        if (columnNumber > this.columns.size()) {
            return null;
        }
        return this.columns.get(columnNumber - 1);
    }

    public Cell getRootCell() {
        return this.rootCell;
    }

    public void setRootCell(Cell rootCell) {
        this.rootCell = rootCell;
    }

    public boolean addCell(Cell cell) {
        String cellName = cell.getName();
        ArrayList<Cell> cells = null;
        if (this.cellsMap.containsKey(cellName)) {
            cells = this.cellsMap.get(cellName);
        } else {
            cells = new ArrayList();
            this.cellsMap.put(cellName, cells);
        }
        int lastIdx = this.findSameLeftCell(cells, cell, 0);
        if (lastIdx > -1 && lastIdx < cells.size() - 1) {
            cells.add(lastIdx + 1, cell);
        } else {
            cells.add(cell);
        }
        Row row = cell.getRow();
        Column col = cell.getColumn();
        Map<Object, Object> colMap = null;
        if (this.rowColCellMap.containsKey(row)) {
            colMap = this.rowColCellMap.get(row);
        } else {
            colMap = new HashMap();
            this.rowColCellMap.put(row, colMap);
        }
        colMap.put(col, cell);
        return this.addLazyCell(cell);
    }

    public int findSameLeftCell(List<Cell> cells, Cell nowCell, int deep) {
        int lastIdx = -1;
        if ((nowCell = nowCell.getLeftParentCell()) == null) {
            return lastIdx;
        }
        for (int i = cells.size() - 1; i >= 0; --i) {
            Cell left = cells.get(i).getLeftParentCell();
            for (int j = 0; j < deep; ++j) {
                if (left == null) {
                    return lastIdx;
                }
                left = left.getLeftParentCell();
            }
            if (left == null || !left.equals(nowCell)) continue;
            return i;
        }
        if (lastIdx == -1 && nowCell.getLeftParentCell() != null) {
            return this.findSameLeftCell(cells, nowCell, deep + 1);
        }
        return lastIdx;
    }

    public boolean addLazyCell(Cell cell) {
        List<ConditionPropertyItem> conditionPropertyItems = cell.getConditionPropertyItems();
        if (conditionPropertyItems != null && conditionPropertyItems.size() > 0) {
            this.lazyComputeCells.add(cell);
            return true;
        }
        return false;
    }

    public Map<Row, Map<Column, Cell>> getRowColCellMap() {
        return this.rowColCellMap;
    }

    public List<Page> getPages() {
        if (this.pages == null) {
            this.pages = PagingBuilder.buildPages(this);
        }
        return this.pages;
    }

    public void setPages(List<Page> pages) {
        this.pages = pages;
    }

    public void rePaging(Paper paper) {
        paper.setColumnCount(this.paper.getColumnCount());
        paper.setColumnEnabled(this.paper.isColumnEnabled());
        paper.setFixRows(this.paper.getFixRows());
        paper.setPagingMode(this.paper.getPagingMode());
        this.setPaper(paper);
        this.pages = PagingBuilder.buildPages(this);
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public String getReportFullName() {
        return this.reportFullName;
    }

    public void setReportFullName(String reportFullName) {
        this.reportFullName = reportFullName;
    }

    public Paper getPaper() {
        return this.paper;
    }

    public void setPaper(Paper paper) {
        this.paper = paper;
    }

    public Map<String, List<Cell>> getCellsMap() {
        return this.cellsMap;
    }

    public List<Cell> getLazyComputeCells() {
        return this.lazyComputeCells;
    }

    public List<Row> getRows() {
        return this.rows;
    }

    public void setRows(List<Row> rows) {
        this.rows = rows;
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public void setColumns(List<Column> columns) {
        this.columns = columns;
    }

    public List<Row> getHeaderRepeatRows() {
        return this.headerRepeatRows;
    }

    public void setHeaderRepeatRows(List<Row> headerRepeatRows) {
        this.headerRepeatRows = headerRepeatRows;
    }

    public List<Row> getFooterRepeatRows() {
        return this.footerRepeatRows;
    }

    public void setFooterRepeatRows(List<Row> footerRepeatRows) {
        this.footerRepeatRows = footerRepeatRows;
    }

    public List<Row> getTitleRows() {
        return this.titleRows;
    }

    public List<Row> getSummaryRows() {
        return this.summaryRows;
    }

    public int getRepeatHeaderRowHeight() {
        return this.repeatHeaderRowHeight;
    }

    public void setRepeatHeaderRowHeight(int repeatHeaderRowHeight) {
        this.repeatHeaderRowHeight = repeatHeaderRowHeight;
    }

    public int getRepeatFooterRowHeight() {
        return this.repeatFooterRowHeight;
    }

    public void setRepeatFooterRowHeight(int repeatFooterRowHeight) {
        this.repeatFooterRowHeight = repeatFooterRowHeight;
    }

    public int getTitleRowsHeight() {
        return this.titleRowsHeight;
    }

    public void setTitleRowsHeight(int titleRowsHeight) {
        this.titleRowsHeight = titleRowsHeight;
    }

    public int getSummaryRowsHeight() {
        return this.summaryRowsHeight;
    }

    public void setSummaryRowsHeight(int summaryRowsHeight) {
        this.summaryRowsHeight = summaryRowsHeight;
    }

    public HeaderFooterDefinition getHeader() {
        return this.header;
    }

    public void setHeader(HeaderFooterDefinition header) {
        this.header = header;
    }

    public HeaderFooterDefinition getFooter() {
        return this.footer;
    }

    public void setFooter(HeaderFooterDefinition footer) {
        this.footer = footer;
    }
}

