/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.model;

import com.bstek.ureport.Range;
import com.bstek.ureport.Utils;
import com.bstek.ureport.build.BindData;
import com.bstek.ureport.build.Context;
import com.bstek.ureport.definition.Alignment;
import com.bstek.ureport.definition.BlankCellInfo;
import com.bstek.ureport.definition.Border;
import com.bstek.ureport.definition.CellStyle;
import com.bstek.ureport.definition.ConditionCellStyle;
import com.bstek.ureport.definition.ConditionPaging;
import com.bstek.ureport.definition.ConditionPropertyItem;
import com.bstek.ureport.definition.Expand;
import com.bstek.ureport.definition.LinkParameter;
import com.bstek.ureport.definition.PagingPosition;
import com.bstek.ureport.definition.Scope;
import com.bstek.ureport.definition.value.SimpleValue;
import com.bstek.ureport.definition.value.Value;
import com.bstek.ureport.exception.ReportComputeException;
import com.bstek.ureport.expression.model.Condition;
import com.bstek.ureport.expression.model.Expression;
import com.bstek.ureport.expression.model.data.BindDataListExpressionData;
import com.bstek.ureport.expression.model.data.ExpressionData;
import com.bstek.ureport.expression.model.data.ObjectExpressionData;
import com.bstek.ureport.expression.model.data.ObjectListExpressionData;
import com.bstek.ureport.model.Column;
import com.bstek.ureport.model.ReportCell;
import com.bstek.ureport.model.Row;
import com.bstek.ureport.utils.UnitUtils;
import java.awt.Font;
import java.awt.FontMetrics;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import org.apache.commons.lang3.StringUtils;

public class Cell
implements ReportCell {
    private String name;
    private int rowSpan;
    private int colSpan;
    private int pageRowSpan = -1;
    private String renderBean;
    private Object data;
    private Object formatData;
    private CellStyle cellStyle;
    private CellStyle customCellStyle;
    private Value value;
    private Row row;
    private Column column;
    private Expand expand;
    private boolean processed;
    private boolean blankCell;
    private boolean existPageFunction;
    private List<Object> bindData;
    private Range duplicateRange;
    private boolean forPaging;
    private String linkUrl;
    private String linkTargetWindow;
    private List<LinkParameter> linkParameters;
    private Map<String, String> linkParameterMap;
    private Expression linkUrlExpression;
    private List<ConditionPropertyItem> conditionPropertyItems;
    private boolean fillBlankRows;
    private int multiple;
    private Cell leftParentCell;
    private Cell topParentCell;
    private Map<String, List<Cell>> rowChildrenCellsMap = new HashMap<String, List<Cell>>();
    private Map<String, List<Cell>> columnChildrenCellsMap = new HashMap<String, List<Cell>>();
    private List<String> increaseSpanCellNames;
    private Map<String, BlankCellInfo> newBlankCellsMap;
    private List<String> newCellNames;

    public Cell newRowBlankCell(Context context, BlankCellInfo blankCellInfo, ReportCell mainCell) {
        Cell blankCell = this.newCell();
        blankCell.setBlankCell(true);
        blankCell.setValue(new SimpleValue(""));
        blankCell.setExpand(Expand.None);
        blankCell.setBindData(null);
        if (blankCellInfo != null) {
            int offset = blankCellInfo.getOffset();
            int mainRowNumber = mainCell.getRow().getRowNumber();
            if (offset == 0) {
                blankCell.setRow(mainCell.getRow());
            } else {
                int rowNumber = mainRowNumber + offset;
                Row row = context.getRow(rowNumber);
                blankCell.setRow(row);
            }
            blankCell.setRowSpan(blankCellInfo.getSpan());
        }
        return blankCell;
    }

    public Cell newColumnBlankCell(Context context, BlankCellInfo blankCellInfo, ReportCell mainCell) {
        Cell blankCell = this.newCell();
        blankCell.setBlankCell(true);
        blankCell.setValue(new SimpleValue(""));
        blankCell.setExpand(Expand.None);
        blankCell.setBindData(null);
        int offset = blankCellInfo.getOffset();
        int mainColNumber = mainCell.getColumn().getColumnNumber();
        if (offset == 0) {
            blankCell.setColumn(mainCell.getColumn());
        } else {
            int colNumber = mainColNumber + offset;
            Column col = context.getColumn(colNumber);
            blankCell.setColumn(col);
        }
        blankCell.setColSpan(blankCellInfo.getSpan());
        return blankCell;
    }

    public Cell newCell() {
        Cell cell = new Cell();
        cell.setColumn(this.column);
        cell.setRow(this.row);
        cell.setLeftParentCell(this.leftParentCell);
        cell.setTopParentCell(this.topParentCell);
        cell.setValue(this.value);
        cell.setRowSpan(this.rowSpan);
        cell.setColSpan(this.colSpan);
        cell.setExpand(this.expand);
        cell.setName(this.name);
        cell.setCellStyle(this.cellStyle);
        cell.setNewBlankCellsMap(this.newBlankCellsMap);
        cell.setNewCellNames(this.newCellNames);
        cell.setIncreaseSpanCellNames(this.increaseSpanCellNames);
        cell.setDuplicateRange(this.duplicateRange);
        cell.setLinkParameters(this.linkParameters);
        cell.setLinkTargetWindow(this.linkTargetWindow);
        cell.setLinkUrl(this.linkUrl);
        cell.setPageRowSpan(this.pageRowSpan);
        cell.setConditionPropertyItems(this.conditionPropertyItems);
        cell.setFillBlankRows(this.fillBlankRows);
        cell.setMultiple(this.multiple);
        cell.setLinkUrlExpression(this.linkUrlExpression);
        return cell;
    }

    public void addRowChild(Cell child) {
        String name = child.getName();
        List<Cell> cells = this.rowChildrenCellsMap.get(name);
        if (cells == null) {
            cells = new ArrayList<Cell>();
            this.rowChildrenCellsMap.put(name, cells);
        }
        if (!cells.contains(child)) {
            cells.add(child);
        }
        if (this.leftParentCell != null) {
            this.leftParentCell.addRowChild(child);
        }
    }

    public void addColumnChild(Cell child) {
        String name = child.getName();
        List<Cell> cells = this.columnChildrenCellsMap.get(name);
        if (cells == null) {
            cells = new ArrayList<Cell>();
            this.columnChildrenCellsMap.put(name, cells);
        }
        if (!cells.contains(child)) {
            cells.add(child);
        }
        if (this.topParentCell != null) {
            this.topParentCell.addColumnChild(child);
        }
    }

    @Override
    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public Object getFormatData() {
        if (this.formatData == null) {
            return this.data;
        }
        return this.formatData;
    }

    public void setFormatData(Object formatData) {
        this.formatData = formatData;
    }

    public void doCompute(Context context) {
        this.doComputeConditionProperty(context);
        this.doFormat();
        this.doDataWrapCompute(context);
    }

    public void doFormat() {
        String format = this.cellStyle.getFormat();
        String customFormat = null;
        if (this.customCellStyle != null) {
            customFormat = this.customCellStyle.getFormat();
        }
        if (StringUtils.isNotBlank(customFormat)) {
            format = customFormat;
        }
        if (StringUtils.isBlank((CharSequence)format) || this.data == null || StringUtils.isBlank((CharSequence)this.data.toString())) {
            return;
        }
        if (this.data instanceof Date) {
            Date d = (Date)this.data;
            SimpleDateFormat sd = new SimpleDateFormat(format);
            this.formatData = sd.format(d);
        } else {
            BigDecimal bd = null;
            try {
                bd = Utils.toBigDecimal(this.data);
            }
            catch (Exception sd) {
                // empty catch block
            }
            if (bd != null) {
                DecimalFormat df = new DecimalFormat(format);
                this.formatData = df.format(bd.doubleValue());
            }
        }
    }

    private void doComputeConditionProperty(Context context) {
        if (this.conditionPropertyItems == null || this.conditionPropertyItems.size() == 0) {
            return;
        }
        for (ConditionPropertyItem item : this.conditionPropertyItems) {
            Border bottomBorder;
            Border topBorder;
            Border rightBorder;
            Border leftBorder;
            Alignment valign;
            Alignment align;
            String format;
            String fontFamily;
            int fontSize;
            String bgcolor;
            String forecolor;
            Boolean underline;
            Boolean italic;
            ConditionCellStyle style;
            int colWidth;
            int rowHeight;
            PagingPosition position;
            Condition condition = item.getCondition();
            if (condition == null) continue;
            Object obj = null;
            List<Object> bindDataList = this.bindData;
            if (bindDataList != null && bindDataList.size() > 0) {
                obj = bindDataList.get(0);
            }
            if (!condition.filter(this, this, obj, context)) continue;
            ConditionPaging paging = item.getPaging();
            if (paging != null && (position = paging.getPosition()) != null) {
                if (position.equals((Object)PagingPosition.after)) {
                    int line = paging.getLine();
                    if (line == 0) {
                        this.row.setPageBreak(true);
                    } else {
                        int rowNumber = this.row.getRowNumber() + line;
                        Row targetRow = context.getRow(rowNumber);
                        targetRow.setPageBreak(true);
                    }
                } else {
                    int rowNumber = this.row.getRowNumber() - 1;
                    Row targetRow = context.getRow(rowNumber);
                    targetRow.setPageBreak(true);
                }
            }
            if ((rowHeight = item.getRowHeight()) > -1) {
                this.row.setRealHeight(rowHeight);
                if (rowHeight == 0 && !this.row.isHide()) {
                    context.doHideProcessRow(this.row);
                }
            }
            if ((colWidth = item.getColWidth()) > -1) {
                this.column.setWidth(colWidth);
                if (colWidth == 0 && !this.column.isHide()) {
                    context.doHideProcessColumn(this.column);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)item.getNewValue())) {
                this.data = item.getNewValue();
                this.formatData = item.getNewValue();
            }
            if (StringUtils.isNotBlank((CharSequence)item.getLinkUrl())) {
                this.linkUrl = item.getLinkUrl();
                if (StringUtils.isNotBlank((CharSequence)item.getLinkTargetWindow())) {
                    this.linkTargetWindow = item.getLinkTargetWindow();
                }
                if (item.getLinkParameters() != null && item.getLinkParameters().size() > 0) {
                    this.linkParameters = item.getLinkParameters();
                }
            }
            if ((style = item.getCellStyle()) == null) continue;
            Boolean bold = style.getBold();
            if (bold != null) {
                Scope scope = style.getBoldScope();
                if (scope.equals((Object)Scope.cell)) {
                    if (this.customCellStyle == null) {
                        this.customCellStyle = new CellStyle();
                    }
                    this.customCellStyle.setBold(bold);
                } else if (scope.equals((Object)Scope.row)) {
                    if (this.row.getCustomCellStyle() == null) {
                        this.row.setCustomCellStyle(new CellStyle());
                    }
                    this.row.getCustomCellStyle().setBold(bold);
                } else if (scope.equals((Object)Scope.column)) {
                    if (this.column.getCustomCellStyle() == null) {
                        this.column.setCustomCellStyle(new CellStyle());
                    }
                    this.column.getCustomCellStyle().setBold(bold);
                }
            }
            if ((italic = style.getItalic()) != null) {
                Scope scope = style.getItalicScope();
                if (scope.equals((Object)Scope.cell)) {
                    if (this.customCellStyle == null) {
                        this.customCellStyle = new CellStyle();
                    }
                    this.customCellStyle.setItalic(italic);
                } else if (scope.equals((Object)Scope.row)) {
                    if (this.row.getCustomCellStyle() == null) {
                        this.row.setCustomCellStyle(new CellStyle());
                    }
                    this.row.getCustomCellStyle().setItalic(italic);
                } else if (scope.equals((Object)Scope.column)) {
                    if (this.column.getCustomCellStyle() == null) {
                        this.column.setCustomCellStyle(new CellStyle());
                    }
                    this.column.getCustomCellStyle().setItalic(italic);
                }
            }
            if ((underline = style.getUnderline()) != null) {
                Scope scope = style.getUnderlineScope();
                if (scope.equals((Object)Scope.cell)) {
                    if (this.customCellStyle == null) {
                        this.customCellStyle = new CellStyle();
                    }
                    this.customCellStyle.setUnderline(underline);
                } else if (scope.equals((Object)Scope.row)) {
                    if (this.row.getCustomCellStyle() == null) {
                        this.row.setCustomCellStyle(new CellStyle());
                    }
                    this.row.getCustomCellStyle().setUnderline(underline);
                } else if (scope.equals((Object)Scope.column)) {
                    if (this.column.getCustomCellStyle() == null) {
                        this.column.setCustomCellStyle(new CellStyle());
                    }
                    this.column.getCustomCellStyle().setUnderline(underline);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)(forecolor = style.getForecolor()))) {
                Scope scope = style.getForecolorScope();
                if (scope.equals((Object)Scope.cell)) {
                    if (this.customCellStyle == null) {
                        this.customCellStyle = new CellStyle();
                    }
                    this.customCellStyle.setForecolor(forecolor);
                } else if (scope.equals((Object)Scope.row)) {
                    if (this.row.getCustomCellStyle() == null) {
                        this.row.setCustomCellStyle(new CellStyle());
                    }
                    this.row.getCustomCellStyle().setForecolor(forecolor);
                } else if (scope.equals((Object)Scope.column)) {
                    if (this.column.getCustomCellStyle() == null) {
                        this.column.setCustomCellStyle(new CellStyle());
                    }
                    this.column.getCustomCellStyle().setForecolor(forecolor);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)(bgcolor = style.getBgcolor()))) {
                Scope scope = style.getBgcolorScope();
                if (scope.equals((Object)Scope.cell)) {
                    if (this.customCellStyle == null) {
                        this.customCellStyle = new CellStyle();
                    }
                    this.customCellStyle.setBgcolor(bgcolor);
                } else if (scope.equals((Object)Scope.row)) {
                    if (this.row.getCustomCellStyle() == null) {
                        this.row.setCustomCellStyle(new CellStyle());
                    }
                    this.row.getCustomCellStyle().setBgcolor(bgcolor);
                } else if (scope.equals((Object)Scope.column)) {
                    if (this.column.getCustomCellStyle() == null) {
                        this.column.setCustomCellStyle(new CellStyle());
                    }
                    this.column.getCustomCellStyle().setBgcolor(bgcolor);
                }
            }
            if ((fontSize = style.getFontSize()) > 0) {
                Scope scope = style.getFontSizeScope();
                if (scope.equals((Object)Scope.cell)) {
                    if (this.customCellStyle == null) {
                        this.customCellStyle = new CellStyle();
                    }
                    this.customCellStyle.setFontSize(fontSize);
                } else if (scope.equals((Object)Scope.row)) {
                    if (this.row.getCustomCellStyle() == null) {
                        this.row.setCustomCellStyle(new CellStyle());
                    }
                    this.row.getCustomCellStyle().setFontSize(fontSize);
                } else if (scope.equals((Object)Scope.column)) {
                    if (this.column.getCustomCellStyle() == null) {
                        this.column.setCustomCellStyle(new CellStyle());
                    }
                    this.column.getCustomCellStyle().setFontSize(fontSize);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)(fontFamily = style.getFontFamily()))) {
                Scope scope = style.getFontFamilyScope();
                if (scope.equals((Object)Scope.cell)) {
                    if (this.customCellStyle == null) {
                        this.customCellStyle = new CellStyle();
                    }
                    this.customCellStyle.setFontFamily(fontFamily);
                } else if (scope.equals((Object)Scope.row)) {
                    if (this.row.getCustomCellStyle() == null) {
                        this.row.setCustomCellStyle(new CellStyle());
                    }
                    this.row.getCustomCellStyle().setFontFamily(fontFamily);
                } else if (scope.equals((Object)Scope.column)) {
                    if (this.column.getCustomCellStyle() == null) {
                        this.column.setCustomCellStyle(new CellStyle());
                    }
                    this.column.getCustomCellStyle().setFontFamily(fontFamily);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)(format = style.getFormat()))) {
                if (this.customCellStyle == null) {
                    this.customCellStyle = new CellStyle();
                }
                this.customCellStyle.setFormat(format);
            }
            if ((align = style.getAlign()) != null) {
                Scope scope = style.getAlignScope();
                if (scope.equals((Object)Scope.cell)) {
                    if (this.customCellStyle == null) {
                        this.customCellStyle = new CellStyle();
                    }
                    this.customCellStyle.setAlign(align);
                } else if (scope.equals((Object)Scope.row)) {
                    if (this.row.getCustomCellStyle() == null) {
                        this.row.setCustomCellStyle(new CellStyle());
                    }
                    this.row.getCustomCellStyle().setAlign(align);
                } else if (scope.equals((Object)Scope.column)) {
                    if (this.column.getCustomCellStyle() == null) {
                        this.column.setCustomCellStyle(new CellStyle());
                    }
                    this.column.getCustomCellStyle().setAlign(align);
                }
            }
            if ((valign = style.getValign()) != null) {
                Scope scope = style.getValignScope();
                if (scope.equals((Object)Scope.cell)) {
                    if (this.customCellStyle == null) {
                        this.customCellStyle = new CellStyle();
                    }
                    this.customCellStyle.setValign(valign);
                } else if (scope.equals((Object)Scope.row)) {
                    if (this.row.getCustomCellStyle() == null) {
                        this.row.setCustomCellStyle(new CellStyle());
                    }
                    this.row.getCustomCellStyle().setValign(valign);
                } else if (scope.equals((Object)Scope.column)) {
                    if (this.column.getCustomCellStyle() == null) {
                        this.column.setCustomCellStyle(new CellStyle());
                    }
                    this.column.getCustomCellStyle().setValign(valign);
                }
            }
            if ((leftBorder = style.getLeftBorder()) != null) {
                this.customCellStyle.setLeftBorder(leftBorder);
            }
            if ((rightBorder = style.getRightBorder()) != null) {
                this.customCellStyle.setRightBorder(rightBorder);
            }
            if ((topBorder = style.getTopBorder()) != null) {
                this.customCellStyle.setTopBorder(topBorder);
            }
            if ((bottomBorder = style.getBottomBorder()) == null) continue;
            this.customCellStyle.setBottomBorder(bottomBorder);
        }
    }

    public void doDataWrapCompute(Context context) {
        int dif;
        Boolean wrapCompute = this.cellStyle.getWrapCompute();
        if (wrapCompute == null || !wrapCompute.booleanValue()) {
            return;
        }
        Object targetData = this.getFormatData();
        if (targetData == null || !(targetData instanceof String)) {
            return;
        }
        String dataText = targetData.toString();
        if (StringUtils.isBlank((CharSequence)dataText) || dataText.length() < 2) {
            return;
        }
        int totalColumnWidth = this.column.getWidth();
        if (this.colSpan > 0) {
            int colNumber = this.column.getColumnNumber();
            for (int i = 1; i < this.colSpan; ++i) {
                Column col = context.getColumn(colNumber + i);
                totalColumnWidth += col.getWidth();
            }
        }
        Font font = this.cellStyle.getFont();
        JLabel jlabel = new JLabel();
        FontMetrics fontMetrics = jlabel.getFontMetrics(font);
        int textWidth = fontMetrics.stringWidth(dataText);
        double fontSize = this.cellStyle.getFontSize();
        float lineHeight = 1.2f;
        if (this.cellStyle.getLineHeight() > 0.0f) {
            lineHeight = this.cellStyle.getLineHeight();
        }
        int singleLineHeight = UnitUtils.pointToPixel(fontSize *= (double)lineHeight) - 2;
        if (textWidth <= totalColumnWidth) {
            return;
        }
        int totalLineHeight = 0;
        StringBuilder multipleLine = new StringBuilder();
        StringBuilder sb = new StringBuilder();
        int length = dataText.length();
        for (int i = 0; i < length; ++i) {
            char text = dataText.charAt(i);
            if (text == '\r' || text == '\n') {
                char nextText;
                int nextIndex;
                if (text != '\r' || (nextIndex = i + 1) >= length || (nextText = dataText.charAt(nextIndex)) != '\n') continue;
                i = nextIndex;
                continue;
            }
            sb.append(text);
            int width = fontMetrics.stringWidth(sb.toString()) + 4;
            if (width <= totalColumnWidth) continue;
            sb.deleteCharAt(sb.length() - 1);
            totalLineHeight += singleLineHeight;
            if (multipleLine.length() > 0) {
                multipleLine.append('\n');
            }
            multipleLine.append((CharSequence)sb);
            sb.delete(0, sb.length());
            sb.append(text);
        }
        if (sb.length() > 0) {
            totalLineHeight += singleLineHeight;
            if (multipleLine.length() > 0) {
                multipleLine.append('\n');
            }
            multipleLine.append((CharSequence)sb);
        }
        this.formatData = multipleLine.toString();
        int totalRowHeight = this.row.getHeight();
        if (this.rowSpan > 0) {
            int rowNumber = this.row.getRowNumber();
            for (int i = 1; i < this.rowSpan; ++i) {
                Row targetRow = context.getRow(rowNumber + i);
                totalRowHeight += targetRow.getHeight();
            }
        }
        if ((dif = totalLineHeight - totalRowHeight) > 0) {
            int rowHeight = this.row.getHeight();
            int newRowHeight = rowHeight + dif;
            if (this.row.getRealHeight() < newRowHeight) {
                this.row.setRealHeight(newRowHeight);
            }
        }
    }

    public static void main(String[] args) {
        FontMetrics fontMetrics = new JLabel().getFontMetrics(new Font("\u5b8b\u4f53", 0, 12));
        String text = "\u6211\u662f\u4e2d\u56fd\u4eba\uff0c\u6211\u6765\u81eaChina,\u597d\u5427\uff01top\u548cbottom\u6587\u6863\u63cf\u8ff0\u5730\u5f88\u6a21\u7cca\uff0c\u5176\u5b9e\u8fd9\u91cc\u6211\u4eec\u53ef\u4ee5\u501f\u9274\u4e00\u4e0bTextView\u5bf9\u6587\u672c\u7684\u7ed8\u5236\uff0cTextView\u5728\u7ed8\u5236\u6587\u672c\u7684\u65f6\u5019\u603b\u4f1a\u5728\u6587\u672c\u7684\u6700\u5916\u5c42\u7559\u51fa\u4e00\u4e9b\u5185\u8fb9\u8ddd\uff0c\u4e3a\u4ec0\u4e48\u8981\u8fd9\u6837\u505a\uff1f\u56e0\u4e3aTextView\u5728\u7ed8\u5236\u6587\u672c\u7684\u65f6\u5019\u8003\u8651\u5230\u4e86\u7c7b\u4f3c\u8bfb\u97f3\u7b26\u53f7\uff0c\u4e0b\u56fe\u4e2d\u7684A\u4e0a\u9762\u7684\u7b26\u53f7\u5c31\u662f\u4e00\u4e2a\u62c9\u4e01\u6587\u7684\u7c7b\u4f3c\u8bfb\u97f3\u7b26\u53f7\u7684\u4e1c\u897f";
        int columnWidth = 50;
        long start = System.currentTimeMillis();
        int totalLineHeight = 0;
        int singleLineHeight = fontMetrics.getHeight();
        StringBuffer multipleLine = new StringBuffer();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < text.length(); ++i) {
            char str = text.charAt(i);
            sb.append(str);
            int width = fontMetrics.stringWidth(sb.toString());
            if (width <= columnWidth) continue;
            sb.deleteCharAt(sb.length() - 1);
            if (multipleLine.length() > 0) {
                multipleLine.append("\r");
                totalLineHeight += singleLineHeight;
            }
            multipleLine.append(sb);
            sb.delete(0, sb.length());
            sb.append(str);
        }
        if (multipleLine.length() > 0) {
            multipleLine.append("\r");
        }
        if (sb.length() > 0) {
            multipleLine.append(sb);
        }
        long end = System.currentTimeMillis();
        System.out.println(end - start);
        System.out.println(multipleLine.toString());
        System.out.println("totalLineHeight:" + totalLineHeight);
    }

    @Override
    public CellStyle getCellStyle() {
        return this.cellStyle;
    }

    public void setCellStyle(CellStyle cellStyle) {
        this.cellStyle = cellStyle;
    }

    public CellStyle getCustomCellStyle() {
        return this.customCellStyle;
    }

    public void setCustomCellStyle(CellStyle customCellStyle) {
        this.customCellStyle = customCellStyle;
    }

    public boolean isBlankCell() {
        return this.blankCell;
    }

    public void setBlankCell(boolean blankCell) {
        this.blankCell = blankCell;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public int getRowSpan() {
        return this.rowSpan;
    }

    public void setRowSpan(int rowSpan) {
        this.rowSpan = rowSpan;
    }

    @Override
    public int getColSpan() {
        return this.colSpan;
    }

    public void setColSpan(int colSpan) {
        this.colSpan = colSpan;
    }

    public int getPageRowSpan() {
        if (this.pageRowSpan == -1) {
            return this.rowSpan;
        }
        return this.pageRowSpan;
    }

    public void setPageRowSpan(int pageRowSpan) {
        this.pageRowSpan = pageRowSpan;
    }

    @Override
    public Row getRow() {
        return this.row;
    }

    public void setRow(Row row) {
        this.row = row;
    }

    @Override
    public Column getColumn() {
        return this.column;
    }

    public void setColumn(Column column) {
        this.column = column;
    }

    @Override
    public Value getValue() {
        return this.value;
    }

    public void setValue(Value value) {
        this.value = value;
    }

    public String getRenderBean() {
        return this.renderBean;
    }

    public void setRenderBean(String renderBean) {
        this.renderBean = renderBean;
    }

    public void setForPaging(boolean forPaging) {
        this.forPaging = forPaging;
    }

    public boolean isForPaging() {
        return this.forPaging;
    }

    public Range getDuplicateRange() {
        return this.duplicateRange;
    }

    public void setDuplicateRange(Range duplicateRange) {
        this.duplicateRange = duplicateRange;
    }

    public Map<String, List<Cell>> getRowChildrenCellsMap() {
        return this.rowChildrenCellsMap;
    }

    public Map<String, List<Cell>> getColumnChildrenCellsMap() {
        return this.columnChildrenCellsMap;
    }

    public List<ConditionPropertyItem> getConditionPropertyItems() {
        return this.conditionPropertyItems;
    }

    public void setConditionPropertyItems(List<ConditionPropertyItem> conditionPropertyItems) {
        this.conditionPropertyItems = conditionPropertyItems;
    }

    @Override
    public Expand getExpand() {
        return this.expand;
    }

    public void setExpand(Expand expand) {
        this.expand = expand;
    }

    public Cell getLeftParentCell() {
        return this.leftParentCell;
    }

    public void setLeftParentCell(Cell leftParentCell) {
        this.leftParentCell = leftParentCell;
    }

    public Cell getTopParentCell() {
        return this.topParentCell;
    }

    public void setTopParentCell(Cell topParentCell) {
        this.topParentCell = topParentCell;
    }

    public boolean isProcessed() {
        return this.processed;
    }

    public void setProcessed(boolean processed) {
        this.processed = processed;
    }

    public boolean isExistPageFunction() {
        return this.existPageFunction;
    }

    public void setExistPageFunction(boolean existPageFunction) {
        this.existPageFunction = existPageFunction;
    }

    @Override
    public List<Object> getBindData() {
        return this.bindData;
    }

    public void setBindData(List<Object> bindData) {
        this.bindData = bindData;
    }

    public List<String> getIncreaseSpanCellNames() {
        return this.increaseSpanCellNames;
    }

    public void setIncreaseSpanCellNames(List<String> increaseSpanCellNames) {
        this.increaseSpanCellNames = increaseSpanCellNames;
    }

    public Map<String, BlankCellInfo> getNewBlankCellsMap() {
        return this.newBlankCellsMap;
    }

    public void setNewBlankCellsMap(Map<String, BlankCellInfo> newBlankCellsMap) {
        this.newBlankCellsMap = newBlankCellsMap;
    }

    public List<String> getNewCellNames() {
        return this.newCellNames;
    }

    public void setNewCellNames(List<String> newCellNames) {
        this.newCellNames = newCellNames;
    }

    public String getLinkUrl() {
        return this.linkUrl;
    }

    public void setLinkUrl(String linkUrl) {
        this.linkUrl = linkUrl;
    }

    public String getLinkTargetWindow() {
        return this.linkTargetWindow;
    }

    public void setLinkTargetWindow(String linkTargetWindow) {
        this.linkTargetWindow = linkTargetWindow;
    }

    public List<LinkParameter> getLinkParameters() {
        return this.linkParameters;
    }

    public void setLinkParameters(List<LinkParameter> linkParameters) {
        this.linkParameters = linkParameters;
    }

    public String buildLinkParameters(Context context) {
        StringBuilder sb = new StringBuilder();
        if (this.linkParameters != null) {
            for (int i = 0; i < this.linkParameters.size(); ++i) {
                String value;
                LinkParameter param = this.linkParameters.get(i);
                String name = param.getName();
                if (this.linkParameterMap == null) {
                    this.linkParameterMap = new HashMap<String, String>();
                }
                if ((value = this.linkParameterMap.get(name)) == null) {
                    Expression expr = param.getValueExpression();
                    value = this.buildExpression(context, name, expr);
                }
                try {
                    value = URLEncoder.encode(value, "utf-8");
                    value = URLEncoder.encode(value, "utf-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new ReportComputeException(e);
                }
                if (i > 0) {
                    sb.append("&");
                }
                sb.append(name + "=" + value);
            }
        }
        return sb.toString();
    }

    public boolean isFillBlankRows() {
        return this.fillBlankRows;
    }

    public void setFillBlankRows(boolean fillBlankRows) {
        this.fillBlankRows = fillBlankRows;
    }

    public int getMultiple() {
        return this.multiple;
    }

    public void setMultiple(int multiple) {
        this.multiple = multiple;
    }

    public Expression getLinkUrlExpression() {
        return this.linkUrlExpression;
    }

    public void setLinkUrlExpression(Expression linkUrlExpression) {
        this.linkUrlExpression = linkUrlExpression;
    }

    private String buildExpression(Context context, String name, Expression expr) {
        ExpressionData<?> exprData = expr.execute(this, this, context);
        if (exprData instanceof ObjectListExpressionData) {
            ObjectListExpressionData listData = (ObjectListExpressionData)exprData;
            Object list = listData.getData();
            StringBuilder dataSB = new StringBuilder();
            for (int i = 0; i < list.size(); ++i) {
                Object obj = list.get(i);
                if (obj == null) {
                    obj = "null";
                }
                if (i > 0) {
                    dataSB.append(",");
                }
                dataSB.append(obj);
            }
            this.linkParameterMap.put(name, dataSB.toString());
            return dataSB.toString();
        }
        if (exprData instanceof ObjectExpressionData) {
            ObjectExpressionData data = (ObjectExpressionData)exprData;
            Object obj = data.getData();
            if (obj == null) {
                obj = "null";
            } else if (obj instanceof String) {
                obj = (String)obj;
            }
            this.linkParameterMap.put(name, obj.toString());
            return obj.toString();
        }
        if (exprData instanceof BindDataListExpressionData) {
            BindDataListExpressionData bindDataListData = (BindDataListExpressionData)exprData;
            Object list = bindDataListData.getData();
            if (list.size() == 1) {
                Object data = ((BindData)list.get(0)).getValue();
                if (data != null) {
                    return data.toString();
                }
                return "";
            }
            if (list.size() > 1) {
                StringBuilder sb = new StringBuilder();
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    Object data;
                    BindData bindData = (BindData)iterator.next();
                    if (sb.length() > 0) {
                        sb.append(",");
                    }
                    if ((data = bindData.getValue()) == null) continue;
                    sb.append(data.toString());
                }
                return sb.toString();
            }
        }
        return "";
    }
}

