/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.expression.parse.builder;

import com.bstek.ureport.dsl.ReportParserParser;
import com.bstek.ureport.exception.ReportParseException;
import com.bstek.ureport.expression.model.condition.BaseCondition;
import com.bstek.ureport.expression.model.expr.BaseExpression;
import com.bstek.ureport.expression.model.expr.set.CellConditionExpression;
import com.bstek.ureport.expression.model.expr.set.CellCoordinate;
import com.bstek.ureport.expression.model.expr.set.CellCoordinateExpression;
import com.bstek.ureport.expression.model.expr.set.CellCoordinateSet;
import com.bstek.ureport.expression.model.expr.set.CellExpression;
import com.bstek.ureport.expression.model.expr.set.CellPairExpression;
import com.bstek.ureport.expression.model.expr.set.CoordinateType;
import com.bstek.ureport.expression.model.expr.set.FromToExpression;
import com.bstek.ureport.expression.model.expr.set.WholeCellExpression;
import com.bstek.ureport.expression.parse.builder.BaseExpressionBuilder;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.tree.TerminalNode;

public class SetExpressionBuilder
extends BaseExpressionBuilder {
    @Override
    public BaseExpression build(ReportParserParser.UnitContext unitContext) {
        ReportParserParser.SetContext context = unitContext.set();
        BaseExpression setExpr = this.buildSetExpression(context);
        setExpr.setExpr(context.getText());
        return setExpr;
    }

    public BaseExpression buildSetExpression(ReportParserParser.SetContext context) {
        if (context instanceof ReportParserParser.SingleCellContext) {
            TerminalNode cellNode = ((ReportParserParser.SingleCellContext)context).Cell();
            return new CellExpression(cellNode.getText());
        }
        if (context instanceof ReportParserParser.WholeCellContext) {
            ReportParserParser.WholeCellContext ctx = (ReportParserParser.WholeCellContext)context;
            WholeCellExpression wholeCellExpression = new WholeCellExpression(ctx.Cell().getText());
            ReportParserParser.ConditionsContext conditionsContext = ctx.conditions();
            if (conditionsContext != null) {
                BaseCondition condition = this.buildConditions(conditionsContext);
                wholeCellExpression.setCondition(condition);
            }
            return wholeCellExpression;
        }
        if (context instanceof ReportParserParser.SingleCellConditionContext) {
            ReportParserParser.SingleCellConditionContext ctx = (ReportParserParser.SingleCellConditionContext)context;
            BaseCondition condition = this.buildConditions(ctx.conditions());
            return new CellConditionExpression(ctx.Cell().getText(), condition);
        }
        if (context instanceof ReportParserParser.CellPairContext) {
            ReportParserParser.CellPairContext pairContext = (ReportParserParser.CellPairContext)context;
            String startCellName = pairContext.Cell(0).getText();
            String endCellName = pairContext.Cell(1).getText();
            return new CellPairExpression(startCellName, endCellName);
        }
        if (context instanceof ReportParserParser.SingleCellCoordinateContext) {
            ReportParserParser.SingleCellCoordinateContext ctx = (ReportParserParser.SingleCellCoordinateContext)context;
            String cellName = null;
            if (ctx.Cell() != null) {
                cellName = ctx.Cell().getText();
            }
            ReportParserParser.CellCoordinateContext cellCoordinateContext = ctx.cellCoordinate();
            List<ReportParserParser.CoordinateContext> coordinateContexts = cellCoordinateContext.coordinate();
            CellCoordinateSet leftCoordinate = this.parseCellCoordinateSet(coordinateContexts.get(0));
            CellCoordinateSet rightCoordinate = null;
            if (coordinateContexts.size() > 1) {
                rightCoordinate = this.parseCellCoordinateSet(coordinateContexts.get(1));
            }
            return new CellCoordinateExpression(cellName, leftCoordinate, rightCoordinate);
        }
        if (context instanceof ReportParserParser.CellCoordinateConditionContext) {
            ReportParserParser.CellCoordinateConditionContext ctx = (ReportParserParser.CellCoordinateConditionContext)context;
            String cellName = null;
            if (ctx.Cell() != null) {
                cellName = ctx.Cell().getText();
            }
            ReportParserParser.CellCoordinateContext cellCoordinateContext = ctx.cellCoordinate();
            List<ReportParserParser.CoordinateContext> coordinateContexts = cellCoordinateContext.coordinate();
            CellCoordinateSet leftCoordinate = this.parseCellCoordinateSet(coordinateContexts.get(0));
            CellCoordinateSet rightCoordinate = null;
            if (coordinateContexts.size() > 1) {
                rightCoordinate = this.parseCellCoordinateSet(coordinateContexts.get(1));
            }
            BaseCondition condition = this.buildConditions(ctx.conditions());
            return new CellCoordinateExpression(cellName, leftCoordinate, rightCoordinate, condition);
        }
        if (context instanceof ReportParserParser.RangeContext) {
            ReportParserParser.RangeContext ctx = (ReportParserParser.RangeContext)context;
            List<ReportParserParser.SetContext> sets = ctx.set();
            if (sets.size() != 2) {
                throw new ReportParseException("Range expression must have from and to expressions.");
            }
            BaseExpression fromExpr = this.buildSetExpression(sets.get(0));
            BaseExpression toExpr = this.buildSetExpression(sets.get(1));
            FromToExpression expr = new FromToExpression(fromExpr, toExpr);
            return expr;
        }
        if (context instanceof ReportParserParser.SimpleDataContext) {
            ReportParserParser.SimpleDataContext ctx = (ReportParserParser.SimpleDataContext)context;
            ReportParserParser.SimpleValueContext valueContext = ctx.simpleValue();
            return this.parseSimpleValueContext(valueContext);
        }
        throw new ReportParseException("Unknow context : " + String.valueOf((Object)context));
    }

    private CellCoordinateSet parseCellCoordinateSet(ReportParserParser.CoordinateContext ctx) {
        ArrayList<CellCoordinate> coordinates = new ArrayList<CellCoordinate>();
        for (ReportParserParser.CellIndicatorContext indicatorContext : ctx.cellIndicator()) {
            String cellName;
            ReportParserParser.CellIndicatorContext context;
            if (indicatorContext instanceof ReportParserParser.RelativeContext) {
                context = (ReportParserParser.RelativeContext)indicatorContext;
                cellName = ((ReportParserParser.RelativeContext)context).Cell().getText();
                CellCoordinate coordinate = new CellCoordinate(cellName, CoordinateType.relative);
                coordinates.add(coordinate);
                continue;
            }
            context = (ReportParserParser.AbsoluteContext)indicatorContext;
            cellName = ((ReportParserParser.AbsoluteContext)context).Cell().getText();
            String pos = ((ReportParserParser.AbsoluteContext)context).INTEGER().getText();
            int position = Integer.valueOf(pos);
            CellCoordinate coordinate = new CellCoordinate(cellName, CoordinateType.absolute);
            coordinate.setPosition(position);
            if (((ReportParserParser.AbsoluteContext)context).EXCLAMATION() != null) {
                coordinate.setReverse(true);
            }
            coordinates.add(coordinate);
        }
        return new CellCoordinateSet(coordinates);
    }

    @Override
    public boolean support(ReportParserParser.UnitContext unitContext) {
        return unitContext.set() != null;
    }
}

