/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.expression.parse.builder;

import com.bstek.ureport.Utils;
import com.bstek.ureport.dsl.ReportParserParser;
import com.bstek.ureport.exception.ReportParseException;
import com.bstek.ureport.expression.ExpressionUtils;
import com.bstek.ureport.expression.model.Expression;
import com.bstek.ureport.expression.model.Op;
import com.bstek.ureport.expression.model.condition.BaseCondition;
import com.bstek.ureport.expression.model.condition.BothExpressionCondition;
import com.bstek.ureport.expression.model.condition.CellExpressionCondition;
import com.bstek.ureport.expression.model.condition.CurrentValueExpressionCondition;
import com.bstek.ureport.expression.model.condition.Join;
import com.bstek.ureport.expression.model.condition.PropertyExpressionCondition;
import com.bstek.ureport.expression.model.expr.BaseExpression;
import com.bstek.ureport.expression.model.expr.BooleanExpression;
import com.bstek.ureport.expression.model.expr.IntegerExpression;
import com.bstek.ureport.expression.model.expr.NullExpression;
import com.bstek.ureport.expression.model.expr.NumberExpression;
import com.bstek.ureport.expression.model.expr.StringExpression;
import com.bstek.ureport.expression.parse.builder.ExpressionBuilder;
import java.util.List;
import org.antlr.v4.runtime.tree.TerminalNode;

public abstract class BaseExpressionBuilder
implements ExpressionBuilder {
    protected BaseExpression parseSimpleValueContext(ReportParserParser.SimpleValueContext valueContext) {
        if (valueContext.BOOLEAN() != null) {
            return new BooleanExpression(Boolean.valueOf(valueContext.getText()));
        }
        if (valueContext.INTEGER() != null) {
            return new IntegerExpression(Integer.valueOf(valueContext.INTEGER().getText()));
        }
        if (valueContext.STRING() != null) {
            String text = valueContext.STRING().getText();
            text = text.substring(1, text.length() - 1);
            return new StringExpression(text);
        }
        if (valueContext.NUMBER() != null) {
            return new NumberExpression(Utils.toBigDecimal(valueContext.NUMBER().getText()));
        }
        if (valueContext.NULL() != null) {
            return new NullExpression();
        }
        throw new ReportParseException("Unknow simple value context " + String.valueOf((Object)valueContext));
    }

    protected BaseCondition buildConditions(ReportParserParser.ConditionsContext conditionsContext) {
        List<ReportParserParser.ConditionContext> conditionContextList = conditionsContext.condition();
        List<ReportParserParser.JoinContext> joins = conditionsContext.join();
        BaseCondition condition = null;
        BaseCondition topCondition = null;
        int opIndex = 0;
        for (ReportParserParser.ConditionContext conditionCtx : conditionContextList) {
            if (condition == null) {
                topCondition = condition = this.parseCondition(conditionCtx);
                continue;
            }
            BaseCondition nextCondition = this.parseCondition(conditionCtx);
            condition.setNextCondition(nextCondition);
            condition.setJoin(Join.parse(joins.get(opIndex).getText()));
            ++opIndex;
            condition = nextCondition;
        }
        return topCondition;
    }

    private BaseCondition parseCondition(ReportParserParser.ConditionContext context) {
        if (context instanceof ReportParserParser.ExprConditionContext) {
            ReportParserParser.ExprConditionContext ctx = (ReportParserParser.ExprConditionContext)context;
            BothExpressionCondition condition = new BothExpressionCondition();
            List<ReportParserParser.ExprContext> exprContexts = ctx.expr();
            String left = exprContexts.get(0).getText();
            condition.setLeft(left);
            Expression leftExpr = ExpressionUtils.parseExpression(left);
            condition.setLeftExpression(leftExpr);
            String rightExpr = exprContexts.get(1).getText();
            condition.setRight(rightExpr);
            condition.setRightExpression(ExpressionUtils.parseExpression(rightExpr));
            condition.setOp(this.parseOp(ctx.OP()));
            condition.setOperation(ctx.OP().getText());
            return condition;
        }
        if (context instanceof ReportParserParser.CurrentValueConditionContext) {
            ReportParserParser.CurrentValueConditionContext ctx = (ReportParserParser.CurrentValueConditionContext)context;
            CurrentValueExpressionCondition condition = new CurrentValueExpressionCondition();
            String rightExpr = ctx.expr().getText();
            condition.setRight(rightExpr);
            condition.setRightExpression(ExpressionUtils.parseExpression(rightExpr));
            condition.setOp(this.parseOp(ctx.OP()));
            return condition;
        }
        if (context instanceof ReportParserParser.PropertyConditionContext) {
            ReportParserParser.PropertyConditionContext ctx = (ReportParserParser.PropertyConditionContext)context;
            PropertyExpressionCondition condition = new PropertyExpressionCondition();
            String left = ctx.property().getText();
            condition.setLeft(left);
            condition.setLeftProperty(left);
            String rightExpr = ctx.expr().getText();
            condition.setRight(rightExpr);
            condition.setRightExpression(ExpressionUtils.parseExpression(rightExpr));
            condition.setOp(this.parseOp(ctx.OP()));
            return condition;
        }
        if (context instanceof ReportParserParser.CellNameExprConditionContext) {
            ReportParserParser.CellNameExprConditionContext ctx = (ReportParserParser.CellNameExprConditionContext)context;
            CellExpressionCondition condition = new CellExpressionCondition();
            String left = ctx.Cell().getText();
            condition.setLeft(left);
            condition.setCellName(left);
            String rightExpr = ctx.expr().getText();
            condition.setRight(rightExpr);
            condition.setRightExpression(ExpressionUtils.parseExpression(rightExpr));
            condition.setOp(this.parseOp(ctx.OP()));
            return condition;
        }
        throw new ReportParseException("Unknow condition context : " + String.valueOf((Object)context));
    }

    private Op parseOp(TerminalNode opNode) {
        if (opNode.getText().equals(">")) {
            return Op.GreatThen;
        }
        if (opNode.getText().equals("<")) {
            return Op.LessThen;
        }
        if (opNode.getText().equals(">=")) {
            return Op.EqualsGreatThen;
        }
        if (opNode.getText().equals("<=")) {
            return Op.EqualsLessThen;
        }
        if (opNode.getText().equals("==")) {
            return Op.Equals;
        }
        if (opNode.getText().equals("!=")) {
            return Op.NotEquals;
        }
        throw new ReportParseException("Unknow operator :" + String.valueOf(opNode));
    }
}

