/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.expression.model.expr.set;

import com.bstek.ureport.Utils;
import com.bstek.ureport.build.Context;
import com.bstek.ureport.exception.ReportComputeException;
import com.bstek.ureport.expression.model.Condition;
import com.bstek.ureport.expression.model.data.ExpressionData;
import com.bstek.ureport.expression.model.data.ObjectExpressionData;
import com.bstek.ureport.expression.model.data.ObjectListExpressionData;
import com.bstek.ureport.expression.model.expr.set.CellCoordinate;
import com.bstek.ureport.expression.model.expr.set.CellCoordinateSet;
import com.bstek.ureport.expression.model.expr.set.CellExpression;
import com.bstek.ureport.expression.model.expr.set.CoordinateType;
import com.bstek.ureport.model.Cell;
import com.bstek.ureport.model.Column;
import com.bstek.ureport.model.Row;
import java.util.ArrayList;
import java.util.List;

public class CellCoordinateExpression
extends CellExpression {
    private static final long serialVersionUID = 4132183845260722859L;
    private Condition condition;
    private CellCoordinateSet leftCoordinate;
    private CellCoordinateSet topCoordinate;

    public CellCoordinateExpression(String cellName, CellCoordinateSet leftCoordinate) {
        super(cellName);
        this.leftCoordinate = leftCoordinate;
    }

    public CellCoordinateExpression(String cellName, CellCoordinateSet leftCoordinate, Condition condition) {
        super(cellName);
        this.leftCoordinate = leftCoordinate;
        this.condition = condition;
    }

    public CellCoordinateExpression(String cellName, CellCoordinateSet leftCoordinate, CellCoordinateSet topCoordinate) {
        super(cellName);
        this.leftCoordinate = leftCoordinate;
        this.topCoordinate = topCoordinate;
    }

    public CellCoordinateExpression(String cellName, CellCoordinateSet leftCoordinate, CellCoordinateSet topCoordinate, Condition condition) {
        super(cellName);
        this.leftCoordinate = leftCoordinate;
        this.topCoordinate = topCoordinate;
        this.condition = condition;
    }

    @Override
    public boolean supportPaging() {
        return false;
    }

    @Override
    protected ExpressionData<?> compute(Cell cell, Cell currentCell, Context context) {
        while (!context.isCellPocessed(this.cellName)) {
            context.getReportBuilder().buildCell(context, null);
        }
        List<Cell> leftCellList = this.buildLeftCells(cell, context);
        List<Cell> topCellList = this.buildTopCells(cell, context);
        ArrayList<Object> list = new ArrayList<Object>();
        if (leftCellList == null) {
            if (topCellList != null) {
                topCellList = this.filterCells(cell, context, this.condition, topCellList);
                for (Cell c : topCellList) {
                    list.add(c.getData());
                }
            } else {
                List<Cell> cells = context.getReport().getCellsMap().get(this.cellName);
                if (cells == null) {
                    throw new ReportComputeException("Cell [" + this.cellName + "] not exist.");
                }
                topCellList = this.filterCells(cell, context, this.condition, cells);
                for (Cell c : cells) {
                    list.add(c.getData());
                }
            }
        } else if (topCellList != null) {
            leftCellList = this.filterCells(cell, context, this.condition, leftCellList);
            topCellList = this.filterCells(cell, context, this.condition, topCellList);
            for (Cell c : topCellList) {
                if (!leftCellList.contains(c)) continue;
                list.add(c.getData());
            }
        } else {
            leftCellList = this.filterCells(cell, context, this.condition, leftCellList);
            for (Cell c : leftCellList) {
                list.add(c.getData());
            }
        }
        if (list.size() == 1) {
            return new ObjectExpressionData(list.get(0));
        }
        return new ObjectListExpressionData(list);
    }

    private List<Cell> buildLeftCells(Cell cell, Context context) {
        if (this.leftCoordinate == null) {
            return null;
        }
        List<Cell> cellList = null;
        Cell targetLeftCell = null;
        Row row = cell.getRow();
        int rowNumber = row.getRowNumber();
        List<CellCoordinate> leftCoordinates = this.leftCoordinate.getCellCoordinates();
        block0: for (CellCoordinate coordinate : leftCoordinates) {
            int newPosition;
            String name = coordinate.getCellName();
            while (!context.isCellPocessed(name)) {
                context.getReportBuilder().buildCell(context, null);
            }
            cellList = targetLeftCell == null ? (coordinate.getCoordinateType().equals((Object)CoordinateType.relative) ? Utils.fetchTargetCells(cell, context, name) : context.getReport().getCellsMap().get(name)) : targetLeftCell.getRowChildrenCellsMap().get(name);
            int position = coordinate.getPosition();
            if (position == 0) {
                for (Cell childCell : cellList) {
                    Row childRow = childCell.getRow();
                    if (row == childRow) {
                        targetLeftCell = childCell;
                        continue block0;
                    }
                    int rowSpan = childCell.getRowSpan();
                    if (rowSpan <= 0) continue;
                    int childRowNumberStart = childRow.getRowNumber();
                    int childRowNumberEnd = childRowNumberStart + rowSpan - 1;
                    if (childRowNumberStart > rowNumber || childRowNumberEnd < rowNumber) continue;
                    targetLeftCell = childCell;
                    continue block0;
                }
                continue;
            }
            if (position > 0) {
                targetLeftCell = cellList.get(position - 1);
                continue;
            }
            if (position >= 0) continue;
            boolean reverse = coordinate.isReverse();
            int cellSize = cellList.size();
            if (reverse) {
                int newPosition2 = cellSize - position;
                if (newPosition2 >= cellSize) {
                    newPosition2 = cellSize - 1;
                }
                targetLeftCell = cellList.get(newPosition2);
                continue;
            }
            int index = 0;
            for (int i = 0; i < cellSize; ++i) {
                int rowNum;
                Cell childCell = cellList.get(i);
                if (childCell.getRow() == cell.getRow()) {
                    index = i;
                    break;
                }
                int rowSpan = childCell.getRowSpan();
                if (rowSpan <= 1) continue;
                int start = rowNum = childCell.getRow().getRowNumber();
                int end = rowNum + rowSpan - 1;
                if (rowNumber < start || rowNumber > end) continue;
                index = i;
                break;
            }
            if ((newPosition = index + position) < 0) {
                newPosition = 0;
            }
            if (newPosition >= cellSize) {
                newPosition = cellSize - 1;
            }
            targetLeftCell = cellList.get(newPosition);
        }
        List<Cell> leftCellList = targetLeftCell.getRowChildrenCellsMap().get(this.cellName);
        return leftCellList;
    }

    private List<Cell> buildTopCells(Cell cell, Context context) {
        if (this.topCoordinate == null) {
            return null;
        }
        List<Cell> cellList = null;
        Cell targetTopCell = null;
        Column col = cell.getColumn();
        int colNumber = col.getColumnNumber();
        List<CellCoordinate> topCoordinates = this.topCoordinate.getCellCoordinates();
        block0: for (CellCoordinate coordinate : topCoordinates) {
            int newPosition;
            String name = coordinate.getCellName();
            while (!context.isCellPocessed(name)) {
                context.getReportBuilder().buildCell(context, null);
            }
            cellList = cellList == null ? (coordinate.getCoordinateType().equals((Object)CoordinateType.relative) ? Utils.fetchTargetCells(cell, context, name) : context.getReport().getCellsMap().get(name)) : targetTopCell.getColumnChildrenCellsMap().get(name);
            int position = coordinate.getPosition();
            if (position == 0) {
                for (Cell childCell : cellList) {
                    Column childCol = childCell.getColumn();
                    if (col == childCol) {
                        targetTopCell = childCell;
                        continue block0;
                    }
                    int colSpan = childCell.getColSpan();
                    if (colSpan <= 0) continue;
                    int childColNumberStart = childCol.getColumnNumber();
                    int childColNumberEnd = childColNumberStart + colSpan - 1;
                    if (childColNumberStart > colNumber || childColNumberEnd < colNumber) continue;
                    targetTopCell = childCell;
                    continue block0;
                }
                continue;
            }
            if (position > 0) {
                targetTopCell = cellList.get(position - 1);
                continue;
            }
            if (position >= 0) continue;
            boolean reverse = coordinate.isReverse();
            int cellSize = cellList.size();
            if (reverse) {
                int newPosition2 = cellSize - position;
                if (newPosition2 >= cellSize) {
                    newPosition2 = cellSize - 1;
                }
                targetTopCell = cellList.get(newPosition2);
                continue;
            }
            int index = 0;
            for (int i = 0; i < cellSize; ++i) {
                int colNum;
                Cell childCell = cellList.get(i);
                if (childCell.getColumn() == cell.getColumn()) {
                    index = i;
                    break;
                }
                int colSpan = childCell.getColSpan();
                if (colSpan <= 1) continue;
                int start = colNum = childCell.getColumn().getColumnNumber();
                int end = colNum + colSpan - 1;
                if (colNumber < start || colNumber > end) continue;
                index = i;
                break;
            }
            if ((newPosition = index + position) < 0) {
                newPosition = 0;
            }
            if (newPosition >= cellSize) {
                newPosition = cellSize - 1;
            }
            targetTopCell = cellList.get(newPosition);
        }
        List<Cell> topCellList = targetTopCell.getColumnChildrenCellsMap().get(this.cellName);
        return topCellList;
    }
}

