/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.expression.model.expr.ifelse;

import com.bstek.ureport.build.BindData;
import com.bstek.ureport.build.Context;
import com.bstek.ureport.exception.ReportComputeException;
import com.bstek.ureport.expression.ExpressionUtils;
import com.bstek.ureport.expression.model.Expression;
import com.bstek.ureport.expression.model.Op;
import com.bstek.ureport.expression.model.data.BindDataListExpressionData;
import com.bstek.ureport.expression.model.data.ExpressionData;
import com.bstek.ureport.expression.model.data.NoneExpressionData;
import com.bstek.ureport.expression.model.data.ObjectExpressionData;
import com.bstek.ureport.expression.model.data.ObjectListExpressionData;
import com.bstek.ureport.model.Cell;
import java.util.Iterator;

public class ExpressionCondition {
    private Expression left;
    private Op op;
    private Expression right;

    public ExpressionCondition(Expression left, Op op, Expression right) {
        this.left = left;
        this.op = op;
        this.right = right;
    }

    public boolean eval(Context context, Cell cell, Cell currentCell) {
        ExpressionData<?> leftData = this.left.execute(cell, currentCell, context);
        ExpressionData<?> rightData = this.right.execute(cell, currentCell, context);
        Object leftObj = this.getData(leftData);
        Object rightObj = this.getData(rightData);
        return ExpressionUtils.conditionEval(this.op, leftObj, rightObj);
    }

    private Object getData(ExpressionData<?> data) {
        if (data instanceof ObjectExpressionData) {
            ObjectExpressionData objData = (ObjectExpressionData)data;
            return objData.getData();
        }
        if (data instanceof ObjectListExpressionData) {
            ObjectListExpressionData exprData = (ObjectListExpressionData)data;
            Object list = exprData.getData();
            StringBuffer sb = new StringBuffer();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object obj = iterator.next();
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(obj);
            }
            return sb.toString();
        }
        if (data instanceof NoneExpressionData) {
            return null;
        }
        if (data instanceof BindDataListExpressionData) {
            BindDataListExpressionData bindDataList = (BindDataListExpressionData)data;
            Object list = bindDataList.getData();
            if (list.size() == 1) {
                return ((BindData)list.get(0)).getValue();
            }
            StringBuffer sb = new StringBuffer();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                BindData bindData = (BindData)iterator.next();
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(bindData.getValue());
            }
            return sb.toString();
        }
        throw new ReportComputeException("Unknow data : " + String.valueOf(data));
    }

    public Expression getLeft() {
        return this.left;
    }

    public Expression getRight() {
        return this.right;
    }
}

