/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.expression.model.expr.el;

import com.bstek.ureport.exception.ReportComputeException;
import com.bstek.ureport.expression.model.Operator;
import com.bstek.ureport.utils.ArithUtils;

public class ElUnit {
    private Object left;
    private Object right;
    private Operator op;
    private Operator nextOp;
    private ElUnit nextUnit;

    public Object compute() {
        if (this.right instanceof ElUnit) {
            this.right = ((ElUnit)this.right).compute();
        }
        switch (this.op) {
            case Add: {
                return ArithUtils.add(this.left, this.right);
            }
            case Complementation: {
                return ArithUtils.com(this.left, this.right);
            }
            case Divide: {
                return ArithUtils.div(this.left, this.right);
            }
            case Multiply: {
                return ArithUtils.mul(this.left, this.right);
            }
            case Subtract: {
                return ArithUtils.sub(this.left, this.right);
            }
        }
        throw new ReportComputeException("Unknow operator :" + String.valueOf((Object)this.op));
    }

    public Object getLeft() {
        return this.left;
    }

    public void setLeft(Object left) {
        this.left = left;
    }

    public Object getRight() {
        return this.right;
    }

    public void setRight(Object right) {
        this.right = right;
    }

    public Operator getOp() {
        return this.op;
    }

    public void setOp(Operator op) {
        this.op = op;
    }

    public Operator getNextOp() {
        return this.nextOp;
    }

    public void setNextOp(Operator nextOp) {
        this.nextOp = nextOp;
    }

    public ElUnit getNextUnit() {
        return this.nextUnit;
    }

    public void setNextUnit(ElUnit nextUnit) {
        this.nextUnit = nextUnit;
    }
}

