/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.expression.model.expr.dataset;

import com.bstek.ureport.build.BindData;
import com.bstek.ureport.build.Context;
import com.bstek.ureport.build.DatasetUtils;
import com.bstek.ureport.definition.Order;
import com.bstek.ureport.definition.mapping.MappingItem;
import com.bstek.ureport.definition.mapping.MappingType;
import com.bstek.ureport.definition.value.AggregateType;
import com.bstek.ureport.definition.value.GroupItem;
import com.bstek.ureport.expression.model.Condition;
import com.bstek.ureport.expression.model.data.BindDataListExpressionData;
import com.bstek.ureport.expression.model.data.ExpressionData;
import com.bstek.ureport.expression.model.expr.BaseExpression;
import com.bstek.ureport.model.Cell;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DatasetExpression
extends BaseExpression {
    private static final long serialVersionUID = -8794866509447790340L;
    private String datasetName;
    private AggregateType aggregate;
    private String property;
    private List<GroupItem> groupItems;
    private MappingType mappingType = MappingType.simple;
    private String mappingDataset;
    private String mappingKeyProperty;
    private String mappingValueProperty;
    private List<MappingItem> mappingItems;
    @JsonIgnore
    private Condition condition;
    @JsonIgnore
    private Map<String, String> mapping = null;
    private List<Condition> conditions;
    private Order order;

    @Override
    public ExpressionData<?> compute(Cell cell, Cell currentCell, Context context) {
        List<BindData> bindDataList = DatasetUtils.computeDatasetExpression(this, cell, context);
        return new BindDataListExpressionData(bindDataList);
    }

    public String getDatasetName() {
        return this.datasetName;
    }

    public void setDatasetName(String datasetName) {
        this.datasetName = datasetName;
    }

    public AggregateType getAggregate() {
        return this.aggregate;
    }

    public void setAggregate(AggregateType aggregate) {
        this.aggregate = aggregate;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public List<GroupItem> getGroupItems() {
        return this.groupItems;
    }

    public void setGroupItems(List<GroupItem> groupItems) {
        this.groupItems = groupItems;
    }

    public Condition getCondition() {
        return this.condition;
    }

    public void setCondition(Condition condition) {
        this.condition = condition;
    }

    public List<Condition> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<Condition> conditions) {
        this.conditions = conditions;
    }

    public Order getOrder() {
        return this.order;
    }

    public void setOrder(Order order) {
        this.order = order;
    }

    public List<MappingItem> getMappingItems() {
        return this.mappingItems;
    }

    public void setMappingItems(List<MappingItem> mappingItems) {
        this.mappingItems = mappingItems;
        if (mappingItems != null) {
            this.mapping = new HashMap<String, String>();
            for (MappingItem item : mappingItems) {
                this.mapping.put(item.getValue(), item.getLabel());
            }
        }
    }

    public MappingType getMappingType() {
        return this.mappingType;
    }

    public void setMappingType(MappingType mappingType) {
        this.mappingType = mappingType;
    }

    public String getMappingDataset() {
        return this.mappingDataset;
    }

    public void setMappingDataset(String mappingDataset) {
        this.mappingDataset = mappingDataset;
    }

    public String getMappingKeyProperty() {
        return this.mappingKeyProperty;
    }

    public void setMappingKeyProperty(String mappingKeyProperty) {
        this.mappingKeyProperty = mappingKeyProperty;
    }

    public String getMappingValueProperty() {
        return this.mappingValueProperty;
    }

    public void setMappingValueProperty(String mappingValueProperty) {
        this.mappingValueProperty = mappingValueProperty;
    }

    public Map<String, String> getMapping() {
        return this.mapping;
    }
}

