/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.expression.model.expr;

import com.bstek.ureport.build.Context;
import com.bstek.ureport.exception.ReportComputeException;
import com.bstek.ureport.expression.ExpressionUtils;
import com.bstek.ureport.expression.function.Function;
import com.bstek.ureport.expression.function.page.PageFunction;
import com.bstek.ureport.expression.model.Expression;
import com.bstek.ureport.expression.model.data.ExpressionData;
import com.bstek.ureport.expression.model.data.ObjectExpressionData;
import com.bstek.ureport.expression.model.data.ObjectListExpressionData;
import com.bstek.ureport.expression.model.expr.BaseExpression;
import com.bstek.ureport.expression.model.expr.set.CellExpression;
import com.bstek.ureport.model.Cell;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class FunctionExpression
extends BaseExpression {
    private static final long serialVersionUID = -6981657541024043558L;
    private String name;
    private List<BaseExpression> expressions;

    @Override
    public ExpressionData<?> compute(Cell cell, Cell currentCell, Context context) {
        Object obj;
        Map<String, Function> functions = ExpressionUtils.getFunctions();
        Function targetFunction = functions.get(this.name);
        if (targetFunction == null) {
            throw new ReportComputeException("Function [" + this.name + "] not exist.");
        }
        ArrayList dataList = new ArrayList();
        if (this.expressions != null) {
            for (BaseExpression expr : this.expressions) {
                ExpressionData<?> data;
                if (targetFunction instanceof PageFunction) {
                    data = this.buildPageExpressionData(expr, cell, currentCell, context);
                    dataList.add(data);
                    continue;
                }
                data = expr.execute(cell, currentCell, context);
                dataList.add(data);
            }
        }
        if ((obj = targetFunction.execute(dataList, context, currentCell)) instanceof List) {
            return new ObjectListExpressionData((List)obj);
        }
        return new ObjectExpressionData(obj);
    }

    private ExpressionData<?> buildPageExpressionData(Expression expr, Cell cell, Cell currentCell, Context context) {
        if (expr instanceof CellExpression) {
            CellExpression cellExpr = (CellExpression)expr;
            if (cellExpr.supportPaging()) {
                return cellExpr.computePageCells(cell, currentCell, context);
            }
            return cellExpr.execute(cell, currentCell, context);
        }
        return expr.execute(cell, currentCell, context);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setExpressions(List<BaseExpression> expressions) {
        this.expressions = expressions;
    }

    public List<BaseExpression> getExpressions() {
        return this.expressions;
    }
}

