/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.expression.model;

import com.bstek.ureport.exception.ReportParseException;

public enum Op {
    GreatThen,
    EqualsGreatThen,
    LessThen,
    EqualsLessThen,
    Equals,
    NotEquals,
    In,
    NotIn,
    Like;


    public static Op parse(String op) {
        if ((op = op.trim()).equals(">")) {
            return GreatThen;
        }
        if (op.equals(">=")) {
            return EqualsGreatThen;
        }
        if (op.equals("==")) {
            return Equals;
        }
        if (op.equals("<")) {
            return LessThen;
        }
        if (op.equals("<=")) {
            return EqualsLessThen;
        }
        if (op.equals("!=")) {
            return NotEquals;
        }
        if (op.equals("in")) {
            return In;
        }
        if (op.equals("not in") || op.equals("not  in")) {
            return NotIn;
        }
        if (op.equals("like")) {
            return Like;
        }
        throw new ReportParseException("Unknow op :" + op);
    }

    public String toString() {
        switch (this.ordinal()) {
            case 0: {
                return ">";
            }
            case 1: {
                return ">=";
            }
            case 2: {
                return "<";
            }
            case 3: {
                return "<=";
            }
            case 4: {
                return "==";
            }
            case 5: {
                return "!=";
            }
            case 6: {
                return " in ";
            }
            case 7: {
                return " not in ";
            }
            case 8: {
                return " like ";
            }
        }
        return super.toString();
    }
}

