/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.expression.function.string;

import com.bstek.ureport.build.Context;
import com.bstek.ureport.exception.ReportComputeException;
import com.bstek.ureport.expression.function.string.StringFunction;
import com.bstek.ureport.expression.model.data.ExpressionData;
import com.bstek.ureport.expression.model.data.ObjectExpressionData;
import com.bstek.ureport.model.Cell;
import java.util.List;

public class ReplaceFunction
extends StringFunction {
    @Override
    public Object execute(List<ExpressionData<?>> dataList, Context context, Cell currentCell) {
        if (dataList.size() != 3) {
            throw new ReportComputeException("Function [" + this.name() + "] need three parameters.");
        }
        String text = this.buildString(dataList);
        String targetText = null;
        String replaceText = null;
        ExpressionData<?> exprData = dataList.get(1);
        if (exprData instanceof ObjectExpressionData) {
            ObjectExpressionData objData = (ObjectExpressionData)exprData;
            Object obj = objData.getData();
            if (obj == null) {
                throw new ReportComputeException("Function [" + this.name() + "] parameter can not be null.");
            }
            targetText = obj.toString();
        }
        exprData = dataList.get(2);
        replaceText = this.buildStart(exprData);
        return text.replaceAll(targetText, replaceText);
    }

    private String buildStart(ExpressionData<?> exprData) {
        if (exprData instanceof ObjectExpressionData) {
            ObjectExpressionData objData = (ObjectExpressionData)exprData;
            Object obj = objData.getData();
            if (obj == null) {
                throw new ReportComputeException("Function [" + this.name() + "] parameter can not be null.");
            }
            return obj.toString();
        }
        throw new ReportComputeException("Function [" + this.name() + "] start position data is invalid : " + String.valueOf(exprData));
    }

    @Override
    public String name() {
        return "replace";
    }
}

