/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.expression.function;

import com.bstek.ureport.Utils;
import com.bstek.ureport.build.BindData;
import com.bstek.ureport.build.Context;
import com.bstek.ureport.exception.ReportException;
import com.bstek.ureport.expression.function.Function;
import com.bstek.ureport.expression.model.data.BindDataListExpressionData;
import com.bstek.ureport.expression.model.data.ExpressionData;
import com.bstek.ureport.expression.model.data.ObjectExpressionData;
import com.bstek.ureport.expression.model.data.ObjectListExpressionData;
import com.bstek.ureport.model.Cell;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JsonFunction
implements Function {
    @Override
    public Object execute(List<ExpressionData<?>> dataList, Context context, Cell currentCell) {
        if (dataList.size() != 2) {
            return null;
        }
        String obj = this.buildData(dataList.get(0));
        String property = this.buildData(dataList.get(1));
        if (obj == null || property == null || obj.equals("") || property.equals("")) {
            return null;
        }
        ObjectMapper mapper = new ObjectMapper();
        try {
            Map map = (Map)mapper.readValue(obj, HashMap.class);
            return Utils.getProperty(map, property);
        }
        catch (Exception ex) {
            throw new ReportException(ex);
        }
    }

    private String buildData(ExpressionData<?> exprData) {
        Object data;
        BindDataListExpressionData listData;
        Object list;
        String obj = null;
        if (exprData instanceof ObjectExpressionData) {
            ObjectExpressionData objData = (ObjectExpressionData)exprData;
            Object data2 = objData.getData();
            if (data2 != null) {
                obj = data2.toString();
            }
        } else if (exprData instanceof ObjectListExpressionData) {
            Object data3;
            ObjectListExpressionData listData2 = (ObjectListExpressionData)exprData;
            Object list2 = listData2.getData();
            if (list2.size() == 1 && (data3 = list2.get(0)) != null) {
                obj = data3.toString();
            }
        } else if (exprData instanceof BindDataListExpressionData && (list = (listData = (BindDataListExpressionData)exprData).getData()).size() == 1 && (data = ((BindData)list.get(0)).getValue()) != null) {
            obj = data.toString();
        }
        return obj;
    }

    @Override
    public String name() {
        return "json";
    }
}

