/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.expression.function;

import com.bstek.ureport.Utils;
import com.bstek.ureport.build.BindData;
import com.bstek.ureport.build.Context;
import com.bstek.ureport.expression.function.Function;
import com.bstek.ureport.expression.model.data.BindDataListExpressionData;
import com.bstek.ureport.expression.model.data.ExpressionData;
import com.bstek.ureport.expression.model.data.ObjectExpressionData;
import com.bstek.ureport.expression.model.data.ObjectListExpressionData;
import com.bstek.ureport.model.Cell;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class AvgFunction
implements Function {
    @Override
    public Object execute(List<ExpressionData<?>> dataList, Context context, Cell currentCell) {
        if (dataList == null || dataList.size() == 0) {
            return null;
        }
        int size = 0;
        Object singleData = null;
        BigDecimal total = new BigDecimal(0);
        for (ExpressionData<?> exprData : dataList) {
            ExpressionData<Object> data;
            Iterator iterator;
            if (exprData instanceof ObjectListExpressionData) {
                ObjectListExpressionData listExpr = (ObjectListExpressionData)exprData;
                Object list = listExpr.getData();
                iterator = list.iterator();
                while (iterator.hasNext()) {
                    Object obj = iterator.next();
                    if (obj == null || StringUtils.isBlank((CharSequence)obj.toString())) continue;
                    singleData = obj;
                    BigDecimal bigData = Utils.toBigDecimal(obj);
                    total = total.add(bigData);
                    ++size;
                }
                continue;
            }
            if (exprData instanceof ObjectExpressionData) {
                data = (ObjectExpressionData)exprData;
                Object obj = ((ObjectExpressionData)data).getData();
                if (obj == null || StringUtils.isBlank((CharSequence)obj.toString())) continue;
                BigDecimal bigData = Utils.toBigDecimal(((ObjectExpressionData)data).getData());
                singleData = ((ObjectExpressionData)data).getData();
                total = total.add(bigData);
                ++size;
                continue;
            }
            if (!(exprData instanceof BindDataListExpressionData)) continue;
            data = (BindDataListExpressionData)exprData;
            Object bindDataList = ((BindDataListExpressionData)data).getData();
            iterator = bindDataList.iterator();
            while (iterator.hasNext()) {
                BindData bindData = (BindData)iterator.next();
                Object obj = bindData.getValue();
                if (obj == null || StringUtils.isBlank((CharSequence)obj.toString())) continue;
                singleData = obj;
                BigDecimal bigData = Utils.toBigDecimal(obj);
                total = total.add(bigData);
                ++size;
            }
        }
        if (size == 0) {
            return 0;
        }
        if (size == 1) {
            if (singleData == null || singleData.equals("")) {
                return "";
            }
            return total;
        }
        return total.divide(new BigDecimal(size), 8, 4);
    }

    @Override
    public String name() {
        return "avg";
    }
}

