/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.export.word.high;

import com.bstek.ureport.build.paging.Page;
import com.bstek.ureport.chart.ChartData;
import com.bstek.ureport.definition.Alignment;
import com.bstek.ureport.definition.Border;
import com.bstek.ureport.definition.BorderStyle;
import com.bstek.ureport.definition.Orientation;
import com.bstek.ureport.definition.Paper;
import com.bstek.ureport.exception.ReportComputeException;
import com.bstek.ureport.export.Producer;
import com.bstek.ureport.export.word.DxaUtils;
import com.bstek.ureport.model.Cell;
import com.bstek.ureport.model.Column;
import com.bstek.ureport.model.Image;
import com.bstek.ureport.model.Report;
import com.bstek.ureport.model.Row;
import com.bstek.ureport.utils.ImageUtils;
import com.bstek.ureport.utils.UnitUtils;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.util.Units;
import org.apache.poi.xwpf.usermodel.BreakType;
import org.apache.poi.xwpf.usermodel.ParagraphAlignment;
import org.apache.poi.xwpf.usermodel.UnderlinePatterns;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTBorder;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTColumns;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPageMar;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPageSz;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSectPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTcBorders;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTcPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STBorder;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STMerge;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STPageOrientation;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STVerticalJc;

public class WordProducer
implements Producer {
    public static final String BEAN_ID = "ureport.wordExporter";

    @Override
    public void produce(Report report, OutputStream outputStream) {
        XWPFDocument document = new XWPFDocument();
        try {
            CTSectPr sectpr = document.getDocument().getBody().addNewSectPr();
            if (!sectpr.isSetPgSz()) {
                sectpr.addNewPgSz();
            }
            CTPageSz pageSize = sectpr.getPgSz();
            Paper paper = report.getPaper();
            Orientation orientation = paper.getOrientation();
            if (orientation.equals(Orientation.landscape)) {
                pageSize.setOrient(STPageOrientation.LANDSCAPE);
                pageSize.setH(BigInteger.valueOf(DxaUtils.points2dxa(paper.getWidth())));
                pageSize.setW(BigInteger.valueOf(DxaUtils.points2dxa(paper.getHeight())));
            } else {
                pageSize.setOrient(STPageOrientation.PORTRAIT);
                pageSize.setW(BigInteger.valueOf(DxaUtils.points2dxa(paper.getWidth())));
                pageSize.setH(BigInteger.valueOf(DxaUtils.points2dxa(paper.getHeight())));
            }
            int columnCount = paper.getColumnCount();
            if (paper.isColumnEnabled() && columnCount > 0) {
                CTColumns cols = CTColumns.Factory.newInstance();
                cols.setNum(new BigInteger(String.valueOf(columnCount)));
                int columnMargin = paper.getColumnMargin();
                cols.setSpace(new BigInteger(String.valueOf(DxaUtils.points2dxa(columnMargin))));
                sectpr.setCols(cols);
            }
            CTPageMar pageMar = sectpr.addNewPgMar();
            pageMar.setLeft(BigInteger.valueOf(DxaUtils.points2dxa(paper.getLeftMargin())));
            pageMar.setRight(BigInteger.valueOf(DxaUtils.points2dxa(paper.getRightMargin())));
            pageMar.setTop(BigInteger.valueOf(DxaUtils.points2dxa(paper.getTopMargin())));
            pageMar.setBottom(BigInteger.valueOf(DxaUtils.points2dxa(paper.getBottomMargin())));
            List<Column> columns = report.getColumns();
            int[] intArr = this.buildColumnSizeAndTotalWidth(columns);
            int totalColumn = intArr[0];
            int tableWidth = intArr[1];
            List<Page> pages = report.getPages();
            Map<Row, Map<Column, Cell>> cellMap = report.getRowColCellMap();
            int totalPages = pages.size();
            int pageIndex = 1;
            for (Page page : pages) {
                List<Row> rows = page.getRows();
                XWPFTable table = document.createTable(rows.size(), totalColumn);
                table.getCTTbl().getTblPr().unsetTblBorders();
                table.getCTTbl().addNewTblPr().addNewTblW().setW(BigInteger.valueOf(DxaUtils.points2dxa(tableWidth)));
                for (int rowNumber = 0; rowNumber < rows.size(); ++rowNumber) {
                    Row row = rows.get(rowNumber);
                    int height = row.getRealHeight();
                    XWPFTableRow tableRow = table.getRow(rowNumber);
                    tableRow.setHeight(DxaUtils.points2dxa(height));
                    Map<Column, Cell> colCell = cellMap.get(row);
                    if (colCell == null) continue;
                    int skipCol = 0;
                    for (Column col : columns) {
                        XWPFTableCell tableCell;
                        int width = col.getWidth();
                        if (width < 1) {
                            ++skipCol;
                            continue;
                        }
                        int colNumber = col.getColumnNumber() - 1 - skipCol;
                        Cell cell = colCell.get(col);
                        if (cell == null || (tableCell = tableRow.getCell(colNumber)) == null) continue;
                        tableCell.getCTTc().addNewTcPr().addNewTcW().setW(BigInteger.valueOf(DxaUtils.points2dxa(width)));
                        this.buildTableCellStyle(table, tableCell, cell, rowNumber, colNumber);
                    }
                }
                if (pageIndex < totalPages) {
                    XWPFParagraph paragraph = document.createParagraph();
                    XWPFRun run = paragraph.createRun();
                    run.setFontSize(0);
                    run.addBreak(BreakType.PAGE);
                }
                ++pageIndex;
            }
            document.write(outputStream);
        }
        catch (Exception ex) {
            throw new ReportComputeException(ex);
        }
        finally {
            try {
                document.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private int[] buildColumnSizeAndTotalWidth(List<Column> columns) {
        int count = 0;
        int totalWidth = 0;
        for (int i = 0; i < columns.size(); ++i) {
            Column col = columns.get(i);
            int width = col.getWidth();
            if (width < 1) continue;
            ++count;
            totalWidth += width;
        }
        return new int[]{count, totalWidth};
    }

    /*
     * Unable to fully structure code
     */
    private void buildTableCellStyle(XWPFTable table, XWPFTableCell tableCell, Cell cell, int rowNumber, int columnNumber) {
        style = cell.getCellStyle();
        customStyle = cell.getCustomCellStyle();
        rowStyle = cell.getRow().getCustomCellStyle();
        colStyle = cell.getColumn().getCustomCellStyle();
        cellProperties = tableCell.getCTTc().addNewTcPr();
        leftBorder = style.getLeftBorder();
        rightBorder = style.getRightBorder();
        topBorder = style.getTopBorder();
        bottomBorder = style.getBottomBorder();
        if (customStyle != null) {
            if (customStyle.getLeftBorder() != null) {
                leftBorder = customStyle.getLeftBorder();
            }
            if (customStyle.getRightBorder() != null) {
                rightBorder = customStyle.getRightBorder();
            }
            if (customStyle.getTopBorder() != null) {
                topBorder = customStyle.getTopBorder();
            }
            if (customStyle.getBottomBorder() != null) {
                bottomBorder = customStyle.getBottomBorder();
            }
        }
        rowSpan = cell.getPageRowSpan();
        colSpan = cell.getColSpan();
        if (style.getLeftBorder() != null) {
            if (rowSpan > 0) {
                start = rowNumber;
                end = start + rowSpan;
                for (i = start; i < end; ++i) {
                    c = table.getRow(i).getCell(columnNumber);
                    this.buildCellBorder(leftBorder, c, 1);
                }
            } else {
                this.buildCellBorder(leftBorder, tableCell, 1);
            }
        }
        if (rightBorder != null) {
            lastCol = columnNumber;
            if (colSpan > 0) {
                lastCol += colSpan - 1;
            }
            if (rowSpan > 0) {
                start = rowNumber;
                end = start + rowSpan;
                for (i = start; i < end; ++i) {
                    c = table.getRow(i).getCell(lastCol);
                    this.buildCellBorder(style.getRightBorder(), c, 2);
                }
            } else {
                c = table.getRow(rowNumber).getCell(lastCol);
                this.buildCellBorder(rightBorder, c, 2);
            }
        }
        if (topBorder != null) {
            if (colSpan > 0) {
                start = columnNumber;
                end = start + colSpan;
                for (i = start; i < end; ++i) {
                    c = table.getRow(rowNumber).getCell(i);
                    this.buildCellBorder(topBorder, c, 3);
                }
            } else {
                this.buildCellBorder(topBorder, tableCell, 3);
            }
        }
        if (bottomBorder != null) {
            lastRow = rowNumber;
            if (rowSpan > 0) {
                lastRow += rowSpan - 1;
            }
            if (colSpan > 0) {
                start = columnNumber;
                end = start + colSpan;
                for (i = start; i < end; ++i) {
                    c = table.getRow(lastRow).getCell(i);
                    this.buildCellBorder(bottomBorder, c, 4);
                }
            } else {
                c = table.getRow(lastRow).getCell(columnNumber);
                this.buildCellBorder(bottomBorder, c, 4);
            }
        }
        paras = tableCell.getParagraphs();
        para = null;
        para = paras != null && paras.size() > 0 ? (XWPFParagraph)paras.get(0) : tableCell.addParagraph();
        runs = para.getRuns();
        run = null;
        run = runs != null && runs.size() > 0 ? (XWPFRun)runs.get(0) : para.createRun();
        value = cell.getFormatData();
        if (value instanceof String) {
            text = value.toString();
            if (text.contains("\n")) {
                line = text.split("\n");
                run.setText(line[0], 0);
                for (i = 1; i < line.length; ++i) {
                    run.addBreak();
                    run.setText(line[i], i);
                }
            } else {
                run.setText(text);
            }
        } else if (value instanceof Number) {
            run.setText(String.valueOf(value));
        } else if (value instanceof Boolean) {
            run.setText(value.toString());
        } else if (value instanceof Image || value instanceof ChartData) {
            img = null;
            img = value instanceof Image != false ? (Image)value : ((base64Data = (chartData = (ChartData)value).retriveBase64Data()) != null ? new Image(base64Data, chartData.getWidth(), chartData.getHeight()) : new Image("", chartData.getWidth(), chartData.getHeight()));
            path = img.getPath();
            imageType = "png";
            if (StringUtils.isNotBlank((String)path)) {
                if ((path = path.toLowerCase()).endsWith(".jpg") || path.endsWith(".jpeg")) {
                    imageType = "jpeg";
                } else if (path.endsWith(".gif")) {
                    imageType = "gif";
                }
            }
            if (StringUtils.isNotBlank((String)(base64Data = img.getBase64Data()))) {
                inputStream = null;
                try {
                    inputStream = ImageUtils.base64DataToInputStream(base64Data);
                    bufferedImage = ImageIO.read(inputStream);
                    width = bufferedImage.getWidth();
                    height = bufferedImage.getHeight();
                    IOUtils.closeQuietly((InputStream)inputStream);
                    inputStream = ImageUtils.base64DataToInputStream(base64Data);
                    width = UnitUtils.pixelToPoint(width);
                    height = UnitUtils.pixelToPoint(height);
                    if (imageType.equals("jpeg")) {
                        run.addPicture(inputStream, 5, "ureport-" + rowNumber + "-" + columnNumber + ".jpg", Units.toEMU((double)width), Units.toEMU((double)height));
                    }
                    if (imageType.equals("png")) {
                        run.addPicture(inputStream, 6, "ureport-" + rowNumber + "-" + columnNumber + ".png", Units.toEMU((double)width), Units.toEMU((double)height));
                    }
                    if (!imageType.equals("gif")) ** GOTO lbl138
                    run.addPicture(inputStream, 8, "ureport-" + rowNumber + "-" + columnNumber + ".gif", Units.toEMU((double)width), Units.toEMU((double)height));
                }
                catch (Exception ex) {
                    throw new ReportComputeException(ex);
                }
                finally {
                    IOUtils.closeQuietly((InputStream)inputStream);
                }
            }
        } else if (value instanceof Date) {
            date = (Date)value;
            sd = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            run.setText(sd.format(date));
        }
lbl138:
        // 12 sources

        fontFamily = style.getFontFamily();
        if (customStyle != null && StringUtils.isNotBlank((String)customStyle.getFontFamily())) {
            fontFamily = customStyle.getFontFamily();
        }
        if (rowStyle != null && StringUtils.isNotBlank((String)rowStyle.getFontFamily())) {
            fontFamily = rowStyle.getFontFamily();
        }
        if (colStyle != null && StringUtils.isNotBlank((String)colStyle.getFontFamily())) {
            fontFamily = colStyle.getFontFamily();
        }
        if (StringUtils.isNotBlank((String)fontFamily)) {
            run.setFontFamily(fontFamily);
        }
        fontSize = style.getFontSize();
        if (customStyle != null && customStyle.getFontSize() > 0) {
            fontSize = customStyle.getFontSize();
        }
        if (rowStyle != null && rowStyle.getFontSize() > 0) {
            fontSize = rowStyle.getFontSize();
        }
        if (colStyle != null && colStyle.getFontSize() > 0) {
            fontSize = colStyle.getFontSize();
        }
        if (fontSize > 0) {
            run.setFontSize(fontSize);
        }
        v0 = bold = style.getBold() == null ? false : style.getBold();
        if (customStyle != null && customStyle.getBold() != null) {
            bold = customStyle.getBold();
        }
        if (rowStyle != null && rowStyle.getBold() != null) {
            bold = rowStyle.getBold();
        }
        if (colStyle != null && colStyle.getBold() != null) {
            bold = colStyle.getBold();
        }
        if (bold) {
            run.setBold(true);
        }
        v1 = italic = style.getItalic() == null ? false : style.getItalic();
        if (customStyle != null && customStyle.getItalic() != null) {
            italic = customStyle.getItalic();
        }
        if (rowStyle != null && rowStyle.getItalic() != null) {
            italic = rowStyle.getItalic();
        }
        if (colStyle != null && colStyle.getItalic() != null) {
            italic = colStyle.getItalic();
        }
        if (italic) {
            run.setItalic(true);
        }
        v2 = underline = style.getUnderline() == null ? false : style.getUnderline();
        if (customStyle != null && customStyle.getUnderline() != null) {
            underline = customStyle.getUnderline();
        }
        if (rowStyle != null && rowStyle.getUnderline() != null) {
            underline = rowStyle.getUnderline();
        }
        if (colStyle != null && colStyle.getUnderline() != null) {
            underline = colStyle.getUnderline();
        }
        if (underline) {
            run.setUnderline(UnderlinePatterns.SINGLE);
        }
        bgcolor = style.getBgcolor();
        if (customStyle != null && StringUtils.isNotBlank((String)customStyle.getBgcolor())) {
            bgcolor = customStyle.getBgcolor();
        }
        if (rowStyle != null && StringUtils.isNotBlank((String)rowStyle.getBgcolor())) {
            bgcolor = rowStyle.getBgcolor();
        }
        if (colStyle != null && StringUtils.isNotBlank((String)colStyle.getBgcolor())) {
            bgcolor = colStyle.getBgcolor();
        }
        if (bgcolor != null) {
            ctshd = cellProperties.addNewShd();
            ctshd.setFill((Object)this.toHex(bgcolor.split(",")));
        }
        forecolor = style.getForecolor();
        if (customStyle != null && StringUtils.isNotBlank((String)customStyle.getForecolor())) {
            forecolor = customStyle.getForecolor();
        }
        if (rowStyle != null && StringUtils.isNotBlank((String)rowStyle.getForecolor())) {
            forecolor = rowStyle.getForecolor();
        }
        if (colStyle != null && StringUtils.isNotBlank((String)colStyle.getForecolor())) {
            forecolor = colStyle.getForecolor();
        }
        if (forecolor != null) {
            run.setColor(this.toHex(forecolor.split(",")));
        }
        align = style.getAlign();
        if (customStyle != null && customStyle.getAlign() != null) {
            align = customStyle.getAlign();
        }
        if (rowStyle != null && rowStyle.getAlign() != null) {
            align = rowStyle.getAlign();
        }
        if (align != null) {
            if (align.equals((Object)Alignment.left)) {
                para.setAlignment(ParagraphAlignment.LEFT);
            } else if (align.equals((Object)Alignment.right)) {
                para.setAlignment(ParagraphAlignment.RIGHT);
            } else if (align.equals((Object)Alignment.center)) {
                para.setAlignment(ParagraphAlignment.CENTER);
            }
        }
        if (style.getLineHeight() > 0.0f) {
            para.setSpacingBetween((double)style.getLineHeight());
        }
        align = style.getValign();
        if (customStyle != null && customStyle.getValign() != null) {
            align = customStyle.getValign();
        }
        if (rowStyle != null && rowStyle.getValign() != null) {
            align = rowStyle.getValign();
        }
        if (colStyle != null && colStyle.getValign() != null) {
            align = colStyle.getValign();
        }
        if (align != null) {
            verticalAlign = cellProperties.addNewVAlign();
            if (align.equals((Object)Alignment.top)) {
                verticalAlign.setVal(STVerticalJc.TOP);
            } else if (align.equals((Object)Alignment.middle)) {
                verticalAlign.setVal(STVerticalJc.CENTER);
            } else if (align.equals((Object)Alignment.bottom)) {
                verticalAlign.setVal(STVerticalJc.BOTTOM);
            }
        }
        startCol = columnNumber;
        endRow = startRow = rowNumber;
        endCol = startCol;
        if (colSpan > 0) {
            endCol = startCol + colSpan - 1;
        }
        if (rowSpan > 0) {
            endRow = startRow + rowSpan - 1;
        }
        if (startCol != endCol) {
            if (rowSpan > 0) {
                for (i = startRow; i <= endRow; ++i) {
                    this.mergeCellsHorizontal(table, i, startCol, endCol);
                }
            } else {
                this.mergeCellsHorizontal(table, startRow, startCol, endCol);
            }
        }
        if (startRow != endRow) {
            if (colSpan > 0) {
                for (i = startCol; i <= endCol; ++i) {
                    this.mergeCellsVertically(table, i, startRow, endRow);
                }
            } else {
                this.mergeCellsVertically(table, startCol, startRow, endRow);
            }
        }
    }

    private void mergeCellsHorizontal(XWPFTable table, int row, int startCol, int endCol) {
        for (int cellIndex = startCol; cellIndex <= endCol; ++cellIndex) {
            XWPFTableCell cell = table.getRow(row).getCell(cellIndex);
            if (cellIndex == startCol) {
                cell.getCTTc().addNewTcPr().addNewHMerge().setVal(STMerge.RESTART);
                continue;
            }
            cell.getCTTc().addNewTcPr().addNewHMerge().setVal(STMerge.CONTINUE);
        }
    }

    private void mergeCellsVertically(XWPFTable table, int col, int fromRow, int toRow) {
        for (int rowIndex = fromRow; rowIndex <= toRow; ++rowIndex) {
            XWPFTableCell cell = table.getRow(rowIndex).getCell(col);
            if (rowIndex == fromRow) {
                cell.getCTTc().addNewTcPr().addNewVMerge().setVal(STMerge.RESTART);
                continue;
            }
            cell.getCTTc().addNewTcPr().addNewVMerge().setVal(STMerge.CONTINUE);
        }
    }

    private void buildCellBorder(Border border, XWPFTableCell tableCell, int type) {
        String color;
        CTTcBorders borders;
        CTTcPr cellPropertie = tableCell.getCTTc().getTcPr();
        if (cellPropertie == null) {
            cellPropertie = tableCell.getCTTc().addNewTcPr();
        }
        if ((borders = cellPropertie.getTcBorders()) == null) {
            borders = cellPropertie.addNewTcBorders();
        }
        BorderStyle borderStyle = border.getStyle();
        CTBorder ctborder = null;
        if (type == 1) {
            ctborder = borders.addNewLeft();
        } else if (type == 2) {
            ctborder = borders.addNewRight();
        } else if (type == 3) {
            ctborder = borders.addNewTop();
        } else if (type == 4) {
            ctborder = borders.addNewBottom();
        }
        if (borderStyle.equals((Object)BorderStyle.dashed)) {
            ctborder.setVal(STBorder.DASHED);
        } else if (borderStyle.equals((Object)BorderStyle.doublesolid)) {
            ctborder.setVal(STBorder.DOUBLE);
        } else {
            ctborder.setVal(STBorder.SINGLE);
        }
        int borderWidth = border.getWidth();
        if (borderWidth > 1) {
            ctborder.setSz(BigInteger.valueOf(DxaUtils.points2dxa(borderWidth)));
        }
        if (StringUtils.isNotBlank((String)(color = border.getColor()))) {
            ctborder.setColor((Object)this.toHex(color.split(",")));
        }
    }

    private String toHex(String[] rgb) {
        StringBuffer sb = new StringBuffer();
        Object R = Integer.toHexString(Integer.valueOf(rgb[0]));
        Object G = Integer.toHexString(Integer.valueOf(rgb[1]));
        Object B = Integer.toHexString(Integer.valueOf(rgb[2]));
        R = ((String)R).length() == 1 ? "0" + (String)R : R;
        G = ((String)G).length() == 1 ? "0" + (String)G : G;
        B = ((String)B).length() == 1 ? "0" + (String)B : B;
        sb.append((String)R);
        sb.append((String)G);
        sb.append((String)B);
        return sb.toString();
    }
}

