/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.export.pdf;

import com.bstek.ureport.build.paging.HeaderFooter;
import com.bstek.ureport.build.paging.Page;
import com.bstek.ureport.definition.Orientation;
import com.bstek.ureport.definition.Paper;
import com.bstek.ureport.exception.ReportComputeException;
import com.bstek.ureport.export.pdf.font.FontBuilder;
import com.bstek.ureport.model.Report;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Font;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfPageEventHelper;
import com.lowagie.text.pdf.PdfWriter;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class PageHeaderFooterEvent
extends PdfPageEventHelper {
    private Report report;

    public PageHeaderFooterEvent(Report report) {
        this.report = report;
    }

    public void onEndPage(PdfWriter writer, Document document) {
        List<Page> pages = this.report.getPages();
        int pageNumber = writer.getPageNumber();
        if (pageNumber > pages.size()) {
            return;
        }
        Page page = pages.get(pageNumber - 1);
        HeaderFooter header = page.getHeader();
        HeaderFooter footer = page.getFooter();
        if (header != null) {
            this.buildTable(writer, header, true, this.report);
        }
        if (footer != null) {
            this.buildTable(writer, footer, false, this.report);
        }
    }

    private void buildTable(PdfWriter writer, HeaderFooter hf, boolean header, Report report) {
        Paper paper = report.getPaper();
        int width = paper.getWidth();
        if (paper.getOrientation().equals(Orientation.landscape)) {
            width = paper.getHeight();
        }
        int leftMargin = paper.getLeftMargin();
        int rightMargin = paper.getRightMargin();
        int tableWidth = width - leftMargin - rightMargin;
        int height = paper.getHeight();
        if (paper.getOrientation().equals(Orientation.landscape)) {
            height = paper.getWidth();
        }
        int margin = hf.getMargin();
        int hfHeight = hf.getHeight();
        String left = hf.getLeft();
        String center = hf.getCenter();
        String right = hf.getRight();
        try {
            PdfPTable table = null;
            if (StringUtils.isNotEmpty((String)left)) {
                if (StringUtils.isNotEmpty((String)center) && StringUtils.isNotEmpty((String)right)) {
                    table = new PdfPTable(3);
                    table.setWidths(new int[]{1, 1, 1});
                    table.addCell(this.buildPdfPCell(hf, left, 1));
                    table.addCell(this.buildPdfPCell(hf, center, 2));
                    table.addCell(this.buildPdfPCell(hf, right, 3));
                } else if (StringUtils.isNotEmpty((String)center)) {
                    table = new PdfPTable(3);
                    table.setWidths(new int[]{1, 1, 1});
                    table.addCell(this.buildPdfPCell(hf, left, 1));
                    table.addCell(this.buildPdfPCell(hf, center, 2));
                    table.addCell(this.buildPdfPCell(hf, "", 3));
                } else if (StringUtils.isNotEmpty((String)right)) {
                    table = new PdfPTable(3);
                    table.setWidths(new int[]{1, 1, 1});
                    table.addCell(this.buildPdfPCell(hf, left, 1));
                    table.addCell(this.buildPdfPCell(hf, "", 2));
                    table.addCell(this.buildPdfPCell(hf, right, 3));
                } else {
                    table = new PdfPTable(1);
                    table.setWidths(new int[]{1});
                    table.addCell(this.buildPdfPCell(hf, left, 1));
                }
            } else if (StringUtils.isNotEmpty((String)center)) {
                if (StringUtils.isNotEmpty((String)right)) {
                    table = new PdfPTable(3);
                    table.setWidths(new int[]{1, 1, 1});
                    table.addCell(this.buildPdfPCell(hf, "", 1));
                    table.addCell(this.buildPdfPCell(hf, center, 2));
                    table.addCell(this.buildPdfPCell(hf, right, 3));
                } else {
                    table = new PdfPTable(1);
                    table.setWidths(new int[]{1});
                    table.addCell(this.buildPdfPCell(hf, center, 2));
                }
            } else if (StringUtils.isNotEmpty((String)right)) {
                table = new PdfPTable(1);
                table.setWidths(new int[]{1});
                table.addCell(this.buildPdfPCell(hf, right, 3));
            }
            if (table == null) {
                return;
            }
            table.getDefaultCell().setMinimumHeight((float)hfHeight);
            table.setTotalWidth((float)tableWidth);
            table.setLockedWidth(true);
            if (header) {
                int y = height - margin;
                table.writeSelectedRows(0, -1, (float)leftMargin, (float)y, writer.getDirectContent());
            } else {
                table.writeSelectedRows(0, -1, (float)leftMargin, (float)(margin + hfHeight), writer.getDirectContent());
            }
        }
        catch (DocumentException de) {
            throw new ReportComputeException((Exception)((Object)de));
        }
    }

    private PdfPCell buildPdfPCell(HeaderFooter phf, String text, int type) {
        PdfPCell cell = new PdfPCell();
        cell.setPadding(0.0f);
        cell.setBorder(0);
        Font font = FontBuilder.getFont(phf.getFontFamily(), phf.getFontSize(), phf.isBold(), phf.isItalic(), phf.isUnderline());
        String fontColor = phf.getForecolor();
        if (StringUtils.isNotEmpty((String)fontColor)) {
            String[] color = fontColor.split(",");
            font.setColor(Integer.valueOf(color[0]).intValue(), Integer.valueOf(color[1]).intValue(), Integer.valueOf(color[2]).intValue());
        }
        Paragraph graph = new Paragraph(text, font);
        cell.setPhrase((Phrase)graph);
        switch (type) {
            case 1: {
                cell.setHorizontalAlignment(0);
                break;
            }
            case 2: {
                cell.setHorizontalAlignment(1);
                break;
            }
            case 3: {
                cell.setHorizontalAlignment(2);
            }
        }
        cell.setVerticalAlignment(5);
        return cell;
    }
}

