/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.export.pdf;

import com.bstek.ureport.definition.CellStyle;
import com.bstek.ureport.model.Cell;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Font;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.BaseFont;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class CellPhrase
extends Phrase {
    public static final Map<String, String> fontPathMap = new HashMap<String, String>();
    private static final long serialVersionUID = 8712267867853876619L;

    public CellPhrase(Cell cell, Object cellData) throws IOException, DocumentException {
        String text = "";
        if (cellData != null) {
            text = cellData.toString();
        }
        Font font = this.buildPdfFont(cell);
        this.setFont(font);
        this.add(text);
    }

    public CellPhrase() {
    }

    public Font buildPdfFont(Cell cell) throws IOException, DocumentException {
        Object fontpath;
        CellStyle style = cell.getCellStyle();
        CellStyle customStyle = cell.getCustomCellStyle();
        CellStyle rowStyle = cell.getRow().getCustomCellStyle();
        CellStyle colStyle = cell.getColumn().getCustomCellStyle();
        String fontName = style.getFontFamily();
        if (customStyle != null && StringUtils.isNotBlank((String)customStyle.getFontFamily())) {
            fontName = customStyle.getFontFamily();
        }
        if (rowStyle != null && StringUtils.isNotBlank((String)rowStyle.getFontFamily())) {
            fontName = rowStyle.getFontFamily();
        }
        if (colStyle != null && StringUtils.isNotBlank((String)colStyle.getFontFamily())) {
            fontName = colStyle.getFontFamily();
        }
        int fontSize = style.getFontSize();
        Boolean bold = style.getBold();
        Boolean italic = style.getItalic();
        Boolean underline = style.getUnderline();
        if (customStyle != null) {
            if (customStyle.getBold() != null) {
                bold = customStyle.getBold();
            }
            if (customStyle.getItalic() != null) {
                italic = customStyle.getItalic();
            }
            if (customStyle.getUnderline() != null) {
                underline = customStyle.getUnderline();
            }
            if (customStyle.getFontSize() > 0) {
                fontSize = customStyle.getFontSize();
            }
        }
        if (rowStyle != null) {
            if (rowStyle.getBold() != null) {
                bold = rowStyle.getBold();
            }
            if (rowStyle.getItalic() != null) {
                italic = rowStyle.getItalic();
            }
            if (rowStyle.getUnderline() != null) {
                underline = rowStyle.getUnderline();
            }
            if (rowStyle.getFontSize() > 0) {
                fontSize = rowStyle.getFontSize();
            }
        }
        if (colStyle != null) {
            if (colStyle.getBold() != null) {
                bold = colStyle.getBold();
            }
            if (colStyle.getItalic() != null) {
                italic = colStyle.getItalic();
            }
            if (colStyle.getUnderline() != null) {
                underline = colStyle.getUnderline();
            }
            if (colStyle.getFontSize() > 0) {
                fontSize = colStyle.getFontSize();
            }
        }
        if (bold == null) {
            bold = false;
        }
        if (italic == null) {
            italic = false;
        }
        if (underline == null) {
            underline = false;
        }
        if (StringUtils.isBlank((String)fontName)) {
            fontName = "\u5b8b\u4f53";
        }
        if (StringUtils.isBlank((String)(fontpath = fontPathMap.get(fontName)))) {
            fontPathMap.put("\u5b8b\u4f53", "com/bstek/ureport/font/songti/SIMSUN.TTC");
            fontPathMap.put("\u6977\u4f53", "com/bstek/ureport/font/kaiti/SIMKAI.TTF");
            fontPathMap.put("\u5fae\u8f6f\u96c5\u9ed1", "com/bstek/ureport/font/yahei/msyh.ttc");
            fontPathMap.put("Times New Roman", "com/bstek/ureport/font/timesnewroman/TIMES.TTF");
            fontPathMap.put("Impact", "com/bstek/ureport/font/impact/IMPACT.TTF");
            fontPathMap.put("\u9ed1\u4f53", "com/bstek/ureport/font/heiti/SIMHEI.TTF");
            fontPathMap.put("\u4eff\u5b8b", "com/bstek/ureport/font/fangsong/SIMFANG.TTF");
            fontPathMap.put("Courier New", "com/bstek/ureport/font/couriernew/COUR.TTF");
            fontPathMap.put("Comic Sans MS", "com/bstek/ureport/font/comicsansms/COMIC.TTF");
            fontPathMap.put("Arial", "com/bstek/ureport/font/arial/ARIAL.TTF");
            fontpath = fontPathMap.get(fontName);
        }
        if (((String)fontpath).toLowerCase().endsWith(".ttc")) {
            fontpath = (String)fontpath + ",0";
        }
        BaseFont baseFont = BaseFont.createFont((String)fontpath, (String)"Identity-H", (boolean)true);
        Font font = new Font(baseFont, (float)fontSize, 0);
        int fontStyle = 0;
        if (bold.booleanValue() && italic.booleanValue() && underline.booleanValue()) {
            fontStyle = 7;
        } else if (bold.booleanValue()) {
            fontStyle = italic.booleanValue() ? 3 : (underline.booleanValue() ? 5 : 1);
        } else if (italic.booleanValue()) {
            fontStyle = underline.booleanValue() ? 6 : (bold.booleanValue() ? 3 : 2);
        } else if (underline.booleanValue()) {
            fontStyle = 4;
        }
        font.setStyle(fontStyle);
        String fontColor = style.getForecolor();
        if (customStyle != null && StringUtils.isNotBlank((String)customStyle.getForecolor())) {
            fontColor = customStyle.getForecolor();
        }
        if (rowStyle != null && StringUtils.isNotBlank((String)rowStyle.getForecolor())) {
            fontColor = rowStyle.getForecolor();
        }
        if (colStyle != null && StringUtils.isNotBlank((String)colStyle.getForecolor())) {
            fontColor = colStyle.getForecolor();
        }
        if (StringUtils.isNotEmpty((String)fontColor)) {
            String[] color = fontColor.split(",");
            font.setColor(Integer.valueOf(color[0]).intValue(), Integer.valueOf(color[1]).intValue(), Integer.valueOf(color[2]).intValue());
        }
        return font;
    }
}

